/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.client.AbstractBgFormulaViewUI;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormulaViewUI
extends AbstractBgFormulaViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormulaViewUI.class);
    protected boolean isRowProcess = true;
    protected Object processUI = null;
    protected KDTable proTable = null;
    protected Map aliasMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSystemInfo();
        this.initTableInfo();
        this.loadProTableInfo();
    }

    protected void initSystemInfo() {
        if (this.getUIContext().get("Owner") != null) {
            this.processUI = this.getUIContext().get("Owner");
        }
        if (this.getUIContext().get("BGFORMULA_TABLE") != null && this.getUIContext().get("BGFORMULA_TABLE") instanceof KDTable) {
            this.proTable = (KDTable)this.getUIContext().get("BGFORMULA_TABLE");
        }
        this.txtRowAlias.setEditable(false);
        this.txtColAlias.setEditable(false);
        this.txtBgItemNumber.setEditable(false);
        this.txtBgItemName.setEditable(false);
        this.txtBgElementNumber.setEditable(false);
        this.txtBgElementName.setEditable(false);
        this.txtBgPeriodNumber.setEditable(false);
        this.txtBgPeriodName.setEditable(false);
        this.txtCurrencyNumber.setEditable(false);
        this.txtCurrencyName.setEditable(false);
        this.txtRowAlias.setRequired(true);
        this.txtColAlias.setRequired(true);
    }

    protected void initTableInfo() {
        int i = 0;
        int j = 0;
        int rowCount = this.proTable.getBody().size();
        int colCount = this.proTable.getColumnCount();
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.addColumns(colCount);
        this.tblMain.addHeadRow();
        this.tblMain.addRows(rowCount);
        for (i = 0; i < rowCount; ++i) {
            for (j = 0; j < colCount; ++j) {
                if (i == 0) {
                    this.tblMain.getHeadRow(0).getCell(j).setValue(this.proTable.getHeadRow(0).getCell(j).getValue());
                }
                if (this.proTable.getCell(i, j).getFormattedValue() != null) {
                    this.tblMain.getCell(i, j).setValue(this.proTable.getCell(i, j).getFormattedValue());
                    continue;
                }
                this.tblMain.getCell(i, j).setValue(this.proTable.getCell(i, j).getValue());
            }
        }
    }

    protected void loadProTableInfo() {
        if (this.proTable.getUserObject() != null && this.proTable.getUserObject() instanceof HashMap) {
            this.aliasMap = (HashMap)this.proTable.getUserObject();
            this.isRowProcess = this.aliasMap.containsKey("BGFORMULA_ALIAS") ? Boolean.valueOf(this.aliasMap.get("BGFORMULA_ALIAS").toString()) != false : true;
        }
        this.txtBgItemNumber.setText("");
        this.txtBgItemName.setText("");
        this.txtBgElementNumber.setText("");
        this.txtBgElementName.setText("");
        this.txtBgPeriodNumber.setText("");
        this.txtBgPeriodName.setText("");
        this.txtCurrencyNumber.setText("");
        this.txtCurrencyName.setText("");
        IRow row = null;
        IColumn column = null;
        if (this.isRowProcess) {
            this.txtRowAlias.setText("");
            int rowCount = this.proTable.getBody().size();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.proTable.getRow(rowIndex);
                if (row.getUserObject() == null || !(row.getUserObject() instanceof HashMap)) continue;
                this.aliasMap = (Map)row.getUserObject();
                if (!this.aliasMap.containsKey("BGFORMULA_ALIAS_NUMBER") && !this.aliasMap.containsKey("BGFORMULA_ALIAS_TITLE")) continue;
                this.txtRowAlias.setText(String.valueOf(rowIndex + 1));
                break;
            }
            this.txtColAlias.setText("");
            int colCount = this.proTable.getColumnCount();
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                column = this.proTable.getColumn(colIndex);
                if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap)) continue;
                this.aliasMap = (Map)column.getUserObject();
                if (!this.aliasMap.containsKey("BGFORMULA_ALIAS_NUMBER") && !this.aliasMap.containsKey("BGFORMULA_ALIAS_TITLE")) continue;
                this.txtColAlias.setText(TableToolkit.xy2range((int)0, (int)colIndex).substring(0, 1));
                break;
            }
        }
    }

    @Override
    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblMain_activeCellChanged(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        int activeColIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
        IRow row = null;
        IColumn column = null;
        if (this.isRowProcess) {
            column = this.proTable.getColumn(activeColIndex);
            if (column.getUserObject() != null && column.getUserObject() instanceof HashMap) {
                this.aliasMap = (Map)column.getUserObject();
                this.txtBgPeriodNumber.setText(this.aliasMap.containsKey("BGFORMULA_BGPERIOD") ? this.aliasMap.get("BGFORMULA_BGPERIOD").toString() : "");
                this.txtBgPeriodName.setText(this.aliasMap.containsKey("BGFORMULA_BGPERIOD_NAME") ? this.aliasMap.get("BGFORMULA_BGPERIOD_NAME").toString() : "");
                this.txtBgElementNumber.setText(this.aliasMap.containsKey("BGFORMULA_BGELEMENT") ? this.aliasMap.get("BGFORMULA_BGELEMENT").toString() : "");
                this.txtBgElementName.setText(this.aliasMap.containsKey("BGFORMULA_BGELEMENT_NAME") ? this.aliasMap.get("BGFORMULA_BGELEMENT_NAME").toString() : "");
                this.txtCurrencyNumber.setText(this.aliasMap.containsKey("BGFORMULA_CURRENCY") ? this.aliasMap.get("BGFORMULA_CURRENCY").toString() : "");
                this.txtCurrencyName.setText(this.aliasMap.containsKey("BGFORMULA_CURRENCY_NAME") ? this.aliasMap.get("BGFORMULA_CURRENCY_NAME").toString() : "");
            } else {
                this.txtBgPeriodNumber.setText("");
                this.txtBgPeriodName.setText("");
                this.txtBgElementNumber.setText("");
                this.txtBgElementName.setText("");
                this.txtCurrencyNumber.setText("");
                this.txtCurrencyName.setText("");
            }
            row = this.proTable.getRow(activeRowIndex);
            if (row.getUserObject() != null && row.getUserObject() instanceof HashMap) {
                this.aliasMap = (Map)row.getUserObject();
                this.txtBgItemNumber.setText(this.aliasMap.containsKey("BGFORMULA_BGITEM") ? this.aliasMap.get("BGFORMULA_BGITEM").toString() : "");
                this.txtBgItemName.setText(this.aliasMap.containsKey("BGFORMULA_BGITEM_NAME") ? this.aliasMap.get("BGFORMULA_BGITEM_NAME").toString() : "");
            } else {
                this.txtBgItemNumber.setText("");
                this.txtBgItemName.setText("");
            }
        } else {
            row = this.proTable.getRow(activeRowIndex);
            if (row.getUserObject() != null && row.getUserObject() instanceof HashMap) {
                this.aliasMap = (Map)row.getUserObject();
                this.txtBgPeriodNumber.setText(this.aliasMap.containsKey("BGFORMULA_BGPERIOD") ? this.aliasMap.get("BGFORMULA_BGPERIOD").toString() : "");
                this.txtBgPeriodName.setText(this.aliasMap.containsKey("BGFORMULA_BGPERIOD_NAME") ? this.aliasMap.get("BGFORMULA_BGPERIOD_NAME").toString() : "");
                this.txtBgElementNumber.setText(this.aliasMap.containsKey("BGFORMULA_BGELEMENT") ? this.aliasMap.get("BGFORMULA_BGELEMENT").toString() : "");
                this.txtBgElementName.setText(this.aliasMap.containsKey("BGFORMULA_BGELEMENT_NAME") ? this.aliasMap.get("BGFORMULA_BGELEMENT_NAME").toString() : "");
                this.txtCurrencyNumber.setText(this.aliasMap.containsKey("BGFORMULA_CURRENCY") ? this.aliasMap.get("BGFORMULA_CURRENCY").toString() : "");
                this.txtCurrencyName.setText(this.aliasMap.containsKey("BGFORMULA_CURRENCY_NAME") ? this.aliasMap.get("BGFORMULA_CURRENCY_NAME").toString() : "");
            } else {
                this.txtBgPeriodNumber.setText("");
                this.txtBgPeriodName.setText("");
                this.txtBgElementNumber.setText("");
                this.txtBgElementName.setText("");
                this.txtCurrencyNumber.setText("");
                this.txtCurrencyName.setText("");
            }
            column = this.proTable.getColumn(activeColIndex);
            if (column.getUserObject() != null && column.getUserObject() instanceof HashMap) {
                this.aliasMap = (Map)row.getUserObject();
                this.txtBgItemNumber.setText(this.aliasMap.containsKey("BGFORMULA_BGITEM") ? this.aliasMap.get("BGFORMULA_BGITEM").toString() : "");
                this.txtBgItemName.setText(this.aliasMap.containsKey("BGFORMULA_BGITEM_NAME") ? this.aliasMap.get("BGFORMULA_BGITEM_NAME").toString() : "");
            } else {
                this.txtBgItemNumber.setText("");
                this.txtBgItemName.setText("");
            }
        }
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }
}

