/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgGetDataBySchemesUI;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BgGetDataBySchemesUI
extends AbstractBgGetDataBySchemesUI {
    private static final long serialVersionUID = 4407751139163602431L;
    private static final Logger logger = CoreUIObject.getLogger(BgGetDataBySchemesUI.class);
    private static final String SOURCESTR = "com.kingdee.eas.ma.budget.client.BgActualResource";
    private OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private ICostCenterOrgUnit iCCOrgUnit = null;
    private IBgAnalyseFacade iAnalyseFacade = null;
    private Map valMap;
    private boolean getBudgetValue = true;
    private String selectedOrgId;

    protected ICostCenterOrgUnit getCCOrgUnitInterface() throws Exception {
        if (this.iCCOrgUnit == null) {
            this.iCCOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
        }
        return this.iCCOrgUnit;
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        if (this.iAnalyseFacade == null) {
            this.iAnalyseFacade = BgAnalyseFacadeFactory.getRemoteInstance();
        }
        return this.iAnalyseFacade;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    public void init() throws Exception {
        this.spnRate.setModel((SpinnerModel)new SpinnerNumberModel(100, 0, 1000, 1));
        this.selectedOrgId = (String)this.getUIContext().get("SelectedOrgUnit");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage("orgUnitTitle"));
        if (this.selectedOrgId != null) {
            orgView.setCuID(this.selectedOrgId);
        } else {
            orgView.setCuID(this.getCurrOrgUnit().getId().toString());
        }
        orgView.setMultiSelect(true);
        orgView.setReturnSuperior(true);
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEditable(false);
    }

    public Map getValMap() {
        return this.valMap;
    }

    public void setValMap(Map valMap) {
        this.valMap = valMap;
    }

    public boolean isGetBudgetValue() {
        return this.getBudgetValue;
    }

    public void setGetBudgetValue(boolean getBudgetValue) {
        this.getBudgetValue = getBudgetValue;
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.comboBgScheme.removeAllItems();
        this.comboTargetBgScheme.removeAllItems();
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null && !(obj instanceof String)) {
            HashSet<BOSUuid> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _currOrgUnit = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<BOSUuid>();
            if (orgUnits != null) {
                if (orgUnits.length > 1) {
                    _currOrgUnit = this.getCurrOrgUnit();
                    if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                        _currOrgUnit = orgUnits[0];
                    }
                    for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                        if (_tmpOrgUnit2.getId().equals((Object)_currOrgUnit.getId())) continue;
                        subOrgUnits.add(_tmpOrgUnit2.getId());
                    }
                } else {
                    _currOrgUnit = orgUnits[0];
                }
            }
            BgSchemeCollection bgSchemeCol = null;
            try {
                if (_currOrgUnit != null) {
                    bgSchemeCol = this.getBgSchemeInfo(_currOrgUnit.getId(), subOrgUnits, false, false);
                    this.comboTargetBgScheme.addItems(bgSchemeCol.toArray());
                    this.comboBgScheme.addItems(bgSchemeCol.toArray());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    protected BgSchemeCollection getBgSchemeInfo(BOSUuid currCCOrgUnitId, Set subOrgUnits, boolean hasUseFund, boolean isFund) throws Exception {
        return this.getInterface().getCommonBgScheme(currCCOrgUnitId, subOrgUnits, hasUseFund, isFund, true);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.verify();
        OrgUnitInfo[] orgUnits = null;
        Object obj = this.prmtOrgUnit.getData();
        if (obj instanceof OrgUnitInfo) {
            orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
        } else if (obj instanceof OrgUnitInfo[]) {
            orgUnits = (OrgUnitInfo[])obj;
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("BgOrgUnit", orgUnits);
        retMap.put("Source_BgScheme", ((BgSchemeInfo)this.comboBgScheme.getSelectedItem()).getRootId().toString());
        retMap.put("Target_BgScheme", ((BgSchemeInfo)this.comboTargetBgScheme.getSelectedItem()).getRootId().toString());
        retMap.put("RateValue", BgHelper.getBigDecimal(this.spnRate.getValue()));
        this.setValMap(retMap);
        if (this.rbBudget.isSelected()) {
            this.setGetBudgetValue(true);
        } else {
            this.setGetBudgetValue(false);
        }
        this.destroyWindow();
    }

    private void verify() {
        if (this.prmtOrgUnit.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("orgUnitInfoIsNull"));
            SysUtil.abort();
        }
        if (this.comboBgScheme.getSelectedItem() == null || this.comboTargetBgScheme.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("bgSchemeInfoIsNull"));
            SysUtil.abort();
        } else {
            BgSchemeInfo bgSSchemeInfo = (BgSchemeInfo)this.comboBgScheme.getSelectedItem();
            BgSchemeInfo bgTSchemeInfo = (BgSchemeInfo)this.comboTargetBgScheme.getSelectedItem();
            if (bgSSchemeInfo.getId().toString().equals(bgTSchemeInfo.getId().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)this.getMessageInfo("bgSchemeRepeat"));
                SysUtil.abort();
            }
        }
    }

    protected String getMessageInfo(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return "";
        }
        return EASResource.getString((String)SOURCESTR, (String)key);
    }

    public CtrlUnitInfo getCtrlUnit() {
        return this.currCU;
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }
}

