/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgDataFacadeFactory;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.IBgDataFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.client.AbstractBgHistoryDataUI;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgHistoryDataUI
extends AbstractBgHistoryDataUI {
    private static final Logger logger = CoreUIObject.getLogger(BgHistoryDataUI.class);
    private IBgDataFacade ibgdatafacade = null;
    private BOSUuid orgUnitId = null;
    private BOSUuid bgSchemeId = null;
    private String formulaString = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setEnabled(false);
        this.btnSubmit.setVisible(false);
        this.btnCancel.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"117_BgAdjustViewUI"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuTool.setVisible(false);
        if (this.getUIContext().get("hisOrgUnitID") != null) {
            this.orgUnitId = (BOSUuid)this.getUIContext().get("hisOrgUnitID");
        }
        if (this.getUIContext().get("hisBgSchemeID") != null) {
            this.bgSchemeId = (BOSUuid)this.getUIContext().get("hisBgSchemeID");
        }
        if (this.getUIContext().get("hisFormula") != null) {
            this.formulaString = (String)this.getUIContext().get("hisFormula");
        }
        if (this.orgUnitId != null && this.bgSchemeId != null && this.formulaString != null) {
            String[] parameter = null;
            String[] info = null;
            List formulaHint = null;
            List hisData = null;
            FormulaHint formulas = null;
            try {
                formulaHint = TableToolkit.parseFormula((String)this.formulaString, (boolean)false);
            }
            catch (ParserException ex) {
                logger.error((Object)ex.getMessage());
            }
            if (formulaHint != null) {
                formulas = (FormulaHint)formulaHint.get(0);
                parameter = formulas.getParams();
                formulaHint.clear();
            }
            this.ibgdatafacade = BgDataFacadeFactory.getRemoteInstance();
            if (this.ibgdatafacade != null) {
                hisData = this.ibgdatafacade.getHistoryData(this.orgUnitId, this.bgSchemeId, parameter);
            }
            this.tblMain.checkParsed();
            if (hisData != null && !hisData.isEmpty()) {
                IRow row = null;
                int i = 0;
                int j = 0;
                int n = 0;
                n = hisData.size();
                for (i = 1; i < n; ++i) {
                    info = (String[])hisData.get(i);
                    if ((info[4] == null || info[4].length() == 0) && (info[5] == null || info[5].length() == 0) || new BigDecimal(info[4]).intValue() == 0 && new BigDecimal(info[5]).intValue() == 0) continue;
                    row = this.tblMain.addRow();
                    for (j = 0; j < info.length; ++j) {
                        row.getCell(j).setValue((Object)info[j]);
                    }
                }
                if (parameter != null && parameter.length > 0) {
                    this.txtItemNumber.setText(parameter[0]);
                }
                this.txtItemName.setText(hisData.get(0).toString());
                BgElementCollection elementCol = null;
                BgElementInfo elementInfo = null;
                IBgElement ibgElement = BgElementFactory.getRemoteInstance();
                if (ibgElement != null) {
                    if (parameter != null) {
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
                        view.setFilter(filter);
                        SelectorItemCollection sc = new SelectorItemCollection();
                        sc.add(new SelectorItemInfo("id"));
                        sc.add(new SelectorItemInfo("number"));
                        sc.add(new SelectorItemInfo("name"));
                        view.getSelector().addObjectCollection((IObjectCollection)sc);
                        elementCol = ibgElement.getBgElementCollection(view);
                    }
                    if (elementCol != null) {
                        Iterator iter = elementCol.iterator();
                        while (iter.hasNext()) {
                            elementInfo = (BgElementInfo)iter.next();
                            this.txtElementName.setText(elementInfo.getName());
                        }
                        elementCol.clear();
                    }
                }
            }
            this.tblMain.addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    BgHistoryDataUI.this.sort(e);
                }
            });
            KDTSortManager sort = new KDTSortManager(this.tblMain);
            this.tblMain.setSortMange(sort);
            this.reSort(1, this.tblMain.getColumnIndex("bgScheme.name"));
            sort.sort(this.tblMain.getColumnIndex("bgScheme.name"), 1);
        }
    }

    private void sort(KDTMouseEvent e) {
        if (e.getType() == 0 && e.getClickCount() == 1) {
            int colIndex = e.getColIndex();
            KDTSortManager sort = this.tblMain.getSortMange();
            IColumn col = this.tblMain.getColumn(colIndex);
            int sortType = 0;
            if (col.getUserObject() instanceof Map) {
                Map map = (Map)col.getUserObject();
                if (map != null && !map.isEmpty()) {
                    sortType = Integer.parseInt(map.get("sortType").toString());
                    sortType = 0 == sortType ? 1 : 0;
                    map.clear();
                    map.put("sortType", sortType);
                }
                col.setUserObject((Object)map);
            } else {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("sortType", sortType);
                col.setUserObject(map);
            }
            sort.sort(colIndex, sortType);
            this.reSort(sortType, colIndex);
            this.tblMain.repaint();
        }
    }

    private void reSort(int sortType, int colIndex) {
        String key;
        if (this.tblMain == null || this.tblMain.getRowCount() < 1) {
            return;
        }
        HashMap<String, IRow> valueMap = new HashMap<String, IRow>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (int index = 0; index < this.tblMain.getRowCount(); ++index) {
            IRow row = this.tblMain.getRow(index);
            key = row.getCell(colIndex).getValue().toString() + "_" + index;
            keyList.add(key);
            valueMap.put(key, row);
        }
        if (keyList == null || keyList.isEmpty()) {
            return;
        }
        Collections.sort(keyList);
        this.tblMain.removeRows();
        if (0 == sortType) {
            for (int k = 0; k < keyList.size(); ++k) {
                key = keyList.get(k).toString();
                if (!valueMap.containsKey(key)) continue;
                this.tblMain.addRow(k, (IRow)valueMap.get(key));
            }
        } else {
            int n = 0;
            for (int k = keyList.size() - 1; k >= 0; --k) {
                key = keyList.get(k).toString();
                if (!valueMap.containsKey(key)) continue;
                this.tblMain.addRow(n, (IRow)valueMap.get(key));
                ++n;
            }
        }
    }
}

