/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgItemFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgItemAssignUI;
import com.kingdee.eas.ma.budget.client.BgItemGroupInDialog;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.budget.client.ProgressDialogUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgItemAssignUI
extends AbstractBgItemAssignUI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemAssignUI.class);
    public static final String ASSIGNED = "ASSIGNED";
    public static final String NON_ASSIGNED = "NON_ASSIGNED";
    public static final String ALL = "ALL";
    public static final String IS_CANCEL_ASSIGN = "IS_CANCEL_ASSIGN";
    private boolean isCancelAssign = false;
    private TreeModel treeModelOld = null;
    private Object itemGroupOld = null;
    protected OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
    protected CostCenterOrgUnitInfo ccoInfo = SysContext.getSysContext().getCurrentCostUnit();

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeOrgUnit.setModel(null);
        this.rbNotAssigned.setSelected(true);
        Object _obj = this.getUIContext().get(IS_CANCEL_ASSIGN);
        if (_obj instanceof Boolean) {
            boolean b = (Boolean)_obj;
            this.setCancelAssign(b);
        }
        if (this.isCancelAssign()) {
            this.setUITitle(this.getResource("bgItem") + this.getResource("cancelAssign"));
            this.rbAssigned.setSelected(true);
            this.rbNotAssigned.setEnabled(false);
            this.btnAssign.setText(this.getResource("cancelAssign"));
            this.btnAssign.setToolTipText(this.getResource("cancelAssign"));
            this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        } else {
            this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        }
        this.treeOrgUnit.setShowCheckBox(true);
        this.treeOrgUnit.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    BgItemAssignUI.this.treeOrgUnit_mouseClicked(e);
                }
                catch (Exception exc) {
                    BgItemAssignUI.this.handUIException(exc);
                }
            }
        });
        BgItemGroupInDialog boxItemGroup = new BgItemGroupInDialog((IUIObject)this);
        this.bizItemGroup.setSelector((KDPromptSelector)boxItemGroup);
        this.bizItemGroup.setEditFormat("$number$");
        this.bizItemGroup.setEditable(false);
        this.initOrgUnitTree();
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                block7: {
                    String parentLongNumber;
                    String childLongNumber;
                    String longNumber;
                    Boolean seleted;
                    IRow row;
                    int rowCount;
                    block8: {
                        block9: {
                            if (e.getColIndex() != 0) break block7;
                            int rowIndex = e.getRowIndex();
                            rowCount = BgItemAssignUI.this.tblMain.getRowCount();
                            row = BgItemAssignUI.this.tblMain.getRow(rowIndex);
                            seleted = (Boolean)row.getCell("selected").getValue();
                            longNumber = (String)row.getCell("longNumber").getValue();
                            childLongNumber = null;
                            parentLongNumber = longNumber + "!";
                            if (BgItemAssignUI.this.isCancelAssign()) break block8;
                            if (seleted.booleanValue()) break block9;
                            row.getCell("selected").setValue((Object)new Boolean(true));
                            parentLongNumber = null;
                            for (int i = rowIndex - 1; i >= 0; --i) {
                                Boolean parentSelected;
                                parentLongNumber = (String)BgItemAssignUI.this.tblMain.getRow(i).getCell("longNumber").getValue();
                                if (!longNumber.startsWith(parentLongNumber + "!") || (parentSelected = (Boolean)BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").getValue()).booleanValue()) continue;
                                BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").setValue((Object)new Boolean(true));
                            }
                            break block7;
                        }
                        if (!seleted.booleanValue()) break block7;
                        row.getCell("selected").setValue((Object)new Boolean(false));
                        childLongNumber = null;
                        for (int i = rowIndex + 1; i < rowCount; ++i) {
                            Boolean childSelected;
                            childLongNumber = (String)BgItemAssignUI.this.tblMain.getRow(i).getCell("longNumber").getValue();
                            if (!childLongNumber.startsWith(longNumber + "!") || !(childSelected = (Boolean)BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").getValue()).booleanValue()) continue;
                            BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").setValue((Object)new Boolean(false));
                        }
                        break block7;
                    }
                    if (!seleted.booleanValue()) {
                        row.getCell("selected").setValue((Object)new Boolean(true));
                        childLongNumber = null;
                        parentLongNumber = longNumber + "!";
                        for (int i = rowIndex + 1; i < rowCount && (childLongNumber = (String)BgItemAssignUI.this.tblMain.getRow(i).getCell("longNumber").getValue()).startsWith(parentLongNumber); ++i) {
                            Boolean childSelected = (Boolean)BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").getValue();
                            if (childSelected.booleanValue()) continue;
                            BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").setValue((Object)new Boolean(true));
                        }
                    } else if (seleted.booleanValue()) {
                        row.getCell("selected").setValue((Object)new Boolean(false));
                        parentLongNumber = null;
                        for (int i = rowIndex - 1; i >= 0 && longNumber.startsWith((parentLongNumber = (String)BgItemAssignUI.this.tblMain.getRow(i).getCell("longNumber").getValue()) + "!"); --i) {
                            Boolean parentSelected = (Boolean)BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").getValue();
                            if (!parentSelected.booleanValue()) continue;
                            BgItemAssignUI.this.tblMain.getRow(i).getCell("selected").setValue((Object)new Boolean(false));
                        }
                    }
                }
            }
        });
    }

    public void onShow() throws Exception {
        super.onShow();
        this.lblAccountForAssigned.setOpaque(false);
        this.btnSelectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnDisselectAllOU.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnAllSelect.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnAllDisSelect.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.tblMain.getColumn("selected").setWidth(32);
    }

    private void initOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = OrgViewType.COSTCENTER;
        if (orgViewType == null) {
            return;
        }
        try {
            OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
            String rootUnitID = orgUnitInfo.getId().toString();
            this.treeModelOld = BgNFSHelper.getOrgTreeModel((String)rootUnitID, (KDTree)this.treeOrgUnit);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
            root.setCheckBoxVisible(false);
            this.treeOrgUnit.setModel(this.treeModelOld);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
    }

    private void refreshTblMain() throws Exception {
        Object obj = this.bizItemGroup.getData();
        BgItemGroupInfo itemGroupInfo = null;
        if (!(obj instanceof BgItemGroupInfo)) {
            this.clearTblMain();
            return;
        }
        itemGroupInfo = (BgItemGroupInfo)obj;
        List orgUnits = this.getSelectedOrgUnits();
        if (orgUnits == null || orgUnits.isEmpty()) {
            this.clearTblMain();
            return;
        }
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        for (int i = 0; i < orgUnits.size(); ++i) {
            orgUnitIds.add(((FullOrgUnitInfo)orgUnits.get(i)).getId().toString());
        }
        IBgItemFacade facade = this.getBgItemFacadeInterface();
        BgItemCollection itemCol = null;
        BgItemInfo itemInfo = null;
        if (this.rbNotAssigned.isSelected()) {
            itemCol = facade.getCollection(itemGroupInfo.getId().toString(), this.ccoInfo.getId().toString(), orgUnitIds, NON_ASSIGNED);
        } else if (this.rbAssigned.isSelected()) {
            itemCol = facade.getCollection(itemGroupInfo.getId().toString(), this.ccoInfo.getId().toString(), orgUnitIds, ASSIGNED);
        } else if (this.rbAll.isSelected()) {
            itemCol = facade.getCollection(itemGroupInfo.getId().toString(), this.ccoInfo.getId().toString(), orgUnitIds, ALL);
        }
        if (itemCol != null) {
            this.tblMain.checkParsed();
            this.tblMain.removeRows();
            for (int i = 0; i < itemCol.size(); ++i) {
                itemInfo = itemCol.get(i);
                IRow row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)itemInfo.getId().toString());
                row.getCell("number").setValue((Object)itemInfo.getNumber());
                row.getCell("name").setValue((Object)itemInfo.getName());
                row.getCell("selected").setValue((Object)new Boolean(true));
                row.getCell("longNumber").setValue((Object)itemInfo.getLongNumber());
                row.getCell("level").setValue((Object)new Integer(itemInfo.getLevel()));
                row.getCell("isLeaf").setValue((Object)new Boolean(itemInfo.isIsLeaf()));
                row.getCell("parentId").setValue((Object)itemInfo.getParent().getId().toString());
            }
        }
    }

    private void clearTblMain() {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.repaint();
    }

    private List getSelectedBgItems() {
        IRow row = null;
        ICell idCell = null;
        ICell selectedCell = null;
        ArrayList<Object> idList = new ArrayList<Object>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            idCell = row.getCell("id");
            selectedCell = row.getCell("selected");
            if (idCell == null || selectedCell == null || !(idCell.getValue() instanceof String) || !(selectedCell.getValue() instanceof Boolean) || !((Boolean)selectedCell.getValue()).booleanValue()) continue;
            idList.add(idCell.getValue());
        }
        return idList;
    }

    protected void treeOrgUnit_mouseClicked(MouseEvent e) throws Exception {
        super.treeOrgUnit_mouseReleased(e);
        this.refreshTblMain();
    }

    @Override
    protected void bizItemGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.bizItemGroup_dataChanged(e);
        if (this.bizItemGroup.getData() != null) {
            this.itemGroupOld = this.bizItemGroup.getData();
        } else {
            this.bizItemGroup.setData(this.itemGroupOld);
        }
        this.refreshTblMain();
    }

    @Override
    protected void rbAll_actionPerformed(ActionEvent e) throws Exception {
        super.rbAll_actionPerformed(e);
        this.refreshTblMain();
    }

    @Override
    protected void rbAssigned_actionPerformed(ActionEvent e) throws Exception {
        super.rbAssigned_actionPerformed(e);
        this.refreshTblMain();
    }

    @Override
    protected void rbNotAssigned_actionPerformed(ActionEvent e) throws Exception {
        super.rbNotAssigned_actionPerformed(e);
        this.refreshTblMain();
    }

    @Override
    protected void btnSelectAllOU_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAllOU_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.treeOrgUnitSelect(root, true);
        root.setChecked(false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnDisselectAllOU_actionPerformed(ActionEvent e) throws Exception {
        super.btnDisselectAllOU_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.treeOrgUnitSelect(root, false);
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnAllSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnAllSelect_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblMain.getRow(i).getCell("selected").setValue((Object)new Boolean(true));
        }
    }

    @Override
    protected void btnAllDisSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnAllDisSelect_actionPerformed(e);
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.tblMain.getRow(i).getCell("selected").setValue((Object)new Boolean(false));
        }
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        super.actionAssign_actionPerformed(e);
        this.verifyInput();
        List orgUnits = this.getSelectedOrgUnits();
        List bgItems = this.getSelectedBgItems();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)uiContext);
        if (!this.isCancelAssign()) {
            int isConfirm = MsgBox.showConfirm2((String)this.getResource("confirmAssign"));
            if (isConfirm != 0) {
                SysUtil.abort();
            }
            if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
                ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
                ui.setShowTableMessage(true);
                this.initParameterValueForAssign(ui, orgUnits, bgItems);
                ui.init();
                window.show();
            }
        } else if (this.isCancelAssign()) {
            int isConfirm = MsgBox.showConfirm2((String)this.getResource("confirmCancelAssign"));
            if (isConfirm != 0) {
                SysUtil.abort();
            }
            if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
                ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
                ui.setShowTableMessage(true);
                this.initParameterValueForCancelAssign(ui, orgUnits, bgItems);
                ui.init();
                window.show();
            }
        }
    }

    private void initParameterValueForAssign(ProgressDialogUI ui, List orgUnits, List bgItems) {
        if (ui == null || orgUnits == null || bgItems == null || orgUnits.isEmpty() || bgItems.isEmpty()) {
            return;
        }
        Class[] cla = new Class[]{FullOrgUnitInfo.class, List.class};
        ui.setUITitle(this.getResource("bgItem") + this.getResource("assign"));
        ui.setInvokeClass(((Object)((Object)this)).getClass().getName());
        ui.setInvokeMethod("invokeMethodAssign");
        ui.setInvokeMethodParmeterType(cla);
        Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
        FullOrgUnitInfo orgUnit = null;
        Collections.sort(orgUnits, new Comparator(){

            public int compare(Object o1, Object o2) {
                FullOrgUnitInfo org1 = (FullOrgUnitInfo)o1;
                FullOrgUnitInfo org2 = (FullOrgUnitInfo)o2;
                return org2.getLongNumber().compareTo(org1.getLongNumber());
            }
        });
        for (int i = 0; i < orgUnits.size(); ++i) {
            Object[] obj = new Object[2];
            orgUnit = (FullOrgUnitInfo)orgUnits.get(i);
            obj[0] = orgUnit;
            obj[1] = bgItems;
            vecPrameterValue.add(obj);
        }
        int size = vecPrameterValue.size();
        int objlength = 2;
        Object[][] valueMethod = new Object[size][objlength];
        for (int i = 0; i < size; ++i) {
            Object[] obj = (Object[])vecPrameterValue.get(i);
            for (int j = 0; j < objlength; ++j) {
                valueMethod[i][j] = obj[j];
            }
        }
        ui.setInvokeMethodParmeterValue(valueMethod);
        ui.setCountSum(vecPrameterValue.size());
    }

    public Object invokeMethodAssign(FullOrgUnitInfo orgUnit, List bgItems) throws Exception {
        if (orgUnit == null || bgItems == null || bgItems.isEmpty()) {
            return null;
        }
        Object[] obj = new Object[2];
        List list = null;
        try {
            IBgItemFacade facade = this.getBgItemFacadeInterface();
            list = facade.assign(this.ccoInfo.getId().toString(), orgUnit.getId().toString(), bgItems, true);
            obj[1] = list;
        }
        catch (Exception exc) {
            if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                throw new BOSException("\u4f1a\u8bdd\u4e22\u5931");
            }
            throw exc;
        }
        obj[0] = "\u6b63\u5728\u5206\u914d\u9884\u7b97\u9879\u76ee\u5230\u7ec4\u7ec7\uff1a" + orgUnit.getName();
        return obj;
    }

    private void initParameterValueForCancelAssign(ProgressDialogUI ui, List orgUnits, List bgItems) {
        if (ui == null || orgUnits == null || bgItems == null || orgUnits.isEmpty() || bgItems.isEmpty()) {
            return;
        }
        Class[] cla = new Class[]{FullOrgUnitInfo.class, List.class};
        ui.setUITitle(this.getResource("bgItem") + this.getResource("cancelAssign"));
        ui.setInvokeClass(((Object)((Object)this)).getClass().getName());
        ui.setInvokeMethod("invokeMethodCancelAssign");
        ui.setInvokeMethodParmeterType(cla);
        Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
        FullOrgUnitInfo orgUnit = null;
        for (int i = 0; i < orgUnits.size(); ++i) {
            Object[] obj = new Object[2];
            orgUnit = (FullOrgUnitInfo)orgUnits.get(i);
            obj[0] = orgUnit;
            obj[1] = bgItems;
            vecPrameterValue.add(obj);
        }
        int size = vecPrameterValue.size();
        int objlength = 2;
        Object[][] valueMethod = new Object[size][objlength];
        for (int i = 0; i < size; ++i) {
            Object[] obj = (Object[])vecPrameterValue.get(i);
            for (int j = 0; j < objlength; ++j) {
                valueMethod[i][j] = obj[j];
            }
        }
        ui.setInvokeMethodParmeterValue(valueMethod);
        ui.setCountSum(vecPrameterValue.size());
    }

    public Object invokeMethodCancelAssign(FullOrgUnitInfo orgUnit, List bgItems) throws Exception {
        if (orgUnit == null || bgItems == null || bgItems.isEmpty()) {
            return null;
        }
        Object[] obj = new Object[2];
        List list = null;
        try {
            IBgItemFacade facade = this.getBgItemFacadeInterface();
            list = facade.cancelAssign(orgUnit.getId().toString(), bgItems, true);
            obj[1] = list;
        }
        catch (Exception exc) {
            if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                throw new BOSException("\u4f1a\u8bdd\u4e22\u5931");
            }
            throw exc;
        }
        obj[0] = "\u6b63\u5728\u53cd\u5206\u914d\u9884\u7b97\u9879\u76ee\uff0c\u7ec4\u7ec7\uff1a" + orgUnit.getName();
        return obj;
    }

    private void verifyInput() {
        boolean pass = false;
        ICell cell = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            boolean selected;
            cell = this.tblMain.getRow(i).getCell("selected");
            if (cell == null || !(cell.getValue() instanceof Boolean) || !(selected = ((Boolean)cell.getValue()).booleanValue())) continue;
            pass = true;
            break;
        }
        if (!pass) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u9879\u76ee!");
            SysUtil.abort();
        }
    }

    private void treeOrgUnitSelect(DefaultKingdeeTreeNode root, boolean isSelected) throws Exception {
        if (root == null) {
            return;
        }
        final DefaultKingdeeTreeNode tmpNode = root;
        final boolean tmpSelected = isSelected;
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgItemAssignUI.this.treeOrgUnitSelectAll(tmpNode, tmpSelected);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void treeOrgUnitSelectAll(DefaultKingdeeTreeNode root, boolean isSelected) throws Exception {
        if (root == null) {
            return;
        }
        root.setChecked(isSelected);
        DefaultKingdeeTreeNode node = null;
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setChecked(isSelected);
            if (node.isLeaf()) continue;
            BgNFSHelper.addChildNode((DefaultKingdeeTreeNode)node);
            this.treeOrgUnitSelectAll(node, isSelected);
        }
    }

    private List getSelectedOrgUnits() {
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        ArrayList orgUnits = new ArrayList();
        this.deepViewTree(orgUnits, rootNode);
        return orgUnits;
    }

    private void deepViewTree(List orgUnits, DefaultKingdeeTreeNode rootNode) {
        Enumeration children = rootNode.children();
        OrgStructureInfo oui = null;
        FullOrgUnitInfo orgUnit = null;
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (node.isChecked()) {
                oui = (OrgStructureInfo)node.getUserObject();
                if (oui == null || oui.getUnit() == null) continue;
                orgUnit = oui.getUnit();
                orgUnit.setLongNumber(oui.getLongNumber());
                if (!orgUnits.contains(orgUnit)) {
                    orgUnits.add(orgUnit);
                }
            }
            if (node.isLeaf()) continue;
            this.deepViewTree(orgUnits, node);
        }
    }

    private void tblMainSelectAll(boolean state) {
        ICell cell = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            cell = this.tblMain.getRow(i).getCell("selected");
            if (cell == null) continue;
            cell.setValue((Object)new Boolean(state));
        }
    }

    protected IBgItem getBgItemInterface() throws Exception {
        return BgItemFactory.getRemoteInstance();
    }

    protected IBgItemFacade getBgItemFacadeInterface() throws Exception {
        return BgItemFacadeFactory.getRemoteInstance();
    }

    public boolean isCancelAssign() {
        return this.isCancelAssign;
    }

    public void setCancelAssign(boolean isCancelAssign) {
        this.isCancelAssign = isCancelAssign;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)key);
    }
}

