/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgItemF7UIForFill;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgItemGroupInDialog;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BgItemF7UIForFill
extends AbstractBgItemF7UIForFill {
    private static final Logger logger = CoreUIObject.getLogger(BgItemF7UIForFill.class);
    private boolean isCancel = true;
    private BgItemCollection result = new BgItemCollection();
    private boolean isGetPater = false;
    private boolean isFiltrate = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(10);
        BgItemGroupInDialog dialog = new BgItemGroupInDialog((IUIObject)this);
        this.prmtItemGroup.setSelector((KDPromptSelector)dialog);
        this.kDSelectName.setSelectedIndex(1);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        KDTRange range = this.table.getSelectManager().toRange();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                BgItemInfo item = (BgItemInfo)this.table.getRow(j).getUserObject();
                this.result.add(item);
            }
        }
        if (this.isGetPater && this.result != null) {
            this.result = BgClientHelper.getBgItemCol(this.result);
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void table_tableClicked(KDTMouseEvent e) throws Exception {
        super.table_tableClicked(e);
    }

    @Override
    protected void prmtItemGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtItemGroup_dataChanged(e);
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        BgItemGroupInfo info = null;
        String groupID = null;
        info = (BgItemGroupInfo)this.prmtItemGroup.getData();
        if (info == null) {
            return;
        }
        groupID = info.getId().toString();
        IQueryExecutor queryExecutor = null;
        queryExecutor = this.isFiltrate ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemEfficiencyQuery")) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemQuery"));
        queryExecutor.setObjectView(" WHERE bgItemGroup.id = '" + groupID + "' ");
        EntityViewInfo viewInfo = queryExecutor.getObjectView();
        FilterInfo filter = viewInfo.getFilter();
        BgClientHelper.getInsulateItem(orgUnit, filter);
        if (BgParamCHelper.isFodian()) {
            BgClientHelper.getOtherOrg(orgUnit, filter);
        }
        viewInfo.setFilter(filter);
        queryExecutor.setObjectView(viewInfo);
        IRowSet rowSet = queryExecutor.executeQuery();
        BgItemCollection bgItemCollection = new BgItemCollection();
        while (rowSet.next()) {
            BgItemInfo item = this.createBgItem(rowSet);
            bgItemCollection.add(item);
            item.put("myItemGroup", item.getBgItemGroup());
        }
        if (bgItemCollection != null) {
            this.buildTable(bgItemCollection);
        } else {
            this.table.removeRows();
        }
    }

    private BgItemInfo createBgItem(IRowSet rowSet) throws SQLException {
        String id = rowSet.getString("id");
        String number = rowSet.getString("number");
        String name = rowSet.getString("name");
        String refField = rowSet.getString("refField");
        String specialNumber = rowSet.getString("specialNumber");
        String bgItemGroupId = rowSet.getString("bgItemGroup.id");
        String bgItemGroupName = rowSet.getString("bgItemGroup.name");
        String bgItemGroupNumber = rowSet.getString("bgItemGroup.number");
        String bgIsEffective = rowSet.getString("isEffective");
        BgItemInfo item = new BgItemInfo();
        item.setId(BOSUuid.read((String)id));
        item.setNumber(number);
        item.setName(name);
        item.setRefField(refField);
        item.setSpecialNumber(specialNumber);
        if (bgIsEffective.equalsIgnoreCase("false")) {
            item.setIsEffective(false);
        } else {
            item.setIsEffective(true);
        }
        BgItemGroupInfo group = new BgItemGroupInfo();
        group.setId(BOSUuid.read((String)bgItemGroupId));
        group.setNumber(bgItemGroupNumber);
        group.setName(bgItemGroupName);
        group.setRefField(refField);
        item.setBgItemGroup(group);
        return item;
    }

    private void buildTable(BgItemCollection coll) {
        this.table.removeRows();
        for (int i = 0; i < coll.size(); ++i) {
            BgItemInfo item = coll.get(i);
            if (!item.isIsEffective()) continue;
            IRow row = this.table.addRow();
            row.setUserObject((Object)item);
            row.getCell("number").setValue((Object)item.getNumber());
            row.getCell("name").setValue((Object)item.getName());
            row.getCell("spNumber").setValue((Object)item.getSpecialNumber());
            row.getCell("desc").setValue((Object)item.getDescription());
        }
    }

    @Override
    public void actionFastFind_actionPerformed(ActionEvent e) throws Exception {
        super.actionFastFind_actionPerformed(e);
        String selectName = this.kDSelectName.getSelectedItem().toString();
        String compare = this.kDCompare.getSelectedItem().toString();
        String textInputField = this.kDTextInputField.getText();
        String sql = this.getSql(selectName, compare, textInputField);
        IQueryExecutor queryExecutor = null;
        if (this.isFiltrate) {
            queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemEfficiencyQuery"));
            queryExecutor.setObjectView(sql);
        } else {
            queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemQuery"));
            queryExecutor.setObjectView(sql);
        }
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        EntityViewInfo viewInfo = queryExecutor.getObjectView();
        FilterInfo filter = viewInfo.getFilter();
        BgClientHelper.getInsulateItem(orgUnit, filter);
        if (BgParamCHelper.isFodian()) {
            BgClientHelper.getOtherOrg(orgUnit, filter);
        }
        viewInfo.setFilter(filter);
        queryExecutor.setObjectView(viewInfo);
        IRowSet rowSet = queryExecutor.executeQuery();
        BgItemCollection bgItemCollection = new BgItemCollection();
        while (rowSet.next()) {
            BgItemInfo item = this.createBgItem(rowSet);
            bgItemCollection.add(item);
            item.put("myItemGroup", item.getBgItemGroup());
        }
        if (bgItemCollection != null && bgItemCollection.get(0) != null && this.kDCompare.getSelectedIndex() == 0) {
            bgItemCollection = BgClientHelper.getBgItemCol(bgItemCollection);
            this.buildTable(bgItemCollection);
        } else if (bgItemCollection != null && bgItemCollection.get(0) != null) {
            this.buildTable(bgItemCollection);
        } else {
            this.table.removeRows();
        }
    }

    private String getSql(String selectName, String compare, String textInputField) {
        String sql = null;
        String name = null;
        String compareName = null;
        String inputField = null;
        String itemName = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"itemNumber");
        String compareKey = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"compare");
        name = selectName.equals(itemName) ? "number" : "name";
        if (compare.equals(compareKey)) {
            compareName = "like";
            inputField = "%" + textInputField + "%";
        } else {
            compareName = "=";
            inputField = textInputField;
        }
        sql = " where " + name + " " + compareName + " '" + inputField + "' or specialNumber " + compareName + " '" + inputField + "' and isEffective = 1";
        return sql;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public BgItemCollection getResult() {
        return this.result;
    }

    public void setResult(BgItemCollection result) {
        this.result = result;
    }

    public void setIsGetPater(boolean isGP) {
        this.isGetPater = isGP;
    }

    public boolean getIsGetPater() {
        return this.isGetPater;
    }

    public void setIsFiltrate(boolean isF) {
        this.isFiltrate = isF;
    }

    public boolean getIsFiltrate() {
        return this.isFiltrate;
    }
}

