/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaException;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.client.AbstractBgItemSelectListUI;
import com.kingdee.eas.ma.budget.client.BgExpProcess;
import com.kingdee.eas.ma.budget.client.BgItemGroupInDialog;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class BgItemSelectListUI
extends AbstractBgItemSelectListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemSelectListUI.class);
    protected BgExpProcess expProcess = null;
    protected Object[] expformula = null;
    protected Object[] expParameter = null;
    protected Object processUI = null;
    protected BgFormInfo bgFormInfo = null;
    protected KDTable proTable = null;
    protected boolean isRowProcess = true;
    protected int activeRowIndex = 0;
    protected int activeColIndex = 0;
    protected int proRowCount = 0;
    protected int proColCount = 0;
    protected int numTitle = -1;
    protected int numNumber = -1;

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgItemFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSystemInfo();
        this.initTableInfo();
    }

    protected void initSystemInfo() throws EASBizException {
        this.btnSearch.setText("");
        this.kdCheckSearch.setSelected(true);
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectClear.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAnti.setIcon(EASResource.getIcon((String)""));
        if (this.getUIContext().get("Owner") != null) {
            this.processUI = this.getUIContext().get("Owner");
        }
        if (this.getUIContext().get("bgFormInfo") != null && this.getUIContext().get("bgFormInfo") instanceof BgFormInfo) {
            this.bgFormInfo = (BgFormInfo)this.getUIContext().get("bgFormInfo");
        }
        if (this.getUIContext().get("BGFORMULA_TABLE") != null && this.getUIContext().get("BGFORMULA_TABLE") instanceof KDTable) {
            this.proTable = (KDTable)this.getUIContext().get("BGFORMULA_TABLE");
            if (this.proTable == null) {
                throw new BgFormulaException(BgFormulaException.PROCESSTABLEISNULL);
            }
            if (this.proTable.getUserObject() != null && this.proTable.getUserObject() instanceof HashMap) {
                HashMap aliasMap = (HashMap)this.proTable.getUserObject();
                this.isRowProcess = aliasMap.containsKey("BGFORMULA_ALIAS") ? Boolean.valueOf(aliasMap.get("BGFORMULA_ALIAS").toString()) != false : true;
            }
            this.activeRowIndex = this.proTable.getSelectManager().getActiveRowIndex();
            this.activeColIndex = this.proTable.getSelectManager().getActiveColumnIndex();
            this.proRowCount = this.proTable.getBody().size();
            this.proColCount = this.proTable.getColumnCount();
        }
        this.expProcess = BgExpProcess.getInstance(this.processUI);
        this.expformula = new Object[6];
        this.expParameter = new Object[8];
    }

    protected void initTableInfo() {
        this.prmtBgItemGroup.setSelector((KDPromptSelector)new BgItemGroupInDialog((IUIObject)this));
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("choose").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("specialNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("bgItemGroup.name").getStyleAttributes().setLocked(true);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent arg0) {
                BgItemSelectListUI.this.tblMain_afterDataFill(arg0);
            }
        });
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0, EntityViewInfo arg1) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = new FilterInfo();
        if (this.txtSearch.getText().trim().length() > 0) {
            if (this.kdCheckSearch.isSelected()) {
                String likeStr = "%";
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)(likeStr + this.txtSearch.getText() + likeStr), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)(likeStr + this.txtSearch.getText() + likeStr), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("specialNumber", (Object)(likeStr + this.txtSearch.getText() + likeStr), CompareType.LIKE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtSearch.getText(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)this.txtSearch.getText(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("specialNumber", (Object)this.txtSearch.getText(), CompareType.EQUALS));
            }
            if (this.prmtBgItemGroup.getData() != null) {
                BgItemGroupInfo bgItemGroupInfo = (BgItemGroupInfo)this.prmtBgItemGroup.getData();
                filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.number", (Object)bgItemGroupInfo.getNumber(), CompareType.EQUALS));
                filter.setMaskString("(#0 or #1 or #2) and #3");
            } else {
                filter.setMaskString("#0 or #1 or #2");
            }
        } else if (this.prmtBgItemGroup.getData() != null) {
            BgItemGroupInfo bgItemGroupInfo = (BgItemGroupInfo)this.prmtBgItemGroup.getData();
            filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.number", (Object)bgItemGroupInfo.getNumber(), CompareType.EQUALS));
            filter.setMaskString("#0");
        }
        arg1.setFilter(filter);
        queryExecutor = super.getQueryExecutor(arg0, arg1);
        return queryExecutor;
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.btnSubmit_actionPerformed(e);
        if (this.proTable == null) {
            throw new BgFormulaException(BgFormulaException.PROCESSTABLEISNULL);
        }
        this.processCreateFormulasInfo(this.proTable);
    }

    @Override
    protected void prmtBgItemGroup_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgItemGroup_dataChanged(e);
        this.txtSearch.setText("");
        this.execQuery();
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        super.txtSearch_focusLost(e);
        this.execQuery();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.execQuery();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        int rowCount = this.tblMain.getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.tblMain.getCell(rowIndex, 1).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    protected void btnSelectClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectClear_actionPerformed(e);
        int rowCount = this.tblMain.getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.tblMain.getCell(rowIndex, 1).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    protected void btnSelectAnti_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAnti_actionPerformed(e);
        ICell cell = null;
        int rowCount = this.tblMain.getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            cell = this.tblMain.getRow(rowIndex).getCell(1);
            if (cell.getValue() instanceof Boolean) {
                if (((Boolean)cell.getValue()).booleanValue()) {
                    cell.setValue((Object)Boolean.FALSE);
                    continue;
                }
                cell.setValue((Object)Boolean.TRUE);
                continue;
            }
            cell.setValue((Object)Boolean.TRUE);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent arg0) throws Exception {
        if (arg0.getClickCount() == 1 && arg0.getColIndex() == 1 || arg0.getClickCount() == 2) {
            ICell cell = this.tblMain.getRow(arg0.getRowIndex()).getCell(1);
            if (cell.getValue() instanceof Boolean) {
                if (((Boolean)cell.getValue()).booleanValue()) {
                    cell.setValue((Object)Boolean.FALSE);
                } else {
                    cell.setValue((Object)Boolean.TRUE);
                }
            } else {
                cell.setValue((Object)Boolean.TRUE);
            }
        }
    }

    protected void tblMain_afterDataFill(KDTDataRequestEvent arg0) {
        int rowCount = this.tblMain.getBody().size();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.tblMain.getCell(rowIndex, 1).setValue((Object)Boolean.FALSE);
        }
    }

    protected void processCreateFormulasInfo(KDTable table) {
        IRow row = null;
        ICell cell = null;
        BgItemInfo bgItemInfo = null;
        BgItemCollection bgItemCol = new BgItemCollection();
        int count = this.tblMain.getBody().size();
        for (int index = 0; index < count; ++index) {
            row = this.tblMain.getRow(index);
            cell = row.getCell("choose");
            if (cell.getValue() == null || !(cell.getValue() instanceof Boolean) || !((Boolean)cell.getValue()).booleanValue()) continue;
            bgItemInfo = new BgItemInfo();
            bgItemInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            bgItemInfo.setName(row.getCell("name").getValue().toString());
            bgItemInfo.setNumber(row.getCell("number").getValue().toString());
            if (row.getCell("specialNumber").getValue() != null) {
                bgItemInfo.setSpecialNumber(row.getCell("specialNumber").getValue().toString());
            }
            bgItemCol.add(bgItemInfo);
        }
        if (!bgItemCol.isEmpty()) {
            Map bgEleMap = this.processBgElementInfo(table);
            int activeSelectIndex = 0;
            activeSelectIndex = this.isRowProcess ? this.activeRowIndex : this.activeColIndex;
            Iterator iter = bgItemCol.iterator();
            while (iter.hasNext()) {
                bgItemInfo = (BgItemInfo)iter.next();
                if (this.isRowProcess) {
                    table.addRow(activeSelectIndex);
                } else {
                    table.addColumn(activeSelectIndex);
                }
                this.processCreateRowFormulaInfo(table, activeSelectIndex, bgItemInfo, bgEleMap);
                ++activeSelectIndex;
            }
            if (this.isRowProcess) {
                this.activeRowIndex += bgItemCol.size();
                this.proRowCount += bgItemCol.size();
            } else {
                this.activeColIndex += bgItemCol.size();
                this.proColCount += bgItemCol.size();
            }
            table.getSelectManager().select(this.activeRowIndex, this.activeColIndex, this.activeRowIndex, this.activeColIndex);
            table.repaint();
        }
    }

    protected Map processBgElementInfo(KDTable table) {
        HashMap<String, String[]> bgEleMap = new HashMap<String, String[]>();
        Map infoMap = null;
        if (table == null) {
            return bgEleMap;
        }
        String[] infoStr = null;
        IRow row = null;
        IColumn column = null;
        if (this.isRowProcess) {
            int count = this.proColCount;
            for (int index = 0; index < count; ++index) {
                column = table.getColumn(index);
                if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap)) continue;
                infoMap = (Map)column.getUserObject();
                if (infoMap.containsKey("BGFORMULA_BGELEMENT")) {
                    infoStr = new String[]{(String)infoMap.get("BGFORMULA_BGELEMENT"), (String)infoMap.get("BGFORMULA_BGELEMENT_NAME"), (String)infoMap.get("BGFORMULA_BGELEMENT_DATATYPE"), (String)infoMap.get("BGFORMULA_BGELEMENT_EXTTYPE"), (String)infoMap.get("BGFORMULA_BGELEMENT_EXTELEMENT"), (String)infoMap.get("BGFORMULA_BGPERIOD"), (String)infoMap.get("BGFORMULA_BGPERIOD_NAME"), (String)infoMap.get("BGFORMULA_CURRENCY"), (String)infoMap.get("BGFORMULA_CURRENCY_NAME")};
                    bgEleMap.put(String.valueOf(index), infoStr);
                }
                if (this.numNumber == -1 && infoMap.containsKey("BGFORMULA_ALIAS_NUMBER")) {
                    this.numNumber = index;
                }
                if (this.numTitle != -1 || !infoMap.containsKey("BGFORMULA_ALIAS_TITLE")) continue;
                this.numTitle = index;
            }
        } else {
            int count = this.proRowCount;
            for (int index = 0; index < count; ++index) {
                row = table.getRow(index);
                if (row.getUserObject() != null && row.getUserObject() instanceof HashMap && (infoMap = (Map)row.getUserObject()).containsKey("BGFORMULA_BGELEMENT")) {
                    infoStr = new String[]{(String)infoMap.get("BGFORMULA_BGELEMENT"), (String)infoMap.get("BGFORMULA_BGELEMENT_NAME"), (String)infoMap.get("BGFORMULA_BGELEMENT_DATATYPE"), (String)infoMap.get("BGFORMULA_BGELEMENT_EXTTYPE"), (String)infoMap.get("BGFORMULA_BGELEMENT_EXTELEMENT"), (String)infoMap.get("BGFORMULA_BGPERIOD"), (String)infoMap.get("BGFORMULA_BGPERIOD_NAME"), (String)infoMap.get("BGFORMULA_CURRENCY"), (String)infoMap.get("BGFORMULA_CURRENCY_NAME")};
                    bgEleMap.put(String.valueOf(index), infoStr);
                }
                if (infoMap == null) continue;
                if (this.numNumber == -1 && infoMap.containsKey("BGFORMULA_ALIAS_NUMBER")) {
                    this.numNumber = index;
                }
                if (this.numTitle != -1 || !infoMap.containsKey("BGFORMULA_ALIAS_TITLE")) continue;
                this.numTitle = index;
            }
        }
        return bgEleMap;
    }

    protected void processCreateRowFormulaInfo(KDTable table, int activeIndex, BgItemInfo bgItemInfo, Map bgEleMap) {
        if (table == null || bgItemInfo == null || activeIndex < 0) {
            return;
        }
        ICell cell = null;
        String indexStr = null;
        String titleString = null;
        String numberString = null;
        String[] infoStr = null;
        int index = 0;
        int count = 0;
        count = this.isRowProcess ? this.proColCount : this.proRowCount;
        for (index = 0; index < count; ++index) {
            indexStr = String.valueOf(index);
            if (!bgEleMap.containsKey(indexStr)) continue;
            infoStr = (String[])bgEleMap.get(indexStr);
            cell = this.isRowProcess ? table.getCell(activeIndex, index) : table.getCell(index, activeIndex);
            if (infoStr[5] == null || infoStr[5].trim().length() == 0) {
                if (this.bgFormInfo != null) {
                    infoStr[5] = this.bgFormInfo.getBgPeriod().getNumber();
                    infoStr[6] = this.bgFormInfo.getBgPeriod().getName();
                } else {
                    infoStr[5] = "";
                    infoStr[6] = "";
                }
            }
            if (infoStr[7] == null || infoStr[7].trim().length() == 0) {
                if (this.bgFormInfo != null) {
                    infoStr[7] = this.bgFormInfo.getCurrency().getNumber();
                    infoStr[8] = this.bgFormInfo.getCurrency().getName();
                } else {
                    infoStr[7] = "";
                    infoStr[8] = "";
                }
            }
            this.expformula[0] = bgItemInfo.getNumber();
            this.expformula[1] = infoStr[5];
            this.expformula[2] = infoStr[0];
            this.expformula[3] = BgDataTypeEnum.BgData.getName();
            this.expformula[4] = "true";
            this.expformula[5] = infoStr[7];
            this.expProcess.process(cell, false, 0, this.expformula);
            if (infoStr[3] == null || infoStr[3].trim().length() <= 0 || Integer.valueOf(infoStr[3]) == 0 || infoStr[4] == null || infoStr[4].trim().length() <= 0) continue;
            try {
                this.expParameter[0] = Boolean.TRUE.toString();
                this.expParameter[1] = this.bgFormInfo == null ? "" : this.bgFormInfo.getOrgUnit().getNumber();
                this.expParameter[2] = this.bgFormInfo == null ? "" : this.bgFormInfo.getBgScheme().getNumber();
                this.expParameter[3] = infoStr[4];
                this.expParameter[4] = bgItemInfo.getNumber();
                this.expParameter[5] = infoStr[7];
                this.expParameter[6] = BgPeriodHelper.getPreYearOfBgPeriodInfo(infoStr[5]).getNumber();
                this.expParameter[7] = this.expParameter[6];
                this.expProcess.process(cell, true, Integer.valueOf(infoStr[3]), this.expParameter);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        titleString = bgItemInfo.getName();
        numberString = bgItemInfo.getNumber();
        this.numNumber = this.numNumber == -1 ? 0 : this.numNumber;
        int n = this.numTitle = this.numTitle == -1 ? 0 : this.numTitle;
        if (this.numNumber == this.numTitle) {
            if (this.isRowProcess) {
                table.getCell(activeIndex, this.numNumber).setValue((Object)(numberString + "-" + titleString));
            } else {
                table.getCell(this.numNumber, activeIndex).setValue((Object)(numberString + "-" + titleString));
            }
        } else if (this.isRowProcess) {
            table.getCell(activeIndex, this.numNumber).setValue((Object)numberString);
            table.getCell(activeIndex, this.numTitle).setValue((Object)titleString);
        } else {
            table.getCell(this.numNumber, activeIndex).setValue((Object)numberString);
            table.getCell(this.numTitle, activeIndex).setValue((Object)titleString);
        }
        if (!this.isRowProcess) {
            BgSHelper.setColObject(table.getColumn(activeIndex), "BGFORMULA_BGITEM", bgItemInfo.getNumber());
            BgSHelper.setColObject(table.getColumn(activeIndex), "BGFORMULA_BGITEM_NAME", bgItemInfo.getName());
        }
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.btnClose_actionPerformed(e);
        if (this.expProcess != null) {
            this.expProcess.close();
        }
        this.getUIWindow().close();
    }
}

