/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgControlRuleSegmentInfo;
import com.kingdee.eas.ma.budget.BgEntity;
import com.kingdee.eas.ma.budget.BgMetaDataFactory;
import com.kingdee.eas.ma.budget.IBgMetaData;
import com.kingdee.eas.ma.budget.client.AbstractBgMetaDataTreeDlgUI;
import com.kingdee.eas.ma.budget.client.BgMetaDataTreeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;

public class BgMetaDataTreeDlgUI
extends AbstractBgMetaDataTreeDlgUI
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger(BgMetaDataTreeDlgUI.class);
    private EntityObjectInfo entity;
    private IBgMetaData targetMetaData;
    private boolean isCancel = false;
    private IBgMetaData bgMetaData;
    private String targetClazzName;

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeView.setShowButton(false);
        this.entity = (EntityObjectInfo)this.getUIContext().get("entity");
        this.targetClazzName = (String)this.getUIContext().get("targetClazz");
        this.setEntityAndTargetProperty(this.entity, this.targetClazzName);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setEntity(EntityObjectInfo entity) {
        this.entity = entity;
    }

    private void setEntityAndTargetProperty(EntityObjectInfo entity, EntityObjectInfo targetEntity) {
        BgEntity targetMetaData = BgMetaDataFactory.createBgEntity(targetEntity);
        this.setEntityAndTargetProperty(entity, targetMetaData);
    }

    private void setEntityAndTargetProperty(EntityObjectInfo entity, IBgMetaData targetMetaData) {
        BgMetaDataTreeUtil.buildTree(this.tree, entity, targetMetaData);
        this.treeView.setTitle(entity.getAlias());
    }

    private void setEntityAndTargetProperty(EntityObjectInfo entity, String targetClazz) {
        BgMetaDataTreeUtil.buildTree(this.tree, entity, targetClazz);
        this.treeView.setTitle(entity.getAlias());
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.actionConfirm();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tree_mouseClicked(MouseEvent e) throws Exception {
        super.tree_mouseClicked(e);
        if (e.getClickCount() == 2) {
            this.actionConfirm();
        }
    }

    private void actionConfirm() {
        DefaultKingdeeTreeNode node;
        if (this.tree.getSelectionPath() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCtrlRuleResource", (String)"selectProp"));
            SysUtil.abort();
        }
        if (((DefaultKingdeeTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getChildCount() != 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCtrlRuleResource", (String)"selectLeafProp"));
            SysUtil.abort();
        }
        if (BgMetaDataTreeUtil.canSafeConverse((IBgMetaData)(node = (DefaultKingdeeTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getUserObject(), this.targetClazzName)) {
            this.bgMetaData = (IBgMetaData)node.getUserObject();
            this.isCancel = false;
            this.getUIWindow().close();
        }
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public Object getData() {
        return this.buildRuleSegmentInfo(this.bgMetaData);
    }

    public BgControlRuleSegmentInfo buildRuleSegmentInfo(IBgMetaData bgMetaDataInfo) {
        if (bgMetaDataInfo == null) {
            return null;
        }
        BgControlRuleSegmentInfo result = new BgControlRuleSegmentInfo();
        result.setExpression(bgMetaDataInfo.getLongName());
        result.setAlias(bgMetaDataInfo.getLongAlias());
        return result;
    }
}

