/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAnalyseDiffFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgNAnalyseDiffFilterUI;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class BgNAnalyseDiffFilterUI
extends AbstractBgNAnalyseDiffFilterUI {
    private static final long serialVersionUID = -7349305392566496974L;
    private static final Logger logger = CoreUIObject.getLogger(BgNAnalyseDiffFilterUI.class);
    private int Col_Element = -1;
    private int Col_MeasureUnit = -1;
    private static final String BEGIN_ITEM_NUMBER = "BEGIN_ITEM_NUMBER";
    private static final String END_ITEM_NUMBER = "END_ITEM_NUMBER";
    private static final String BGELEMENT_IDS = "BGELEMENT_IDS";
    private static final String BGELEMNET_MEASUREUNIT_IDS = "BGELEMNET_MEASUREUNIT_IDS";

    public BgNAnalyseDiffFilterUI() throws Exception {
    }

    public BgNAnalyseDiffFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddLine.setEnabled(true);
        this.btnRemoveLine.setEnabled(true);
        this.contMeasureUnit.setVisible(false);
        this.comMeasureUnit.setVisible(false);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDLabel1.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.tblMain.checkParsed();
        this.Col_Element = this.tblMain.getColumnIndex("colElement");
        this.Col_MeasureUnit = this.tblMain.getColumnIndex("colMeasureUnit");
        this.init();
    }

    private void init() throws Exception {
        this.tblMain.setRefresh(false);
        this.tblMain.reLayoutAndPaint();
        KDBizPromptBox prmtSelect = new KDBizPromptBox();
        prmtSelect.setQueryInfo("com.kingdee.eas.ma.budget.F7BgElementQuery");
        prmtSelect.setVisible(true);
        prmtSelect.setEditable(false);
        prmtSelect.setEnabledMultiSelection(true);
        prmtSelect.setEditFormat("$number$");
        prmtSelect.setDisplayFormat("$name$");
        this.tblMain.getColumn(this.Col_Element).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("coefficient"));
        MeasureUnitInfo muInfo2 = null;
        MeasureUnitCollection muCol = null;
        KDTDefaultCellEditor editor = null;
        KDComboBox comboBox = new KDComboBox();
        DefaultComboBoxModel<MeasureUnitInfo> model = new DefaultComboBoxModel<MeasureUnitInfo>();
        try {
            muCol = this.getMeasureUnitInterface().getMeasureUnitCollection(muView);
            this.comMeasureUnit.removeAllItems();
            if (muCol != null && !muCol.isEmpty()) {
                for (MeasureUnitInfo muInfo2 : muCol) {
                    this.comMeasureUnit.addItem((Object)muInfo2);
                    model.addElement(muInfo2);
                }
            }
            comboBox.setModel(model);
            editor = new KDTDefaultCellEditor((JComboBox)comboBox);
            this.tblMain.getColumn(this.Col_MeasureUnit).setEditor((ICellEditor)editor);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected IMeasureUnit getMeasureUnitInterface() throws Exception {
        return MeasureUnitFactory.getRemoteInstance();
    }

    @Override
    public String getUITitle() {
        return BgAnalyseHelper.getMessage("bgDiffFilterTitle");
    }

    @Override
    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            Object _obj = this.prmtBgPeriodBegin.getData();
            if (_obj == null || !(_obj instanceof BgPeriodInfo)) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgPeriodBegin"));
                return false;
            }
            _obj = this.prmtBgPeriodEnd.getData();
            if (_obj == null || !(_obj instanceof BgPeriodInfo)) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgPeriodEnd"));
                return false;
            }
            if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodEnd.getData() != null) {
                BgPeriodInfo _begin = null;
                BgPeriodInfo _end = null;
                _begin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
                _end = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
                if (_begin.getPeriodType().getValue() != _end.getPeriodType().getValue()) {
                    MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgPeriodNoAccord"));
                    return false;
                }
            }
            if (this.prmtBgItemBegin.getData() != null && !((_obj = this.prmtBgItemBegin.getData()) instanceof VisualItemInfo)) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgItemBegin"));
                return false;
            }
            if (this.prmtBgItemEnd.getData() != null && !((_obj = this.prmtBgItemEnd.getData()) instanceof VisualItemInfo)) {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgItemEnd"));
                return false;
            }
            if (this.tblMain.getRowCount() > 0) {
                int i;
                HashSet<String> verifySet = new HashSet<String>();
                int size = 0;
                ArrayList<Integer> rowList = new ArrayList<Integer>();
                int rowCount = this.tblMain.getRowCount();
                for (i = 0; i < rowCount; ++i) {
                    ICell elementCell = this.tblMain.getCell(i, this.Col_Element);
                    ICell measureUnitCell = this.tblMain.getCell(i, this.Col_MeasureUnit);
                    if (elementCell.getValue() == null && measureUnitCell.getValue() == null) {
                        rowList.add(new Integer(i));
                        continue;
                    }
                    if (elementCell.getValue() == null) {
                        MsgBox.showWarning((String)BgAnalyseHelper.getMessage("elementIsNull"));
                        return false;
                    }
                    if (measureUnitCell.getValue() == null) {
                        MsgBox.showWarning((String)BgAnalyseHelper.getMessage("measureUnitIsNull"));
                        return false;
                    }
                    String elementNumber = ((BgElementInfo)elementCell.getValue()).getNumber();
                    verifySet.add(elementNumber);
                    ++size;
                }
                for (i = rowList.size() - 1; i >= 0; --i) {
                    int rowIndex = (Integer)rowList.get(i);
                    this.tblMain.removeRow(rowIndex);
                }
                if (verifySet.size() < size) {
                    MsgBox.showWarning((String)BgAnalyseHelper.getMessage("elementIsRepeat"));
                    return false;
                }
            }
        }
        return re;
    }

    @Override
    public void clear() {
        super.clear();
        this.prmtBgItemBegin.setData(null);
        this.prmtBgItemEnd.setData(null);
        this.tblMain.removeRows();
    }

    @Override
    protected void initFilter() throws Exception {
        super.initFilter();
        this.initSelectBgItem();
    }

    protected void initSelectBgItem() throws Exception {
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        String orgUnitId = "";
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null) {
            if (obj instanceof FullOrgUnitInfo) {
                orgUnitId = ((FullOrgUnitInfo)obj).getId().toString();
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnitId = ((OrgUnitInfo[])obj)[0].getId().toString();
            }
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            bgItemSelect.setOrgUnitId("NULL_ORGUNITID");
        } else {
            bgItemSelect.setOrgUnitId(orgUnitId);
        }
        this.prmtBgItemBegin.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtBgItemEnd.setSelector((KDPromptSelector)bgItemSelect);
    }

    @Override
    protected void orgUnit_dataChanged(DataChangeEvent e) throws Exception {
        NewBgItemDialog bgItemSelect = new NewBgItemDialog((IUIObject)this);
        String orgUnitId = "";
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null) {
            if (obj instanceof FullOrgUnitInfo) {
                orgUnitId = ((FullOrgUnitInfo)obj).getId().toString();
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnitId = ((OrgUnitInfo[])obj)[0].getId().toString();
            }
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            bgItemSelect.setOrgUnitId("NULL_ORGUNITID");
        } else {
            bgItemSelect.setOrgUnitId(orgUnitId);
        }
        this.prmtBgItemBegin.setSelector((KDPromptSelector)bgItemSelect);
        this.prmtBgItemEnd.setSelector((KDPromptSelector)bgItemSelect);
        super.orgUnit_dataChanged(e);
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgAnalyseDiffFilterParam();
    }

    @Override
    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _fp = super.getFilterParam(mainParam, filterParam);
        BgAnalyseDiffFilterParam _mainParam = null;
        BgAnalyseDiffFilterParam _filterParam = null;
        if (_fp != null) {
            _mainParam = (BgAnalyseDiffFilterParam)_fp;
            _filterParam = (BgAnalyseDiffFilterParam)filterParam;
            if (_filterParam.getBgItemBegin() != null) {
                _mainParam.setBgItemBegin(_filterParam.getBgItemBegin());
            } else {
                _mainParam.setBgItemBegin(null);
            }
            if (_filterParam.getBgItemEnd() != null) {
                _mainParam.setBgItemEnd(_filterParam.getBgItemEnd());
            } else {
                _mainParam.setBgItemEnd(null);
            }
            if (_filterParam.getElementMap() != null) {
                _mainParam.setElementMap(_filterParam.getElementMap());
            } else {
                _mainParam.setElementMap(null);
            }
        }
        return _mainParam;
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        HashMap<Object, Object> elementMap = new HashMap<Object, Object>();
        if (filterParam != null && filterParam instanceof BgAnalyseDiffFilterParam) {
            BgAnalyseDiffFilterParam _filterParam = (BgAnalyseDiffFilterParam)filterParam;
            if (this.prmtBgItemBegin.getData() != null) {
                _filterParam.setBgItemBegin((VisualItemInfo)this.prmtBgItemBegin.getData());
            } else {
                _filterParam.setBgItemBegin(null);
            }
            if (this.prmtBgItemEnd.getData() != null) {
                _filterParam.setBgItemEnd((VisualItemInfo)this.prmtBgItemEnd.getData());
            } else {
                _filterParam.setBgItemEnd(null);
            }
            if (this.tblMain.getRowCount() > 0) {
                ICell elementCell = null;
                ICell measureUnitCell = null;
                int rowCount = this.tblMain.getRowCount();
                for (int i = 0; i < rowCount; ++i) {
                    elementCell = this.tblMain.getCell(i, this.Col_Element);
                    measureUnitCell = this.tblMain.getCell(i, this.Col_MeasureUnit);
                    elementMap.put(elementCell.getValue(), measureUnitCell.getValue());
                }
            }
            _filterParam.setElementMap(elementMap);
        }
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseDiffFilterParam) {
            BgAnalyseDiffFilterParam _filterParam = (BgAnalyseDiffFilterParam)filterParam;
            if (_filterParam.getBgItemBegin() != null) {
                this.prmtBgItemBegin.setData((Object)_filterParam.getBgItemBegin());
            } else {
                this.prmtBgItemBegin.setData(null);
            }
            if (_filterParam.getBgItemEnd() != null) {
                this.prmtBgItemEnd.setData((Object)_filterParam.getBgItemEnd());
            } else {
                this.prmtBgItemEnd.setData(null);
            }
            this.tblMain.removeRows();
            if (_filterParam.getElementMap() != null && !_filterParam.getElementMap().isEmpty()) {
                Map.Entry _entry2 = null;
                IRow _row = null;
                for (Map.Entry _entry2 : _filterParam.getElementMap().entrySet()) {
                    _row = this.tblMain.addRow();
                    _row.getCell(this.Col_Element).setValue(_entry2.getKey());
                    _row.getCell(this.Col_MeasureUnit).setValue(_entry2.getValue());
                }
            }
        }
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        this.tblMain.addRow();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (this.tblMain.getSelectManager().getActiveRowIndex() > -1) {
            this.tblMain.removeRow(this.tblMain.getSelectManager().getActiveRowIndex());
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == this.Col_Element) {
            KDTRange range = this.tblMain.getSelectManager().toRange();
            KDTSelectBlock block = (KDTSelectBlock)range.get(0);
            int firstInsertRow = block.getBeginRow();
            Object object = this.tblMain.getCell(rowIndex, colIndex).getValue();
            if (object instanceof Object[]) {
                int i;
                Object[] result = (Object[])object;
                int size = result.length;
                int maxRow = this.tblMain.getRowCount();
                int leftRow = maxRow - (firstInsertRow + 1);
                if (size > leftRow) {
                    for (i = leftRow; i < size - 1; ++i) {
                        this.tblMain.addRow();
                    }
                }
                int length = result.length;
                for (i = 0; i < length; ++i) {
                    BgElementInfo info = (BgElementInfo)result[i];
                    this.tblMain.getCell(firstInsertRow, this.Col_Element).setValue((Object)info);
                    ++firstInsertRow;
                }
            }
        }
    }

    @Override
    protected boolean hasNewScheme() {
        return true;
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgAnalyseDiffFilterParam)) {
            return;
        }
        String id = null;
        String number = null;
        List ids = null;
        Map tmpMap = null;
        BgAnalyseDiffFilterParam _filterParam = (BgAnalyseDiffFilterParam)filterParam;
        try {
            number = cp.getCustomerParam(BEGIN_ITEM_NUMBER);
            if (!StringUtils.isEmpty((String)number)) {
                _filterParam.setBgItemBegin(new VisualItemInfo());
                _filterParam.getBgItemBegin().setNumber(number);
            } else {
                _filterParam.setBgItemBegin(null);
            }
            number = cp.getCustomerParam(END_ITEM_NUMBER);
            if (!StringUtils.isEmpty((String)number)) {
                _filterParam.setBgItemEnd(new VisualItemInfo());
                _filterParam.getBgItemEnd().setNumber(number);
            } else {
                _filterParam.setBgItemEnd(null);
            }
            ids = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(BGELEMENT_IDS)));
            if (ids != null) {
                _filterParam.setBgElements(new Object[ids.size()]);
                int in = ids.size();
                for (int i = 0; i < in; ++i) {
                    id = (String)ids.get(i);
                    if (StringUtils.isEmpty((String)id)) continue;
                    _filterParam.getBgElements()[i] = new BgElementInfo();
                    ((BgElementInfo)_filterParam.getBgElements()[i]).setId(BOSUuid.read((String)id));
                }
            } else {
                _filterParam.setBgElements(null);
            }
            tmpMap = (Map)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(BGELEMNET_MEASUREUNIT_IDS)));
            if (tmpMap != null) {
                _filterParam.setElementMap(new HashMap());
                _filterParam.getElementMap().putAll(tmpMap);
            } else {
                _filterParam.setElementMap(null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgAnalyseDiffFilterParam)) {
            return;
        }
        BgElementInfo _bgElementInfo = null;
        MeasureUnitInfo _measureUnitInfo = null;
        ArrayList<String> tmpList = null;
        HashMap<String, String> tmpMap = null;
        BgAnalyseDiffFilterParam _filterParam = (BgAnalyseDiffFilterParam)filterParam;
        try {
            if (_filterParam.getBgItemBegin() != null) {
                cp.addCustomerParam(BEGIN_ITEM_NUMBER, _filterParam.getBgItemBegin().getNumber());
            } else {
                cp.removeCustomerParam(BEGIN_ITEM_NUMBER);
            }
            if (_filterParam.getBgItemEnd() != null) {
                cp.addCustomerParam(END_ITEM_NUMBER, _filterParam.getBgItemEnd().getNumber());
            } else {
                cp.removeCustomerParam(END_ITEM_NUMBER);
            }
            if (_filterParam.getBgElements() != null) {
                tmpList = new ArrayList<String>();
                int in = _filterParam.getBgElements().length;
                for (int i = 0; i < in; ++i) {
                    _bgElementInfo = (BgElementInfo)_filterParam.getBgElements()[i];
                    if (_bgElementInfo == null) continue;
                    tmpList.add(_bgElementInfo.getId().toString());
                }
                if (!tmpList.isEmpty()) {
                    cp.addCustomerParam(BGELEMENT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(tmpList)));
                } else {
                    cp.removeCustomerParam(BGELEMENT_IDS);
                }
            } else {
                cp.removeCustomerParam(BGELEMENT_IDS);
            }
            if (_filterParam.getElementMap() != null) {
                Map.Entry _entry2 = null;
                tmpMap = new HashMap<String, String>();
                for (Map.Entry _entry2 : _filterParam.getElementMap().entrySet()) {
                    _bgElementInfo = (BgElementInfo)_entry2.getKey();
                    _measureUnitInfo = (MeasureUnitInfo)_entry2.getValue();
                    tmpMap.put(_bgElementInfo.getId().toString(), _measureUnitInfo.getId().toString());
                }
                if (!tmpMap.isEmpty()) {
                    cp.addCustomerParam(BGELEMNET_MEASUREUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(tmpMap)));
                } else {
                    cp.removeCustomerParam(BGELEMNET_MEASUREUNIT_IDS);
                }
            } else {
                cp.removeCustomerParam(BGELEMNET_MEASUREUNIT_IDS);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }
}

