/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.ActualTypeEnum;
import com.kingdee.eas.ma.budget.BgAnalyseBaseFilterParam;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTraceFilterParam;
import com.kingdee.eas.ma.budget.BgTraceHelperBean;
import com.kingdee.eas.ma.budget.BgTraceInfo;
import com.kingdee.eas.ma.budget.BgTraceInfoContainter;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.IBgRptFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgNTraceMainUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgAvlBalDetailUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgNTraceFilterUI;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BgNTraceMainUI
extends AbstractBgNTraceMainUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgNTraceMainUI");
    private static final long serialVersionUID = -9205393558009431619L;
    public static final String BTN_QUERY_VISIBLE_FLAG = "BtnQueryVisibleFlag";
    public static final String DIRECT_FORMULA = "DirectFormula";
    private BgTraceFilterParam oldParam;
    private BgNTraceFilterUI filterUI;
    private boolean isDirectShow;
    private IBgRptFacade iBgRpt;
    private IFullOrgUnit iFullOrgUnit;
    private List objList;
    private final BigDecimal ZERO = new BigDecimal("0.00");
    private int v_precision = 0;
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                BgNTraceMainUI.this.TabPaneMain_stateChanged(e);
            }
            catch (Exception exc) {
                BgNTraceMainUI.this.handUIException(exc);
            }
        }
    };

    @Override
    public void onLoad() throws Exception {
        Object obj = this.getUIContext().get("isDirectShow");
        if (obj != null) {
            this.isDirectShow = Boolean.valueOf(obj.toString());
            BgTraceFilterParam filterParam = (BgTraceFilterParam)this.getUIContext().get("filterParam");
            BgNTraceFilterUI filterUI = (BgNTraceFilterUI)this.getFilterUI();
            filterUI.setBgTraceFilterParam(filterParam);
        }
        super.onLoad();
        if (!this.isDirectShow) {
            this.initList();
        }
        this.initUI();
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.itemViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.actionViewBill.setEnabled(false);
        this.btnViewAvlBalDetail.setIcon(EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        this.miViewAvlBalDetail.setIcon(EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        Object flag = this.getUIContext().get(BTN_QUERY_VISIBLE_FLAG);
        if (flag != null && !"".equals(flag)) {
            this.btnQuery.setVisible(false);
        }
        this.addTabPaneMainListener();
    }

    private void addTabPaneMainListener() {
        this.TabPaneMain.addChangeListener(this.listener);
    }

    private void removeTabPaneMainListener() {
        this.TabPaneMain.removeChangeListener(this.listener);
    }

    private void initList() throws BOSException {
        BgTraceFilterParam filterParam = this.getFilterUIParams();
        this.objList = this.getRemoteInstance().getRelationData(filterParam);
    }

    private String getBgFormIDByOrgUnitID(String orgUnitID) {
        if (this.objList == null) {
            return null;
        }
        int num = this.objList.size();
        for (int i = 0; i < num; ++i) {
            BgTraceHelperBean bh = (BgTraceHelperBean)this.objList.get(i);
            if (!orgUnitID.equals(bh.getOrgUnitID())) continue;
            bh.setLoad(true);
            String bgFormID = bh.getBgFormID();
            return bgFormID;
        }
        return null;
    }

    @Override
    protected void executeQuery() {
        try {
            this.execute();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dialog = super.getCommonQueryDialog();
        dialog.setWidth(340);
        dialog.setHeight(450);
        return dialog;
    }

    private IBgRptFacade getRemoteInstance() throws BOSException {
        return BgRptFacadeFactory.getRemoteInstance();
    }

    protected void execute() throws Exception {
        BgTraceFilterParam filterParam = this.getFilterUIParams();
        if (filterParam.getOrgUnitInfoAry() == null) {
            return;
        }
        if (!this.isInit(filterParam)) {
            if (!this.isDirectShow) {
                this.initList();
            }
            this.initUI();
        }
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("billType").setWidth(140);
        this.tblMain.getColumn("BgPeriod").setWidth(70);
        this.tblMain.getColumn("currency").setWidth(50);
        this.tblMain.getColumn("bizDate").setWidth(70);
        this.tblMain.getColumn("ctrlDate").setWidth(70);
        String format = BgNationalFormatUIUtil.getNationalDateFormatString();
        this.tblMain.getColumn("bizDate").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn("ctrlDate").getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn(0).getStyleAttributes().setWrapText(true);
        this.setOrgUnitID(filterParam);
        int periodColumnIndex = this.tblMain.getColumnIndex("BgPeriod");
        int itemColumnIndex = this.tblMain.getColumnIndex("BgItem");
        int amountIndex = this.tblMain.getColumnIndex("billAmount");
        int dataIndex = this.tblMain.getColumnIndex("bizDate");
        int billTypeIndex = this.tblMain.getColumnIndex("billType");
        int billNum = this.tblMain.getColumnIndex("billNumber");
        int ctrlDate = this.tblMain.getColumnIndex("ctrlDate");
        int currencyIndex = this.tblMain.getColumnIndex("currency");
        BigDecimal coefficient = (BigDecimal)this.getUIContext().get("coefficient");
        if (coefficient == null) {
            coefficient = new BigDecimal("1.00");
        }
        List dataIDList = null;
        BigDecimal sumBillAmount = null;
        String[] array = null;
        if (this.isDirectShow) {
            dataIDList = (List)this.getUIContext().get("bgDataIDList");
            array = new String[]{this.getUIContext().get("formula") != null ? (String)this.getUIContext().get("formula") : null, filterParam.getOrgUnitInfoAry()[0].getId().toString()};
        } else {
            array = this.getBgFormAndOrgUnitID();
            if (array.length != 0) {
                dataIDList = this.getRemoteInstance().getBgDataByFormID(filterParam, array[0], array[1]);
            }
        }
        boolean isHideActualTypeColumn = true;
        if (dataIDList != null && dataIDList.size() != 0) {
            BgTraceInfoContainter container = this.getRemoteInstance().getTraceInfoByBgDataId(dataIDList);
            if (container.size() == 0) {
                return;
            }
            HashMap<String, Object> bgDataIds = new HashMap<String, Object>();
            ArrayList lst = new ArrayList(container.valList());
            for (int i = 0; i < lst.size(); ++i) {
                List tempList = (List)lst.get(i);
                for (int j = 0; j < tempList.size(); ++j) {
                    BgTraceInfo info = (BgTraceInfo)tempList.get(j);
                    bgDataIds.put(info.getBgDataID(), null);
                }
            }
            Map groupItemMap = this.getRemoteInstance().getGroupBgDataId(bgDataIds);
            boolean hasGroupData = false;
            HashMap groupDumpMap = new HashMap();
            if (groupItemMap != null && !groupItemMap.isEmpty()) {
                hasGroupData = true;
                Iterator itr = groupItemMap.keySet().iterator();
                while (itr.hasNext()) {
                    Map temp = (Map)groupItemMap.get(itr.next().toString());
                    groupDumpMap.putAll(temp);
                }
            }
            ArrayList valList = new ArrayList(container.valList());
            ArrayList keyList = new ArrayList(container.keyList());
            HashMap removeBgDataMap = new HashMap();
            int num = valList.size();
            for (int i = 0; i < num; ++i) {
                Map _sameGroupMap;
                BigDecimal itemSumBillAmount = null;
                List tempList = (List)valList.get(i);
                String bgDataId = keyList.get(i).toString();
                if (removeBgDataMap.containsKey(bgDataId)) continue;
                boolean hasGrp = false;
                IRow beforeBudgetAmountRow = this.tblMain.addRow();
                beforeBudgetAmountRow.getCell(billTypeIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"124_BgAvlBalDetailUI"));
                beforeBudgetAmountRow.getCell(0).setUserObject((Object)bgDataId);
                BigDecimal bgVal = null;
                BgDataInfo bgDataInfo = (BgDataInfo)groupDumpMap.get(bgDataId);
                if (bgDataInfo != null && (_sameGroupMap = (Map)groupItemMap.get(bgDataInfo.getGroupNo())) != null && !_sameGroupMap.isEmpty()) {
                    Set bgDataIdSet = _sameGroupMap.keySet();
                    Iterator ix = bgDataIdSet.iterator();
                    while (ix.hasNext()) {
                        BgTraceInfo xinfo;
                        hasGrp = true;
                        String _bgDataId = ix.next().toString();
                        BgDataInfo infoy = (BgDataInfo)_sameGroupMap.get(_bgDataId);
                        if (bgDataId.equals(_bgDataId) || keyList.indexOf(_bgDataId) <= -1 || tempList == null || tempList.size() <= 0 || !(xinfo = (BgTraceInfo)tempList.get(0)).getPeriod().equals(infoy.getBgPeriod().getNumber())) continue;
                        tempList.addAll((List)container.get(_bgDataId));
                        removeBgDataMap.put(_bgDataId, null);
                    }
                }
                int jNum = tempList.size();
                for (int j = 0; j < jNum; ++j) {
                    String number;
                    Iterator itrx;
                    String groupItemExp;
                    String bgItemNumber;
                    String[] paramter;
                    String formula;
                    BgDataInfo _bgDataInfo;
                    String _bgDataId;
                    Map<String, Object> itemNameMap;
                    Iterator itr;
                    BgDataInfo bgData;
                    Map theGroup;
                    BgTraceInfo info = (BgTraceInfo)tempList.get(j);
                    int precision = info.getPrecision();
                    String numberFormat = this.getNumberFormat(info);
                    beforeBudgetAmountRow.getCell("bgBalance").getStyleAttributes().setNumberFormat(numberFormat);
                    beforeBudgetAmountRow.getCell("billAmount").getStyleAttributes().setNumberFormat(numberFormat);
                    if (bgVal == null) {
                        bgVal = this.dealWithData(info, array, filterParam);
                        if (bgVal != null) {
                            beforeBudgetAmountRow.getCell("bgBalance").setValue((Object)bgVal.divide(coefficient, 2, 6));
                        } else {
                            beforeBudgetAmountRow.getCell("bgBalance").setValue((Object)"0");
                        }
                    }
                    IRow row = this.tblMain.addRow();
                    row.getCell(0).setUserObject((Object)bgDataId);
                    row.getCell(periodColumnIndex).setValue((Object)info.getPeriod());
                    if (!filterParam.getIsShowItemNumber().booleanValue()) {
                        row.getCell(itemColumnIndex).setValue((Object)info.getItem());
                        if (hasGroupData && groupDumpMap.containsKey(bgDataId) && (theGroup = (Map)groupItemMap.get((bgData = (BgDataInfo)groupDumpMap.get(bgDataId)).getGroupNo())) != null) {
                            itr = theGroup.keySet().iterator();
                            itemNameMap = new HashMap();
                            while (itr.hasNext()) {
                                _bgDataId = itr.next().toString();
                                _bgDataInfo = (BgDataInfo)theGroup.get(_bgDataId);
                                formula = _bgDataInfo.getFormula();
                                paramter = BgNFSHelper.parseFormulaPara(null, (String)formula);
                                bgItemNumber = paramter[BgSHelper.paraItem];
                                itemNameMap.put(bgItemNumber.replaceAll(",", "_"), null);
                            }
                            itemNameMap = BgBudgetFacadeFactory.getRemoteInstance().getSelectBgItemCombinName(itemNameMap, bgData.getOrgUnit().getId().toString());
                            groupItemExp = "";
                            itrx = itemNameMap.keySet().iterator();
                            while (itrx.hasNext()) {
                                number = itrx.next().toString();
                                groupItemExp = groupItemExp + itemNameMap.get(number) + ",";
                            }
                            groupItemExp = BudgetCtrlUtil.deleteStrTail(groupItemExp);
                            row.getCell(0).setValue((Object)groupItemExp);
                        }
                    } else {
                        row.getCell(itemColumnIndex).setValue((Object)this.dealItemName(info.getFormula(), info.getItem()));
                        if (hasGroupData && groupDumpMap.containsKey(bgDataId) && (theGroup = (Map)groupItemMap.get((bgData = (BgDataInfo)groupDumpMap.get(bgDataId)).getGroupNo())) != null) {
                            itr = theGroup.keySet().iterator();
                            itemNameMap = new HashMap();
                            while (itr.hasNext()) {
                                _bgDataId = itr.next().toString();
                                _bgDataInfo = (BgDataInfo)theGroup.get(_bgDataId);
                                formula = _bgDataInfo.getFormula();
                                paramter = BgNFSHelper.parseFormulaPara(null, (String)formula);
                                bgItemNumber = paramter[BgSHelper.paraItem];
                                itemNameMap.put(bgItemNumber.replaceAll(",", "_"), null);
                            }
                            itemNameMap = BgBudgetFacadeFactory.getRemoteInstance().getSelectBgItemCombinName(itemNameMap, bgData.getOrgUnit().getId().toString());
                            groupItemExp = "";
                            itrx = itemNameMap.keySet().iterator();
                            while (itrx.hasNext()) {
                                number = itrx.next().toString();
                                groupItemExp = groupItemExp + number + " " + itemNameMap.get(number) + ",";
                            }
                            groupItemExp = BudgetCtrlUtil.deleteStrTail(groupItemExp);
                            row.getCell(0).setValue((Object)groupItemExp);
                        }
                    }
                    row.getCell(currencyIndex).setValue((Object)info.getCurrency());
                    if (this.v_precision == 0 && info.getPrecision() != 0) {
                        this.v_precision = info.getPrecision();
                    }
                    row.getCell(ctrlDate).setValue((Object)info.getCtrlDate());
                    if (isHideActualTypeColumn && info.getActualType() == 10) {
                        isHideActualTypeColumn = false;
                    }
                    row.getCell("actualType").setValue((Object)ActualTypeEnum.getEnum(info.getActualType()));
                    BigDecimal billAmount = info.getAmount().divide(coefficient, 2, 6);
                    row.getCell(amountIndex).setValue((Object)billAmount);
                    itemSumBillAmount = itemSumBillAmount == null ? billAmount : itemSumBillAmount.add(billAmount);
                    row.getCell(billNum).setValue((Object)info.getBillNum());
                    row.getCell(dataIndex).setValue((Object)info.getDate());
                    row.getCell(billTypeIndex).setValue((Object)info.getBillType());
                    row.getCell("traceType").setValue((Object)new Integer(info.getTraceType()));
                    row.setUserObject((Object)info.getBillid());
                    row.getCell("bgBalance").setValue((Object)this.getUpRowVal(row).subtract(billAmount));
                }
                IRow afterBudgetAmountRow = this.tblMain.addRow();
                afterBudgetAmountRow.getCell(0).setUserObject((Object)bgDataId);
                afterBudgetAmountRow.getCell(billTypeIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"124_BgAvlBalDetailUI"));
                afterBudgetAmountRow.getCell("bgBalance").setValue((Object)this.getUpRowVal(afterBudgetAmountRow));
                IRow sumRow = this.tblMain.addRow();
                sumRow.getCell(0).setUserObject((Object)bgDataId);
                sumRow.getCell(billTypeIndex).setValue((Object)EASResource.getString((String)resourcePath, (String)"collect"));
                sumRow.getCell("bgBalance").setValue((Object)this.getUpRowVal(afterBudgetAmountRow));
                sumRow.getCell(amountIndex).setValue(itemSumBillAmount);
                sumRow.getStyleAttributes().setBackground(new Color(245, 245, 230));
                if (!hasGrp) {
                    this.tblMain.getMergeManager().mergeBlock(beforeBudgetAmountRow.getRowIndex(), 1, sumRow.getRowIndex(), 1);
                    this.tblMain.getMergeManager().mergeBlock(beforeBudgetAmountRow.getRowIndex(), 0, sumRow.getRowIndex(), 0);
                    this.tblMain.getMergeManager().mergeBlock(beforeBudgetAmountRow.getRowIndex(), 2, sumRow.getRowIndex(), 2);
                } else {
                    this.tblMain.getCell(beforeBudgetAmountRow.getRowIndex(), 1).setValue(this.tblMain.getCell(beforeBudgetAmountRow.getRowIndex() + 1, 1).getValue());
                    this.tblMain.getCell(beforeBudgetAmountRow.getRowIndex(), 0).setValue(this.tblMain.getCell(beforeBudgetAmountRow.getRowIndex() + 1, 0).getValue());
                    this.tblMain.getCell(beforeBudgetAmountRow.getRowIndex(), 2).setValue(this.tblMain.getCell(beforeBudgetAmountRow.getRowIndex() + 1, 2).getValue());
                    this.tblMain.getCell(sumRow.getRowIndex() - 1, 1).setValue(this.tblMain.getCell(sumRow.getRowIndex() - 2, 1).getValue());
                    this.tblMain.getCell(sumRow.getRowIndex() - 1, 0).setValue(this.tblMain.getCell(sumRow.getRowIndex() - 2, 0).getValue());
                    this.tblMain.getCell(sumRow.getRowIndex() - 1, 2).setValue(this.tblMain.getCell(sumRow.getRowIndex() - 2, 2).getValue());
                    this.tblMain.getCell(sumRow.getRowIndex(), 1).setValue(this.tblMain.getCell(sumRow.getRowIndex() - 2, 1).getValue());
                    this.tblMain.getCell(sumRow.getRowIndex(), 0).setValue(this.tblMain.getCell(sumRow.getRowIndex() - 2, 0).getValue());
                    this.tblMain.getCell(sumRow.getRowIndex(), 2).setValue(this.tblMain.getCell(sumRow.getRowIndex() - 2, 2).getValue());
                    this.tblMain.getMergeManager().mergeBlock(beforeBudgetAmountRow.getRowIndex(), 1, sumRow.getRowIndex(), 1, 1);
                    this.tblMain.getMergeManager().mergeBlock(beforeBudgetAmountRow.getRowIndex(), 0, sumRow.getRowIndex(), 0, 1);
                    this.tblMain.getMergeManager().mergeBlock(beforeBudgetAmountRow.getRowIndex(), 2, sumRow.getRowIndex(), 2, 1);
                }
                sumBillAmount = sumBillAmount == null ? itemSumBillAmount : sumBillAmount.add(itemSumBillAmount);
            }
            int rowCount = this.tblMain.getRowCount();
            if (rowCount != 0) {
                IRow sumRow = this.tblMain.addRow();
                sumRow.getCell(billTypeIndex).setValue((Object)EASResource.getString((String)resourcePath, (String)"sumValue"));
                if (sumBillAmount != null) {
                    sumRow.getCell(amountIndex).setValue(sumBillAmount);
                } else {
                    sumRow.getCell(amountIndex).setValue((Object)this.ZERO);
                }
                sumRow.getStyleAttributes().setBackground(Color.YELLOW);
                sumRow.getStyleAttributes().setHided(true);
                this.formatBigDecimalVal(rowCount + 1);
                this.tblMain.setEditable(false);
            }
            if (!hasGroupData) {
                this.tblMain.getColumn(0).getStyleAttributes().setHided(true);
            } else {
                this.tblMain.getColumn(0).getStyleAttributes().setHided(false);
            }
        }
        this.tblMain.getColumn("actualType").getStyleAttributes().setHided(isHideActualTypeColumn);
        if (this.tblMain.getRowCount() <= 0) {
            this.tblMain.getColumn(0).getStyleAttributes().setHided(true);
        }
        this.isDirectShow = false;
    }

    protected String getNumberFormat(BgTraceInfo info) {
        int precision;
        String NUM_FOTMATTER = null;
        if (info != null && (precision = info.getPrecision()) != 0) {
            NUM_FOTMATTER = "#,##0." + BgNFSHelper.getNumberFormat((String)"0", (int)precision);
        }
        return NUM_FOTMATTER;
    }

    private String dealItemName(String formulaStr, String itemName) throws EASBizException, BOSException {
        String[] names;
        if (itemName == null || itemName.length() == 0) {
            return itemName;
        }
        if (formulaStr == null || formulaStr.length() == 0) {
            return itemName;
        }
        String[] paramter = BgNFSHelper.parseFormulaPara(null, (String)formulaStr);
        String bgItemNumber = paramter[BgSHelper.paraItem];
        String[] numbers = bgItemNumber.split(",");
        if (numbers.length != (names = itemName.split("_")).length) {
            return itemName;
        }
        String ret = numbers[0] + " " + names[0];
        for (int i = 1; i < numbers.length; ++i) {
            ret = ret + "_" + numbers[i] + " " + names[i];
        }
        return ret;
    }

    private void formatBigDecimalVal(int rowCount) {
        int billAmountIndex = this.tblMain.getColumnIndex("billAmount");
        int balanceIndex = this.tblMain.getColumnIndex("bgBalance");
        for (int i = 0; i < rowCount; ++i) {
            ICell billCell = this.tblMain.getCell(i, billAmountIndex);
            ICell balanceCell = this.tblMain.getCell(i, balanceIndex);
            if (billCell != null) {
                if (this.v_precision != 0) {
                    billCell.getStyleAttributes().setNumberFormat(this.getNumberFormat(this.v_precision));
                } else {
                    billCell.getStyleAttributes().setNumberFormat("#,##0.00");
                }
                billCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            if (balanceCell == null) continue;
            if (this.v_precision != 0) {
                balanceCell.getStyleAttributes().setNumberFormat(this.getNumberFormat(this.v_precision));
            } else {
                balanceCell.getStyleAttributes().setNumberFormat("#,##0.00");
            }
            balanceCell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public String getNumberFormat(int precision) {
        String NUM_FOTMATTER = "#,##0.00";
        if (precision != 0) {
            NUM_FOTMATTER = "#,##0." + BgNFSHelper.getNumberFormat((String)"0", (int)precision);
        }
        return NUM_FOTMATTER;
    }

    private BigDecimal getUpRowVal(IRow row) {
        BigDecimal upVal = this.ZERO;
        IRow upRow = this.tblMain.getRow(row.getRowIndex() - 1);
        Object obj = upRow.getCell("bgBalance").getValue();
        if (obj instanceof BigDecimal) {
            upVal = (BigDecimal)obj;
        }
        return upVal;
    }

    private BigDecimal dealWithData(BgTraceInfo info, String[] array, BgTraceFilterParam filterParam) {
        BigDecimal ret = BgNConstants.ZERO;
        String bgDataId = info.getBgDataID();
        if (bgDataId == null) {
            return ret;
        }
        try {
            ret = this.getRemoteInstance().getAddedBgVal(filterParam, info, array[0], array[1]);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return ret;
    }

    private void initUI() throws Exception {
        BgTraceFilterParam filterParam = this.getFilterUIParams();
        this.addPanel(this.TabPaneMain, filterParam.getOrgUnitInfoAry());
        this.addTable();
    }

    private void addPanel(KDTabbedPane kdTabbed, OrgUnitInfo[] orgAry) throws Exception {
        for (int i = kdTabbed.getTabCount(); i > 0; --i) {
            kdTabbed.removeTabAt(i - 1);
        }
        OrgUnitInfo orgUnitInfo2 = null;
        for (OrgUnitInfo orgUnitInfo2 : orgAry) {
            BOSUuid obj = orgUnitInfo2.getId();
            if (obj == null) {
                String orgUnitNum = orgUnitInfo2.getNumber();
                FullOrgUnitInfo info = this.getOrgUnitRemoteIntance().getFullOrgUnitInfo("select id ,name where number = '" + orgUnitNum + "'");
                orgUnitInfo2.setName(info.getName());
                orgUnitInfo2.setId(info.getId());
            }
            String orgUnitID = orgUnitInfo2.getId().toString();
            this.TabPaneMain.addTab(orgUnitInfo2.getName(), (Component)this.createPanel(orgUnitID));
        }
    }

    private IFullOrgUnit getOrgUnitRemoteIntance() {
        try {
            if (this.iFullOrgUnit == null) {
                this.iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return this.iFullOrgUnit;
    }

    private KDPanel createPanel(String orgUnitID) {
        KDPanel kdPanel = new KDPanel();
        kdPanel.addContainerListener((ContainerListener)new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                try {
                    BgNTraceMainUI.this.pnlMainTrace_componentAdded(e);
                }
                catch (Exception exc) {
                    BgNTraceMainUI.this.handUIException(exc);
                }
            }
        });
        kdPanel.setUserObject((Object)orgUnitID);
        return kdPanel;
    }

    protected void TabPaneMain_stateChanged(ChangeEvent e) throws Exception {
        if (this.isDirectShow) {
            return;
        }
        this.addTable();
        this.execute();
    }

    @Override
    public boolean destroyWindow() {
        this.removeTabPaneMainListener();
        return super.destroyWindow();
    }

    private boolean isInit(BgTraceFilterParam filterParam) {
        if (filterParam.equals(this.oldParam)) {
            return true;
        }
        this.oldParam = filterParam;
        return false;
    }

    private String[] getBgFormAndOrgUnitID() {
        int index = this.TabPaneMain.getSelectedIndex();
        String bgFormID = null;
        if (index == -1) {
            return new String[0];
        }
        KDPanel panel = (KDPanel)this.TabPaneMain.getComponentAt(index);
        Object objOrgUnitID = panel.getUserObject();
        if (objOrgUnitID != null) {
            String orgUnitID = objOrgUnitID.toString();
            bgFormID = this.getBgFormIDByOrgUnitID(orgUnitID);
            return new String[]{bgFormID, orgUnitID};
        }
        return new String[0];
    }

    private void addTable() {
        int index = this.TabPaneMain.getSelectedIndex();
        if (index == -1) {
            return;
        }
        KDPanel panel = (KDPanel)this.TabPaneMain.getComponentAt(index);
        panel.setLayout((LayoutManager)new KDLayout());
        panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, panel.getWidth(), panel.getHeight()));
        this.tblMain.setBounds(new Rectangle(8, 10, panel.getWidth() - 16, panel.getHeight() - 20));
        panel.add((Component)this.tblMain, (Object)new KDLayout.Constraints(8, 10, panel.getWidth() - 16, panel.getHeight() - 20, 15));
    }

    private void setOrgUnitID(BgTraceFilterParam filterParam) {
        OrgUnitInfo[] orgAry = filterParam.getOrgUnitInfoAry();
        String[] ids = new String[orgAry.length];
        int num = orgAry.length;
        for (int i = 0; i < num; ++i) {
            ids[i] = orgAry[i].getId().toString();
        }
        filterParam.setOrgUnitIds(ids);
    }

    @Override
    public BgAnalyseFilterBaseUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new BgNTraceFilterUI();
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return this.filterUI;
    }

    BgTraceFilterParam getFilterUIParams() {
        BgNTraceFilterUI filterUI = (BgNTraceFilterUI)this.getFilterUI();
        BgRptFilterParam param = filterUI.getFilterParam();
        if (param != null) {
            return (BgTraceFilterParam)param;
        }
        CustomerParams cp = this.getFilterUI().getCustomerParams();
        BgTraceFilterParam filterParam = (BgTraceFilterParam)filterUI.getFilterObject(cp, BgNTraceFilterUI.getFILTER_UI_KEY());
        return filterParam;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    @Override
    protected int getHeightOfDialog() {
        return 370;
    }

    public static void showDialogWindow(IUIObject ui, BgRptFilterParam param) throws Exception {
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.removeTabPaneMainListener();
        super.actionQuery_actionPerformed(e);
        this.addTabPaneMainListener();
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        Object obj;
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index >= 0 && (obj = this.tblMain.getRow(index).getUserObject()) != null) {
            String billid = obj.toString();
            CompanyOrgUnitInfo info = SysContext.getSysContext().getCurrentFIUnit();
            BgClientHelper.viewDetailBill((CoreUIObject)this, billid.trim(), info);
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        if (index >= 0 && this.tblMain.getRow(index).getUserObject() != null) {
            Integer traceType = (Integer)this.tblMain.getRow(index).getCell("traceType").getValue();
            if (3 == traceType || 7 == traceType || 6 == traceType || 4 == traceType) {
                this.actionViewBill.setEnabled(true);
            } else {
                this.actionViewBill.setEnabled(false);
            }
        } else {
            this.actionViewBill.setEnabled(false);
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgClientHelper.exportTablesToExcel((Component)((Object)this), this.TabPaneMain, false);
    }

    public BgTraceFilterParam getQueryParam() {
        try {
            BgAnalyseFilterBaseUI f = this.getFilterUI();
            f.onLoad();
            CustomerParams cp = f.getCustomerParams();
            return (BgTraceFilterParam)f.getFilterObject(cp);
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception exp) {
            logger.error((Object)"budget error:", (Throwable)exp);
            return null;
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)resourcePath, (String)"ntraceMainUITitle");
    }

    @Override
    protected String getQueryMainName() {
        return BgNTraceMainUI.class.getName();
    }

    @Override
    protected boolean getDefaultFilterParam() throws Exception {
        if (this.isDirectShow) {
            return true;
        }
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            this.setSolutionId(ds.getId());
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            try {
                this.setFilterParam(cp, BgNTraceFilterUI.getFILTER_UI_KEY());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getFilterParam() != null;
    }

    private void setFilterParam(CustomerParams cp, String filterUIKey) throws Exception {
        if (cp == null) {
            return;
        }
        BgNTraceFilterUI filterUI = (BgNTraceFilterUI)this.getFilterUI();
        Object obj = filterUI.getFilterObject1(cp, filterUIKey);
        filterUI.setBgTraceFilterParam((BgTraceFilterParam)obj);
        this.defaultFilterParam = new BgAnalyseBaseFilterParam();
    }

    @Override
    public void actionViewAvlBalDetail_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"185_BgControlRuleTreeListUI"));
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        String bgDataId = (String)row.getCell(0).getUserObject();
        if (bgDataId == null || bgDataId.length() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bgDataId", (Object)bgDataId);
        uiContext.put((Object)"formatStyle", (Object)this.getNumberFormat(this.v_precision));
        uiContext.put((Object)"isCtrl", (Object)Boolean.FALSE);
        uiContext.put((Object)"balTypeEnum", (Object)BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAvlBalDetailUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    protected int getWidthOfDialog() {
        return 290;
    }
}

