/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgControlPeriodMapFactory;
import com.kingdee.eas.ma.budget.BgLocaleHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodException;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgWeekDataTypeEnum;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.client.AbstractBgPeriodEditUI;
import com.kingdee.eas.ma.budget.client.BgPeriodListUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgPeriodEditUI
extends AbstractBgPeriodEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodEditUI.class);
    private static Map clientResource = null;
    private BgPeriodListUI ui = null;
    private BgPeriodRender render = null;
    private IBgPeriod iBgPeriod = null;
    private DecimalFormat df = null;
    private String sYear = null;
    private int iYear = 0;
    private boolean isClose = true;
    private boolean isSelect = false;
    private Map map = new HashMap(500);
    private BgPeriodCollection yearCol = null;
    private BgPeriodCollection halfYearCol = null;
    private BgPeriodCollection quarterCol = null;
    private BgPeriodCollection monthCol = null;
    private BgPeriodCollection weekCol = null;
    private BgPeriodCollection tenDaysCol = null;
    private BgPeriodCollection dayCol = null;
    private int minYear = 1979;
    private int maxYear = 2050;
    private Locale sLocale = new Locale("l2");
    private Locale tLocale = new Locale("l3");
    private CalendarHelper helper = null;
    private static final String PREFIX_PERSONAL_PERIOD = "ZDY_";

    public void onLoad() throws Exception {
        super.onLoad();
        this.helper = new CalendarHelper();
        this.kDButStartupHelp.setVisible(false);
        this.kDButEndHelp.setVisible(false);
        this.arcNature.setSelected(true);
        this.kDPanelPersonalEnd.setVisible(false);
        this.ui = (BgPeriodListUI)((Object)this.getUIContext().get("ISCANCEL"));
        this.df = new DecimalFormat("00");
        this.kDTable.setVisible(false);
        this.InitTable();
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.kDStartupImage.setIcon(bg);
        this.kDEndImage.setIcon(bg);
        this.KDPersonalImage.setIcon(bg);
        this.beginDate.setEditable(false);
        this.endDate.setEditable(false);
        this.kDCheckYear.setSelected(true);
        int maxSelectYear = 9999;
        int minSelectYear = 1;
        int year = this.helper.getCurrentlyYear() + 1;
        this.kDSpinner.setModel((SpinnerModel)new SpinnerNumberModel(year, minSelectYear, maxSelectYear, 1));
        this.kDComboBox1.setEnabled(false);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.kDSpinner.requestFocus(true);
    }

    private void InitTable() {
        this.kDTable.getSelectManager().setSelectMode(2);
        int colCount = 4;
        for (int i = 0; i < colCount; ++i) {
            this.kDTable.addColumn(i);
        }
        IRow row = this.kDTable.addHeadRow();
        if (row != null) {
            row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"rowLongNumber"));
            row.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"rowName"));
            row.getCell(2).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"rowStartupDate"));
            row.getCell(3).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"rowEndDate"));
        }
        IColumn col = null;
        String formatString = "%{yyyy-MM-dd}t";
        col = this.kDTable.getColumn(0);
        if (col != null) {
            this.render = new BgPeriodRender();
            col.setRenderer((IBasicRender)this.render);
            col.setWidth(175);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(1)) != null) {
            col.setWidth(150);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(2)) != null) {
            col.getStyleAttributes().setNumberFormat(formatString);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(3)) != null) {
            col.getStyleAttributes().setNumberFormat(formatString);
            col.getStyleAttributes().setLocked(true);
        }
    }

    private void checkYearSelect(boolean showMessage) {
        if (!this.kDCheckYear.isSelected()) {
            this.kDCheckYear.setSelected(true);
            if (showMessage) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectYear"));
                SysUtil.abort();
            }
        }
    }

    private void checkHalfYearSelect(boolean showMessage) {
        if (!this.kDCheckHalfYear.isSelected()) {
            this.kDCheckHalfYear.setSelected(true);
            if (showMessage) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectHalfYear"));
                SysUtil.abort();
            }
        }
        this.checkYearSelect(showMessage);
    }

    private void checkQuarterSelect(boolean showMessage) {
        if (!this.kDCheckQuarter.isSelected()) {
            this.kDCheckQuarter.setSelected(true);
            if (showMessage) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectQuarter"));
                SysUtil.abort();
            }
        }
        this.checkHalfYearSelect(showMessage);
    }

    private void checkMonthSelect(boolean showMessage) {
        if (!this.kDCheckMonth.isSelected()) {
            this.kDCheckMonth.setSelected(true);
            if (showMessage) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectMonth"));
                SysUtil.abort();
            }
        }
        this.checkQuarterSelect(showMessage);
    }

    private void checkWeekSelect(boolean showMessage) {
        if (!this.kDCheckWeek.isSelected() && (this.kDYear.isSelected() || this.kDMonth.isSelected())) {
            this.kDCheckWeek.setSelected(true);
        } else if (this.kDCheckWeek.isSelected() && !this.kDYear.isSelected() && !this.kDMonth.isSelected()) {
            this.kDYear.setSelected(true);
            this.kDMonth.setSelected(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectWeek"));
            SysUtil.abort();
        }
        if (this.kDYear.isSelected()) {
            this.checkYearSelect(showMessage);
        }
        if (this.kDMonth.isSelected()) {
            this.checkMonthSelect(showMessage);
        }
    }

    @Override
    protected void kDCheckHalfYear_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDCheckHalfYear.isSelected()) {
            this.checkYearSelect(false);
        }
    }

    @Override
    protected void kDCheckQuarter_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDCheckQuarter.isSelected()) {
            this.checkHalfYearSelect(false);
        }
    }

    @Override
    protected void kDCheckTenDays_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDCheckTenDays.isSelected()) {
            this.checkMonthSelect(false);
        }
    }

    @Override
    protected void kDCheckMonth_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDCheckMonth.isSelected()) {
            this.checkQuarterSelect(false);
        }
    }

    @Override
    protected void kDCheckDay_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDCheckDay.isSelected()) {
            this.checkMonthSelect(false);
        }
    }

    @Override
    protected void kDCheckWeek_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckWeek_actionPerformed(e);
        if (this.kDCheckWeek.isSelected()) {
            this.kDYear.setSelected(true);
            this.kDMonth.setSelected(true);
            this.checkWeekSelect(false);
        } else {
            this.kDYear.setSelected(false);
            this.kDMonth.setSelected(false);
        }
        this.checkWeekItemState();
    }

    @Override
    protected void kDYear_actionPerformed(ActionEvent e) throws Exception {
        super.kDYear_actionPerformed(e);
        this.checkWeekSelect(false);
        this.checkWeekItemState();
    }

    @Override
    protected void kDMonth_actionPerformed(ActionEvent e) throws Exception {
        super.kDMonth_actionPerformed(e);
        this.checkWeekSelect(false);
        this.checkWeekItemState();
    }

    private void checkWeekItemState() {
        if (this.kDMonth.isSelected() || this.kDYear.isSelected() || this.kDCheckWeek.isSelected()) {
            if (!this.kDComboBox1.isEnabled()) {
                this.kDComboBox1.setEnabled(true);
            }
        } else {
            this.kDComboBox1.setEnabled(false);
        }
    }

    @Override
    protected void kDButEndHelp_actionPerformed(ActionEvent e) throws Exception {
        super.kDButEndHelp_actionPerformed(e);
    }

    @Override
    protected void kDButStartupCancel_actionPerformed(ActionEvent e) throws Exception {
        this.ui.setRefreshType(0);
        this.uiWindow.close();
    }

    @Override
    protected void kDButStartupNext_actionPerformed(ActionEvent e) throws Exception {
        if (this.arcNature.isSelected()) {
            if (this.checkProcess()) {
                this.startupProcess();
                this.kDPanelStartup.setVisible(false);
                this.kDPanelEnd.setVisible(true);
                this.kDTable.setVisible(true);
                this.kDProgressBar.setValue(0);
                this.kDProgressBar.setMinimum(0);
            }
        } else if (this.arcPersonal.isSelected()) {
            this.kDPanelStartup.setVisible(false);
            this.kDPanelEnd.setVisible(false);
            this.kDPanelPersonalEnd.setVisible(true);
        }
    }

    @Override
    protected void kDButStartupHelp_actionPerformed(ActionEvent e) throws Exception {
        super.kDButStartupHelp_actionPerformed(e);
    }

    @Override
    protected void kDButEndCancel_actionPerformed(ActionEvent e) throws Exception {
        this.ui.setRefreshType(0);
        this.uiWindow.close();
    }

    @Override
    protected void kDButEndPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable.setVisible(false);
        this.kDPanelStartup.setVisible(true);
        this.kDPanelEnd.setVisible(false);
        this.kDTable.removeRows();
    }

    @Override
    protected void kDButEndFinish_actionPerformed(ActionEvent e) throws Exception {
        this.kDButEndHelp.setEnabled(false);
        this.kDButEndCancel.setEnabled(false);
        this.kDButEndPrevious.setEnabled(false);
        this.kDButEndFinish.setEnabled(false);
        this.isClose = false;
        this.endProcess();
    }

    private void startupProcess() {
        try {
            this.periodProcess();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
    }

    @Override
    protected void kDSpinner_stateChanged(ChangeEvent e) throws Exception {
        super.kDSpinner_stateChanged(e);
    }

    private boolean checkProcess() throws EASBizException {
        this.checkYearSelect(true);
        if (this.kDCheckHalfYear.isSelected()) {
            this.checkYearSelect(true);
        }
        if (this.kDCheckQuarter.isSelected()) {
            this.checkHalfYearSelect(true);
        }
        if (this.kDCheckMonth.isSelected()) {
            this.checkQuarterSelect(true);
        }
        if (this.kDCheckTenDays.isSelected()) {
            this.checkMonthSelect(true);
        }
        if (this.kDCheckWeek.isSelected() || this.kDYear.isSelected() || this.kDMonth.isSelected()) {
            this.checkWeekSelect(true);
            this.checkYearSelect(true);
        }
        if (this.kDCheckDay.isSelected()) {
            this.checkMonthSelect(true);
        }
        this.isSelect = false;
        ArrayList<String> info = new ArrayList<String>();
        BgPeriodInfo bgPeriodInfo = null;
        try {
            Iterator iter;
            if (this.iBgPeriod == null) {
                this.iBgPeriod = BgPeriodFactory.getRemoteInstance();
            }
            this.sYear = this.kDSpinner.getValue().toString();
            this.iYear = Integer.valueOf(this.sYear);
            if (this.iYear < this.minYear || this.iYear > this.maxYear) {
                throw new BgPeriodException(BgPeriodException.SELECTYEARERROR, new String[]{String.valueOf(this.minYear), String.valueOf(this.maxYear)});
            }
            this.map.clear();
            StringBuffer oql = new StringBuffer();
            oql.append("select * where number like '" + this.sYear + "Y" + "' order by number");
            this.yearCol = this.iBgPeriod.getBgPeriodCollection(oql.toString());
            if (this.yearCol != null && this.yearCol.size() > 0) {
                iter = this.yearCol.iterator();
                while (iter.hasNext()) {
                    bgPeriodInfo = (BgPeriodInfo)iter.next();
                    this.map.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                }
                info.add(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"Year"));
            }
            this.isSelect = this.yearCol.size() == 1;
            if (this.kDCheckYear.isSelected() && this.kDCheckHalfYear.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + this.sYear + "%" + "HY" + "' order by number");
                this.halfYearCol = this.iBgPeriod.getBgPeriodCollection(oql.toString());
                if (this.halfYearCol != null && this.halfYearCol.size() > 0) {
                    iter = this.halfYearCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.map.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"HalfYear"));
                }
                this.isSelect = this.halfYearCol.size() == 2;
            }
            if (this.kDCheckHalfYear.isSelected() && this.kDCheckQuarter.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + this.sYear + "%" + "Q" + "' order by number");
                this.quarterCol = this.iBgPeriod.getBgPeriodCollection(oql.toString());
                if (this.quarterCol != null && this.quarterCol.size() > 0) {
                    iter = this.quarterCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.map.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"Quarter"));
                }
                this.isSelect = this.quarterCol.size() == 4;
            }
            if (this.kDCheckQuarter.isSelected() && this.kDCheckMonth.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + this.sYear + "%" + "M" + "' order by number");
                this.monthCol = this.iBgPeriod.getBgPeriodCollection(oql.toString());
                if (this.monthCol != null && this.monthCol.size() > 0) {
                    iter = this.monthCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.map.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"Month"));
                }
                this.isSelect = this.monthCol.size() == 12;
            }
            if (this.kDCheckTenDays.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + this.sYear + "%" + "TD" + "' order by number");
                this.tenDaysCol = this.iBgPeriod.getBgPeriodCollection(oql.toString());
                if (this.tenDaysCol != null && this.tenDaysCol.size() > 0) {
                    iter = this.tenDaysCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.map.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"TenDays"));
                }
                this.isSelect = this.tenDaysCol.size() == 36;
            }
            if (this.kDCheckWeek.isSelected()) {
                oql = new StringBuffer();
                if (this.kDYear.isSelected() && this.kDMonth.isSelected()) {
                    oql.append("select * where number like '" + this.sYear + "%" + "W" + "' order by number");
                } else if (this.kDYear.isSelected() && !this.kDMonth.isSelected()) {
                    oql.append("select * where number like '" + this.sYear + "%" + "W" + "' order by number");
                } else if (!this.kDYear.isSelected() && this.kDMonth.isSelected()) {
                    oql.append("select * where number like '" + this.sYear + "%" + "MW" + "' order by number");
                }
                this.weekCol = this.iBgPeriod.getBgPeriodCollection(oql.toString());
                if (this.weekCol != null && this.weekCol.size() > 0) {
                    iter = this.weekCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.map.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"Week"));
                }
                if (this.kDYear.isSelected() && !this.kDMonth.isSelected()) {
                    this.isSelect = this.weekCol.size() == BgPeriodHelper.getWeek(this.iYear, true);
                } else if (!this.kDYear.isSelected() && this.kDMonth.isSelected()) {
                    this.isSelect = this.weekCol.size() == BgPeriodHelper.getWeek(this.iYear, false);
                } else if (this.kDYear.isSelected() && this.kDMonth.isSelected()) {
                    this.isSelect = this.weekCol.size() == BgPeriodHelper.getWeek(this.iYear, true) + BgPeriodHelper.getWeek(this.iYear, false);
                }
            }
            if (this.kDCheckMonth.isSelected() && this.kDCheckDay.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + this.sYear + "%" + "D" + "' order by number");
                this.dayCol = this.iBgPeriod.getBgPeriodCollection(oql.toString());
                if (this.dayCol != null && this.dayCol.size() > 0) {
                    iter = this.dayCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.map.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"Day"));
                }
                this.isSelect = this.dayCol.size() == BgPeriodHelper.getDaysOfYear(this.iYear);
            }
            this.clear();
            if (this.isSelect) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"existExit"));
                SysUtil.abort();
            } else if (info.size() > 0) {
                String and = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"AND");
                String left = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"left");
                String right = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"right");
                StringBuffer message = new StringBuffer(128);
                message.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"SYSTEM"));
                int n = info.size();
                for (int i = 0; i < n; ++i) {
                    if (i + 1 < n) {
                        message.append(left + info.get(i) + right + and);
                        continue;
                    }
                    message.append(left + info.get(i) + right);
                }
                message.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"PERIOD"));
                message.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"existCreate"));
                MsgBox.showWarning((Component)((Object)this), (String)message.toString());
            }
            info.clear();
        }
        catch (BOSException ex) {
            MsgBox.showError((Component)((Object)this), (String)ex.toString());
            SysUtil.abort();
        }
        return true;
    }

    private void clear() {
        if (this.yearCol != null) {
            this.yearCol.clear();
        }
        if (this.quarterCol != null) {
            this.quarterCol.clear();
        }
        if (this.monthCol != null) {
            this.monthCol.clear();
        }
        if (this.halfYearCol != null) {
            this.halfYearCol.clear();
        }
        if (this.tenDaysCol != null) {
            this.tenDaysCol.clear();
        }
        if (this.weekCol != null) {
            this.weekCol.clear();
        }
        if (this.dayCol != null) {
            this.dayCol.clear();
        }
    }

    private void periodProcess() throws BOSException {
        if (this.kDSpinner.getValue() == null) {
            return;
        }
        this.kDTable.setRefresh(false);
        this.processYear();
        this.kDTable.setRefresh(true);
    }

    private void processYear() throws BOSException {
        String YearNumber = null;
        boolean isLeaf = true;
        if (this.kDCheckHalfYear.isSelected() || this.kDYear.isSelected()) {
            isLeaf = false;
        }
        BgPeriodInfo bgPeriodYear = null;
        if (this.kDCheckYear.isSelected()) {
            YearNumber = this.sYear + "Y";
            bgPeriodYear = (BgPeriodInfo)this.map.get(YearNumber);
            if (bgPeriodYear == null) {
                bgPeriodYear = new BgPeriodInfo();
                bgPeriodYear.setId(BOSUuid.create((BOSObjectType)bgPeriodYear.getBOSType()));
                bgPeriodYear.setNumber(YearNumber);
                bgPeriodYear.setLongNumber(YearNumber);
                for (int i = 0; i < BgLocaleHelper.locales.length; ++i) {
                    Locale locale = BgLocaleHelper.locales[i];
                    bgPeriodYear.setName(this.sYear + BgPeriodEditUI.getString("Year", locale), locale);
                }
                bgPeriodYear.setBeginDate(this.helper.getStartDate(this.helper.getFirstDayOfYear(this.iYear)));
                bgPeriodYear.setEndDate(this.helper.getBeoverDate(this.helper.getLastDayOfYear(this.iYear)));
                bgPeriodYear.setPeriodType(BgPeriodEnum.YEAR);
                bgPeriodYear.setYear(this.iYear);
                bgPeriodYear.setMonth(this.helper.getMonthsOfYear());
                bgPeriodYear.setLevel(1);
                bgPeriodYear.setShowLevel(1);
            }
            bgPeriodYear.setIsLeaf(isLeaf);
            this.processTable(bgPeriodYear);
            if (this.kDCheckHalfYear.isSelected()) {
                this.processHalfYear(this.iYear, bgPeriodYear);
            }
            if (this.kDCheckWeek.isSelected() && this.kDYear.isSelected()) {
                this.processYearWeek(this.iYear, bgPeriodYear);
            }
        }
    }

    private void processHalfYear(int year, BgPeriodInfo bgPeriodYear) throws BOSException {
        String halfYear = null;
        String halfYearNumber = null;
        BgPeriodInfo bgPeriodHalfYear = null;
        boolean isLeaf = true;
        if (this.kDCheckQuarter.isSelected()) {
            isLeaf = false;
        }
        for (int i = 1; i <= 2; ++i) {
            halfYear = this.df.format(i);
            halfYearNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + halfYear + "HY").toString();
            bgPeriodHalfYear = (BgPeriodInfo)this.map.get(halfYearNumber);
            if (bgPeriodHalfYear == null) {
                bgPeriodHalfYear = new BgPeriodInfo();
                bgPeriodHalfYear.setId(BOSUuid.create((BOSObjectType)bgPeriodHalfYear.getBOSType()));
                bgPeriodHalfYear.setNumber(halfYearNumber);
                bgPeriodHalfYear.setLongNumber(bgPeriodYear.getLongNumber() + "!" + halfYearNumber);
                for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                    Locale locale = BgLocaleHelper.locales[l];
                    bgPeriodHalfYear.setName(bgPeriodYear.getName(locale) + BgPeriodEditUI.getHalfYearName(i, locale) + BgPeriodEditUI.getString("HalfYear", locale), locale);
                }
                bgPeriodHalfYear.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getHalfYearFirstDay(year, i)));
                bgPeriodHalfYear.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getHalfYearLastDay(year, i)));
                bgPeriodHalfYear.setPeriodType(BgPeriodEnum.HALFYEAR);
                bgPeriodHalfYear.setYear(year);
                bgPeriodHalfYear.setHalfYear(i);
                bgPeriodHalfYear.setMonth(i * 6);
                bgPeriodHalfYear.setLevel(2);
                bgPeriodHalfYear.setShowLevel(100 + (i - 1) * 900);
                bgPeriodHalfYear.setParent(bgPeriodYear);
            }
            bgPeriodHalfYear.setIsLeaf(isLeaf);
            this.processTable(bgPeriodHalfYear);
            if (isLeaf) continue;
            this.processQuarter(this.iYear, bgPeriodYear, bgPeriodHalfYear);
        }
    }

    private void processQuarter(int Year, BgPeriodInfo bgPeriodYear, BgPeriodInfo bgPeriodHalfYear) throws BOSException {
        boolean isLeaf = true;
        if (this.kDCheckMonth.isSelected()) {
            isLeaf = false;
        }
        int iQuearter = 0;
        String Quearter = null;
        String QuarterNumber = null;
        BgPeriodInfo bgPeriodQuarter = null;
        int q = 2;
        for (int i = 1; i <= q; ++i) {
            iQuearter = (bgPeriodHalfYear.getHalfYear() - 1) * 2 + i;
            Quearter = this.df.format(iQuearter);
            QuarterNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + Quearter + "Q").toString();
            bgPeriodQuarter = (BgPeriodInfo)this.map.get(QuarterNumber);
            if (bgPeriodQuarter == null) {
                bgPeriodQuarter = new BgPeriodInfo();
                bgPeriodQuarter.setId(BOSUuid.create((BOSObjectType)bgPeriodQuarter.getBOSType()));
                bgPeriodQuarter.setNumber(QuarterNumber);
                bgPeriodQuarter.setLongNumber(bgPeriodHalfYear.getLongNumber() + "!" + QuarterNumber);
                for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                    Locale locale = BgLocaleHelper.locales[l];
                    bgPeriodQuarter.setName(bgPeriodYear.getName(locale) + Quearter + BgPeriodEditUI.getString("Quarter", locale), locale);
                }
                bgPeriodQuarter.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getQuarterFirstDay(Year, iQuearter)));
                bgPeriodQuarter.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getQuarterLastDay(Year, iQuearter)));
                bgPeriodQuarter.setPeriodType(BgPeriodEnum.QUARTER);
                bgPeriodQuarter.setYear(Year);
                bgPeriodQuarter.setHalfYear(bgPeriodHalfYear.getHalfYear());
                bgPeriodQuarter.setQuarter(iQuearter);
                bgPeriodQuarter.setLevel(3);
                bgPeriodQuarter.setShowLevel(bgPeriodHalfYear.getShowLevel() + 100 + (i - 1) * 400);
                bgPeriodQuarter.setParent(bgPeriodHalfYear);
            }
            bgPeriodQuarter.setIsLeaf(isLeaf);
            this.processTable(bgPeriodQuarter);
            if (isLeaf) continue;
            this.processMonth(Year, iQuearter, bgPeriodYear, bgPeriodQuarter);
        }
    }

    private void processYearWeek(int Year, BgPeriodInfo bgPeriodYear) throws BOSException {
        String Week = null;
        BgPeriodInfo bgPeriodWeek = null;
        int weekFirstDay = ((BgWeekDataTypeEnum)((Object)this.kDComboBox1.getSelectedItem())).getValue();
        int w = BgPeriodHelper.getWeek(Year, true);
        for (int i = 1; i <= w; ++i) {
            Week = this.df.format(i);
            String WeekNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + Week + "W").toString();
            bgPeriodWeek = (BgPeriodInfo)this.map.get(WeekNumber);
            if (bgPeriodWeek == null) {
                bgPeriodWeek = new BgPeriodInfo();
                bgPeriodWeek.setId(BOSUuid.create((BOSObjectType)bgPeriodWeek.getBOSType()));
                bgPeriodWeek.setNumber(WeekNumber);
                bgPeriodWeek.setLongNumber(bgPeriodYear.getLongNumber() + "!" + WeekNumber);
                for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                    Locale locale = BgLocaleHelper.locales[l];
                    bgPeriodWeek.setName(bgPeriodYear.getName(locale) + Week + BgPeriodEditUI.getString("Week", locale), locale);
                }
                bgPeriodWeek.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getWeekFirstDay(Year, i, weekFirstDay)));
                bgPeriodWeek.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getWeekLastDay(Year, i, weekFirstDay)));
                bgPeriodWeek.setPeriodType(BgPeriodEnum.YWEEK);
                bgPeriodWeek.setYear(Year);
                bgPeriodWeek.setMonth(this.helper.getCurrentlyMonth(bgPeriodWeek.getEndDate()));
                bgPeriodWeek.setWeek(i);
                bgPeriodWeek.setLevel(2);
                bgPeriodWeek.setShowLevel(1900 + i);
                bgPeriodWeek.setIsLeaf(true);
                bgPeriodWeek.setParent(bgPeriodYear);
            }
            this.processTable(bgPeriodWeek);
        }
    }

    private void processMonthWeek(int Month, BgPeriodInfo bgPeriodMonth) throws BOSException {
        String Week = null;
        BgPeriodInfo bgPeriodMonthWeek = null;
        int weekFirstDay = ((BgWeekDataTypeEnum)((Object)this.kDComboBox1.getSelectedItem())).getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(BgPeriodHelper.getMonthLastDay(this.iYear, Month));
        calendar.setFirstDayOfWeek(weekFirstDay);
        int monthWeeks = calendar.get(4);
        for (int i = 1; i <= monthWeeks; ++i) {
            Week = this.df.format(i);
            String WeekNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + Week + "MW").toString();
            bgPeriodMonthWeek = (BgPeriodInfo)this.map.get(WeekNumber);
            if (bgPeriodMonthWeek == null) {
                bgPeriodMonthWeek = new BgPeriodInfo();
                bgPeriodMonthWeek.setId(BOSUuid.create((BOSObjectType)bgPeriodMonthWeek.getBOSType()));
                bgPeriodMonthWeek.setNumber(WeekNumber);
                bgPeriodMonthWeek.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + WeekNumber);
                for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                    Locale locale = BgLocaleHelper.locales[l];
                    bgPeriodMonthWeek.setName(bgPeriodMonth.getName(locale) + Week + BgPeriodEditUI.getString("Week", locale), locale);
                }
                bgPeriodMonthWeek.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getMonthWeekFirstDay(this.iYear, Month, i, weekFirstDay)));
                bgPeriodMonthWeek.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getMonthWeekLastDay(this.iYear, Month, i, weekFirstDay)));
                bgPeriodMonthWeek.setPeriodType(BgPeriodEnum.MWEEK);
                bgPeriodMonthWeek.setYear(this.iYear);
                bgPeriodMonthWeek.setHalfYear(bgPeriodMonth.getHalfYear());
                bgPeriodMonthWeek.setMonth(Month);
                bgPeriodMonthWeek.setWeek(i);
                bgPeriodMonthWeek.setLevel(5);
                bgPeriodMonthWeek.setShowLevel(bgPeriodMonth.getShowLevel() + 70 + i);
                bgPeriodMonthWeek.setIsLeaf(true);
                bgPeriodMonthWeek.setParent(bgPeriodMonth);
            }
            this.processTable(bgPeriodMonthWeek);
        }
    }

    private void processMonth(int Year, int Quarter, BgPeriodInfo bgPeriodYear, BgPeriodInfo bgPeriodQuarter) throws BOSException {
        int month = 1;
        boolean isLeaf = true;
        if (this.kDCheckTenDays.isSelected() || this.kDCheckWeek.isSelected() || this.kDCheckDay.isSelected()) {
            isLeaf = false;
        }
        String sMonth = null;
        String MonthNumber = null;
        BgPeriodInfo bgPeriodMonth = null;
        int m = 3;
        for (int i = 1; i <= m; ++i) {
            month = (Quarter - 1) * 3 + i;
            sMonth = this.df.format(month);
            MonthNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + sMonth + "M").toString();
            bgPeriodMonth = (BgPeriodInfo)this.map.get(MonthNumber);
            if (bgPeriodMonth == null) {
                bgPeriodMonth = new BgPeriodInfo();
                bgPeriodMonth.setId(BOSUuid.create((BOSObjectType)bgPeriodMonth.getBOSType()));
                bgPeriodMonth.setNumber(MonthNumber);
                bgPeriodMonth.setLongNumber(bgPeriodQuarter.getLongNumber() + "!" + MonthNumber);
                for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                    Locale locale = BgLocaleHelper.locales[l];
                    bgPeriodMonth.setName(bgPeriodYear.getName(locale) + sMonth + BgPeriodEditUI.getString("Month", locale), locale);
                }
                bgPeriodMonth.setBeginDate(this.helper.getStartDate(this.helper.getFirstDayOfMonth(Year, month)));
                bgPeriodMonth.setEndDate(this.helper.getBeoverDate(this.helper.getLastDayOfMonth(Year, month)));
                bgPeriodMonth.setPeriodType(BgPeriodEnum.MONTH);
                bgPeriodMonth.setYear(Year);
                bgPeriodMonth.setHalfYear(bgPeriodQuarter.getHalfYear());
                bgPeriodMonth.setQuarter(Quarter);
                bgPeriodMonth.setMonth(month);
                bgPeriodMonth.setLevel(4);
                bgPeriodMonth.setShowLevel(bgPeriodQuarter.getShowLevel() + i * 100);
                bgPeriodMonth.setParent(bgPeriodQuarter);
            }
            bgPeriodMonth.setIsLeaf(isLeaf);
            this.processTable(bgPeriodMonth);
            if (this.kDCheckDay.isSelected()) {
                this.processDay(Year, Quarter, month, bgPeriodMonth);
            }
            if (this.kDCheckWeek.isSelected() && this.kDMonth.isSelected()) {
                this.processMonthWeek(month, bgPeriodMonth);
            }
            if (!this.kDCheckTenDays.isSelected()) continue;
            this.processTenDays(Year, Quarter, month, bgPeriodMonth);
        }
    }

    protected void processTenDays(int Year, int Quarter, int Month, BgPeriodInfo bgPeriodMonth) throws BOSException {
        String day = null;
        String dayNumber = null;
        BgPeriodInfo bgPeriodTenDay = null;
        int d = 3;
        for (int i = 1; i <= d; ++i) {
            day = this.df.format(i);
            dayNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + day + "TD").toString();
            bgPeriodTenDay = (BgPeriodInfo)this.map.get(dayNumber);
            if (bgPeriodTenDay == null) {
                bgPeriodTenDay = new BgPeriodInfo();
                bgPeriodTenDay.setId(BOSUuid.create((BOSObjectType)bgPeriodTenDay.getBOSType()));
                bgPeriodTenDay.setNumber(dayNumber);
                bgPeriodTenDay.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + dayNumber);
                for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                    Locale locale = BgLocaleHelper.locales[l];
                    day = day.equals("01") ? BgPeriodEditUI.getString("the_first_ten_days_of_a_month", locale) : (day.equals("02") ? BgPeriodEditUI.getString("the_middle_ten_days_of_a_month", locale) : BgPeriodEditUI.getString("the_last_ten_day_of_a_month", locale));
                    bgPeriodTenDay.setName(bgPeriodMonth.getName(locale) + day, locale);
                }
                bgPeriodTenDay.setBeginDate(BgPeriodHelper.getTenDaysFirstDay(Year, Month, i));
                bgPeriodTenDay.setEndDate(BgPeriodHelper.getTenDaysLastDay(Year, Month, i));
                bgPeriodTenDay.setPeriodType(BgPeriodEnum.TENDAYS);
                bgPeriodTenDay.setYear(Year);
                bgPeriodTenDay.setQuarter(Quarter);
                bgPeriodTenDay.setMonth(Month);
                bgPeriodTenDay.setLevel(5);
                bgPeriodTenDay.setShowLevel(bgPeriodMonth.getShowLevel() + 80 + i);
                bgPeriodTenDay.setIsLeaf(true);
                bgPeriodTenDay.setParent(bgPeriodMonth);
            }
            this.processTable(bgPeriodTenDay);
        }
    }

    private void processDay(int Year, int Quarter, int Month, BgPeriodInfo bgPeriodMonth) throws BOSException {
        String day = null;
        String dayNumber = null;
        BgPeriodInfo bgPeriodDay = null;
        int d = this.helper.getDaysOfMonth(Year, Month);
        for (int i = 1; i <= d; ++i) {
            day = this.df.format(i);
            dayNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + day + "D").toString();
            bgPeriodDay = (BgPeriodInfo)this.map.get(dayNumber);
            if (bgPeriodDay == null) {
                bgPeriodDay = new BgPeriodInfo();
                bgPeriodDay.setId(BOSUuid.create((BOSObjectType)bgPeriodDay.getBOSType()));
                bgPeriodDay.setNumber(dayNumber);
                bgPeriodDay.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + dayNumber);
                for (int l = 0; l < BgLocaleHelper.locales.length; ++l) {
                    Locale locale = BgLocaleHelper.locales[l];
                    bgPeriodDay.setName(bgPeriodMonth.getName(locale) + day + BgPeriodEditUI.getString("Day", locale), locale);
                }
                bgPeriodDay.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getDay(Year, Month, i)));
                bgPeriodDay.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getDay(Year, Month, i)));
                bgPeriodDay.setPeriodType(BgPeriodEnum.DAY);
                bgPeriodDay.setYear(Year);
                bgPeriodDay.setQuarter(Quarter);
                bgPeriodDay.setMonth(Month);
                bgPeriodDay.setLevel(5);
                bgPeriodDay.setShowLevel(bgPeriodMonth.getShowLevel() + i);
                bgPeriodDay.setIsLeaf(true);
                bgPeriodDay.setParent(bgPeriodMonth);
            }
            this.processTable(bgPeriodDay);
        }
    }

    private void processTable(BgPeriodInfo bgPeriodInfo) {
        IRow row = null;
        NumberExpandInfo numberExpandInfo = null;
        row = this.kDTable.addRow();
        if (row != null) {
            row.setUserObject((Object)bgPeriodInfo);
            row.getCell(0).setValue((Object)bgPeriodInfo.getNumber());
            row.getCell(1).setValue((Object)bgPeriodInfo.getName());
            row.getCell(2).setValue((Object)bgPeriodInfo.getBeginDate());
            row.getCell(3).setValue((Object)bgPeriodInfo.getEndDate());
            numberExpandInfo = new NumberExpandInfo();
            numberExpandInfo.setLevel(bgPeriodInfo.getLevel());
            numberExpandInfo.setLeaf(bgPeriodInfo.isIsLeaf());
            numberExpandInfo.setLongNumber(bgPeriodInfo.getLongNumber());
            numberExpandInfo.setNumber(bgPeriodInfo.getNumber());
            numberExpandInfo.setExpandStatus(true);
            row.getCell(0).setValue((Object)numberExpandInfo);
        }
    }

    private void endProcess() {
        try {
            if (this.iBgPeriod == null) {
                this.iBgPeriod = BgPeriodFactory.getRemoteInstance();
            }
            BarThread process = new BarThread(this.iBgPeriod, this.kDProgressBar, this.ui);
            process.start();
        }
        catch (BOSException ex) {
            this.isClose = true;
            this.kDButEndHelp.setEnabled(true);
            this.kDButEndCancel.setEnabled(true);
            this.kDButEndPrevious.setEnabled(true);
            this.kDButEndFinish.setEnabled(true);
            MsgBox.showError((Component)((Object)this), (String)ex.toString());
            SysUtil.abort();
        }
    }

    public boolean destroyWindow() {
        if (this.isClose) {
            boolean re = super.destroyWindow();
            if (re) {
                // empty if block
            }
            return re;
        }
        return false;
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        NumberExpandInfo numberExpandInfo;
        int rowIndex;
        IRow row;
        int colIndex;
        if (e.getClickCount() == 1 && (colIndex = e.getColIndex()) == 0 && (row = this.kDTable.getRow(rowIndex = e.getRowIndex())) != null && (numberExpandInfo = (NumberExpandInfo)row.getCell(0).getValue()) != null && this.render.inRect(numberExpandInfo, e.getX(), e.getY())) {
            this.setTreeDisplayStyle(row, numberExpandInfo);
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo numberExpandInfo) {
        if (!numberExpandInfo.isLeaf) {
            this.kDTable.setRefresh(false);
            this.expandTable(row, numberExpandInfo);
            this.kDTable.setRefresh(true);
            this.kDTable.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo numberExpandInfo) {
        if (row == null || numberExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String bgLongNumber = numberExpandInfo.getLongNumber();
        boolean isExpandStatus = numberExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            numberExpandInfo.setExpandStatus(false);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            numberExpandInfo.setExpandStatus(true);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                this.expandChild(child, expandInfo);
            }
        }
    }

    private int expandChild(IRow row, NumberExpandInfo parentExpandInfo) {
        int rowIndex;
        IRow child = null;
        int endIndex = rowIndex = row.getRowIndex() + 1;
        int rowCount = this.kDTable.getRowCount();
        String number = null;
        NumberExpandInfo childExpandInfo = null;
        String parentNumber = parentExpandInfo.getLongNumber();
        parentExpandInfo.setExpandStatus(true);
        for (int i = rowIndex; i < rowCount; ++i) {
            child = this.kDTable.getRow(i);
            if (child != null) {
                childExpandInfo = (NumberExpandInfo)child.getCell(0).getValue();
                number = childExpandInfo.getLongNumber();
                if (!number.startsWith(parentNumber)) break;
                if (!childExpandInfo.isLeaf()) {
                    i = this.expandChild(child, childExpandInfo);
                }
            }
            ++endIndex;
        }
        return endIndex;
    }

    public static String getHalfYearName(int i, Locale locale) throws BOSException {
        String s = "";
        if (i == 1) {
            s = BgPeriodEditUI.getString("firstHalfYear", locale);
        } else if (i == 2) {
            s = BgPeriodEditUI.getString("lastHalfYear", locale);
        }
        return s;
    }

    @Override
    protected void arcNature_actionPerformed(ActionEvent e) throws Exception {
        this.arcPersonal.setSelected(false);
        this.setNatureState(true);
        if (!this.arcNature.isSelected()) {
            this.arcNature.setSelected(true);
        }
    }

    private void setNatureState(boolean state) {
        this.kDSpinner.setEnabled(state);
        this.kDCheckDay.setEnabled(state);
        this.kDCheckHalfYear.setEnabled(state);
        this.kDCheckMonth.setEnabled(state);
        this.kDCheckQuarter.setEnabled(state);
        this.kDCheckWeek.setEnabled(state);
        this.kDCheckYear.setEnabled(state);
        this.kDYear.setEnabled(state);
        this.kDMonth.setEnabled(state);
    }

    @Override
    protected void arcPersonal_actionPerformed(ActionEvent e) throws Exception {
        this.arcNature.setSelected(false);
        this.setNatureState(false);
        if (!this.arcPersonal.isSelected()) {
            this.arcPersonal.setSelected(true);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnFinish_actionPerformed(ActionEvent e) throws Exception {
        Date beginDate = (Date)this.beginDate.getValue();
        Date endDate = (Date)this.endDate.getValue();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String beginD = df.format(beginDate);
        String endD = df.format(endDate);
        if (beginDate.getTime() > endDate.getTime()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"CheckBgPeriodMsg"));
            return;
        }
        String number = this.txtNum.getText();
        if (number == null || number.equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"PeriodNumberNotNull"));
            return;
        }
        number = PREFIX_PERSONAL_PERIOD + number;
        String name = this.txtName.getText();
        String appendName = "(" + beginD.replace('-', '.') + "-" + endD.replace('-', '.') + ")";
        if ((name = name + appendName) == null || name.equals("")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"PeriodNameNotNull"));
            return;
        }
        BgPeriodInfo info = new BgPeriodInfo();
        BgLocaleHelper.setLocalesProperty((IObjectValue)info, "name", name, this.getCurrentLocale());
        info.setNumber(number);
        info.setLongNumber(number);
        info.setPeriodType(BgPeriodEnum.PERSONAL);
        info.setBeginDate(beginDate);
        info.setEndDate(endDate);
        info.setShowLevel(0);
        if (this.iBgPeriod == null) {
            this.iBgPeriod = BgPeriodFactory.getRemoteInstance();
        }
        IObjectPK pk = this.iBgPeriod.addnew((CoreBaseInfo)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        this.getUIWindow().close();
    }

    private void createNewRelatedPeriodInfo(int sYear, int eYear, IBgPeriod iBgPeriod, BgPeriodInfo parentInfo) {
        int[] years = this.helper.getYear(sYear, eYear);
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = years.length;
        for (int i = 0; i < num; ++i) {
            String fnumber = years[i] + "Y";
            sb.append(fnumber);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        try {
            List numList = iBgPeriod.judgePeriodInfoExistByNums(sb.toString());
            int num2 = years.length;
            for (int i = 0; i < num2; ++i) {
                String fnumber = years[i] + "Y";
                if (numList.contains(fnumber)) continue;
                this.createNewYearPeriodInfo(iBgPeriod, fnumber, parentInfo, years[i]);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void createNewYearPeriodInfo(IBgPeriod iBgPeriod, String YearNumber, BgPeriodInfo parentInfo, int year) throws BOSException {
        BgPeriodInfo bgPeriodYear = new BgPeriodInfo();
        bgPeriodYear.setId(BOSUuid.create((BOSObjectType)bgPeriodYear.getBOSType()));
        bgPeriodYear.setNumber(YearNumber);
        bgPeriodYear.setLongNumber(YearNumber);
        for (int i = 0; i < BgLocaleHelper.locales.length; ++i) {
            Locale locale = BgLocaleHelper.locales[i];
            bgPeriodYear.setName(year + BgPeriodEditUI.getString("Year", locale), locale);
        }
        bgPeriodYear.setBeginDate(this.helper.getStartDate(this.helper.getFirstDayOfYear(year)));
        bgPeriodYear.setEndDate(this.helper.getBeoverDate(this.helper.getLastDayOfYear(year)));
        bgPeriodYear.setPeriodType(BgPeriodEnum.YEAR);
        bgPeriodYear.setYear(year);
        bgPeriodYear.setMonth(this.helper.getMonthsOfYear());
        bgPeriodYear.setLevel(1);
        bgPeriodYear.setShowLevel(1);
        try {
            iBgPeriod.addnew((CoreBaseInfo)bgPeriodYear);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
    }

    @Override
    protected void btnPrevious_actionPerformed(ActionEvent e) throws Exception {
        this.kDPanelPersonalEnd.setVisible(false);
        this.kDPanelStartup.setVisible(true);
    }

    public static String getString(String key, Locale locale) throws BOSException {
        Object ctx = null;
        String resource = "com.kingdee.eas.ma.budget.BgPeriodResource";
        if (ctx == null) {
            if (clientResource == null) {
                HashSet<String> keys = new HashSet<String>();
                keys.add("Year");
                keys.add("HalfYear");
                keys.add("Quarter");
                keys.add("Week");
                keys.add("Month");
                keys.add("the_first_ten_days_of_a_month");
                keys.add("the_middle_ten_days_of_a_month");
                keys.add("the_last_ten_day_of_a_month");
                keys.add("Day");
                keys.add("firstHalfYear");
                keys.add("lastHalfYear");
                clientResource = BgControlPeriodMapFactory.getRemoteInstance().getString(resource, keys, BgLocaleHelper.locales);
            }
            if (locale == null) {
                locale = SysContext.getSysContext().getLocale();
            }
            if (clientResource.containsKey(key + "_" + locale)) {
                return (String)clientResource.get(key + "_" + locale);
            }
            return EASResource.getString((String)resource, (String)key);
        }
        if (locale == null) {
            locale = ctx.getLocale();
        }
        return ResourceBase.getString((String)resource, (String)key, (Locale)locale);
    }

    private class BgPeriodRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        private BgPeriodRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    class NumberExpandInfo {
        private String number;
        private String longNumber;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        NumberExpandInfo() {
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }
    }

    class BarThread
    extends Thread {
        private int DELAY = 10;
        private KDProgressBar progressBar = null;
        private IBgPeriod iBgPeriod = null;
        private BgPeriodListUI ui = null;

        public BarThread(IBgPeriod iBgPeriod, KDProgressBar bar, BgPeriodListUI ui) {
            this.iBgPeriod = iBgPeriod;
            this.progressBar = bar;
            this.ui = ui;
        }

        @Override
        public void run() {
            if (this.iBgPeriod == null) {
                return;
            }
            int rowCount = BgPeriodEditUI.this.kDTable.getRowCount();
            this.progressBar.setMaximum(rowCount);
            BgPeriodInfo bgPeriodInfo = null;
            try {
                for (int i = 0; i < rowCount; ++i) {
                    bgPeriodInfo = (BgPeriodInfo)BgPeriodEditUI.this.kDTable.getRow(i).getUserObject();
                    if (bgPeriodInfo != null && this.checkPeriodInfo(bgPeriodInfo)) {
                        this.iBgPeriod.addnew((CoreBaseInfo)bgPeriodInfo);
                    }
                    this.progressBar.setValue(i);
                    try {
                        Thread.sleep(this.DELAY);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (EASBizException ex) {
                logger.error((Object)ex.getMessage());
            }
            catch (BOSException ex) {
                logger.error((Object)ex.getMessage());
            }
            BgPeriodEditUI.this.map.clear();
            BgPeriodEditUI.this.isClose = true;
            this.ui.setSelectYear(BgPeriodEditUI.this.iYear);
            this.ui.setRefreshType(2);
            BgPeriodEditUI.this.getUIWindow().close();
        }

        private boolean checkPeriodInfo(BgPeriodInfo bgPeriodInfo) {
            if (bgPeriodInfo == null) {
                return false;
            }
            return BgPeriodEditUI.this.map.get(bgPeriodInfo.getNumber()) == null;
        }
    }
}

