/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.client.AbstractBgPeriodF7UI;
import com.kingdee.eas.ma.budget.client.BgPeriodF7ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class BgPeriodF7UI
extends AbstractBgPeriodF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodF7UI.class);
    private BgPeriodF7ListUI bgPeriodListUI = null;
    private boolean isCanceled = true;
    private boolean isMultiSelect = false;
    private boolean isExamine = false;
    protected BgPeriodInfo bgPeriodInfo;
    protected BgPeriodCollection bgPeriodColl = new BgPeriodCollection();
    protected Date beginDate = null;
    protected Date endDate = null;
    BgPeriodEnum bgPeriodEnum = null;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.bgPeriodEnum = (BgPeriodEnum)((Object)this.getUIContext().get("bgPeriodEnum"));
        this.beginDate = (Date)this.getUIContext().get("beginDate");
        this.endDate = (Date)this.getUIContext().get("endDate");
        this.isMultiSelect = this.getUIContext().get("isMultiSelect") == null ? false : (Boolean)this.getUIContext().get("isMultiSelect");
        this.isExamine = this.getUIContext().get("isExamine") == null ? false : (Boolean)this.getUIContext().get("isExamine");
        this.bgPeriodListUI.setBgPeriodEnum(this.bgPeriodEnum);
        this.bgPeriodListUI.setBgPeriodDate(this.beginDate, this.endDate);
        this.bgPeriodListUI.bgPeriodInitial();
        if (this.isExamine) {
            this.bgPeriodListUI.loadPeriodYearWithExamine(true, new CalendarHelper().getCurrentlyYear(new Date()), 1);
        } else if (this.bgPeriodEnum != null && this.bgPeriodEnum.getValue() == 8) {
            this.bgPeriodListUI.loadPersonalPeriod();
        } else {
            this.bgPeriodListUI.loadPeriodYear(true, new CalendarHelper().getCurrentlyYear(new Date()), 1);
        }
        if (this.isMultiSelect) {
            this.bgPeriodListUI.getTable().getSelectManager().setSelectMode(10);
        } else {
            this.bgPeriodListUI.getTable().getSelectManager().setSelectMode(2);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setSize(650, 490);
        this.setMinimumSize(new Dimension(650, 490));
        this.setPreferredSize(new Dimension(650, 490));
        try {
            this.bgPeriodListUI = new BgPeriodF7ListUI();
            this.bgPeriodListUI.initUIContentLayout();
            this.bgPeriodListUI.getTable().addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    try {
                        if (e.getClickCount() == 2) {
                            BgPeriodF7UI.this.btnConfirm_actionPerformed(null);
                        }
                    }
                    catch (Exception exc) {
                        BgPeriodF7UI.this.handUIException(exc);
                    }
                }
            });
            this.bgPeriodListUI.onLoad(false);
        }
        catch (Exception e) {
            if (this.bgPeriodListUI != null) {
                this.bgPeriodListUI.destroyWindow();
                this.bgPeriodListUI = null;
            }
            this.destroyWindow();
            this.handUIExceptionAndAbort(e);
        }
        this.panMain.setLayout((LayoutManager)new BorderLayout());
        this.panMain.add((Component)((Object)this.bgPeriodListUI), (Object)"Center");
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.setCanceled(false);
        if (this.isMultiSelect) {
            BgPeriodCollection bgPeriodCol = this.bgPeriodListUI.getBgPeriodCollection();
            if (bgPeriodCol == null || bgPeriodCol.isEmpty()) {
                String msg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectFaild");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            } else {
                this.setBgPeriodColl(bgPeriodCol);
            }
        } else {
            BgPeriodInfo obj = this.bgPeriodListUI.getData();
            if (obj != null && obj instanceof BgPeriodInfo) {
                this.setBgPeriodInfo(this.bgPeriodListUI.getData());
            } else {
                String msg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectFaild");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
        this.getUIWindow().close();
    }

    public BgPeriodInfo getBgPeriodInfo() {
        return this.bgPeriodInfo;
    }

    public void setBgPeriodInfo(BgPeriodInfo bgPeriodInfo) {
        this.bgPeriodInfo = bgPeriodInfo;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setCanceled(true);
        this.getUIWindow().close();
    }

    protected JButton getDefaultButton() {
        return this.btnConfirm;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        this.isMultiSelect = isMultiSelect;
    }

    public BgPeriodCollection getBgPeriodColl() {
        return this.bgPeriodColl;
    }

    public void setBgPeriodColl(BgPeriodCollection bgPeriodColl) {
        this.bgPeriodColl = bgPeriodColl;
    }
}

