/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.client.AbstractBgPeriodNSettingUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgPeriodNSettingUI
extends AbstractBgPeriodNSettingUI {
    private static final long serialVersionUID = -850192395251020484L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodNSettingUI.class);
    private static final String DEFAULT_VALUE_N = "N";
    private static final String DEFAULT_VALUE_n = "n";
    private static final String OPERATOR_ADD = "+";
    private static final String OPERATOR_SUBTRACT = "-";
    private static final String EMPTY_STR = "";
    public static final String LONGSEPARATOR = "!";
    private boolean isCancel = true;
    private String convertType = "ALL";
    private String value = null;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.kdYear.setEnabled(true);
        this.kdHalfYear.setEnabled(true);
        this.kdQuarter.setEnabled(true);
        this.kdMonth.setEnabled(true);
        this.kdTenDays.setEnabled(true);
        this.kdDay.setEnabled(true);
        this.kdWeek.setEnabled(true);
        this.kdYear.setSelected(true);
        this.kdAll.setSelected(true);
        this.txtInput.setText(DEFAULT_VALUE_N);
        this.kDCheckBox1.setEnabled(false);
        this.kDCheckBox2.setEnabled(false);
        this.kDTextArea1.setEnabled(false);
        this.kDTextArea1.setEditable(false);
        this.kDTextArea1.setCustomForegroundColor(Color.gray);
        this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"293_BgPeriodNSettingUI") + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"294_BgPeriodNSettingUI") + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"295_BgPeriodNSettingUI") + "\r\n" + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"296_BgPeriodNSettingUI") + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"297_BgPeriodNSettingUI") + "\r\n" + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"298_BgPeriodNSettingUI"));
    }

    @Override
    protected void kdAll_actionPerformed(ActionEvent e) throws Exception {
        this.setState(this.kdAll.isSelected());
        this.kDCheckBox2.setSelected(!this.kdAll.isSelected());
        if (this.kdAll.isSelected()) {
            this.setConvertType("ALL");
        } else {
            this.setConvertType("PART");
        }
    }

    @Override
    protected void kdPart_actionPerformed(ActionEvent e) throws Exception {
        this.setState(!this.kdPart.isSelected());
        if (!this.kdPart.isSelected()) {
            this.setConvertType("ALL");
        } else {
            this.setConvertType("PART");
        }
    }

    private void setState(boolean state) {
        this.kdYear.setEnabled(state);
        this.kdHalfYear.setEnabled(state);
        this.kdQuarter.setEnabled(state);
        this.kdMonth.setEnabled(state);
        this.kdTenDays.setEnabled(state);
        this.kdDay.setEnabled(state);
        this.kdWeek.setEnabled(state);
        this.kdYear.setSelected(state);
        this.kDCheckBox1.setEnabled(!state);
        this.kDCheckBox2.setEnabled(!state);
        this.kDCheckBox1.setSelected(!state);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.verify();
        this.setCancel(false);
        this.setValue(this.getTheNValue());
        this.getUIWindow().close();
    }

    private void verify() {
        String nValue = this.txtInput.getText().trim().replaceAll(DEFAULT_VALUE_n, DEFAULT_VALUE_N);
        boolean isValid = true;
        String[] string = nValue.split(LONGSEPARATOR);
        int length = string.length;
        if (length > 0 && length < 3) {
            int j = string.length;
            for (int i = 0; i < j && (isValid = this.verifyStr(string[i])); ++i) {
            }
        } else {
            isValid = false;
        }
        if (!isValid) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodNSetResource", (String)"periodInputInValid"));
            SysUtil.abort();
        }
    }

    public boolean verifyStr(String str) {
        boolean isBoolean = true;
        if (str.length() == 1 && !DEFAULT_VALUE_N.equals(str)) {
            isBoolean = false;
        }
        if (str.length() == 2) {
            isBoolean = false;
        }
        if (str.length() >= 3) {
            if (str.indexOf(DEFAULT_VALUE_N) != 0) {
                isBoolean = false;
            }
            if (str.indexOf(OPERATOR_ADD) != 1 && str.indexOf(OPERATOR_SUBTRACT) != 1) {
                isBoolean = false;
            }
            try {
                Integer.valueOf(str.replaceAll(DEFAULT_VALUE_N, EMPTY_STR).replaceAll("\\+", EMPTY_STR).replaceAll(LONGSEPARATOR, EMPTY_STR));
            }
            catch (NumberFormatException e) {
                isBoolean = false;
            }
        }
        return isBoolean;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    private String getTheNValue() {
        String value = this.txtInput.getText().trim().replaceAll(DEFAULT_VALUE_n, DEFAULT_VALUE_N);
        String periodType = null;
        if (EMPTY_STR.equals(value)) {
            return value;
        }
        String[] varValue = value.split(LONGSEPARATOR);
        varValue[0] = varValue[0] + LONGSEPARATOR;
        if (this.kdAll.isSelected()) {
            if (this.kdYear.isSelected()) {
                periodType = "Y";
            }
            if (this.kdHalfYear.isSelected()) {
                periodType = "HY";
            }
            if (this.kdQuarter.isSelected()) {
                periodType = "Q";
            }
            if (this.kdMonth.isSelected()) {
                periodType = "M";
            }
            if (this.kdDay.isSelected()) {
                periodType = "D";
            }
            if (this.kdWeek.isSelected()) {
                periodType = "W";
            }
            if (this.kdTenDays.isSelected()) {
                periodType = "TD";
            }
            return varValue[0] + periodType;
        }
        if (this.kdPart.isSelected()) {
            if (varValue.length == 1) {
                if (this.kDCheckBox1.isSelected() && !this.kDCheckBox2.isSelected()) {
                    return varValue[0] + "Y";
                }
                if (this.kDCheckBox2.isSelected() && !this.kDCheckBox1.isSelected()) {
                    return varValue[0] + "M";
                }
                if (this.kDCheckBox1.isSelected() && this.kDCheckBox2.isSelected()) {
                    return varValue[0] + "Y" + "." + varValue[0] + "M";
                }
            }
            if (varValue.length == 2 && this.kDCheckBox1.isSelected() && this.kDCheckBox2.isSelected()) {
                return varValue[0] + "Y" + "." + varValue[1] + LONGSEPARATOR + "M";
            }
        }
        return null;
    }

    @Override
    protected void kDCheckBox1_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckBox1_actionPerformed(e);
        if (!this.kDCheckBox1.isSelected() && !this.kDCheckBox2.isSelected()) {
            this.kDCheckBox1.setSelected(true);
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodNSetResource", (String)"checkboxVerify"));
        }
        if (this.kDCheckBox1.isSelected() && this.kDCheckBox2.isSelected()) {
            this.txtInput.setText("N!N");
        } else {
            this.txtInput.setText(DEFAULT_VALUE_N);
        }
    }

    @Override
    protected void kDCheckBox2_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckBox2_actionPerformed(e);
        if (!this.kDCheckBox1.isSelected() && !this.kDCheckBox2.isSelected()) {
            this.kDCheckBox2.setSelected(true);
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgPeriodNSetResource", (String)"checkboxVerify"));
        }
        if (this.kDCheckBox1.isSelected() && this.kDCheckBox2.isSelected()) {
            this.txtInput.setText("N!N");
        } else {
            this.txtInput.setText(DEFAULT_VALUE_N);
        }
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public String getConvertType() {
        return this.convertType;
    }

    public void setConvertType(String convertType) {
        this.convertType = convertType;
    }
}

