/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.print.extend.KDTableImagePrinter;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.AbstractBgRptBaseUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgFilterBaseUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public abstract class BgRptBaseUI
extends AbstractBgRptBaseUI {
    private static final Logger logger = CoreUIObject.getLogger(BgRptBaseUI.class);
    public static final String ISDIRECTSHOW = "isDirectShow";
    public static final String FILTER_PARAM = "filterParam";
    public static final String FILTER_ENTITYVIEW = "filterEntityView";
    private FilterParam defaultQueryParam;
    protected EntityViewInfo mainQuery = null;
    private FilterParam param;
    private CommonQueryDialog queryDlg;
    protected IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.ma.budget", "BgFormQuery");
    protected boolean isShowDialog = true;

    public void onLoad() throws Exception {
        block14: {
            super.onLoad();
            Boolean isDirectShow = (Boolean)this.getUIContext().get(ISDIRECTSHOW);
            FilterParam obj = null;
            if (isDirectShow != null && isDirectShow.equals(Boolean.TRUE)) {
                obj = (FilterParam)this.getUIContext().get(FILTER_PARAM);
                BgFilterBaseUI fui = this.getFilterUI();
                if (fui != null) {
                    fui.onLoad();
                    try {
                        CustomerParams cp = new CustomerParams();
                        fui.setCustomerParams(cp);
                        fui.setFilterObject(cp, obj);
                    }
                    catch (Exception cp) {}
                }
            } else {
                boolean isShow = false;
                if (isShow && this.isShowDialog) {
                    CommonQueryDialog qDlg = this.getQueryDlg();
                    if (!qDlg.show()) {
                        SysUtil.abort();
                    }
                    CustomerParams cp = this.getFilterUI().getCustomerParams();
                    obj = (FilterParam)this.getFilterUI().getFilterObject(cp);
                } else {
                    this.initDefaultQuery(this.mainQueryPK.getFullName());
                    if (this.defaultQueryParam == null && !this.isShowDialog) {
                        this.defaultQueryParam = this.getDefalutQueryParam();
                    }
                    if (this.defaultQueryParam != null) {
                        obj = this.defaultQueryParam;
                    }
                    if (obj == null && this.isShowDialog) {
                        CommonQueryDialog qDlg = this.getQueryDlg();
                        if (!qDlg.show()) {
                            SysUtil.abort();
                        }
                        CustomerParams cp = this.getFilterUI().getCustomerParams();
                        obj = (FilterParam)this.getFilterUI().getFilterObject(cp);
                    }
                }
            }
            this.enableExportExcel(this.getMainTable());
            try {
                this.executeQuery(obj);
            }
            catch (AbortException e) {
                if (this.defaultQueryParam != null) break block14;
                throw e;
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.itemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.itemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.itemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.itemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.itemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        BgFilterBaseUI filterUI = this.getFilterUI();
        this.queryDlg = new CommonQueryDialog();
        EntityViewInfo view = new EntityViewInfo();
        this.queryDlg.setEntityViewInfo(view);
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setHeight(this.getHeightOfDialog());
        this.queryDlg.setWidth(this.getWidthOfDialog());
        this.queryDlg.setTitle(filterUI.getUITitle());
        this.queryDlg.addUserPanel((KDPanel)filterUI);
        if (this.getSecendPanel() != null) {
            this.queryDlg.addUserPanel(this.getSecendPanel());
        }
        this.queryDlg.setShowFilter(false);
        this.queryDlg.setShowSorter(false);
        return this.queryDlg;
    }

    protected int getHeightOfDialog() {
        return 350;
    }

    protected int getWidthOfDialog() {
        return 320;
    }

    protected KDPanel getSecendPanel() {
        return null;
    }

    public void initDefaultQuery(String queryName) throws Exception {
        if (this.defaultQueryParam != null) {
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION)) {
            if (ds.getQueryPanelInfo().size() > 0) {
                CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
                this.defaultQueryParam = (FilterParam)this.getFilterUI().getFilterObject(cp);
            }
            if (this.defaultQueryParam == null) {
                this.defaultQueryParam = this.getDefalutQueryParam();
            }
        }
    }

    public FilterParam getDefalutQueryParam() {
        try {
            BgFilterBaseUI f = this.getFilterUI();
            f.onLoad();
            CustomerParams cp = f.getCustomerParams();
            return (FilterParam)f.getFilterObject(cp);
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void executeQuery(FilterParam param) throws Exception {
        this.setFilterParam(param);
        this.mainQuery = new EntityViewInfo();
        this.mainQuery.setFilter(param.getFilter());
        this.execQuery();
    }

    protected abstract void execQuery() throws Exception;

    public abstract BgFilterBaseUI getFilterUI() throws Exception;

    protected abstract KDTable getMainTable();

    public void setFilterParam(FilterParam param) {
        this.param = param;
    }

    public FilterParam getFilterParam() {
        return this.param;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        KDTable tblMain = this.getMainTable();
        if (tblMain == null) {
            return;
        }
        tblMain.getDataRequestManager().setDataRequestMode(0);
        this.preparePrintPage(tblMain);
        tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        KDTable tblMain = this.getMainTable();
        if (tblMain == null) {
            return;
        }
        tblMain.getDataRequestManager().setDataRequestMode(0);
        this.preparePrintPage(tblMain);
        tblMain.getPrintManager().printPreview();
        KDTableImagePrinter printer = new KDTableImagePrinter();
        tblMain.getPrintManager().fromXmlElement(printer.getPrinter().getPrintConfig().toXmlElement());
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        BgClientHelper.exportTableToExcel((Component)((Object)this), this.getMainTable());
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        CommonQueryDialog dialog = this.getQueryDlg();
        if (!dialog.show()) {
            return;
        }
        CustomerParams cp = this.getFilterUI().getCustomerParams();
        this.param = (FilterParam)this.getFilterUI().getFilterObject(cp);
        this.executeQuery(this.param);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.execQuery();
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.removeNotify();
        }
        return re;
    }
}

