/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgCommonException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgRptFacade;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.AbstractBgRptMain2UI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgFilterBaseUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public abstract class BgRptMain2UI
extends AbstractBgRptMain2UI {
    private static final Logger logger = CoreUIObject.getLogger(BgRptMain2UI.class);
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    protected FlexRender render = null;
    protected FlexRender render4Item = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        if (this.paneMain.getTabCount() > 0) {
            this.paneMain.setSelectedIndex(0);
            this.isLoaded = true;
        }
        if (this.isSumDisp) {
            this.tblMain.checkParsed();
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
        }
    }

    @Override
    public void setIcon() {
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    @Override
    protected boolean isExistApprovedBgForm(BgRptFilterParam filterParam) throws Exception {
        IRowSet rs = null;
        StringBuffer sqlBuff = new StringBuffer(" select BGFORM.FID as FID, BGFORM.FOrgUnitID as FOrgUnitID from t_bg_bgform as BGFORM ");
        sqlBuff.append(" where BGFORM.FOrgUnitID IN ");
        sqlBuff.append(BgHelper.tranArray2String(filterParam.getOrgUnitIds()));
        sqlBuff.append(" AND BGFORM.FBgSchemeId IN ");
        if (filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            sqlBuff.append(BgHelper.tranSet2String(filterParam.getMultiBgSchemeMap().keySet()));
        } else {
            sqlBuff.append(BgHelper.tranArray2String(filterParam.getBgSchemeIds()));
        }
        sqlBuff.append(" AND BGFORM.FBgTemplateID IN ");
        sqlBuff.append(BgHelper.tranArray2String(filterParam.getBgTemplateIds()));
        if (this.periodVec != null && this.periodVec.size() > 0) {
            String[] ids = new String[this.periodVec.size()];
            for (int i = 0; i < this.periodVec.size(); ++i) {
                ids[i] = ((BgPeriodInfo)this.periodVec.get(i)).getId().toString();
            }
            sqlBuff.append(" AND BGFORM.FBgPeriodId IN ");
            sqlBuff.append(BgHelper.tranArray2String(ids));
        }
        sqlBuff.append(" AND BGFORM.FState=");
        sqlBuff.append(2);
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sqlBuff.toString());
        try {
            rs = sqlExe.executeSQL();
            return rs.size() > 0;
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void execQuery() throws Exception {
        Object obj;
        BgSchemeInfo bgScheme;
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (this.paneMain.getTabCount() > 1) {
            int selectedIndex = this.paneMain.getSelectedIndex();
            for (int i = this.paneMain.getTabCount() - 1; i > 0; --i) {
                this.isRemoved = false;
                this.paneMain.remove(i);
                this.isRemoved = true;
            }
        }
        this.rptFilterParam = (BgRptFilterParam)this.getUIContext().get("filterParam");
        this.getUIContext().put("filterParam", null);
        if (this.rptFilterParam == null) {
            this.rptFilterParam = (BgRptFilterParam)this.getFilterParam();
            if (this.rptFilterParam == null) {
                CustomerParams cp = this.getFilterUI().getCustomerParams();
                this.rptFilterParam = (BgRptFilterParam)this.getFilterUI().getFilterObject(cp);
            }
        }
        if ((bgScheme = this.getBgScheme(this.rptFilterParam.getBgSchemeId())) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckExistScheme"));
            this.paneMain.setTitleAt(0, currentCompany.getName());
            this.defaultQueryAvalible = false;
            return;
        }
        if (this.rptFilterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGBALANCE) && !bgScheme.isIsFormal()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSchemIsFormal"));
            this.paneMain.setTitleAt(0, currentCompany.getName());
            SysUtil.abort();
        }
        if (this.getBgTemplate((String)this.rptFilterParam.getBgTemplate().keySet().toArray()[0]) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckExistTemplate"));
            this.paneMain.setTitleAt(0, currentCompany.getName());
            this.defaultQueryAvalible = false;
            return;
        }
        if (this.rptFilterParam.getBeginPeriod() != null && this.rptFilterParam.getEndPeriod() != null && this.rptFilterParam.getBeginPeriod().getPeriodType().getValue() != 8) {
            int type = this.rptFilterParam.getBeginPeriod().getPeriodType().getValue();
            Date beginDate = BgHelper.getDayBegin(this.rptFilterParam.getBeginPeriod().getBeginDate());
            Date endDate = BgHelper.getDayEnd(this.rptFilterParam.getEndPeriod().getEndDate());
            BgPeriodCollection bgPeriodColl = BgHelper.getBgPeriodCollection(type, beginDate, endDate);
            this.periodVec = BgHelper.tranColl2Vec((IObjectCollection)bgPeriodColl);
        } else if (this.periodVec == null) {
            this.periodVec = new Vector();
            this.periodVec.add(this.rptFilterParam.getBeginPeriod());
        }
        if (this.periodVec == null || this.periodVec.size() < 1) {
            // empty if block
        }
        if (!this.rptFilterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGTRACE)) {
            // empty if block
        }
        this.setBgBaseMap((String)this.rptFilterParam.getBgTemplate().keySet().toArray()[0]);
        if (!this.rptFilterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGTRACE) && ((obj = this.bgBaseMap.get("BGELEMENT")) == null || obj != null && ((Vector)obj).size() < 1)) {
            throw new BgCommonException(BgCommonException.CHECKBGELEMENT);
        }
        this.txtBgForm.setText((String)this.rptFilterParam.getBgTemplate().get(this.rptFilterParam.getBgTemplate().keySet().toArray()[0]));
        this.currency = BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit());
        this.txtCurrency.setText(this.currency.getName());
        this.getFilterParam(this.rptFilterParam);
        if (this.paneMain.getTabCount() > 1) {
            for (int i = this.paneMain.getTabCount() - 1; i > 0; --i) {
                this.isRemoved = false;
                this.paneMain.remove(i);
                this.isRemoved = true;
            }
        }
        if (!this.rptFilterParam.isIsSum() || this.rptFilterParam.getOrgUnitIds().length == 1) {
            this.isSumDisp = false;
            this.rptFilterParam.setAttainOrgUnitIds(this.rptFilterParam.getOrgUnitIds());
            this.addPanel(this.paneMain, this.companyVec);
            int index = this.paneMain.getSelectedIndex();
            this.showTable(index);
        } else {
            this.isSumDisp = true;
            Set companyIdSet = BgHelper.tranArray2Set(this.rptFilterParam.getOrgUnitIds());
            companyIdSet.removeAll(this.parentCompanySet);
            this.rptFilterParam.setAttainOrgUnitIds(BgHelper.tranObjArray2StrArray(companyIdSet.toArray()));
            this.paneMain.setTitleAt(0, currentCompany.getName());
            this.showTable(0);
        }
        this.setRptFilterParam(this.rptFilterParam);
    }

    @Override
    protected void initTable(BgRptFilterParam filterParam) throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.getColumn("BgPeriod").setMergeable(true);
        this.tblMain.getColumn("BgPeriod").setGroup(true);
        boolean isSum = false;
        if (filterParam.isIsSum() && filterParam.getOrgUnitIds().length > 1) {
            isSum = true;
        }
        if (isSum) {
            if (this.tblMain.getColumn("BgOrgUnit") != null) {
                this.tblMain.getColumn("BgOrgUnit").setMergeable(true);
                this.tblMain.getColumn("BgOrgUnit").setGroup(true);
            } else {
                return;
            }
        }
        int periodColumnIndex = this.tblMain.getColumnIndex("BgPeriod");
        int itemColumnIndex = this.tblMain.getColumnIndex("BgItem");
        int orgUnitIndex = 0;
        if (isSum) {
            orgUnitIndex = this.tblMain.getColumnIndex("BgOrgUnit");
        }
        Map itemMap = (Map)this.bgBaseMap.get("BGITEMCOMBINE");
        Vector itemIdVec = (Vector)this.bgBaseMap.get("BgItemCombinId");
        int beginOneIndex = 0;
        int endOneIndex = 0;
        int beginIndex = 0;
        int endIndex = 0;
        if (isSum && !filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGTRACE)) {
            Object expandInfo = null;
            for (int i = 0; i < this.companyVec.size(); ++i) {
                FullOrgUnitInfo companyInfo = (FullOrgUnitInfo)this.companyVec.get(i);
                beginOneIndex = this.tblMain.getRowCount();
                for (int j = 0; j < this.periodVec.size(); ++j) {
                    beginIndex = this.tblMain.getRowCount();
                    BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.periodVec.get(j);
                    for (int k = 0; k < itemIdVec.size(); ++k) {
                        String key = (String)itemIdVec.get(k);
                        IRow row = this.tblMain.addRow();
                        if (this.parentCompanySet.contains(companyInfo.getId().toString())) {
                            row.getStyleAttributes().setBackground(BgClientHelper.TOTAL_COLOR);
                        }
                        row.getCell("BgOrgUnit").setValue((Object)companyInfo.getId().toString());
                        row.getCell(orgUnitIndex).setUserObject((Object)companyInfo);
                        row.getCell(periodColumnIndex).setValue((Object)bgPeriodInfo.getName());
                        row.getCell(periodColumnIndex).setUserObject((Object)bgPeriodInfo.getId().toString());
                        row.getCell(itemColumnIndex).setValue(itemMap.get(key));
                        row.getCell(itemColumnIndex).setUserObject((Object)key);
                    }
                    endIndex = this.tblMain.getRowCount();
                }
                endOneIndex = this.tblMain.getRowCount();
                this.tblMain.getMergeManager().mergeBlock(beginOneIndex, 0, endOneIndex, 0);
            }
        } else {
            for (int i = 0; i < this.periodVec.size(); ++i) {
                beginIndex = this.tblMain.getRowCount();
                for (int j = 0; j < itemIdVec.size(); ++j) {
                    String key = (String)itemIdVec.get(j);
                    IRow row = this.tblMain.addRow();
                    BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.periodVec.get(i);
                    row.getCell(periodColumnIndex).setValue((Object)bgPeriodInfo.getName());
                    row.getCell(periodColumnIndex).setUserObject((Object)bgPeriodInfo.getId().toString());
                    row.getCell(itemColumnIndex).setValue(itemMap.get(key));
                    row.getCell(itemColumnIndex).setUserObject((Object)key);
                }
                endIndex = this.tblMain.getRowCount();
                this.tblMain.getMergeManager().mergeBlock(beginIndex, 0, endIndex, 0);
            }
        }
        this.tblMain.getGroupManager().group();
    }

    @Override
    protected void initListener() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent event) {
                if (BgRptMain2UI.this.tblMain.getRowCount() <= 0) {
                    return;
                }
                BgRptMain2UI.this.setActionState();
            }
        });
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 1) {
            NumberExpandInfo expandInfo;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            IRow row = this.getMainTable().getRow(rowIndex);
            if (colIndex == this.tblMain.getColumnIndex("BgOrgUnit") && row != null && row.getCell("BgOrgUnit").getValue() != null && row.getCell("BgOrgUnit").getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)row.getCell("BgOrgUnit").getValue()) != null && this.render != null && this.render.inRect(expandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, expandInfo, false);
            }
            if (colIndex == this.tblMain.getColumnIndex("BgItem") && row != null && row.getCell(2).getValue() != null && row.getCell(2).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)row.getCell(2).getValue()) != null && this.render4Item.inRect(expandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, expandInfo, true);
            }
            if (colIndex == 1 && row != null && row.getCell(1).getValue() != null && row.getCell(1).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)row.getCell(1).getValue()) != null && this.render4Item.inRect(expandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, expandInfo, true);
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo numberExpandInfo, boolean isBgItem) {
        if (!numberExpandInfo.isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, numberExpandInfo, isBgItem);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    void registRender() {
        IColumn col = null;
        if (this.isSumDisp) {
            col = this.getMainTable().getColumn(this.tblMain.getColumnIndex("BgOrgUnit"));
            if (col != null) {
                this.render = new FlexRender();
                col.setRenderer((IBasicRender)this.render);
                col.getStyleAttributes().setLocked(true);
            }
            if ((col = this.getMainTable().getColumn(this.tblMain.getColumnIndex("BgItem"))) != null) {
                this.render4Item = new FlexRender();
                col.setRenderer((IBasicRender)this.render4Item);
                col.getStyleAttributes().setLocked(true);
            }
        } else {
            col = this.getMainTable().getColumn(this.tblMain.getColumnIndex("BgItem"));
            if (col != null) {
                this.render4Item = new FlexRender();
                col.setRenderer((IBasicRender)this.render4Item);
                col.getStyleAttributes().setLocked(true);
            }
        }
    }

    protected void expandTable(IRow row, NumberExpandInfo numberExpandInfo, boolean isBgItem) {
        if (row == null || numberExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String bgLongNumber = numberExpandInfo.getLongNumber();
        boolean isExpandStatus = numberExpandInfo.isExpandStatus();
        if (!isBgItem) {
            if (isExpandStatus) {
                numberExpandInfo.setExpandStatus(false);
                numberExpandInfo.setVisible(false);
                int rowCount = this.tblMain.getRowCount();
                for (int rowIndex = row.getRowIndex() + this.flexRowCount + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                    child.getStyleAttributes().setHided(true);
                    expandInfo.setVisible(false);
                }
            } else {
                numberExpandInfo.setExpandStatus(true);
                numberExpandInfo.setVisible(true);
                int rowCount = this.tblMain.getRowCount();
                for (int rowIndex = row.getRowIndex() + this.flexRowCount; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                    child.getStyleAttributes().setHided(false);
                    expandInfo.setVisible(true);
                    if (child.getCell(2).getValue() != null && child.getCell(2).getValue() instanceof NumberExpandInfo && !((NumberExpandInfo)child.getCell(2).getValue()).getVisible()) {
                        child.getStyleAttributes().setHided(true);
                    }
                    if (expandInfo.isLeaf()) continue;
                    this.expandChild(child, expandInfo);
                }
            }
        } else if (isExpandStatus) {
            numberExpandInfo.setExpandStatus(false);
            numberExpandInfo.setVisible(false);
            int rowCount = this.getMainTable().getRowCount();
            for (int rowIndex = row.getRowIndex(); rowIndex < rowCount; ++rowIndex) {
                child = this.getMainTable().getRow(rowIndex);
                expandInfo = this.isSumDisp ? (NumberExpandInfo)child.getCell(2).getValue() : (NumberExpandInfo)child.getCell(1).getValue();
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(bgLongNumber)) {
                    if (!longNumber.equals(bgLongNumber)) {
                        child.getStyleAttributes().setHided(true);
                        expandInfo.setVisible(false);
                        continue;
                    }
                    expandInfo.setVisible(true);
                    continue;
                }
                break;
            }
        } else {
            numberExpandInfo.setExpandStatus(true);
            numberExpandInfo.setVisible(true);
            int rowCount = this.getMainTable().getRowCount();
            for (int rowIndex = row.getRowIndex(); rowIndex < rowCount; ++rowIndex) {
                child = this.getMainTable().getRow(rowIndex);
                expandInfo = this.isSumDisp ? (NumberExpandInfo)child.getCell(2).getValue() : (NumberExpandInfo)child.getCell(1).getValue();
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(bgLongNumber)) {
                    child.getStyleAttributes().setHided(false);
                    expandInfo.setVisible(true);
                    continue;
                }
                break;
            }
        }
    }

    protected int expandChild(IRow row, NumberExpandInfo parentExpandInfo) {
        int rowIndex;
        IRow child = null;
        int endIndex = rowIndex = row.getRowIndex() + 1;
        int rowCount = this.tblMain.getRowCount();
        String number = null;
        NumberExpandInfo childExpandInfo = null;
        String parentNumber = parentExpandInfo.getLongNumber();
        parentExpandInfo.setExpandStatus(true);
        for (int i = rowIndex; i < rowCount; ++i) {
            child = this.tblMain.getRow(i);
            if (child != null) {
                childExpandInfo = (NumberExpandInfo)child.getCell(0).getValue();
                number = childExpandInfo.getLongNumber();
                if (!number.startsWith(parentNumber)) break;
                if (!childExpandInfo.isLeaf()) {
                    i = this.expandChild(child, childExpandInfo);
                }
            }
            ++endIndex;
        }
        return endIndex;
    }

    @Override
    protected void showTable(int index) {
        if (index == -1) {
            return;
        }
        KDPanel panel = (KDPanel)this.paneMain.getComponentAt(index);
        this.tblMain.setBounds(new Rectangle(8, 51, 990, 512));
        panel.add((Component)this.tblMain, null);
        this.contBgForm.setBounds(new Rectangle(11, 13, 270, 19));
        panel.add((Component)this.contBgForm, null);
        this.contCurrency.setBounds(new Rectangle(362, 13, 270, 19));
        panel.add((Component)this.contCurrency, null);
        this.contBgForm.setBoundEditor((JComponent)this.txtBgForm);
        this.contCurrency.setBoundEditor((JComponent)this.txtCurrency);
        BorderLayout layOut = new BorderLayout(0, 0);
        panel.setLayout((LayoutManager)layOut);
        KDPanel panl = (KDPanel)this.paneMain.getSelectedComponent();
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(8, 51, 1000, 530);
        cons.anchor = 449;
        this.tblMain.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        panl.add((Component)this.tblMain, null);
        panl.setLayout((LayoutManager)new KDLayout());
        panl.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 1016, 600));
    }

    @Override
    protected void setBgBaseMap(String bgTemId) {
        if (bgTemId != null) {
            try {
                IBgRptFacade iBgRpt = BgRptFacadeFactory.getRemoteInstance();
                this.bgBaseMap = iBgRpt.getBgBaseMap(bgTemId);
                this.flexRowCount = 1;
                this.flexRowCount = this.periodVec != null && this.periodVec.size() > 0 ? ((Map)this.bgBaseMap.get("BGITEMCOMBINE")).size() * this.periodVec.size() : ((Map)this.bgBaseMap.get("BGITEMCOMBINE")).size();
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    @Override
    protected void addPanel(KDTabbedPane kdTabbed, Vector orgUnitVec) throws Exception {
        for (int i = 0; i < orgUnitVec.size(); ++i) {
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)orgUnitVec.get(i);
            String key = orgUnitInfo.getId().toString();
            if (i == 0) {
                this.paneMain.setTitleAt(0, orgUnitInfo.getName());
                continue;
            }
            this.paneMain.addTab(orgUnitInfo.getName(), (Component)this.createPanel());
        }
    }

    private KDPanel createPanel() {
        KDPanel kdPanel = new KDPanel();
        return kdPanel;
    }

    @Override
    protected FullOrgUnitCollection getOrgUnitCollById(String[] orgUnitIds) throws Exception {
        IFullOrgUnit iCompany = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set companyIdSet = BgHelper.tranArray2Set(orgUnitIds);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent.name"));
        selector.add(new SelectorItemInfo("parent.number"));
        selector.add(new SelectorItemInfo("isCU"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortItemInfo = new SorterItemInfo("longNumber");
        sortItemInfo.setSortType(SortType.ASCEND);
        sorter.add(sortItemInfo);
        viewInfo.getSorter().addObjectCollection((IObjectCollection)sorter);
        FullOrgUnitCollection companyColl = iCompany.getFullOrgUnitCollection(viewInfo);
        return companyColl;
    }

    private void getFilterParam(BgRptFilterParam filterParam) throws Exception {
        this.companyVec = null;
        IFullOrgUnit iCompany = FullOrgUnitFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set companyIdSet = BgHelper.tranArray2Set(filterParam.getOrgUnitIds());
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent.name"));
        selector.add(new SelectorItemInfo("parent.number"));
        selector.add(new SelectorItemInfo("isCU"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortItemInfo = new SorterItemInfo("longNumber");
        sortItemInfo.setSortType(SortType.ASCEND);
        sorter.add(sortItemInfo);
        viewInfo.getSorter().addObjectCollection((IObjectCollection)sorter);
        FullOrgUnitCollection companyColl = iCompany.getFullOrgUnitCollection(viewInfo);
        this.companyVec = BgHelper.tranColl2Vec((IObjectCollection)companyColl);
        if (filterParam.isIsSum()) {
            this.companyMap = BgHelper.tranColl2Map((IObjectCollection)companyColl, new String[]{"id"});
            this.parentCompanySet = new HashSet();
            FullOrgUnitInfo orgUnitInfo = null;
            String parentCompanyId = null;
            for (int i = 0; i < companyColl.size(); ++i) {
                orgUnitInfo = companyColl.get(i);
                if (orgUnitInfo.getParent() == null || (parentCompanyId = orgUnitInfo.getParent().getId().toString()) == null || !companyIdSet.contains(parentCompanyId)) continue;
                this.parentCompanySet.add(parentCompanyId);
            }
        }
    }

    @Override
    protected Vector getBgPeriodVec(String beginPeriodId, String endPeriodId) throws Exception {
        Vector periodVec = BgHelper.tranColl2Vec((IObjectCollection)this.getBgPeriodColl(beginPeriodId, endPeriodId));
        return periodVec;
    }

    @Override
    protected BgPeriodCollection getBgPeriodColl(String beginPeriodId, String endPeriodId) throws Exception {
        BOSUuid sId = BOSUuid.read((String)beginPeriodId);
        BOSUuid eId = BOSUuid.read((String)endPeriodId);
        return this.getBgPeriodColl(sId, eId);
    }

    @Override
    protected BgPeriodCollection getBgPeriodColl(BOSUuid beginUuid, BOSUuid endUuid) throws Exception {
        IBgPeriod iBgP = BgPeriodFactory.getRemoteInstance();
        BgPeriodCollection bgPeiodColl = iBgP.getPeriodCollection(beginUuid, endUuid);
        return bgPeiodColl;
    }

    @Override
    protected BgPeriodCollection getAccumPeriodColl(int bgPeriodType, Date beginDate, Date endDate) throws Exception {
        return BgHelper.getBgPeriodCollection(bgPeriodType, beginDate, endDate);
    }

    @Override
    protected Set getAccumPeriodIdSet(int bgPeriodType, Date beginDate, Date endDate) throws Exception {
        HashSet<String> accumPeriodIdSet = new HashSet<String>();
        BgPeriodCollection bgPeriodColl = this.getAccumPeriodColl(bgPeriodType, BgHelper.getDayBegin(beginDate), BgHelper.getDayEnd(endDate));
        if (bgPeriodColl != null && bgPeriodColl.size() > 0) {
            for (int i = 0; i < bgPeriodColl.size(); ++i) {
                BgPeriodInfo bgPeriodInfo = bgPeriodColl.get(i);
                accumPeriodIdSet.add(bgPeriodInfo.getId().toString());
            }
        }
        return accumPeriodIdSet;
    }

    @Override
    protected List getAccumPeriodIdList(int bgPeriodType, Date beginDate, Date endDate) throws Exception {
        ArrayList<String> periodIdList = new ArrayList<String>();
        BgPeriodCollection bgPeriodColl = this.getAccumPeriodColl(bgPeriodType, BgHelper.getDayBegin(beginDate), BgHelper.getDayEnd(endDate));
        if (bgPeriodColl != null && bgPeriodColl.size() > 0) {
            for (int i = 0; i < bgPeriodColl.size(); ++i) {
                BgPeriodInfo bgPeriodInfo = bgPeriodColl.get(i);
                periodIdList.add(bgPeriodInfo.getId().toString());
            }
        }
        return periodIdList;
    }

    @Override
    protected BgSchemeInfo getBgScheme(String bgSchemeId) throws Exception {
        if (bgSchemeId == null) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("dateFrom"));
        selector.add(new SelectorItemInfo("dateTo"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("isFormal"));
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), selector);
        return bgSchemeInfo;
    }

    @Override
    protected BgTemplateInfo getBgTemplate(String bgTemplateId) throws Exception {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        IBgTemplate iBgTemplate = BgTemplateFactory.getRemoteInstance();
        BgTemplateInfo bgTemplateInfo = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemplateId), selector);
        return bgTemplateInfo;
    }

    @Override
    protected BigDecimal getBgBalance(BigDecimal bgValue, BigDecimal bizActual) {
        if (bgValue != null && bizActual != null) {
            return bgValue.subtract(bizActual);
        }
        if (bgValue == null && bizActual != null) {
            return bizActual.negate();
        }
        if (bgValue != null && bizActual == null) {
            return bgValue;
        }
        return null;
    }

    @Override
    protected BigDecimal getUsableBgBalance(BigDecimal bgValue, BigDecimal bizActual) {
        BigDecimal usableBgBalance = this.getBgBalance(bgValue, bizActual);
        return this.getUsableBgBalance(usableBgBalance);
    }

    @Override
    protected BigDecimal getUsableBgBalance(BigDecimal bgBalance) {
        if (bgBalance != null && bgBalance.signum() > 0) {
            return bgBalance;
        }
        if (bgBalance != null && bgBalance.signum() <= 0) {
            return BgConstants.BIGZERO;
        }
        return null;
    }

    @Override
    protected BigDecimal getBgDiffRate(BigDecimal bgDiffVal, BigDecimal bgVal) {
        if (bgDiffVal == null || bgVal == null) {
            return null;
        }
        if (bgVal.compareTo(BgConstants.BIGZERO) == 0) {
            return BgConstants.BIGZERO;
        }
        return bgDiffVal.divide(bgVal, 4, 6);
    }

    @Override
    protected Object sumTwoObject(Object firstObj, Object secondObj) {
        if (firstObj == null && secondObj != null) {
            return secondObj;
        }
        if (firstObj != null && secondObj == null) {
            return firstObj;
        }
        if (firstObj != null && secondObj != null) {
            return this.sumTwoBigDecimal((BigDecimal)firstObj, (BigDecimal)secondObj);
        }
        return null;
    }

    @Override
    protected BigDecimal sumTwoBigDecimal(BigDecimal firstBigVal, BigDecimal secondBigVal) {
        if (firstBigVal == null && secondBigVal != null) {
            return secondBigVal;
        }
        if (firstBigVal != null && secondBigVal == null) {
            return firstBigVal;
        }
        if (firstBigVal != null && secondBigVal != null) {
            return firstBigVal.add(secondBigVal);
        }
        return null;
    }

    @Override
    protected String[] getBgPeriodIds(String beginPeriodId, String endPeriodId) throws BOSException, EASBizException {
        if (beginPeriodId == null || beginPeriodId.trim().length() == 0 || endPeriodId == null || endPeriodId.trim().length() == 0) {
            return new String[0];
        }
        BOSUuid sId = BOSUuid.read((String)beginPeriodId);
        BOSUuid eId = BOSUuid.read((String)endPeriodId);
        IBgPeriod iBgP = BgPeriodFactory.getRemoteInstance();
        BgPeriodCollection bgPeiodColl = iBgP.getPeriodCollection(sId, eId);
        String[] ids = new String[bgPeiodColl.size()];
        for (int i = 0; i < bgPeiodColl.size(); ++i) {
            ids[i] = bgPeiodColl.get(i).getId().toString();
        }
        return ids;
    }

    @Override
    protected boolean isExistAccumAnaly(String bgSchemeId, String beginPeriodId, String endPeriodId) throws Exception {
        BgSchemeInfo bgSchemeInfo = this.getBgScheme(bgSchemeId);
        if (bgSchemeInfo != null) {
            this.accumPeriodIdList = this.getAccumPeriodIdList(bgSchemeInfo.getPeriod().getValue(), bgSchemeInfo.getDateFrom(), bgSchemeInfo.getDateTo());
        }
        return true;
    }

    @Override
    public abstract BgFilterBaseUI getFilterUI() throws Exception;

    @Override
    protected void insertColumn(int i, String field) {
        IColumn column = this.tblMain.addColumn();
        column.setKey("Element" + i + field);
        this.tblMain.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"", (String)""));
    }

    @Override
    protected void paneMain_stateChanged(ChangeEvent e) throws Exception {
        super.paneMain_stateChanged(e);
    }

    @Override
    protected KDTable getMainTable() {
        return this.tblMain;
    }

    @Override
    protected void initTableHead_bak() {
        int curIndex;
        this.tblMain.addHeadRow(0);
        this.tblMain.addHeadRow(1);
        this.tblMain.addHeadRow(2);
        int mergeIndex = curIndex = this.tblMain.getColumnCount();
        IColumn column0 = this.tblMain.addColumn(curIndex++);
        column0.setKey("BgPeriod");
        this.tblMain.getHeadRow(0).getCell(column0.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"306_BgRptMain2UI"));
        this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 2, this.tblMain.getColumnCount() - 1);
        mergeIndex = this.tblMain.getColumnCount();
        IColumn column1 = this.tblMain.addColumn(curIndex++);
        column1.setKey("BgItem");
        this.tblMain.getHeadRow(0).getCell(column1.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"209_BgDataExamineViewUI"));
        this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 2, this.tblMain.getColumnCount() - 1);
        IColumn column = null;
        mergeIndex = this.tblMain.getColumnCount();
        column = this.tblMain.addColumn(curIndex++);
        column.setKey("Analy_CurrentPeriodBg");
        this.tblMain.getHeadRow(2).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"307_BgRptMain2UI"));
        this.tblMain.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"308_BgRptMain2UI"));
        this.tblMain.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"309_BgRptMain2UI"));
        column = this.tblMain.addColumn(curIndex++);
        column.setKey("Analy_CurrentPeriodActual");
        this.tblMain.getHeadRow(2).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"310_BgRptMain2UI"));
        this.tblMain.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"308_BgRptMain2UI"));
        this.tblMain.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"309_BgRptMain2UI"));
        this.tblMain.getHeadMergeManager().mergeBlock(1, mergeIndex, 1, this.tblMain.getColumnCount() - 1);
        this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 0, this.tblMain.getColumnCount() - 1);
        mergeIndex = this.tblMain.getColumnCount();
        column = this.tblMain.addColumn(curIndex++);
        column.setKey("Analy_AccumBg");
        this.tblMain.getHeadRow(2).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"311_BgRptMain2UI"));
        this.tblMain.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"308_BgRptMain2UI"));
        this.tblMain.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"312_BgRptMain2UI"));
        column = this.tblMain.addColumn(curIndex++);
        column.setKey("Analy_AccumActual");
        this.tblMain.getHeadRow(2).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"313_BgRptMain2UI"));
        this.tblMain.getHeadRow(1).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"308_BgRptMain2UI"));
        this.tblMain.getHeadRow(0).getCell(column.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"312_BgRptMain2UI"));
        this.tblMain.getHeadMergeManager().mergeBlock(1, mergeIndex, 1, this.tblMain.getColumnCount() - 1);
        this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 0, this.tblMain.getColumnCount() - 1);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    @Override
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    @Override
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void setRptFilterParam(BgRptFilterParam param) {
        this.rptFilterParam = param;
    }

    public FilterParam getRptFilterParam() {
        return this.rptFilterParam;
    }

    class NumberExpandInfo {
        private String id;
        private String name;
        private String number;
        private String longNumber;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;
        private boolean isVisible = true;

        NumberExpandInfo() {
        }

        public boolean getVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.name;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }
    }

    protected class FlexRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        protected FlexRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - ident - this.ICONSIZE, rect.height), numberExpandInfo.toString(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }
}

