/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.AbstractBgSchemeF7UI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class BgSchemeF7UI
extends AbstractBgSchemeF7UI {
    private static final long serialVersionUID = 1184314724848094248L;
    private static final Logger logger = CoreUIObject.getLogger(BgSchemeF7UI.class);
    private boolean isCancel = true;
    private BgSchemeInfo result = null;
    private final String NUMBER = "number";
    private final String NAME = "name";
    private final String ISFORMAL = "isFormal";
    private final String PERIOD = "period";
    private final String ORGUNIT = "orgUnit.name";

    public BgSchemeF7UI() throws Exception {
        this.initKDtable();
    }

    public void initKDtable() {
        this.kdTable.removeHeadRows();
        this.kdTable.removeRows();
        this.kdTable.removeColumns();
        this.kdTable.checkParsed();
        this.kdTable.getStyleAttributes().setLocked(true);
        this.kdTable.getSelectManager().setSelectMode(2);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String strOrgNumber = (String)this.getUIContext().get("orgNumber");
        this.putDataToKDTable(strOrgNumber);
    }

    public void putDataToKDTable(String strOrgNumber) throws EASBizException {
        try {
            IBgScheme iBgS = BgSchemeFactory.getRemoteInstance();
            String sql = "";
            BgSchemeCollection bgSchemeCol = null;
            if (StringUtils.isEmpty((String)strOrgNumber)) {
                sql = "select id, number, name, isFormal, period, orgUnit.name order by number ";
                bgSchemeCol = iBgS.getBgSchemeCollection(sql);
            } else if (strOrgNumber.indexOf(";") == -1) {
                sql = "select id, number, name, isFormal, period, orgUnit.name where orgUnit.number='" + strOrgNumber + "' order by number ";
                bgSchemeCol = iBgS.getBgSchemeCollection(sql);
            } else {
                bgSchemeCol = iBgS.getSameSchemeByOrgNumbers(strOrgNumber.split(";"));
            }
            if (bgSchemeCol != null && bgSchemeCol.size() > 0) {
                IRow row = null;
                this.kdTable.removeRows();
                for (int i = 0; i < bgSchemeCol.size(); ++i) {
                    BgSchemeInfo bgSchemeInfo = bgSchemeCol.get(i);
                    row = this.kdTable.addRow();
                    row.setUserObject((Object)bgSchemeInfo);
                    row.getCell("number").setValue((Object)bgSchemeInfo.getNumber());
                    row.getCell("name").setValue((Object)bgSchemeInfo.getName());
                    row.getCell("isFormal").setValue((Object)new Boolean(bgSchemeInfo.isIsFormal()));
                    row.getCell("period").setValue((Object)bgSchemeInfo.getPeriod());
                    row.getCell("orgUnit.name").setValue((Object)bgSchemeInfo.getOrgUnit().getName());
                }
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void kdTable_tableClicked(KDTMouseEvent e) throws Exception {
        super.kdTable_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnOK();
        }
    }

    private void onBtnOK() throws BOSException, EASBizException {
        KDTSelectBlock selectBlock = this.kdTable.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int currRow = this.kdTable.getSelectManager().getActiveRowIndex();
        IRow iRow = this.kdTable.getRow(currRow);
        this.result = (BgSchemeInfo)iRow.getUserObject();
        this.isCancel = false;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public BgSchemeInfo getResult() {
        return this.result;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        int currRow = this.kdTable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdTable.getRow(currRow);
            this.result = (BgSchemeInfo)iRow.getUserObject();
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }
}

