/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.client.AbstractBgSubOrgUnitSelectUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgSubOrgUnitSelectUI
extends AbstractBgSubOrgUnitSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(BgSubOrgUnitSelectUI.class);
    private boolean isOk = false;
    private ArrayList returnValue = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeViewOrgUnit.setShowButton(false);
        this.setIcons();
        this.initComBoxOrgType();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setShowCheckBox(true);
        this.refreshOrgUnitTree();
    }

    private void setIcons() {
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        root.setChecked(false);
        root.syncChecked();
        this.treeOrgUnit.repaint();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        root.setChecked(true);
        root.syncChecked();
        this.treeOrgUnit.repaint();
        root.setChecked(false);
    }

    private void initComBoxOrgType() {
        this.comBoxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setEditable(false);
        this.comBoxOrgType.setEnabled(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comBoxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        TreeModel treeModel = null;
        try {
            String rootUnitID = (String)this.getUIContext().get("CUID");
            treeModel = BgNFSHelper.getOrgTreeModel((String)rootUnitID, (KDTree)this.treeOrgUnit);
            this.treeOrgUnit.setModel(treeModel);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
        if (this.treeOrgUnit.getModel() != null) {
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)this.treeOrgUnit.getModel().getRoot());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.returnValue = null;
        this.getUIWindow().close();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        int j;
        super.btnConfirm_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        } else {
            this.returnValue.clear();
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.traceNode(root, this.returnValue);
        OrgUnitCollection orgUnitCollectionSub = (OrgUnitCollection)this.getUIContext().get("EditOrg");
        OrgUnitCollection notChild = new OrgUnitCollection();
        String warning = "";
        Hashtable<BOSUuid, BOSUuid> orgSub = new Hashtable<BOSUuid, BOSUuid>();
        for (j = 0; j < orgUnitCollectionSub.size(); ++j) {
            OrgUnitInfo subOrgInfo = orgUnitCollectionSub.get(j);
            orgSub.put(subOrgInfo.getId(), subOrgInfo.getId());
        }
        for (int i = 0; i < this.returnValue.size(); ++i) {
            OrgUnitInfo orgInfo = (OrgUnitInfo)this.returnValue.get(i);
            if (orgSub.containsKey(orgInfo.getId())) continue;
            this.returnValue.remove(i);
            notChild.add(orgInfo);
        }
        if (!notChild.isEmpty()) {
            for (j = 0; j < notChild.size(); ++j) {
                OrgUnitInfo info = notChild.get(j);
                warning = warning + " " + info.getName();
            }
            MsgBox.showWarning((Component)((Object)this), (String)(warning + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NotSubOrgs")));
        }
        if (this.returnValue.size() == 0) {
            return;
        }
        this.isOk = true;
        this.getUIWindow().close();
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (root.isChecked()) {
            OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            list.add(info);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public ArrayList getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(ArrayList returnValue) {
        this.returnValue = returnValue;
    }
}

