/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.AbstractBgSubOrgUnitSelectUIForActual;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgSubOrgUnitSelectUIForForm;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.SheetInfo;
import com.kingdee.eas.ma.nbudget.client.BgFormSheetDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class BgSubOrgUnitSelectUIForActual
extends AbstractBgSubOrgUnitSelectUIForActual
implements AssignSolutionInterface {
    public static final String DIRECT = "direct";
    public static final String INDIRECT = "inDirect";
    private static final Logger logger = CoreUIObject.getLogger(BgSubOrgUnitSelectUIForForm.class);
    protected Vector orgUnits = null;
    private boolean isOk = false;
    private ArrayList returnValue = null;
    private String selectType = "inDirect";
    private Object ui = null;
    private Map returnData = null;
    private IBgForm ibgForm = null;
    private SheetInfo[] sheet = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.treeViewOrgUnit.setShowButton(false);
        this.ui = this.getUIContext().get("Owner");
        this.setIcons();
        this.initComBoxOrgType();
        this.treeOrgUnit.setModel(null);
        this.treeOrgUnit.setShowCheckBox(true);
        this.refreshOrgUnitTree();
        this.initTable();
        this.GatherParameter.add((AbstractButton)this.raGatherFormula);
        this.initSheetName();
        this.initSheetSelector();
    }

    public String getSelectType() {
        return this.selectType;
    }

    public void setSelectType(String selectType) {
        this.selectType = selectType;
    }

    public void initTable() {
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(2);
        OrgUnitCollection orgUnitCollectionSub = (OrgUnitCollection)this.getUIContext().get("EditOrg");
        for (int i = 0; i < orgUnitCollectionSub.size(); ++i) {
            IRow row = this.table.addRow();
            row.setUserObject((Object)orgUnitCollectionSub.get(i));
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("select").getStyleAttributes().setLocked(false);
            row.getCell("number").setValue((Object)orgUnitCollectionSub.get(i).getNumber());
            row.getCell("number").getStyleAttributes().setLocked(true);
            row.getCell("name").setValue((Object)orgUnitCollectionSub.get(i).getName());
            row.getCell("name").getStyleAttributes().setLocked(true);
        }
    }

    private void setIcons() {
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    private void initComBoxOrgType() {
        this.comBoxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setEditable(false);
        this.comBoxOrgType.setEnabled(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comBoxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        TreeModel treeModel = null;
        try {
            String rootUnitID = (String)this.getUIContext().get("CUID");
            treeModel = BgNFSHelper.getOrgTreeModel((String)rootUnitID, (KDTree)this.treeOrgUnit);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
            root.setCheckBoxVisible(false);
            this.treeOrgUnit.setModel(treeModel);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
        if (this.treeOrgUnit.getModel() != null) {
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)this.treeOrgUnit.getModel().getRoot());
        }
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        if (this.returnValue == null) {
            this.returnValue = new ArrayList();
        } else {
            this.returnValue.clear();
        }
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.traceNode(root, this.returnValue);
        } else if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                if (!((Boolean)this.table.getRow(i).getCell("select").getValue()).booleanValue()) continue;
                this.returnValue.add(this.table.getRow(i).getUserObject());
            }
        }
        if (this.returnValue.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"pleaseSelectOrg"));
            SysUtil.abort();
        }
        this.returnData = new HashMap();
        this.returnData.put("returnValue", this.returnValue);
        this.sheet = this.raAllSheet.isSelected() ? null : (SheetInfo[])this.prmtSheet.getData();
        this.returnData.put("sheet", this.sheet);
        if (this.chkShowOrg.isSelected()) {
            this.returnData.put("isShowOrg", Boolean.TRUE);
        } else {
            this.returnData.put("isShowOrg", Boolean.FALSE);
        }
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        if (root.isChecked()) {
            OrgStructureInfo oui = (OrgStructureInfo)root.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            list.add(info);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            this.traceNode(node, list);
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.returnValue = null;
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            root.setChecked(true);
            root.syncChecked();
            this.treeOrgUnit.repaint();
            root.setChecked(false);
        } else if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
            }
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.raIndirect.isSelected()) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            root.setChecked(false);
            root.syncChecked();
            this.treeOrgUnit.repaint();
        } else if (this.raDirect.isSelected()) {
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                this.table.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
            }
        }
    }

    @Override
    protected void raDirect_actionPerformed(ActionEvent e) throws Exception {
        super.raDirect_actionPerformed(e);
        this.selectType = DIRECT;
        this.table.setVisible(true);
        this.treeViewOrgUnit.setVisible(false);
    }

    @Override
    protected void raIndirect_actionPerformed(ActionEvent e) throws Exception {
        super.raIndirect_actionPerformed(e);
        this.selectType = INDIRECT;
        this.table.setVisible(false);
        this.treeViewOrgUnit.setVisible(true);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public ArrayList getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(ArrayList returnValue) {
        this.returnValue = returnValue;
    }

    @Override
    public void clear() throws Exception {
    }

    @Override
    public Object saveSolution() throws Exception {
        HashMap<String, Serializable> saveData = new HashMap<String, Serializable>();
        saveData.put("raDirect", new Boolean(this.raDirect.isSelected()));
        this.orgUnits = null;
        if (this.raDirect.isSelected()) {
            this.setTableOrgs();
        } else {
            this.setOrgs();
        }
        saveData.put("orgUnits", this.orgUnits);
        return saveData;
    }

    private void setTableOrgs() {
        this.orgUnits = new Vector();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (!((Boolean)this.table.getRow(i).getCell("select").getValue()).booleanValue()) continue;
            this.orgUnits.add((FullOrgUnitInfo)this.table.getRow(i).getUserObject());
        }
    }

    private void setOrgs() {
        this.orgUnits = new Vector();
        try {
            this.orgs((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"errorData"));
            SysUtil.abort();
        }
    }

    private void orgs(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        this.orgUnits.add(((OrgStructureInfo)root.getUserObject()).getUnit());
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            osi = (OrgStructureInfo)node.getUserObject();
            orgUnitInfo = osi.getUnit();
            if (node.isChecked()) {
                this.orgUnits.add(orgUnitInfo);
            }
            this.checkTraceNode(node);
        }
    }

    private void checkTraceNode(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                this.orgUnits.add(orgUnitInfo);
            }
            this.checkTraceNode(node);
        }
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        HashMap loadData;
        if (o instanceof Map && (loadData = (HashMap)o) != null && loadData.size() > 0 && !this.loadDataToUI(loadData)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"317_BgSubOrgUnitSelectUIForActual"));
        }
    }

    private boolean loadDataToUI(Map loadData) throws Exception {
        if (((Boolean)loadData.get("raDirect")).booleanValue()) {
            this.raDirect.setSelected(true);
            this.raIndirect.setSelected(false);
            this.inputOrgUnitToTable((Vector)loadData.get("orgUnits"));
            this.raDirect_actionPerformed(null);
        } else {
            this.raDirect.setSelected(false);
            this.raIndirect.setSelected(true);
            this.inputOrgUnitToTree((Vector)loadData.get("orgUnits"));
            this.raIndirect_actionPerformed(null);
        }
        this.treeOrgUnit.requestFocus();
        return true;
    }

    private void inputOrgUnitToTable(Vector vector) {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            if (vector.contains((FullOrgUnitInfo)this.table.getRow(i).getUserObject())) {
                this.table.getRow(i).getCell("select").setValue((Object)new Boolean(true));
                continue;
            }
            this.table.getRow(i).getCell("select").setValue((Object)new Boolean(false));
        }
    }

    private void inputOrgUnitToTree(Vector orgUnit) {
        ((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot()).setChecked(true);
        this.inputOrgUnitTraceNode((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot(), orgUnit);
        this.treeOrgUnit.requestFocus();
    }

    private void inputOrgUnitTraceNode(DefaultKingdeeTreeNode root, Vector orgUnit) {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            osi = (OrgStructureInfo)node.getUserObject();
            orgUnitInfo = osi.getUnit();
            if (orgUnit != null && orgUnit.contains(orgUnitInfo)) {
                node.setChecked(true);
            } else {
                node.setChecked(false);
            }
            this.inputOrgUnitTraceNode(node, orgUnit);
        }
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    private void initSheetName() throws Exception {
        Object obj = this.getUIContext().get("BGFORM_ID");
        if (obj != null && obj instanceof String) {
            String bgFormId = obj.toString();
            BgFormSheetDialog bgFormSheetDialog = new BgFormSheetDialog((IUIObject)this);
            bgFormSheetDialog.setBgFormId(bgFormId);
            bgFormSheetDialog.setBgFormName((String)this.getUIContext().get("BGFORM_NAME"));
            this.prmtSheet.setSelector((KDPromptSelector)bgFormSheetDialog);
            String[] sheetStr = null;
            SheetInfo sheetInfo = null;
            List sheets = this.getInterface().getSheetName(bgFormId);
            if (sheets != null && !sheets.isEmpty()) {
                sheetStr = (String[])sheets.get(0);
                sheetInfo = new SheetInfo();
                sheetInfo.setBgFormId(bgFormId);
                sheetInfo.setSheetId(sheetStr[0]);
                sheetInfo.setSheetName(sheetStr[1]);
                this.prmtSheet.setData((Object)new SheetInfo[]{sheetInfo});
            }
        }
    }

    protected IBgForm getInterface() throws Exception {
        if (this.ibgForm == null) {
            this.ibgForm = BgFormFactory.getRemoteInstance();
        }
        return this.ibgForm;
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiName='" + BgSubOrgUnitSelectUIForActual.class.getName() + "' ");
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.btnConfirm_actionPerformed(null);
        return true;
    }

    @Override
    public boolean cancel() throws Exception {
        this.btnCancel_actionPerformed(null);
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return this.returnData;
    }

    public void setConfermLabel(String confermLabel) {
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        return null;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    @Override
    protected void raAllSheet_actionPerformed(ActionEvent e) throws Exception {
        super.raAllSheet_actionPerformed(e);
        this.initSheetSelector();
    }

    @Override
    protected void raSelectSheet_actionPerformed(ActionEvent e) throws Exception {
        super.raSelectSheet_actionPerformed(e);
        this.initSheetSelector();
    }

    private void initSheetSelector() {
        if (this.raAllSheet.isSelected()) {
            this.prmtSheet.setEnabled(false);
        } else {
            this.prmtSheet.setEnabled(true);
        }
    }

    public SheetInfo[] getSheet() {
        return this.sheet;
    }

    public void setSheet(SheetInfo[] sheet) {
        this.sheet = sheet;
    }
}

