/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeFacadeFactory;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgSchemeFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgSubmitBySchemeUI;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgSubmitBySchemeReportUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.client.BgNCWfHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgSubmitBySchemeUI
extends AbstractBgSubmitBySchemeUI {
    private static final long serialVersionUID = -2031384226368538150L;
    private static final Logger logger = CoreUIObject.getLogger(BgSubmitBySchemeUI.class);
    private static final String SCHEME_SUBMIT_RESOURCE_PATH = "com.kingdee.eas.ma.budget.client.BgSubmitBySchemeResource";
    private String bgformId = null;
    private FullOrgUnitInfo orgUnit = null;
    private BOSUuid[] bgFormSubmitIds = null;
    private LongTimeDialog dialog = null;
    private List billId = null;
    private List auditSuccess = null;
    private List auditDefeat = null;
    private List cantSubmit = null;
    private List errorState = null;
    private Map billIdMap = null;
    private String xNum = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadBgFormInfo();
        this.init();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void loadBgFormInfo() throws Exception {
        if (this.getUIContext().get("BGFORM_ID") == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"formNull"));
            SysUtil.abort();
        }
        String bgschemeid = null;
        String orgUnitId = null;
        String bgPeriodId = null;
        this.bgformId = (String)this.getUIContext().get("BGFORM_ID");
        try {
            String sql = " select fbgschemeid,forgunitid,fbgperiodid from t_bg_bgform where fid = '" + this.bgformId + "'";
            ISQLExecutor query = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = query.executeSQL();
            if (rs.next()) {
                bgschemeid = rs.getString(1);
                orgUnitId = rs.getString(2);
                bgPeriodId = rs.getString(3);
            }
            SQLUtils.cleanup((ResultSet)rs);
            IBgScheme ibgscheme = BgSchemeFactory.getRemoteInstance();
            BgSchemeInfo bgschemeinfo = ibgscheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgschemeid));
            IFullOrgUnit ifullorgunit = FullOrgUnitFactory.getRemoteInstance();
            this.orgUnit = ifullorgunit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
            IBgPeriod ibgperiod = BgPeriodFactory.getRemoteInstance();
            BgPeriodInfo bgPeriod = ibgperiod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodId));
            this.kdtOrgUnit.setText(this.orgUnit.getName());
            this.prmtScheme.setValue((Object)bgschemeinfo);
            this.prmtPeriod.setValue((Object)bgPeriod);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
    }

    protected void init() throws Exception {
        this.kdtOrgUnit.setEnabled(false);
        BgPeriodDialog beginF7 = new BgPeriodDialog((CoreUIObject)this);
        this.prmtPeriod.setSelector((KDPromptSelector)beginF7);
        this.initBgScheme();
    }

    private void initBgScheme() {
        EntityViewInfo view = null;
        FilterInfo filter = null;
        FullOrgUnitInfo orgInfo = this.orgUnit;
        if (orgInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isSubmitByScheme", (Object)new Integer(1)));
            view.setFilter(filter);
            this.prmtScheme.setEntityViewInfo(view);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        boolean re;
        super.actionConfirm_actionPerformed(e);
        BgSchemeInfo bgschemeinfo = (BgSchemeInfo)this.prmtScheme.getValue();
        String bgschemeId = bgschemeinfo.getId().toString();
        boolean result = this.checkSchemeCondition(bgschemeId);
        if (!result) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"formNoSubmitByScheme"));
            SysUtil.abort();
        }
        if (!(re = this.checkFormComplete())) {
            SysUtil.abort();
        }
        this.getUIWindow().hide();
        LongTimeDialog dialog = new LongTimeDialog((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgSubmitBySchemeUI.this.submitFormToWF();
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSchemeCondition(String id) throws Exception {
        boolean result = false;
        IRowSet rs = null;
        try {
            String sql = " select a.FIsSubmitByScheme from t_bg_bgscheme a where a.fid='" + id + "'";
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
            rs = iSql.executeSQL();
            if (rs.next()) {
                result = rs.getBoolean(1);
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return result;
    }

    private boolean checkFormComplete() throws Exception {
        block13: {
            List list = new ArrayList();
            BgFormInfo bgforminfo = this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(this.bgformId));
            String orgUnitId = bgforminfo.getOrgUnit().getId().toString();
            BgSchemeInfo bgschemeinfo = (BgSchemeInfo)this.prmtScheme.getValue();
            String bgschemeId = bgschemeinfo.getId().toString();
            String[] bpCollIds = null;
            Object obj = this.prmtPeriod.getValue();
            if (obj instanceof BgPeriodInfo) {
                bpCollIds = new String[]{((BgPeriodInfo)this.prmtPeriod.getValue()).getId().toString()};
            } else {
                BgPeriodDialog bgDialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
                BgPeriodCollection bgColl = bgDialog.getF7UI().getBgPeriodColl();
                int bgSize = bgColl.size();
                bpCollIds = new String[bgSize];
                for (int i = 0; i < bgSize; ++i) {
                    bpCollIds[i] = bgColl.get(i).getId().toString();
                }
            }
            IBgSchemeFacade ibgschemefacade = BgSchemeFacadeFactory.getRemoteInstance();
            list = ibgschemefacade.getErrorList(orgUnitId, bgschemeId, bpCollIds);
            if (list.size() <= 0) break block13;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"formSubmitBySchemeError"));
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            String str = "";
            if (obj instanceof BgPeriodInfo) {
                str = ((BgPeriodInfo)obj).getName();
            } else {
                BgPeriodDialog bgDialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
                BgPeriodCollection bgColl = bgDialog.getF7UI().getBgPeriodColl();
                for (int i = 0; i < bgColl.size(); ++i) {
                    str = str + bgColl.get(i).getName() + ",";
                }
                str = str.substring(0, str.length() - 1);
            }
            ctx.put("Owner", (Object)this);
            ctx.put("errorList", list);
            ctx.put("bgSchemeName", bgschemeinfo.getName());
            ctx.put("bgPeriodName", str);
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow reportUi = uiFactory.create(BgSubmitBySchemeReportUI.class.getName(), ctx);
                reportUi.show();
                boolean bl = false;
                return bl;
            }
            catch (UIException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    throw ex;
                }
            }
        }
        return true;
    }

    private void submitFormToWF() throws Exception {
        int i;
        List list = new ArrayList();
        try {
            BgFormInfo bgforminfo = this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(this.bgformId));
            String orgUnitId = bgforminfo.getOrgUnit().getId().toString();
            BgSchemeInfo bgschemeinfo = (BgSchemeInfo)this.prmtScheme.getValue();
            String bgschemeId = bgschemeinfo.getId().toString();
            String[] bpCollIds = null;
            Object obj = this.prmtPeriod.getValue();
            if (obj instanceof BgPeriodInfo) {
                bpCollIds = new String[]{((BgPeriodInfo)this.prmtPeriod.getValue()).getId().toString()};
            } else {
                BgPeriodDialog bgDialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
                BgPeriodCollection bgColl = bgDialog.getF7UI().getBgPeriodColl();
                int bgSize = bgColl.size();
                bpCollIds = new String[bgSize];
                for (int i2 = 0; i2 < bgSize; ++i2) {
                    bpCollIds[i2] = bgColl.get(i2).getId().toString();
                }
            }
            IBgSchemeFacade ibgschemefacade = BgSchemeFacadeFactory.getRemoteInstance();
            list = ibgschemefacade.getCorrectFormList(orgUnitId, bgschemeId, bpCollIds);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
        this.billId = new ArrayList();
        this.auditSuccess = new ArrayList();
        this.auditDefeat = new ArrayList();
        this.cantSubmit = new ArrayList();
        this.errorState = new ArrayList();
        this.billIdMap = new HashMap();
        String bgFormId = null;
        String number = null;
        StringBuffer str = null;
        BgFormStateEnum enumValue = null;
        int _state = 0;
        for (i = 0; i < list.size(); ++i) {
            Vector formVec = new Vector();
            formVec = (Vector)list.get(i);
            bgFormId = formVec.get(0).toString();
            number = formVec.get(1).toString();
            enumValue = (BgFormStateEnum)((Object)formVec.get(2));
            _state = enumValue.getValue();
            if (_state == 1 || _state == 41 || _state == 25 || _state == 14 || _state == 102) {
                if (BgFormHelper.checkInProInst(bgFormId)) {
                    if (!this.billIdMap.containsKey(bgFormId)) {
                        this.cantSubmit.add(bgFormId);
                    }
                } else if (!this.billIdMap.containsKey(bgFormId)) {
                    this.billId.add(bgFormId);
                }
            } else if (!this.billIdMap.containsKey(bgFormId)) {
                this.errorState.add(bgFormId);
            }
            this.billIdMap.put(bgFormId, number);
        }
        if (!this.errorState.isEmpty()) {
            str = new StringBuffer();
            int n = this.errorState.size();
            for (i = 0; i < n; ++i) {
                bgFormId = (String)this.errorState.get(i);
                number = (String)this.billIdMap.get(bgFormId);
                str.append(number + ",");
            }
            str.delete(str.length() - 1, str.length());
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormInWorkErrorState"), str.toString()));
            this.errorState.clear();
            SysUtil.abort();
        }
        if (!this.cantSubmit.isEmpty()) {
            str = new StringBuffer();
            int n = this.cantSubmit.size();
            for (i = 0; i < n; ++i) {
                bgFormId = (String)this.cantSubmit.get(i);
                number = (String)this.billIdMap.get(bgFormId);
                str.append(number + ",");
            }
            str.delete(str.length() - 1, str.length());
            MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormInWrokErrorInWork"), str.toString()));
            this.cantSubmit.clear();
            SysUtil.abort();
        }
        this.bgFormSubmitIds = new BOSUuid[this.billId.size()];
        int n = this.billId.size();
        for (i = 0; i < n; ++i) {
            this.bgFormSubmitIds[i] = BOSUuid.read((String)((String)this.billId.get(i)));
        }
        if (this.bgFormSubmitIds == null || this.bgFormSubmitIds.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"noFormInCondition"));
            return;
        }
        if (BgParamCHelper.isCompulsionReportCheck()) {
            List nopass;
            boolean isExit = false;
            List check = this.getBgFormInterface().reportCheck(this.bgFormSubmitIds);
            if (check.size() >= 3 && check.get(3) != null) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"String", (Object)check.get(3).toString());
                uiContext.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"ReportCheckError"));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI", (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            if (check.size() >= 3 && check.get(2) != null && (nopass = (List)check.get(2)).size() > 0) {
                isExit = true;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"ReportCheckError"));
            }
            if (isExit) {
                SysUtil.abort();
            }
        }
        if (this.getBgExamineInterface().canExamine(this.bgFormSubmitIds)) {
            this.xNum = BgNFCHelper.returnExamineX((BOSUuid[])this.bgFormSubmitIds, (Object)((Object)this));
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            this.dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
            if (this.dialog != null) {
                this.dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        Object[] result = BgSubmitBySchemeUI.this.getBgExamineInterface().examines(BgSubmitBySchemeUI.this.bgFormSubmitIds, BgSubmitBySchemeUI.this.xNum);
                        HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                        bgExamineCheckMap.put("BgExamineChecked", result[0]);
                        bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                        return bgExamineCheckMap;
                    }

                    public void afterExec(Object result) throws Exception {
                        if (result != null && result instanceof HashMap) {
                            BgSubmitBySchemeUI.this.openBgExamineViewUI(result);
                            Map bgExamineCheckMap = (Map)result;
                            Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                            if (bgExCheck.booleanValue()) {
                                int n;
                                String nextPerson = BgNCWfHelper.getNextPersonInfo4Batch((List)BgSubmitBySchemeUI.this.billId, (CoreUI)BgSubmitBySchemeUI.this, (Context)BgSubmitBySchemeUI.this.getFormFacadeInterface().getContext());
                                String id = null;
                                String number = null;
                                int n2 = BgSubmitBySchemeUI.this.billId.size();
                                for (int i = 0; i < n2; ++i) {
                                    id = BgSubmitBySchemeUI.this.billId.get(i).toString();
                                    number = BgSubmitBySchemeUI.this.billIdMap.get(id).toString();
                                    try {
                                        boolean flag = !BgNCWfHelper.isNextPersonSubmit() ? BgSubmitBySchemeUI.this.getFormFacadeInterface().submitFormWork(BOSUuid.read((String)id)) : BgNCWfHelper.submitFormWorkNextPerson4Batch((Object)id, (String)nextPerson, (IBgFormFacade)BgSubmitBySchemeUI.this.getFormFacadeInterface(), (ICoreBase)BgSubmitBySchemeUI.this.getBgFormInterface());
                                        if (flag) {
                                            BgSubmitBySchemeUI.this.auditSuccess.add(number);
                                            continue;
                                        }
                                        BgSubmitBySchemeUI.this.auditDefeat.add(number);
                                        continue;
                                    }
                                    catch (Exception ex) {
                                        BgSubmitBySchemeUI.this.auditDefeat.add(number);
                                    }
                                }
                                StringBuffer content = new StringBuffer(128);
                                if (BgSubmitBySchemeUI.this.auditDefeat.size() > 0) {
                                    StringBuffer temStr = new StringBuffer();
                                    n = BgSubmitBySchemeUI.this.auditDefeat.size();
                                    for (int i = 0; i < n; ++i) {
                                        temStr.append(BgSubmitBySchemeUI.this.auditDefeat.get(i));
                                        if (n - i <= 1) continue;
                                        temStr.append(",");
                                    }
                                    content.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitBySchemeFail"), temStr)).append("\r\n");
                                }
                                if (BgSubmitBySchemeUI.this.auditSuccess.size() > 0) {
                                    StringBuffer temStr = new StringBuffer();
                                    n = BgSubmitBySchemeUI.this.auditSuccess.size();
                                    for (int i = 0; i < n; ++i) {
                                        temStr.append(BgSubmitBySchemeUI.this.auditSuccess.get(i));
                                        if (n - i <= 1) continue;
                                        temStr.append(",");
                                    }
                                    content.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitBySchemeSuccess"), temStr)).append("\r\n");
                                }
                                MsgBox.showInfo((Component)((Object)BgSubmitBySchemeUI.this), (String)content.toString());
                                BgFormHelper.refreshBgFormList((CoreUI)BgSubmitBySchemeUI.this.getUIContext().get("Owner"));
                            } else {
                                MsgBox.showInfo((Component)((Object)BgSubmitBySchemeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantsubmit"));
                            }
                        } else {
                            MsgBox.showWarning((Component)((Object)BgSubmitBySchemeUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                        }
                    }
                });
                this.dialog.show();
            }
        } else {
            if (!this.billId.isEmpty()) {
                int i3;
                String nextPerson = BgNCWfHelper.getNextPersonInfo4Batch((List)this.billId, (CoreUI)this, (Context)this.getFormFacadeInterface().getContext());
                int n2 = this.billId.size();
                for (int i4 = 0; i4 < n2; ++i4) {
                    bgFormId = this.billId.get(i4).toString();
                    number = this.billIdMap.get(bgFormId).toString();
                    try {
                        boolean flag = !BgNCWfHelper.isNextPersonSubmit() ? this.getFormFacadeInterface().submitFormWork(BOSUuid.read((String)bgFormId)) : BgNCWfHelper.submitFormWorkNextPerson4Batch((Object)bgFormId, (String)nextPerson, (IBgFormFacade)this.getFormFacadeInterface(), (ICoreBase)this.getBgFormInterface());
                        if (flag) {
                            this.auditSuccess.add(number);
                            continue;
                        }
                        this.auditDefeat.add(number);
                        continue;
                    }
                    catch (Exception ex) {
                        this.auditDefeat.add(number);
                    }
                }
                StringBuffer content = new StringBuffer(128);
                if (this.auditDefeat.size() > 0) {
                    content.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"codeis"));
                    int n3 = this.auditDefeat.size();
                    for (i3 = 0; i3 < n3; ++i3) {
                        content.append(this.auditDefeat.get(i3));
                        if (n3 - i3 <= 1) continue;
                        content.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"and"));
                    }
                    content.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormDefeat") + "\r\n");
                }
                if (this.auditSuccess.size() > 0) {
                    content.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"codeis"));
                    int n4 = this.auditSuccess.size();
                    for (i3 = 0; i3 < n4; ++i3) {
                        content.append(this.auditSuccess.get(i3));
                        if (n4 - i3 <= 1) continue;
                        content.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"andtwo"));
                    }
                    content.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormSucceed"));
                }
                MsgBox.showInfo((Component)((Object)this), (String)content.toString());
            }
        }
    }

    protected IBgFormFacade getFormFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }

    private IBgForm getBgFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    protected void openBgExamineViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void prmtScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtScheme_dataChanged(e);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.prmtScheme.getData();
            BgPeriodDialog dialog = (BgPeriodDialog)this.prmtPeriod.getSelector();
            dialog.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
            dialog.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
        }
    }
}

