/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTraceFilterParam;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgTraceFilterUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgTraceFilterUI
extends AbstractBgTraceFilterUI {
    private static final long serialVersionUID = -3339818298287277946L;
    private static final Logger logger = CoreUIObject.getLogger(BgTraceFilterUI.class);
    private BgTraceFilterParam filterParam;
    private boolean hasUseFund = false;
    private OrgUnitInfo currOrgUnit;
    static final String FILTER_UI_KEY = BgTraceFilterUI.class.getName();
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private static final String ORGUNIT_IDS = "ORGUNIT_IDS";
    private static final String BGSCHEME_ID = "BGSCHEME_ID";
    private static final String BGPERIOD_ID_BEGIN = "BGPERIOD_ID_BEGIN";
    private static final String BGPERIOD_ID_END = "BGPERIOD_ID_END";
    private static final String BGITEM_NUMBER_BEGIN = "BGITEM_NUMBER_BEGIN";
    private static final String BGITEM_NUMBER_END = "BGITEM_NUMBER_END";
    private static final String CURRENCY_ID = "CURRENCY_ID";
    private static final String BGFORM_ID = "BGFORM_ID";
    private static final String BGELEMENT_ID = "BGELEMENT_ID";
    private static final String SHOWITEMNUMBER = "SHOWITEMNUMBER";

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (BgParamCHelper.isFodian()) {
            this.initCurrency();
            this.hasUseFund = true;
        } else {
            this.hasUseFund = false;
        }
        this.init();
        this.initOrgUnit();
        this.initBgPeriod();
        this.initComboBox();
        NewBgItemDialog bgItem = new NewBgItemDialog((IUIObject)this);
        BgElementDialog bgElement = new BgElementDialog((IUIObject)this);
        this.prmtItemFrom.setQueryInfo(null);
        this.prmtItemFrom.setSelector((KDPromptSelector)bgItem);
        this.prmtItemFrom.setDisplayFormat("$name$");
        this.prmtItemTo.setSelector((KDPromptSelector)bgItem);
        this.prmtItemTo.setDisplayFormat("$name$");
        this.prmtElement.setSelector((KDPromptSelector)bgElement);
        this.prmtElement.setDisplayFormat("$name$");
        this.prmtBeginPeriod.setEditable(false);
        this.prmtEndPeriod.setEditable(false);
    }

    private void initOrgUnit() throws Exception {
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage("orgUnitTitle"));
        orgView.setCuID(this.getCurrOrgUnit().getId().toString());
        orgView.setMultiSelect(true);
        orgView.setReturnSuperior(true);
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtOrgUnit.setData((Object)this.getCurrOrgUnit());
    }

    private void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = null;
        bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBeginPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtEndPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
    }

    private void initComboBox() throws Exception {
        this.combBgForm.setLimitedSize(false);
        this.combBgForm.setComboPopupWidth(400);
        this.bgScheme.setLimitedSize(true);
    }

    private void initCurrency() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"BB01"));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        CurrencyCollection cols = CurrencyFactory.getRemoteInstance().getCurrencyCollection(viewInfo);
        if (cols.size() > 0) {
            this.prmtCurrency.setValue((Object)cols.get(0));
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        Object orgUnitObj = this.prmtOrgUnit.getData();
        this.bgScheme.removeAllItems();
        if (orgUnitObj != null) {
            HashSet<BOSUuid> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo cOrgUnit2 = null;
            OrgUnitInfo currOrgUnitInfo = null;
            if (orgUnitObj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)orgUnitObj};
            } else if (orgUnitObj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])orgUnitObj;
            }
            subOrgUnits = new HashSet<BOSUuid>();
            if (orgUnits != null) {
                if (orgUnits.length > 1) {
                    currOrgUnitInfo = this.getCurrOrgUnit();
                    if (!currOrgUnitInfo.getId().equals((Object)orgUnits[0].getId())) {
                        currOrgUnitInfo = orgUnits[0];
                    }
                    for (OrgUnitInfo cOrgUnit2 : orgUnits) {
                        if (cOrgUnit2.getId().equals((Object)currOrgUnitInfo.getId())) continue;
                        subOrgUnits.add(cOrgUnit2.getId());
                    }
                } else {
                    currOrgUnitInfo = orgUnits[0];
                }
            }
            BgSchemeCollection bgSchemeCol = null;
            try {
                if (currOrgUnitInfo != null) {
                    bgSchemeCol = this.getInterface().getCommonBgScheme(currOrgUnitInfo.getId(), subOrgUnits, this.isHasUseFund(), false, true);
                    this.bgScheme.addItems(bgSchemeCol.toArray());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
        if (this.prmtOrgUnit.getData() != null) {
            BgCostCenterOrgViewF7 orgView = (BgCostCenterOrgViewF7)this.prmtOrgUnit.getSelector();
            OrgUnitInfo unitInfo2 = null;
            OrgUnitInfo[] unitInfos = null;
            Object obj = this.prmtOrgUnit.getData();
            if (obj instanceof OrgUnitInfo) {
                unitInfo2 = (OrgUnitInfo)obj;
                HashSet<String> checked = new HashSet<String>();
                checked.add(unitInfo2.getId().toString());
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else if (obj instanceof OrgUnitInfo[]) {
                unitInfos = (OrgUnitInfo[])obj;
                HashSet<String> checked = new HashSet<String>();
                for (OrgUnitInfo unitInfo2 : unitInfos) {
                    checked.add(unitInfo2.getId().toString());
                }
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else {
                orgView.setCheckedOrgIDs(null);
            }
        }
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public void init() throws Exception {
        this.currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        this.currOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.currOrgUnit.getId()));
    }

    protected BgRptFilterParam getFilterParam() {
        return this.filterParam;
    }

    protected void setBgTraceFilterParam(BgTraceFilterParam filterParam) {
        this.filterParam = filterParam;
    }

    public boolean verify() {
        if (this.prmtOrgUnit.getValue() == null) {
            this.prmtOrgUnit.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectUnit"));
            return false;
        }
        if (this.bgScheme.getSelectedItem() == null) {
            this.bgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            return false;
        }
        if (this.combBgForm.getSelectedItem() == null) {
            this.combBgForm.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgForm"));
            return false;
        }
        if ("".equals(this.prmtCurrency.getText())) {
            this.prmtCurrency.setValue(null);
        }
        BgClientHelper.verifyBgPeriodBegin2End((CoreUIObject)this, this.prmtBeginPeriod, this.prmtEndPeriod);
        return true;
    }

    @Override
    public CustomerParams getCustomerParams() {
        Object bgFormObj;
        Object shemeObj;
        CustomerParams cp = super.getCustomerParams();
        this.filterParam = (BgTraceFilterParam)this.createNewFilterParam();
        Object orgObj = this.prmtOrgUnit.getData();
        if (orgObj != null) {
            if (orgObj instanceof OrgUnitInfo[]) {
                OrgUnitInfo[] array = (OrgUnitInfo[])orgObj;
                int length = array.length;
                OrgUnitInfo[] costAry = null;
                if (length > 0) {
                    costAry = new OrgUnitInfo[length];
                    System.arraycopy(array, 0, costAry, 0, length);
                }
                this.filterParam.setOrgUnitInfoAry(costAry);
            } else if (orgObj instanceof CostCenterOrgUnitInfo) {
                this.filterParam.setOrgUnitInfoAry(new OrgUnitInfo[]{(OrgUnitInfo)orgObj});
            }
        }
        if ((shemeObj = this.bgScheme.getSelectedItem()) != null) {
            BgSchemeInfo info = (BgSchemeInfo)shemeObj;
            this.filterParam.setBgSchemeId(info.getId().toString());
        }
        BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
        if (this.prmtBeginPeriod.getValue() != null) {
            this.filterParam.setBeginPeriod(beginPeriod);
        }
        BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
        if (this.prmtEndPeriod.getValue() != null) {
            this.filterParam.setEndPeriod(endPeriod);
        }
        if ((bgFormObj = this.combBgForm.getSelectedItem()) != null) {
            this.filterParam.setBgFormId(((BgFormInfo)bgFormObj).getId().toString());
            this.filterParam.setBgFormInfo((BgFormInfo)bgFormObj);
        }
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        this.filterParam.setObjItemFrom(vi);
        if (vi != null) {
            String stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            this.filterParam.setItemFrom(stritem);
        } else {
            this.filterParam.setItemFrom(null);
        }
        Object prmtItemToObj = this.prmtItemTo.getValue();
        if (prmtItemToObj instanceof BgItemInfo) {
            BgItemInfo bii = (BgItemInfo)prmtItemToObj;
            VisualItemInfo vii = new VisualItemInfo();
            vii.setNumber(bii.getNumber());
            vii.setName(bii.getName());
            vi = vii;
        } else {
            vi = (VisualItemInfo)prmtItemToObj;
        }
        this.filterParam.setObjItemTo(vi);
        if (vi != null) {
            String stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            this.filterParam.setItemTo(stritem);
        } else {
            this.filterParam.setItemTo(null);
        }
        BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
        this.filterParam.setObjElement(beinfo);
        if (beinfo != null) {
            String stritem = beinfo.getId().toString();
            this.filterParam.setElement(stritem);
        } else {
            this.filterParam.setElement(null);
        }
        if (this.combBgForm.getSelectedItem() != null) {
            BgFormInfo info = (BgFormInfo)this.combBgForm.getSelectedItem();
            this.filterParam.setBgFormId(info.getId().toString());
        }
        if (this.prmtCurrency.getValue() != null) {
            this.filterParam.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        } else {
            this.filterParam.setCurrency(null);
        }
        this.filterParam.setBgRptType(BgAnalysisTypeEnum.BGTRACE);
        this.filterParam.setIsShowItemNumber(this.chkIsShowItemName.isSelected());
        this.saveCustomerParams(cp, this.filterParam);
        return cp;
    }

    public Object getFilterObject1(CustomerParams cp, String key) throws Exception {
        if (cp == null) {
            return null;
        }
        FilterParam param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam("FILTERPARAM") : cp.getCustomerParam(key);
        if (objStr == null) {
            return null;
        }
        byte[] objByte = Base64.decode((String)objStr);
        if (objByte == null || objByte.length == 0) {
            return null;
        }
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = (FilterParam)bais.readObject();
        }
        catch (IOException e) {
            throw new IOException();
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    throw new IOException();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new IOException();
                }
            }
        }
        return param;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        BgTraceFilterParam filterParam = (BgTraceFilterParam)this.createNewFilterParam();
        this.loadCustomerParams(cp, filterParam);
        try {
            filterParam = (BgTraceFilterParam)this.getCPInterface().loadCustomerParams((FilterParam)filterParam);
        }
        catch (Exception ex) {
            filterParam = null;
            logger.error((Object)ex);
        }
        if (filterParam == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"UpdateSelectScheme"));
            return;
        }
        OrgUnitInfo[] ccouiAry = filterParam.getOrgUnitInfoAry();
        if (ccouiAry != null) {
            this.prmtOrgUnit.setData((Object)ccouiAry);
        }
        try {
            this.prmtOrgUnit_dataChanged(null);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String schemeId = filterParam.getBgSchemeId();
        int num = this.bgScheme.getItemCount();
        for (int i = 0; i < num; ++i) {
            String tempId = ((BgSchemeInfo)this.bgScheme.getItemAt(i)).getId().toString();
            if (!tempId.equals(schemeId)) continue;
            this.bgScheme.setSelectedIndex(i);
        }
        try {
            this.bgScheme_itemStateChanged(null);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String bgFormId = filterParam.getBgFormId();
        int num2 = this.combBgForm.getItemCount();
        for (int i = 0; i < num2; ++i) {
            String tempId = ((BgFormInfo)this.combBgForm.getItemAt(i)).getId().toString();
            if (!tempId.equals(bgFormId)) continue;
            this.combBgForm.setSelectedIndex(i);
        }
        this.prmtBeginPeriod.setData((Object)filterParam.getBeginPeriod());
        this.prmtEndPeriod.setData((Object)filterParam.getEndPeriod());
        this.prmtItemFrom.setData((Object)filterParam.getObjItemFrom());
        this.prmtItemTo.setData((Object)filterParam.getObjItemTo());
        this.prmtElement.setData((Object)filterParam.getObjElement());
        this.prmtCurrency.setData((Object)filterParam.getCurrency());
        this.chkIsShowItemName.setSelected(filterParam.getIsShowItemNumber().booleanValue());
    }

    @Override
    protected void prmtEndPeriod_stateChanged(ChangeEvent e) throws Exception {
        BgPeriodInfo endPeriod;
        int periodType;
        Object obj = this.prmtEndPeriod.getValue();
        if (obj != null && (periodType = (endPeriod = (BgPeriodInfo)obj).getPeriodType().getValue()) == 8) {
            this.prmtBeginPeriod.setValue((Object)endPeriod);
        }
    }

    @Override
    protected void prmtBeginPeriod_stateChanged(ChangeEvent e) throws Exception {
        Object obj = this.prmtBeginPeriod.getValue();
        if (obj != null) {
            BgPeriodInfo beginPeriod = (BgPeriodInfo)obj;
            int periodType = beginPeriod.getPeriodType().getValue();
            if (periodType == 8) {
                this.prmtEndPeriod.setValue((Object)beginPeriod);
                this.prmtEndPeriod.setEnabled(false);
            } else {
                this.prmtEndPeriod.setEnabled(true);
            }
        }
    }

    @Override
    public void clear() {
        this.prmtOrgUnit.setData((Object)this.getCurrOrgUnit());
        this.prmtBeginPeriod.setData(null);
        this.prmtEndPeriod.setData(null);
        this.prmtCurrency.setData(null);
        this.prmtItemFrom.setData(null);
        this.prmtItemTo.setData(null);
        this.prmtElement.setData(null);
        this.prmtCurrency.setData(null);
    }

    @Override
    protected void bgScheme_itemStateChanged(ItemEvent e) throws Exception {
        this.combBgForm.removeAllItems();
        if (this.prmtOrgUnit.getData() != null && this.bgScheme.getSelectedItem() != null) {
            HashSet<Object> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo cOrgUnit = null;
            OrgUnitInfo currOrgUnitInfo = null;
            Object obj = this.prmtOrgUnit.getData();
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.bgScheme.getSelectedItem();
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<Object>();
            if (orgUnits != null && orgUnits.length > 1) {
                currOrgUnitInfo = this.getCurrOrgUnit();
                if (!currOrgUnitInfo.getId().equals((Object)orgUnits[0].getId())) {
                    currOrgUnitInfo = orgUnits[0];
                }
                int n = orgUnits.length;
                for (int i = 0; i < n; ++i) {
                    cOrgUnit = orgUnits[i];
                    subOrgUnits.add(cOrgUnit.getId());
                }
            }
            if (orgUnits != null && orgUnits.length == 1) {
                subOrgUnits.add(orgUnits[0].getId().toString());
            }
            BgFormCollection bgFormCol = null;
            try {
                bgFormCol = this.getInterface().getCommonBgForm(bgSchemeInfo.getId(), subOrgUnits, this.isHasUseFund(), false, true);
                this.combBgForm.addItems(bgFormCol.toArray());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    public boolean isHasUseFund() {
        return this.hasUseFund;
    }

    @Override
    public String getUITitle() {
        return EASResource.getString((String)resourcePath, (String)"traceFilterUITitle");
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgTraceFilterParam();
    }

    @Override
    protected boolean hasNewScheme() {
        return true;
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgTraceFilterParam)) {
            return;
        }
        String tmpStr = null;
        List ids = null;
        BgTraceFilterParam _filterParam = (BgTraceFilterParam)filterParam;
        try {
            ids = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(ORGUNIT_IDS)));
            if (ids != null) {
                _filterParam.setOrgUnitInfoAry(new OrgUnitInfo[ids.size()]);
                int in = ids.size();
                for (int i = 0; i < in; ++i) {
                    tmpStr = (String)ids.get(i);
                    if (StringUtils.isEmpty((String)tmpStr)) continue;
                    _filterParam.getOrgUnitInfoAry()[i] = new OrgUnitInfo();
                    _filterParam.getOrgUnitInfoAry()[i].setId(BOSUuid.read((String)tmpStr));
                }
            } else {
                _filterParam.setOrgUnitInfoAry(null);
            }
            tmpStr = cp.getCustomerParam(BGSCHEME_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgSchemeId(tmpStr);
            } else {
                _filterParam.setBgSchemeId(null);
            }
            tmpStr = cp.getCustomerParam(BGPERIOD_ID_BEGIN);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBeginPeriod(new BgPeriodInfo());
                _filterParam.getBeginPeriod().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setBeginPeriod(null);
            }
            tmpStr = cp.getCustomerParam(BGPERIOD_ID_END);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setEndPeriod(new BgPeriodInfo());
                _filterParam.getEndPeriod().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setEndPeriod(null);
            }
            tmpStr = cp.getCustomerParam(CURRENCY_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setCurrency(new CurrencyInfo());
                _filterParam.getCurrency().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setCurrency(null);
            }
            tmpStr = cp.getCustomerParam(BGITEM_NUMBER_BEGIN);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setObjItemFrom(new VisualItemInfo());
                _filterParam.getObjItemFrom().setNumber(tmpStr);
            } else {
                _filterParam.setObjItemFrom(null);
            }
            tmpStr = cp.getCustomerParam(BGITEM_NUMBER_END);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setObjItemTo(new VisualItemInfo());
                _filterParam.getObjItemTo().setNumber(tmpStr);
            } else {
                _filterParam.setObjItemTo(null);
            }
            tmpStr = cp.getCustomerParam(BGFORM_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setBgFormId(tmpStr);
                _filterParam.setBgFormInfo(new BgFormInfo());
                _filterParam.getBgFormInfo().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setBgFormId(null);
                _filterParam.setBgFormInfo(null);
            }
            tmpStr = cp.getCustomerParam(BGELEMENT_ID);
            if (!StringUtils.isEmpty((String)tmpStr)) {
                _filterParam.setObjElement(new BgElementInfo());
                _filterParam.getObjElement().setId(BOSUuid.read((String)tmpStr));
            } else {
                _filterParam.setObjElement(null);
            }
            tmpStr = cp.getCustomerParam(SHOWITEMNUMBER);
            if (!StringUtils.isEmpty((String)tmpStr) && BgNConstants.TRUE_STE.equals(tmpStr)) {
                _filterParam.setIsShowItemNumber(Boolean.TRUE);
            } else {
                _filterParam.setIsShowItemNumber(Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgTraceFilterParam)) {
            return;
        }
        BgTraceFilterParam _filterParam = (BgTraceFilterParam)filterParam;
        ArrayList<String> tmpList = null;
        OrgUnitInfo _unitInfo = null;
        if (_filterParam.getOrgUnitInfoAry() != null) {
            tmpList = new ArrayList<String>();
            int in = _filterParam.getOrgUnitInfoAry().length;
            for (int i = 0; i < in; ++i) {
                _unitInfo = _filterParam.getOrgUnitInfoAry()[i];
                if (_unitInfo == null) continue;
                tmpList.add(_unitInfo.getId().toString());
            }
            if (!tmpList.isEmpty()) {
                cp.addCustomerParam(ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(tmpList)));
            } else {
                cp.removeCustomerParam(ORGUNIT_IDS);
            }
        } else {
            cp.removeCustomerParam(ORGUNIT_IDS);
        }
        if (_filterParam.getBgSchemeId() != null) {
            cp.addCustomerParam(BGSCHEME_ID, _filterParam.getBgSchemeId());
        } else {
            cp.removeCustomerParam(BGSCHEME_ID);
        }
        if (_filterParam.getBeginPeriod() != null) {
            cp.addCustomerParam(BGPERIOD_ID_BEGIN, _filterParam.getBeginPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_ID_BEGIN);
        }
        if (_filterParam.getEndPeriod() != null) {
            cp.addCustomerParam(BGPERIOD_ID_END, _filterParam.getEndPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_ID_END);
        }
        if (_filterParam.getBgFormId() != null) {
            cp.addCustomerParam(BGFORM_ID, _filterParam.getBgFormId());
        } else {
            cp.removeCustomerParam(BGFORM_ID);
        }
        if (_filterParam.getObjItemFrom() != null) {
            cp.addCustomerParam(BGITEM_NUMBER_BEGIN, _filterParam.getObjItemFrom().getNumber());
        } else {
            cp.removeCustomerParam(BGITEM_NUMBER_BEGIN);
        }
        if (_filterParam.getObjItemTo() != null) {
            cp.addCustomerParam(BGITEM_NUMBER_END, _filterParam.getObjItemTo().getNumber());
        } else {
            cp.removeCustomerParam(BGITEM_NUMBER_END);
        }
        if (_filterParam.getObjElement() != null) {
            cp.addCustomerParam(BGELEMENT_ID, _filterParam.getObjElement().getId().toString());
        } else {
            cp.removeCustomerParam(BGELEMENT_ID);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(CURRENCY_ID);
        }
        if (_filterParam.getIsShowItemNumber().booleanValue()) {
            cp.addCustomerParam(SHOWITEMNUMBER, _filterParam.getIsShowItemNumber().toString());
        } else {
            cp.removeCustomerParam(SHOWITEMNUMBER);
        }
    }
}

