/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgTypeFactory;
import com.kingdee.eas.ma.budget.BgTypeInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BgTypeEditUI
extends AbstractBgTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgTypeEditUI.class);
    private boolean hasCodeNumber = false;
    private boolean hasShowCodeNumber = false;
    private boolean isUseIntermitNumber = false;

    public boolean isUseIntermitNumber() {
        return this.isUseIntermitNumber;
    }

    public void setUseIntermitNumber(boolean isUseIntermitNumber) {
        this.isUseIntermitNumber = isUseIntermitNumber;
    }

    public boolean isHasCodeNumber() {
        return this.hasCodeNumber;
    }

    public void setHasCodeNumber(boolean hasCodeNumber) {
        this.hasCodeNumber = hasCodeNumber;
    }

    public boolean isHasShowCodeNumber() {
        return this.hasShowCodeNumber;
    }

    public void setHasShowCodeNumber(boolean hasShowCodeNumber) {
        this.hasShowCodeNumber = hasShowCodeNumber;
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        if (number != null && number.length() > 0) {
            caller.put("number", (Object)number);
            this.txtNumber.setText(number);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add(new SelectorItemInfo("parent.id"));
        return selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeLoad() throws EASBizException {
        String costId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        BgTypeInfo bgTemplateInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            bgTemplateInfo = new BgTypeInfo();
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            this.setHasCodeNumber(BgHelper.hasNumber((CoreBaseInfo)bgTemplateInfo, costId, codingRuleManager));
            if (this.isHasCodeNumber()) {
                this.setHasShowCodeNumber(BgHelper.hasDisplayNumber((CoreBaseInfo)bgTemplateInfo, costId, codingRuleManager));
                this.setUseIntermitNumber(BgHelper.isUseIntermitNumber((CoreBaseInfo)bgTemplateInfo, costId, null));
            }
            if (this.isHasCodeNumber()) {
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEnabled(true);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        finally {
            codingRuleManager = null;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.separatorFile1.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkBeforeSave()) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    protected boolean checkBeforeSave() {
        String name;
        if (this.txtNumber.isEnabled()) {
            if (this.txtNumber == null || this.txtNumber.getText().trim().equals("")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)"num"));
                return false;
            }
            if (this.txtNumber.getText().trim().toLowerCase().startsWith("selfdefineanalysistemplategroup.")) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)"notAddChildBySysSet"));
                return false;
            }
        }
        if (StringUtils.isEmpty((String)(name = (String)this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)"name"));
            return false;
        }
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkBeforeSave()) {
            super.actionSubmit_actionPerformed(e);
        }
    }

    protected IObjectValue createNewData() {
        BgTypeInfo info = new BgTypeInfo();
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        String OUID = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        if (this.isHasCodeNumber() && this.isHasShowCodeNumber()) {
            this.getNumberByCodingRule((IObjectValue)info, OUID);
        } else if (this.isHasCodeNumber() && this.isUseIntermitNumber()) {
            String num = "";
            info.setNumber(num);
            this.txtNumber.setText(num);
            this.txtNumber.setEnabled(false);
        }
        return info;
    }

    public void onLoad() throws Exception {
        this.beforeLoad();
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgTypeFactory.getRemoteInstance();
    }

    private int setSelectLanguage() {
        int nTemp = 0;
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        LanguageInfo currentLang = new LanguageInfo(SysContext.getSysContext().getLocale());
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            if (currentLang.getLocale().toString().equals(languageInfo.getLocale().toString())) break;
            ++nTemp;
        }
        return nTemp;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.txtNumber.isEnabled() && this.txtNumber.getText() != null && this.txtNumber.getText().trim().length() > 50) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)"longNumber"));
            SysUtil.abort();
        }
        if (this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() != null && this.txtName.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() > 50) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)"longName"));
            SysUtil.abort();
        }
        if (this.txtSimpleName.getText() != null && this.txtSimpleName.getText().trim().length() > 50) {
            this.txtSimpleName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)"longSN"));
            SysUtil.abort();
        }
        if (this.txtDescription.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() != null && this.txtDescription.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() > 200) {
            this.txtDescription.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)"longDes"));
            SysUtil.abort();
        }
    }
}

