/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgTypeFactory;
import com.kingdee.eas.ma.budget.IBgType;
import com.kingdee.eas.ma.budget.client.AbstractBgTypeListUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgTypeListUI
extends AbstractBgTypeListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgTypeListUI.class);
    public static final String NUMBER_COLUMN = "number";
    public static final String ID_COLUMN = "id";
    public static final String LEVEL_COLUMN = "level";
    public static final String ISLEAF_COLUMN = "isLeaf";
    protected BgTypeRender render;

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        return filter;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            ICell cell = row.getCell(NUMBER_COLUMN);
            String number = null;
            NumberExpandInfo expandInfo = null;
            if (cell != null) {
                if (cell.getValue() instanceof NumberExpandInfo) {
                    expandInfo = (NumberExpandInfo)row.getCell(NUMBER_COLUMN).getValue();
                    number = expandInfo.getNumber();
                } else if (cell.getValue() != null) {
                    number = cell.getValue().toString();
                }
            }
            boolean enabled = !"SelfDefineAnalysisTemplateGroup".equalsIgnoreCase(number);
            this.menuItemRemove.setEnabled(enabled);
            this.menuItemEdit.setEnabled(enabled);
            this.btnRemove.setEnabled(enabled);
            this.btnEdit.setEnabled(enabled);
            if (e.getClickCount() == 1 && expandInfo != null) {
                if (this.render.inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
                String nexts = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_1") + this.tblMain.getRowCount() + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_2");
                this.setMessageBarText(nexts);
            } else if (e.getClickCount() != 2 || !this.isF7Query()) {
                super.tblMain_tableClicked(e);
            }
        }
    }

    protected boolean isF7Query() {
        return false;
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell(ISLEAF_COLUMN).getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String number = null;
        String pNumber = null;
        NumberExpandInfo expandInfo = null;
        pNumber = parentExpandInfo.getNumber();
        boolean isExpanded = parentExpandInfo.isExpanded();
        if (isExpanded) {
            parentExpandInfo.setExpanded(false);
            int rowCount = this.tblMain.getBody().size();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (number = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(NUMBER_COLUMN).getValue()).getNumber()).startsWith(pNumber + "."); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            int rowIndex;
            parentExpandInfo.setExpanded(true);
            int rowCount = this.tblMain.getBody().size();
            if (rowIndex >= rowCount) {
                this.getChildBgType(parentExpandInfo.getId(), parentExpandInfo.getLevel(), rowIndex);
            } else {
                for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                    child = this.tblMain.getRow(rowIndex);
                    expandInfo = (NumberExpandInfo)child.getCell(NUMBER_COLUMN).getValue();
                    number = expandInfo.getNumber();
                    if (number.startsWith(pNumber + ".")) {
                        if (expandInfo.getLevel() - parentLevel != 1) continue;
                        child.getStyleAttributes().setHided(false);
                        if (expandInfo.isLeaf()) continue;
                        expandInfo.setExpanded(false);
                        continue;
                    }
                    if (rowIndex != row.getRowIndex() + 1) break;
                    this.getChildBgType(parentExpandInfo.getId(), parentExpandInfo.getLevel(), rowIndex);
                    break;
                }
            }
        }
    }

    protected void getChildBgType(String id, int level, int rowIndex) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IBgType iBg = BgTypeFactory.getRemoteInstance();
        String id = this.getSelectedKeyValue();
        if (id != null && !id.equals("")) {
            int res = iBg.checkRefAll(id);
            String resKey = null;
            switch (res) {
                case 1: {
                    resKey = "notEditRefByForm";
                    break;
                }
                case 2: {
                    resKey = "notEditRefByTemplate";
                    break;
                }
                case 3: {
                    resKey = "notEditRefByChild";
                }
            }
            if (resKey != null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)resKey));
                SysUtil.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IBgType iBg = BgTypeFactory.getRemoteInstance();
        String id = this.getSelectedKeyValue();
        if (id != null && !id.equals("")) {
            int res = iBg.checkRefAll(id);
            String resKey = null;
            switch (res) {
                case 1: {
                    resKey = "notDelRefByForm";
                    break;
                }
                case 2: {
                    resKey = "notDelRefByTemplate";
                    break;
                }
                case 3: {
                    resKey = "notDelRefByChild";
                }
            }
            if (resKey != null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgTypeResource", (String)resKey));
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    protected String getEditUIName() {
        return BgTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgTypeFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return ID_COLUMN;
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRemove.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.menuItemEdit.setEnabled(false);
        this.menuItemRemove.setEnabled(false);
        BgClientHelper.addSqlMenu((CoreUIObject)this, this.menuEdit);
        this.initTable();
        BgNationalFormatUIUtil.setDateTimeOrNumberFormat(this.tblMain);
    }

    protected void initTable() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        IColumn col = null;
        col = this.tblMain.getColumn(NUMBER_COLUMN);
        if (col != null) {
            this.render = new BgTypeRender();
            col.setRenderer((IBasicRender)this.render);
            col.getStyleAttributes().setLocked(true);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                BgTypeListUI.this.setTableDisplayStyle(start, end);
            }
        });
    }

    protected void setTableDisplayStyle(int start, int end) {
        IRow row = null;
        IRow sRow = null;
        boolean isLeaf = true;
        int level = 0;
        Object numberValue = null;
        NumberExpandInfo expandInfo = null;
        int count = end;
        for (int i = start; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (i + 1 <= count) {
                sRow = this.tblMain.getRow(i + 1);
            }
            if (row == null || row.getCell(ID_COLUMN) == null) continue;
            String id = (String)row.getCell(ID_COLUMN).getValue();
            numberValue = row.getCell(NUMBER_COLUMN).getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            String number = numberValue.toString();
            level = (Integer)row.getCell(LEVEL_COLUMN).getValue();
            isLeaf = (Boolean)row.getCell(ISLEAF_COLUMN).getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setNumber(number);
            if (sRow != null) {
                String nNumber = sRow.getCell(NUMBER_COLUMN).getValue().toString();
                if (nNumber.startsWith(number + ".")) {
                    expandInfo.setExpanded(true);
                    expandInfo.setLeaf(false);
                } else {
                    expandInfo.setExpanded(false);
                }
            } else {
                expandInfo.setExpanded(false);
            }
            row.getCell(NUMBER_COLUMN).setValue((Object)expandInfo);
        }
    }

    protected class NumberExpandInfo {
        private String id;
        private String number;
        private boolean isExpanded;
        private int level;
        private boolean isLeaf;

        protected NumberExpandInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.number;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public void setExpanded(boolean isExpanded) {
            this.isExpanded = isExpanded;
        }
    }

    protected class BgTypeRender
    extends ObjectValueRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        private SimpleTextRender simpleRender = new SimpleTextRender();
        private Map acctIdToPos = new HashMap();

        protected BgTypeRender() {
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle, Object extObject) {
            if (object instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)object;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - x - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.getNumber(), cellStyle);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (object != null) {
                this.simpleRender.draw(graphics, clip, object.toString(), cellStyle);
            }
        }

        public String getText(Object obj) {
            if (obj != null) {
                return obj.toString();
            }
            return super.getText(obj);
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpanded()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpanded()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
        }

        protected boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }
    }
}

