/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.analysiscolumn.BgCompareAndAnalysisObjInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgViewBudgetCtrlUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class BgViewBudgetCtrlUI
extends AbstractBgViewBudgetCtrlUI {
    private static final long serialVersionUID = -8391749402374351264L;
    private String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();

    public void onLoad() throws Exception {
        super.onLoad();
        String formulaString = String.valueOf(this.getUIContext().get("formula"));
        this.inputItemAndElement(formulaString);
        List recordList = (List)this.getUIContext().get("records");
        this.fillDataToTable(recordList);
    }

    private void inputItemAndElement(String formulaString) {
        Vector itemAndElement = BgClientHelper.getItemAndElement(formulaString, this.orgUnitId);
        String itemNum = new String();
        String itemName = new String();
        String element = new String();
        Map visItemsMap = new HashMap();
        Map bgElementMap = new HashMap();
        visItemsMap = (Map)itemAndElement.get(0);
        bgElementMap = (Map)itemAndElement.get(1);
        itemNum = visItemsMap.keySet().toString();
        itemName = visItemsMap.values().toString();
        element = bgElementMap.values().toString();
        this.kDTextField1.setText(itemNum.substring(itemNum.indexOf("[") + 1, itemNum.indexOf("]")));
        this.kDTextField2.setText(itemName.substring(itemName.indexOf("[") + 1, itemName.indexOf("]")));
        this.kDTextField3.setText(element.substring(element.indexOf("[") + 1, element.indexOf("]")));
    }

    private void fillDataToTable(List recordList) {
        this.tblMain.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getColumn(2).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        int size = recordList.size();
        BigDecimal coefficient = (BigDecimal)this.getUIContext().get("coefficient");
        if (coefficient == null) {
            coefficient = new BigDecimal("1.00");
        }
        String _text = null;
        DecimalFormat _decFormat = null;
        for (int i = 0; i < size; ++i) {
            BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj info = (BgCompareAndAnalysisObjInfo.BudgetAdjustRecordDataObj)recordList.get(i);
            this.tblMain.addRow(i);
            BigDecimal _value = info.getPastVal().divide(coefficient, 2, 6);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat(2);
            _text = _decFormat.format(_value.doubleValue());
            this.tblMain.getCell(i, 0).setValue((Object)_text);
            this.tblMain.getCell(i, 1).setValue((Object)BgPastSourceEnum.getEnum(info.getPastSource()).getAlias());
            this.tblMain.getCell(i, 2).setValue((Object)info.getModifyDate());
        }
    }
}

