/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.client.AbstractBudgetCtrlBatchUI;
import com.kingdee.eas.ma.budget.client.BgBatchCtrlReportUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class BudgetCtrlBatchUI
extends AbstractBudgetCtrlBatchUI {
    private static final long serialVersionUID = 5289166930312386711L;
    public static final String Ctrl_BizBills = "controlBizBills";
    public static final String Cancel_Ctrl_BizBills = "cancelControlBizBills";
    protected boolean isCtrlBizBills = true;
    protected String boName = "NotFounded";
    protected String boAlias = null;
    protected String subSystemAlias = null;
    protected Date beginDate = null;
    protected Date endDate = null;
    protected Map subSystems = null;
    protected Map subSystemBizBills = null;
    protected Map ccId2csIdMap = new HashMap();
    protected Map ccId2csNameMap = new HashMap();
    protected List result = null;
    protected IBgControlScheme iBgControlScheme = null;
    protected IBudgetCtrlFacade iBudgetCtrlFacade = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        if (uiContext.get(Ctrl_BizBills) != null) {
            this.isCtrlBizBills = true;
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"132_BgBatchCtrlBizBillsUI"));
        } else if (uiContext.get(Cancel_Ctrl_BizBills) != null) {
            this.isCtrlBizBills = false;
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"133_BgBatchCtrlBizBillsUI"));
        }
        this.toolBar.setVisible(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getColumn("select").getStyleAttributes().setLocked(false);
        this.initSubSystem();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                for (int i = 0; i < BudgetCtrlBatchUI.this.tblMain.getRowCount(); ++i) {
                    IRow row = BudgetCtrlBatchUI.this.tblMain.getRow(i);
                    String costCenterId = row.getCell("cc.id").getValue().toString();
                    if (BudgetCtrlBatchUI.this.ccId2csIdMap.containsKey(costCenterId)) {
                        row.getCell("select").setValue((Object)Boolean.TRUE);
                        continue;
                    }
                    row.getCell("select").setValue((Object)Boolean.FALSE);
                }
            }
        });
    }

    private void initSubSystem() {
        this.initListeners();
        this.initSubSystemAndBizBillList();
        this.fillSubSystems(this.subSystems.entrySet());
    }

    private void initListeners() {
        this.cmbSubSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    BudgetCtrlBatchUI.this.cmbSubSystem_itemStateChanged(e);
                }
                catch (Exception exc) {
                    BudgetCtrlBatchUI.this.handUIException(exc);
                }
            }
        });
        this.cmbBizBill.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    BudgetCtrlBatchUI.this.cmbBizBill_itemStateChanged(e);
                }
                catch (Exception exc) {
                    BudgetCtrlBatchUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BudgetCtrlBatchUI.this.tblMain_editStopped(e);
                }
                catch (Exception exc) {
                    BudgetCtrlBatchUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initSubSystemAndBizBillList() {
        this.subSystems = new HashMap();
        this.subSystemBizBills = new HashMap();
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_botp", (BOSObjectType)MetaDataTypeList.ENTITY)));
        this.traceLeafNode(root);
    }

    private void traceLeafNode(DefaultKingdeeTreeNode node) {
        MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)node.getUserObject();
        BizBillMetaBriefInfo bizNodeBriefInfo = new BizBillMetaBriefInfo(briefInfo);
        if (bizNodeBriefInfo.getMetaDatatype().equals((Object)MetaDataTypeList.ENTITY)) {
            List<BizBillMetaBriefInfo> bizBillList;
            DefaultKingdeeTreeNode packageNode = (DefaultKingdeeTreeNode)node.getParent();
            MetaDataBriefInfo packageBriefInfo = (MetaDataBriefInfo)packageNode.getUserObject();
            BizBillMetaBriefInfo bizPackageBriefInfo = new BizBillMetaBriefInfo(packageBriefInfo);
            if (!this.subSystems.containsKey(bizPackageBriefInfo.getFullName())) {
                this.subSystems.put(bizPackageBriefInfo.getFullName(), bizPackageBriefInfo);
            }
            if (this.subSystemBizBills.containsKey(bizPackageBriefInfo.getFullName())) {
                bizBillList = (List)this.subSystemBizBills.get(bizPackageBriefInfo.getFullName());
            } else {
                bizBillList = new ArrayList();
                this.subSystemBizBills.put(bizPackageBriefInfo.getFullName(), bizBillList);
            }
            bizBillList.add(bizNodeBriefInfo);
        } else {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.traceLeafNode(childNode);
            }
        }
    }

    private void fillSubSystems(Collection subSystemCols) {
        for (Object obj : subSystemCols) {
            this.cmbSubSystem.addItem(((Map.Entry)obj).getValue());
        }
    }

    private void fillBizBills(Collection bizBillList) {
        Iterator iter = bizBillList.iterator();
        while (iter.hasNext()) {
            this.cmbBizBill.addItem(iter.next());
        }
    }

    protected void cmbSubSystem_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            if (this.cmbSubSystem.getSelectedIndex() >= 0) {
                BizBillMetaBriefInfo bizBriefInfo = (BizBillMetaBriefInfo)this.cmbSubSystem.getSelectedItem();
                this.subSystemAlias = bizBriefInfo.getAlias();
                if (this.subSystemBizBills.containsKey(bizBriefInfo.getFullName())) {
                    List bizBillList = (List)this.subSystemBizBills.get(bizBriefInfo.getFullName());
                    this.fillBizBills(bizBillList);
                }
            }
        } else {
            this.cmbBizBill.removeAllItems();
        }
    }

    protected void cmbBizBill_itemStateChanged(ItemEvent e) throws Exception {
        BizBillMetaBriefInfo selectedBill = (BizBillMetaBriefInfo)this.cmbBizBill.getSelectedItem();
        if (selectedBill != null && selectedBill.getFullName() != null) {
            this.boName = selectedBill.getFullName();
            this.boAlias = selectedBill.getAlias();
        }
        this.refreshList();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter;
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if ((filter = viewInfo.getFilter()) == null) {
            filter = new FilterInfo();
        }
        FilterItemInfo item = new FilterItemInfo("boName", (Object)this.boName, CompareType.EQUALS);
        this.replaceFilterItems(filter, item);
        FilterItemInfo item2 = new FilterItemInfo("isValid", (Object)new Integer(1), CompareType.EQUALS);
        this.replaceFilterItems(filter, item2);
        FilterItemInfo item3 = new FilterItemInfo("isSysDefault", (Object)new Integer(0), CompareType.EQUALS);
        this.replaceFilterItems(filter, item3);
        viewInfo.setFilter(filter);
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.ccId2csIdMap.clear();
        this.ccId2csNameMap.clear();
        this.selectRows(false);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.ccId2csIdMap.clear();
        this.ccId2csNameMap.clear();
        this.selectRows(true);
    }

    private void selectRows(boolean select) {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell("select").setValue((Object)select);
            if (!select) continue;
            String costCenterId = row.getCell("cc.id").getValue().toString();
            String costCenterName = String.valueOf(row.getCell("cc.name").getValue());
            String ctrlSchemeId = row.getCell("id").getValue().toString();
            this.ccId2csIdMap.put(costCenterId, ctrlSchemeId);
            this.ccId2csNameMap.put(costCenterId, costCenterName);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        int colIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
        if (rowIndex < 0 || colIndex < 0) {
            return;
        }
        if (colIndex != 0) {
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        String costCenterId = row.getCell("cc.id").getValue().toString();
        String costCenterName = String.valueOf(row.getCell("cc.name").getValue());
        String ctrlSchemeId = row.getCell("id").getValue().toString();
        boolean select = (Boolean)row.getCell("select").getValue();
        if (select) {
            if (!this.ccId2csIdMap.containsKey(costCenterId)) {
                this.ccId2csIdMap.put(costCenterId, ctrlSchemeId);
                this.ccId2csNameMap.put(costCenterId, costCenterName);
            }
        } else if (this.ccId2csIdMap.containsKey(costCenterId)) {
            this.ccId2csIdMap.remove(costCenterId);
            this.ccId2csNameMap.remove(costCenterId);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.ccId2csIdMap == null || this.ccId2csIdMap.isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"335_BudgetCtrlBatchUI"));
            SysUtil.abort();
        }
        if (this.kDPickerBeginTime.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"136_BgBatchCtrlBizBillsUI"));
            SysUtil.abort();
        }
        if (this.kDPickerEndTime.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"137_BgBatchCtrlBizBillsUI"));
            SysUtil.abort();
        }
        this.beginDate = (Date)this.kDPickerBeginTime.getValue();
        this.endDate = (Date)this.kDPickerEndTime.getValue();
        this.beginDate.setHours(0);
        this.beginDate.setMinutes(0);
        this.beginDate.setSeconds(0);
        this.endDate.setHours(23);
        this.endDate.setMinutes(59);
        this.endDate.setSeconds(59);
        if (this.endDate.before(this.beginDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"138_BgBatchCtrlBizBillsUI"));
            this.kDPickerEndTime.setValue(null);
            SysUtil.abort();
        }
        this.checkPermission();
        HashSet ccids = new HashSet();
        ccids.addAll(this.ccId2csIdMap.keySet());
        Map bills = this.getCtrlFacade().getBillsCountOnOU(this.boName, ccids, this.beginDate, this.endDate);
        DateFormat formater = BgNationalFormatUIUtil.getNationalDateFormat();
        if (bills == null || bills.isEmpty()) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgActualResource", (String)"notFoundBill"), formater.format(this.beginDate), formater.format(this.endDate), this.boAlias);
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        float minCtrlSecond = 0.3f;
        float maxCtrlSecond = 0.5f;
        float minClearSecond = 0.1f;
        float maxClearSecond = 0.15f;
        int count = 0;
        Iterator itr = bills.keySet().iterator();
        while (itr.hasNext()) {
            String ccid = itr.next().toString();
            int x = (Integer)bills.get(ccid);
            count += x;
        }
        if (count == 0) {
            String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgActualResource", (String)"notFoundBill"), formater.format(this.beginDate), formater.format(this.endDate), this.boAlias);
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        String minTime = this.isCtrlBizBills ? String.valueOf((int)(minCtrlSecond * (float)count)) : String.valueOf((int)(minClearSecond * (float)count));
        String maxTime = this.isCtrlBizBills ? String.valueOf((int)(maxCtrlSecond * (float)count)) : String.valueOf((int)(maxCtrlSecond * (float)count));
        String msg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgActualResource", (String)"foundBills");
        int flag = MsgBox.showConfirm3((Component)((Object)this), (String)(msg = MessageFormat.format(msg, formater.format(this.beginDate), formater.format(this.endDate), this.boAlias, new Integer(count), minTime, maxTime)));
        if (flag != 0) {
            return;
        }
        this.setAllComponentEnabled(false);
        this.callRemoteCtrl();
        this.setAllComponentEnabled(true);
        this.dealExcelReport();
        this.getUIWindow().close();
    }

    private void checkPermission() throws EASBizException, BOSException {
        if (this.ccId2csIdMap == null || this.ccId2csIdMap.isEmpty()) {
            return;
        }
        String batchCtrlPermission = "bg_scheme12_batchCtrl";
        String batchCancelCtrlPermission = "bg_scheme13_batchCancelCtrl";
        OrgUnitInfo currentOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK currentOrgPK = new ObjectUuidPK(currentOrgUnit.getId());
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        if (this.isCtrlBizBills) {
            iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, batchCtrlPermission);
        } else {
            iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, batchCancelCtrlPermission);
        }
        ICostCenterOrgUnit iCC = CostCenterOrgUnitFactory.getRemoteInstance();
        Object orgUnitInfo = null;
        ObjectUuidPK CCPK = null;
        Iterator itr = this.ccId2csIdMap.keySet().iterator();
        while (itr.hasNext()) {
            CCPK = new ObjectUuidPK(itr.next().toString());
            if (!iCC.exists((IObjectPK)new ObjectUuidPK(CCPK.toString()))) continue;
            if (this.isCtrlBizBills) {
                iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)CCPK, batchCtrlPermission);
                continue;
            }
            iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)CCPK, batchCancelCtrlPermission);
        }
    }

    private void callRemoteCtrl() {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog != null) {
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    BudgetCtrlBatchUI.this.result = BudgetCtrlBatchUI.this.isCtrlBizBills ? BudgetCtrlBatchUI.this.getCtrlFacade().batchWriteCtrlData(BudgetCtrlBatchUI.this.boName, BudgetCtrlBatchUI.this.ccId2csIdMap, BudgetCtrlBatchUI.this.beginDate, BudgetCtrlBatchUI.this.endDate) : BudgetCtrlBatchUI.this.getCtrlFacade().batchClearCtrlData(BudgetCtrlBatchUI.this.boName, BudgetCtrlBatchUI.this.ccId2csIdMap, BudgetCtrlBatchUI.this.beginDate, BudgetCtrlBatchUI.this.endDate);
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((Component)((Object)BudgetCtrlBatchUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"142_BgBatchCtrlBizBillsUI"));
                }
            });
            dialog.show();
        }
    }

    private void dealExcelReport() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        if (this.isCtrlBizBills) {
            uiContext.put((Object)Ctrl_BizBills, (Object)Ctrl_BizBills);
        } else {
            uiContext.put((Object)Cancel_Ctrl_BizBills, (Object)Cancel_Ctrl_BizBills);
        }
        uiContext.put((Object)this.getMetaDataPK().getFullName(), (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgBatchCtrlReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void setAllComponentEnabled(boolean enable) {
        this.cmbSubSystem.setEnabled(enable);
        this.cmbBizBill.setEnabled(enable);
        this.treeViewOrgUnit.setEnabled(enable);
        this.btnSelectAll.setEnabled(enable);
        this.btnClearAll.setEnabled(enable);
        this.rbCurrOrgUnit.setEnabled(enable);
        this.rbImmOrgUnit.setEnabled(enable);
        this.rbAllOrgUnit.setEnabled(enable);
        this.tblMain.getStyleAttributes().setLocked(enable);
        this.kDPickerBeginTime.setEnabled(enable);
        this.kDPickerEndTime.setEnabled(enable);
        this.bntOK.setEnabled(enable);
        this.btnAbort.setEnabled(enable);
    }

    protected IBgControlScheme getIBgControlScheme() throws BOSException {
        if (this.iBgControlScheme == null) {
            this.iBgControlScheme = BgControlSchemeFactory.getRemoteInstance();
        }
        return this.iBgControlScheme;
    }

    protected IBudgetCtrlFacade getCtrlFacade() throws BOSException {
        if (this.iBudgetCtrlFacade == null) {
            this.iBudgetCtrlFacade = BudgetCtrlFacadeFactory.getRemoteInstance();
        }
        return this.iBudgetCtrlFacade;
    }

    private class BizBillMetaBriefInfo {
        private String packageName;
        private String name;
        private String fullName;
        private String alias;
        private String description;
        private boolean isPackage;
        private String bosType;
        BOSObjectType metaDatatype;
        private IObjectValue metaData;

        public BizBillMetaBriefInfo(MetaDataBriefInfo briefInfo) {
            this.setPackageName(briefInfo.getPackgeName());
            this.setPackage(briefInfo.isPackage());
            this.setName(briefInfo.getName());
            this.setAlias(briefInfo.getAlias());
            this.setDescription(briefInfo.getDescription());
            this.setMetaDatatype(briefInfo.getMetaDataType());
        }

        public boolean isPackage() {
            return this.isPackage;
        }

        public void setPackage(boolean isPackage) {
            this.isPackage = isPackage;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getBosType() {
            return this.bosType;
        }

        public void setBosType(String bosType) {
            this.bosType = bosType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public IObjectValue getMetaData() {
            if (this.metaData == null) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                this.metaData = loader.get(this.getMetaDatatype(), this.getMetaDataPK());
            }
            return this.metaData;
        }

        public void setMetaData(IObjectValue metaData) {
            this.metaData = metaData;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getFullName() {
            if (this.fullName == null) {
                this.fullName = this.isPackage() ? this.getPackageName() : this.getPackageName() + "." + this.getName();
            }
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public IMetaDataPK getMetaDataPK() {
            return new MetaDataPK(this.getPackageName(), this.getName());
        }

        public BOSObjectType getMetaDatatype() {
            return this.metaDatatype;
        }

        public void setMetaDatatype(BOSObjectType metaDatatype) {
            this.metaDatatype = metaDatatype;
        }

        public String toString() {
            return this.alias;
        }
    }
}

