/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.BgAllFormCollectionUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Map;

public final class BudgetFormAllDisplayValueProvider
implements IDisplayValueProvider {
    private BgAllFormCollectionUI ui = null;

    public BudgetFormAllDisplayValueProvider(Component component) {
        if (component != null && component instanceof BgAllFormCollectionUI) {
            this.ui = (BgAllFormCollectionUI)((Object)component);
        }
    }

    public BigDecimal getCoefficient() {
        return this.ui.getCoefficient();
    }

    public int getPrecision() {
        return this.ui.getBgFormInfo(this.ui).getCurrency().getPrecision();
    }

    public Map getMeasureUnitMap() {
        return this.ui.getMeasureMap();
    }

    public Map getCurrencyMap() {
        return this.ui.getCurrencyMap();
    }

    public Map getFormulaMap() {
        return this.ui.getFormulaMap();
    }

    public Object getDisplayValue(Cell cell, int viewMode) {
        Object obj = null;
        if (cell != null && !BgNFSHelper.checkIsEmptyValue((Cell)cell)) {
            if (cell.getValue().getValue() instanceof GregorianCalendar) {
                return cell.getText();
            }
            String _text = cell.getText();
            obj = cell.getValue();
            if (obj != null) {
                obj = obj.getValue();
            }
            if (BgNFSHelper.checkHasTextOfCell((Cell)cell) || BgNFSHelper.checkHasPercentage((Cell)cell)) {
                return cell.getText();
            }
            if (!BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
                return _text;
            }
            if (!StringUtils.isEmpty((String)_text)) {
                if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                    if (this.getMeasureUnitMap().isEmpty()) {
                        return this.getMeasureUnitDisplayValue(cell, obj, false);
                    }
                    return this.getMeasureUnitDisplayValue(cell, obj, true);
                }
                if (cell.getUserObject("BG_COLLECT") != null) {
                    return this.getMeasureUnitValue(cell, obj);
                }
                return this.getDefMeasureUnitDisplayValue(cell, obj);
            }
        }
        return null;
    }

    private Object getMeasureUnitValue(Cell cell, Object obj) {
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
            _text = this.getDisplayValue(cell, obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected Object getMeasureUnitDisplayValue(Cell cell, Object obj, boolean useMeasureUnit) {
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _coefficient = this.getCoefficient();
        int _precision = this.getPrecision();
        CurrencyInfo _currencyInfo = null;
        _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
        _parameter = BgNFSHelper.parseFormulaPara((Map)this.getFormulaMap(), (String)_formulaStr);
        if (_parameter != null) {
            if (useMeasureUnit && !StringUtils.isEmpty((String)_parameter[2]) && this.getMeasureUnitMap().containsKey(_parameter[2])) {
                _coefficient = (BigDecimal)this.getMeasureUnitMap().get(_parameter[2]);
            }
            if (!StringUtils.isEmpty((String)_parameter[5]) && this.getCurrencyMap().containsKey(_parameter[5])) {
                _currencyInfo = (CurrencyInfo)this.getCurrencyMap().get(_parameter[5]);
                _precision = _currencyInfo.getPrecision();
            }
        }
        _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
        return this.getDisplayValue(cell, obj, _coefficient, _precision);
    }

    protected Object getDefMeasureUnitDisplayValue(Cell cell, Object obj) {
        obj = cell.getValue();
        if (obj != null) {
            obj = ((Variant)obj).getValue();
        }
        if (!BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
            return obj;
        }
        String _text = null;
        int _precision = this.getPrecision();
        try {
            _precision = BgNFSHelper.getDigitOfNumber((Cell)cell, (int)_precision);
            _text = this.getDisplayValue(cell, obj, this.getCoefficient(), _precision);
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    protected String getDisplayValue(Cell cell, Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = BgNationalFormatUIUtil.parseToBigDecimal(obj).divide(coefficient, 8, 4);
            _decFormat = BgNationalFormatUIUtil.getDecimalFormat(precision);
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }
}

