/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.ma.budget.BgCombinItemObject;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.client.AbstractCombinCtrlSetUI;
import com.kingdee.eas.ma.budget.client.BgCombinItemDialog;
import com.kingdee.eas.ma.budget.client.BgEleDialogForCtrlSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CombinCtrlSetUI
extends AbstractCombinCtrlSetUI {
    private static final Logger logger = CoreUIObject.getLogger(CombinCtrlSetUI.class);
    private Hashtable itemAndElementMap = new Hashtable();
    private String RESOURCE = "com.kingdee.eas.ma.budget.client.BgCtrlSetResource";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        this.table.checkParsed();
        this.table.getSelectManager().setSelectMode(1);
        this.table.getColumn("name").getStyleAttributes().setLocked(true);
        Vector combinItemNumberVec = (Vector)this.getUIContext().get("combinItemNumberVec");
        Hashtable combinItemMap = (Hashtable)this.getUIContext().get("combinItemMap");
        Vector elementNumberVec = (Vector)this.getUIContext().get("elementNumberVec");
        Hashtable elementMap = (Hashtable)this.getUIContext().get("elementMap");
        KDBizPromptBox box1 = new KDBizPromptBox();
        BgCombinItemDialog dialog1 = new BgCombinItemDialog((IUIObject)this);
        dialog1.setCombinItemNumberVec(combinItemNumberVec);
        dialog1.setCombinItemMap(combinItemMap);
        box1.setSelector((KDPromptSelector)dialog1);
        KDTDefaultCellEditor editor1 = new KDTDefaultCellEditor((IKDEditor)box1);
        this.table.getColumn("number").setEditor((ICellEditor)editor1);
        KDBizPromptBox box2 = new KDBizPromptBox();
        BgEleDialogForCtrlSet dialog2 = new BgEleDialogForCtrlSet((IUIObject)this);
        dialog2.setElementNumberVec(elementNumberVec);
        dialog2.setElementMap(elementMap);
        box2.setSelector((KDPromptSelector)dialog2);
        KDTDefaultCellEditor editor2 = new KDTDefaultCellEditor((IKDEditor)box2);
        this.table.getColumn("element").setEditor((ICellEditor)editor2);
    }

    private void setIcon() {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        super.btnSave_actionPerformed(e);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            if (row.getCell("number").getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"selectCombinItem"));
                SysUtil.abort();
            }
            if (row.getCell("element").getValue() != null) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"selectBgElement"));
            SysUtil.abort();
        }
        Hashtable<String, String> temp = new Hashtable<String, String>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            IRow row = this.table.getRow(i);
            String key = ((BgCombinItemObject)row.getCell("number").getValue()).getNumber() + "_" + ((BgElementInfo)row.getCell("element").getValue()).getNumber();
            if (temp.containsKey(key)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"existSameItemAndElement"));
                SysUtil.abort();
            }
            temp.put(key, key);
            this.itemAndElementMap.put(key, key);
        }
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"success"));
    }

    @Override
    protected void btnRemoveRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnRemoveRow_actionPerformed(e);
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"selectRow"));
            SysUtil.abort();
        }
        this.table.removeRow(rowIndex);
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddRow_actionPerformed(e);
        this.table.addRow();
    }

    @Override
    protected void table_editStopped(KDTEditEvent e) throws Exception {
        IRow iRow;
        ICell iCell;
        super.table_editStopped(e);
        int colIndex = e.getColIndex();
        int curRow = e.getRowIndex();
        if (colIndex == this.table.getColumnIndex("number") && (iCell = (iRow = this.table.getRow(curRow)).getCell("number")).getValue() != null) {
            BgCombinItemObject obj = (BgCombinItemObject)iCell.getValue();
            iRow.getCell("name").setValue((Object)obj.getName());
        }
        if (colIndex == this.table.getColumnIndex("element")) {
            // empty if block
        }
    }

    public Hashtable getItemAndElementMap() {
        return this.itemAndElementMap;
    }
}

