/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.budget.client.AbstractCompanyTreeSelectUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CompanyTreeSelectUI
extends AbstractCompanyTreeSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(CompanyTreeSelectUI.class);
    private IUIObject uiOwner = null;
    private JDialog dialog = null;
    private TreeModel bakSelectedTreeModel = null;

    private void bakTreeSelected() {
        if (this.treeSelected.getModel().getRoot() != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            this.cloneTree((DefaultKingdeeTreeNode)root2, (DefaultKingdeeTreeNode)((KDTreeNode)this.treeSelected.getModel().getRoot()));
            this.bakSelectedTreeModel = new KingdeeTreeModel((TreeNode)root2);
        }
    }

    private void restoreTreeSelected() {
        if (this.bakSelectedTreeModel != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            this.cloneTree((DefaultKingdeeTreeNode)root2, (DefaultKingdeeTreeNode)((KDTreeNode)this.bakSelectedTreeModel.getRoot()));
            this.treeSelected.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root2));
            this.treeSelected.expandAllNodes(true, (TreeNode)this.treeSelected.getModel().getRoot());
        } else {
            KDTreeNode root = new KDTreeNode((Object)"");
            ((KingdeeTreeModel)this.treeSelected.getModel()).setRoot((TreeNode)root);
        }
    }

    protected TreeModel getTreeModel() throws EASBizException {
        TreeModel orgTreeModel = null;
        try {
            String rootUnitID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            orgTreeModel = BgNFSHelper.getOrgTreeModel((String)rootUnitID, (KDTree)this.treeOrigin);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return orgTreeModel;
    }

    public CompanyTreeSelectUI() throws Exception {
        this.initUIContentLayout();
        if (this.getTreeModel() == null) {
            return;
        }
        this.treeOrigin.setModel(this.getTreeModel());
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrigin.getModel().getRoot();
        this.treeOrigin.expandAllNodes(true, (TreeNode)root);
        KingdeeTreeModel treeModel = (KingdeeTreeModel)this.treeSelected.getModel();
        if (treeModel.getRoot() != null) {
            KDTreeNode root2 = new KDTreeNode((Object)"");
            treeModel.setRoot((TreeNode)root2);
            this.treeSelected.setRootVisible(false);
            this.treeSelected.setShowsRootHandles(true);
        }
    }

    private void addTo(DefaultKingdeeTreeNode toNode, TreePath tp, int from) {
        DefaultKingdeeTreeNode root = null;
        while (from < tp.getPathCount()) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)tp.getPathComponent(from);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            if (from == tp.getPathCount() - 1) {
                this.cloneTree(child, oriChild);
            }
            if (toNode == null) {
                root = (DefaultKingdeeTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot();
                ((KingdeeTreeModel)this.treeSelected.getModel()).insertNodeInto((MutableTreeNode)child, (MutableTreeNode)root, 0);
            } else {
                DefaultKingdeeTreeNode sibling = oriChild;
                DefaultKingdeeTreeNode found = null;
                while ((sibling = (DefaultKingdeeTreeNode)sibling.getNextSibling()) != null && (found = this.findNode(sibling, toNode)) == null) {
                }
                if (found != null) {
                    toNode.insert((MutableTreeNode)child, toNode.getIndex((TreeNode)found));
                } else {
                    toNode.add((MutableTreeNode)child);
                }
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)toNode);
            }
            toNode = child;
            ++from;
        }
    }

    private void cloneTree(DefaultKingdeeTreeNode root, DefaultKingdeeTreeNode oriRoot) {
        for (int i = 0; i < oriRoot.getChildCount(); ++i) {
            DefaultKingdeeTreeNode oriChild = (DefaultKingdeeTreeNode)oriRoot.getChildAt(i);
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)oriChild.clone();
            root.add((MutableTreeNode)child);
            this.cloneTree(child, oriChild);
        }
    }

    private DefaultKingdeeTreeNode findNode(DefaultKingdeeTreeNode source, DefaultKingdeeTreeNode dest) {
        if (source == null || dest == null) {
            return null;
        }
        if (source.getUserObject().equals(dest.getUserObject())) {
            return dest;
        }
        for (int i = 0; i < dest.getChildCount(); ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)dest.getChildAt(i);
            if ((child = this.findNode(source, child)) == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] tps = this.treeOrigin.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            KDTreeNode rightRoot;
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            DefaultKingdeeTreeNode findNode = this.findNode(selectedNode, (DefaultKingdeeTreeNode)(rightRoot = (KDTreeNode)((KingdeeTreeModel)this.treeSelected.getModel()).getRoot()));
            if (findNode != null) {
                DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)findNode.getParent();
                findNode.removeFromParent();
                ((KingdeeTreeModel)this.treeSelected.getModel()).nodeStructureChanged((TreeNode)parent);
            }
            DefaultKingdeeTreeNode toNode = null;
            for (int j = 0; j < tp.getPathCount(); ++j) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getPathComponent(j);
                DefaultKingdeeTreeNode temp = null;
                temp = this.findNode(node, (DefaultKingdeeTreeNode)this.treeSelected.getModel().getRoot());
                if (temp == null) {
                    this.addTo(toNode, tp, j);
                    continue;
                }
                toNode = temp;
            }
        }
        KDTreeNode root = (KDTreeNode)this.treeSelected.getModel().getRoot();
        this.treeSelected.expandAllNodes(true, (TreeNode)root);
        super.actionAdd_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.restoreTreeSelected();
        this.dialog.setVisible(false);
        super.actionCancel_actionPerformed(e);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        KingdeeTreeModel tree = (KingdeeTreeModel)this.treeSelected.getModel();
        KDTreeNode root = (KDTreeNode)tree.getRoot();
        ArrayList list = new ArrayList();
        this.popNode(list, (DefaultKingdeeTreeNode)root);
        this.firePropertyChange("companyChanged", null, list.toArray());
        this.dialog.setVisible(false);
        super.actionConfirm_actionPerformed(e);
        this.bakTreeSelected();
    }

    private void popNode(List list, DefaultKingdeeTreeNode root) {
        Enumeration c = root.children();
        while (c.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)c.nextElement();
            if (node.isCheckBoxEnabled()) {
                OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
                list.add(org.getUnit());
            }
            this.popNode(list, node);
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        TreePath[] tps = this.treeSelected.getSelectionPaths();
        if (tps == null) {
            return;
        }
        for (int i = 0; i < tps.length; ++i) {
            TreePath tp = tps[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            while (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                tp = tp.getParentPath();
                node = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            }
            if (node.getParent() != null && node.getParent().getChildCount() == 1 && node.getParent().getParent() != null) {
                node = (DefaultKingdeeTreeNode)node.getParent();
            }
            ((KingdeeTreeModel)this.treeSelected.getModel()).removeNodeFromParent((MutableTreeNode)node);
        }
        super.actionDelete_actionPerformed(e);
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public void setValue(TreeModel model) {
        this.treeSelected.setModel(model);
    }
}

