/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTAbstractAction;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.client.RptTablePane;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.client.BgProcessUI;
import java.awt.event.ActionEvent;

public class KDTReportTableAgent
extends KDTAbstractAction {
    private BgProcessUI processUi = null;
    public static final int ACTION_PASTE = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_CUT = 3;
    public static final int ACTION_ESC = 4;
    public static final int ACTION_COPY = 5;
    public static final String CMD_DEL_VALUE = "value";
    public static final String CMD_DEL_FORMULA = "formula";
    public static final String CMD_DEL_CONTENT = "content";
    protected int actionCode;
    protected RptTablePane rptPanel;

    public KDTReportTableAgent(KDTable tbl, int code, RptTablePane panel, BgProcessUI processUi) {
        super(tbl);
        this.rptPanel = panel;
        this.actionCode = code;
        this.processUi = processUi;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.rptPanel == null) {
            return;
        }
        this.table = this.rptPanel.getCurrentPage();
        if (this.table == null) {
            return;
        }
        switch (this.actionCode) {
            case 1: {
                this.paste();
                break;
            }
            case 2: {
                this.delete();
                break;
            }
            case 3: {
                this.cut();
                break;
            }
            case 4: {
                if (this.table.getEditManager().isEditing()) {
                    this.table.getEditManager().cancelEditing();
                    break;
                }
                this.rptPanel.onEscape();
            }
        }
        this.rptPanel.resetFormulaBarContent();
    }

    private void cut() {
        if (!this.table.getStyleAttributes().isLocked()) {
            KDTRange rangeCut = this.table.getSelectManager().toRange();
            this.table.getEditHelper().copy();
            this.table.getEditHelper().delete(rangeCut.getSequenceRange(), 15);
        }
    }

    private void paste() {
        if (!this.table.getStyleAttributes().isLocked() && !this.processUi.getOprtState().equals(OprtState.VIEW)) {
            this.clearAlias();
            if (this.processUi.itemRadValue.isSelected()) {
                this.table.getEditHelper().paste(2);
            } else if (this.processUi.itemRadExpressions.isSelected()) {
                this.table.getEditHelper().paste(4);
            } else if (this.processUi.itemRadAll.isSelected()) {
                this.table.getEditHelper().paste(15);
            }
            this.processUi.aliasCellOfFormula(this.processUi.alias);
        }
    }

    private void delete() {
        if (!this.table.getStyleAttributes().isLocked()) {
            KDTRange rangeDel = this.table.getSelectManager().toRange();
            if (!this.processUi.getOprtState().equals(OprtState.VIEW)) {
                this.clearAlias();
                if (this.processUi.itemRadValue.isSelected()) {
                    this.table.getEditHelper().delete(rangeDel.getSequenceRange(), 2);
                } else if (this.processUi.itemRadExpressions.isSelected()) {
                    this.table.getEditHelper().delete(rangeDel.getSequenceRange(), 4);
                } else if (this.processUi.itemRadAll.isSelected()) {
                    this.table.getEditHelper().delete(rangeDel.getSequenceRange(), 15);
                }
                this.processUi.aliasCellOfFormula(this.processUi.alias);
            }
            int i = 0;
            int n = 0;
            int r = 0;
            int c = 0;
            int rowBegin = 0;
            int rowEnd = 0;
            int colBegin = 0;
            int colEnd = 0;
            KDTSelectBlock block = null;
            ICell cell = null;
            n = rangeDel.size();
            for (i = 0; i < n; ++i) {
                block = (KDTSelectBlock)rangeDel.get(i);
                rowBegin = block.getBeginRow();
                rowEnd = block.getEndRow();
                colBegin = block.getBeginCol();
                colEnd = block.getEndCol();
                for (r = rowBegin; r <= rowEnd; ++r) {
                    for (c = colBegin; c <= colEnd; ++c) {
                        cell = this.table.getCell(r, c);
                        if (BgFSHelper.checkHasFormulaOfCell(cell) || BgFSHelper.checkHasExpressionsOfCell(cell) || BgFSHelper.checkHasFormulaOfBgItem(cell) || BgFSHelper.checkHasFormulaOfBgElement(cell) || BgFSHelper.checkHasFormulaOfBgPeriod(cell) || BgFSHelper.checkHasFormulaOfCurrency(cell) || BgFSHelper.checkIsLinkCell(cell)) continue;
                        cell.setUserObject(null);
                    }
                }
            }
        }
    }

    private void clearAlias() {
        if (this.processUi.alias != null) {
            this.processUi.alias.clear();
        }
    }
}

