/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgAnalyseBaseFilterParam;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisDoForBook;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisFacadeFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgIOHelper;
import com.kingdee.eas.ma.budget.BgMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTraceFilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisSimpleObjFilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.FetchDataFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.IDataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.RatePopoInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchAndDealDataAnalysisSystemFacade;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchStandardDataForBgFormulaFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.StandardDataByBgItemDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.StandardDataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.listener.CustomerQueryConditionObserver;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.budget.client.AbstractNewBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.budget.client.BgAllFormCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgCollectViewCompareAndAUI;
import com.kingdee.eas.ma.budget.client.BgTraceMainUI;
import com.kingdee.eas.ma.budget.client.BgViewActualCtrlUI;
import com.kingdee.eas.ma.budget.client.BgViewBudgetCtrlUI;
import com.kingdee.eas.ma.budget.client.BudgetUserCellDisplayProvider;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisFilterUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisSavedFormMainUI;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnaylsisFilter2UI;
import com.kingdee.eas.ma.budget.client.NewDirectedBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.OrgUnitRender;
import com.kingdee.eas.ma.nbudget.BgExecuteFilterParam;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNLockProtectHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgSelfDefineFacadeFactory;
import com.kingdee.eas.ma.nbudget.IBgSelfDefineFacade;
import com.kingdee.eas.ma.nbudget.client.BgExecuteAnalyseMainUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class NewBgCompareAndAnalysisMainUI
extends AbstractNewBgCompareAndAnalysisMainUI {
    protected SpreadContext sc;
    private static final Logger logger = CoreUIObject.getLogger(NewBgCompareAndAnalysisMainUI.class);
    protected Book book;
    public static final String Analysis_Element_Cls = "AnalysisElementCls";
    protected static final BigDecimal ONE = new BigDecimal("1.00");
    private static final long serialVersionUID = 1133432990146680429L;
    protected static final String COL_KEY = "bgCompareAndAnalysisColKey";
    protected static final String NEW_ANALYSIS_COL_KEY = "AnalysisColKey";
    public static final String ANALYSIS_FLAG = "analysis_col";
    protected static final String TITLE_FLAG = "title_col";
    protected static final String ADD_ROW_FLAG = "add_row_flag";
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private OrgUnitRender render;
    private static CostCenterOrgUnitInfo[] CACHE_ARY;
    private static Map CACHE_MAP;
    private NewBgCompareAndAnalysisFilterUI filterUI;
    private NewBgCompareAndAnaylsisFilter2UI filter2UI;
    private MeasureUnitInfo defaultMeasureUnitInfo = null;
    protected DataDealCenter sddc;
    protected FetchDataFactory fsdf;
    protected boolean isDisplayZero;
    private FetchStandardDataForBgFormulaFactory factory;
    private FetchAndDealDataAnalysisSystemFacade fetchAndDealDataFacade = new FetchAndDealDataAnalysisSystemFacade();
    protected static final List notAllowOperation;
    private boolean isNeedToFetchTheLastData = true;
    public static final String THIS_ROW_HAS_DAIL_NUMBER_FORMAT = "THIS_ROW_HAS_DAIL_NUMBER_FORMAT";

    private FetchStandardDataForBgFormulaFactory getFetchStandardDataForBgFormulaFactory() {
        if (this.factory == null) {
            this.factory = new FetchStandardDataForBgFormulaFactory();
        }
        return this.factory;
    }

    protected final FetchAndDealDataAnalysisSystemFacade getAnalysisSysFacade() {
        return this.fetchAndDealDataFacade;
    }

    protected void initDataDealCenter(DataDealCenter sddc) {
        this.getAnalysisSysFacade().initDataDealCenter(sddc);
    }

    protected FetchDataFactory getFetchDataFactory() {
        return this.fsdf;
    }

    protected DataDealCenter getDataDealCenter(NewBgCompareAndAnalysisFilterParam filter1Params) throws ClassNotFoundException {
        BgPeriodInfo sPeriodInfo = filter1Params.getBeginPeriod();
        if (sPeriodInfo != null) {
            return new StandardDataDealCenter();
        }
        return new StandardDataByBgItemDealCenter();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (BgParamCHelper.isFodian()) {
            this.btnViewActualVal.setEnabled(false);
            this.btnViewActualVal.setVisible(false);
        }
        this.btnViewActualVal.setIcon(EASResource.getIcon((String)"imgTbtn_demandhistorydata"));
        this.btnViewBgVal.setIcon(EASResource.getIcon((String)"imgTbtn_demandnoncedata"));
        this.btnAllFormView.setIcon(EASResource.getIcon((String)"imgTbtn_allgathersee"));
        this.btnViewOrgInfo.setIcon(EASResource.getIcon((String)"imgTbtn_seegather"));
        this.menuItemSaveFile.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemViewBgActualVal.setIcon(EASResource.getIcon((String)"imgTbtn_demandhistorydata"));
        this.menuItemViewBgAdjustVal.setIcon(EASResource.getIcon((String)"imgTbtn_demandnoncedata"));
        this.menuItemViewBgActualVal.setMnemonic('C');
        this.menuItemSaveFile.setMnemonic('B');
        this.btnViewOrgInfo.setEnabled(true);
        this.menuItemViewOrg.setEnabled(true);
        this.inVisibleButton();
        this.visibleButton();
    }

    protected NewBgCompareAndAnalysisFilterParam getDirectFilterParam() {
        return null;
    }

    @Override
    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getDirectFilterParam() != null) {
            return true;
        }
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION)) {
            this.setSolutionId(ds.getId());
            int size = ds.getQueryPanelInfo().size();
            for (int i = 0; i < size; ++i) {
                QueryPanelInfo info = ds.getQueryPanelInfo().get(i);
                CustomerParams cp = new CustomerParams().getCustomerParams(info.getCustomerParams());
                this.setFilterParam(cp, info.getPanelClassName());
            }
        }
        return this.getFilterParam() != null;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.sc != null) {
            this.sc.getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.sc != null) {
            this.sc.getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"322_BgTendencyMainUI"));
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        BgFormInfo info = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(this.getDirectFilterParam().getBgFormID()));
        fc.setSelectedFile(new File("C://" + info.getName() + ".xlsx"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            FileFilter fileFilter = fc.getFileFilter();
            File file = fc.getSelectedFile();
            if (file.getName().indexOf(".") == -1) {
                String with = null;
                if (fileFilter instanceof ExcelFileFilter) {
                    with = ".xls";
                }
                if (fileFilter instanceof Excel2007FileFilter) {
                    with = ".xlsx";
                }
                file = new File(fc.getSelectedFile() + with);
            }
            if (file != null) {
                if (file.exists()) {
                    int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                    if (re == 1 || re == 2) {
                        return;
                    }
                    file.delete();
                }
                if (file.getName().endsWith(".xls")) {
                    try {
                        this.exportBookContent(file);
                        String exportSuccess = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgFormImportAndExportResource", (String)"exportSucceed");
                        MsgBox.showInfo((String)exportSuccess);
                    }
                    catch (Exception ex) {
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
                if (file.getName().endsWith(".xlsx")) {
                    try {
                        this.export2007BookContent(file);
                        String exportSuccess = EASResource.getString((String)"com.kingdee.eas.ma.nbudget.client.BgFormImportAndExportResource", (String)"exportSucceed");
                        MsgBox.showInfo((String)exportSuccess);
                    }
                    catch (Exception ex) {
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
            }
        }
    }

    protected void exportBookContent(File file) throws Exception {
        String numFormater = this.getNumberFormat(null);
        Book _book = this.stopBookProtection(this.sc.getBook());
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        String _filename = file.getPath();
        _kdsBook = new KDSBook(_filename);
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            _kdsSheet = new KDSSheet(_kdsBook, _sheet.getSheetName());
            _kdsSheet.setProtection(null);
            _kdsBook.addSheet(null, _kdsSheet);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (_cell == null) {
                        _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                        continue;
                    }
                    StyleAttributes ssa = Styles.getEmptySA();
                    _cell.getSheet().getRange(_cell).getStyle(ssa);
                    if (_cell == null || _cell.getValue() == Variant.nullVariant) continue;
                    Variant value = _cell.getValue();
                    if (value.getValue() instanceof BigDecimal) {
                        if (StringUtils.isEmpty((String)ssa.getNumberFormat())) {
                            ssa.setNumberFormat(numFormater);
                        }
                        ssa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                    _kdsCell = _kdsSheet.setCell(_rowIndex, _colIndex, (Object)value, (ShareStyleAttributes)ssa);
                }
            }
        }
        ExportManager em = new ExportManager();
        em.exportToExcel(_kdsBook, _filename);
    }

    private Book stopBookProtection(Book _book) {
        Book book = _book;
        try {
            book = IOHelper.unpackBook((byte[])IOHelper.packBook((Book)_book));
            BgNFSHelper.stopBookProtection((Book)book);
            int sheetSize = book.getSheetCount();
            for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                BgNFSHelper.stopSheetProtection((SheetOption)book.getSheet(sheetIndex).getSheetOption());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return book;
    }

    protected void export2007BookContent(File file) throws Exception {
        Book book = this.stopBookProtection(this.book);
        BookDataWrapper bookDataWrapper = new BookDataWrapper(book);
        bookDataWrapper.setExportFormula(false);
        bookDataWrapper.setExportCustomerFomulas(true);
        bookDataWrapper.setShowValue(true);
        bookDataWrapper.setExportHideCols(true);
        bookDataWrapper.setExportHideRows(true);
        SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
        booksc.write(file.getPath());
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.setNeedToFetchTheLastData(true);
        super.actionRefresh_actionPerformed(e);
        Range selectRange = this.sc.getBook().getActiveSheet().getRange(0, 0);
        selectRange.select();
        this.sc.getSpread().scrollCellVisible(0, 0);
        this.loadPrintConfigInfo();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getCommonQueryDialog();
        if (dialog.show()) {
            NewBgCompareAndAnalysisFilterUI filterui = (NewBgCompareAndAnalysisFilterUI)this.getFilterUI();
            filterui.setOwnFilterParam(null);
            NewBgCompareAndAnaylsisFilter2UI filter2ui = (NewBgCompareAndAnaylsisFilter2UI)this.getFilter2UI();
            filter2ui.setOwnFilterParam(null);
            this.setFilterParam(this.getFilterUI().getCustomerParams());
            this.setFilterParam(this.getFilter2UI().getCustomerParams());
            CommonQueryPanel queryPanel = dialog.getCommonqueryPanel();
            if (queryPanel.getCurrentSolution() != null) {
                this.setSolutionId(queryPanel.getCurrentSolution().getId());
            }
            this.executeQuery();
            this.loadPrintConfigInfo();
        }
    }

    private void setFilterParam(CustomerParams cp, String filterUIKey) {
        if (cp == null) {
            return;
        }
        BgAnalyseFilterBaseUI filterUI = this.getFilterUIByFilterUIKey(filterUIKey);
        if (filterUI instanceof NewBgCompareAndAnalysisFilterUI) {
            NewBgCompareAndAnalysisFilterUI filter1UI = (NewBgCompareAndAnalysisFilterUI)filterUI;
            NewBgCompareAndAnalysisFilterParam filter1Param = filter1UI.getOwnFilterParam();
            CostCenterOrgUnitInfo[] ccouiAry = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCostCenterOrgUnit(cp.getCustomerParam("OrgUnitKey"));
            filter1Param.setCostCenterOrgUnitInfoAry(ccouiAry);
            BgSchemeInfo scheme = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgSchemeInfo(cp.getCustomerParam("BgSchemeID"));
            filter1Param.setBgSchemeInfo(scheme);
            String bgFormId = cp.getCustomerParam("BgFormID");
            filter1Param.setBgFormID(bgFormId);
            Map titleMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey(cp.getCustomerParam("BgTitleColKey"));
            filter1Param.setTitleColsMap(titleMap);
            Map analysisMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisAndTitleColKey(cp.getCustomerParam("BgAnalysisColKey"));
            filter1Param.setAnalysisColsMap(analysisMap);
            BgPeriodInfo sInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo(cp.getCustomerParam("BeginPeriodID"));
            filter1Param.setBeginPeriod(sInfo);
            BgPeriodInfo eInfo = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeBgPeriodInfo(cp.getCustomerParam("EndPeriodID"));
            filter1Param.setEndPeriod(eInfo);
            CurrencyInfo currency = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeCurrencyInfo(cp.getCustomerParam("CurrencyID"));
            filter1Param.setCurrencyInfo(currency);
            Map measureMap = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeMeasureUnit(cp.getCustomerParam("BgMeasureUnitKey"));
            filter1Param.setMeasureUnitInfoMap(measureMap);
            String isSum = cp.getCustomerParam("IsSum");
            filter1Param.setShowColRow(Boolean.valueOf(isSum));
        } else if (filterUI instanceof NewBgCompareAndAnaylsisFilter2UI) {
            NewBgCompareAndAnaylsisFilter2UI filter2UI = (NewBgCompareAndAnaylsisFilter2UI)filterUI;
            List analysisEleList = NewBgCompareAndAnalysisSimpleObjFilterParam.decodeAnalysisElement(cp.getCustomerParam("BgSimpleAnalysisElement"));
            filter2UI.getOwnFilterParam().setAnalysisElement(analysisEleList);
        }
        this.defaultFilterParam = new BgAnalyseBaseFilterParam();
    }

    @Override
    protected BgAnalyseFilterBaseUI getFilterUI() {
        try {
            if (this.filterUI == null) {
                this.filterUI = new NewBgCompareAndAnalysisFilterUI();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return this.filterUI;
    }

    protected BgAnalyseFilterBaseUI getFilter2UI() {
        KDPanel[] ary = this.getOtherFilterUI();
        NewBgCompareAndAnaylsisFilter2UI filter2UI = (NewBgCompareAndAnaylsisFilter2UI)ary[0];
        return filter2UI;
    }

    @Override
    protected boolean hasOtherFilterUI() {
        return true;
    }

    @Override
    protected KDPanel[] getOtherFilterUI() {
        try {
            if (this.filter2UI == null) {
                this.filter2UI = new NewBgCompareAndAnaylsisFilter2UI();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        CustomerQueryConditionObserver.getIntance().attach(this.filter2UI);
        return new KDPanel[]{this.filter2UI};
    }

    @Override
    protected void executeQuery() {
        this.clearCache();
        NewBgCompareAndAnalysisFilterParam filter1Params = this.getFilterUIParams();
        this.setDelete(filter1Params);
        if (filter1Params.toString() == null) {
            if (!this.resetFilterParam()) {
                SysUtil.abort();
            }
            return;
        }
        if (this.isNeedToFetchTheLastData()) {
            try {
                this.getAnalysisSysFacade().initDataDealCenter(this.getDataDealCenter(filter1Params));
            }
            catch (ClassNotFoundException e) {
                this.handleException(e);
                SysUtil.abort();
            }
        }
        Map amountUnitMap = this.getMeasureUnit(filter1Params);
        filter1Params.setCurrencyInfo(null);
        this.book = this.addAndInitTable(filter1Params);
        BgNFSHelper.disableCal((Book)this.book);
        BgNFSHelper.disableUndo((Book)this.book);
        int sheetNum = this.book.getSheetCount();
        for (int i = 0; i < sheetNum && this.isNeedToFetchTheLastData(); ++i) {
            Sheet sheet = this.book.getSheet(i);
            NewBgCompareAndAnalysisFilterParam filter2Params = this.getFilterUI2Params();
            int addRowIndex = this.constructSheet(filter1Params, filter2Params.getAnalysisElement(), sheet);
            this.rebuildFilter1Params(filter1Params, new CostCenterOrgUnitInfo[]{filter1Params.getCostCenterOrgUnitInfoAry()[0]});
            try {
                this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().initDataFactory(filter1Params, filter2Params);
                this.fillDataToTable(sheet, filter1Params, filter2Params, addRowIndex, amountUnitMap);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
            this.delBgItemWithAllAnalysisDataEqualZero(this.isDelete(), sheet, addRowIndex);
            BgNLockProtectHelper.setSheetLockedAndProtection((Sheet)sheet, (boolean)true, (List)notAllowOperation);
        }
        this.addTableListener();
        NewBgCompareAndAnalysisMainUI.setAllNumberRightA(this.sc.getBook().getSheet(0));
        this.sc.setBook(this.book);
        this.sc.repaint();
        Range selectRange = this.sc.getBook().getSheet(0).getRange(0, 0);
        selectRange.select();
        this.sc.getSpread().scrollCellVisible(0, 0);
    }

    void rebuildFilter1Params(NewBgCompareAndAnalysisFilterParam filter1Params, Object[] ary) {
        filter1Params.setLazyLoadDataCostCenterOrgUnitInfoAry((CostCenterOrgUnitInfo[])ary);
    }

    private boolean resetFilterParam() {
        try {
            CommonQueryDialog dialog = this.getCommonQueryDialog();
            if (!dialog.show()) {
                return false;
            }
            this.setFilterParam(this.getFilterUI().getCustomerParams(), NewBgCompareAndAnalysisFilterUI.FILTER_UI_KEY);
            KDPanel[] ary = this.getOtherFilterUI();
            this.setFilterParam(((NewBgCompareAndAnaylsisFilter2UI)ary[0]).getCustomerParams(), NewBgCompareAndAnaylsisFilter2UI.FILTER_UI_KEY);
            this.executeQuery();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return true;
    }

    @Override
    public boolean destroyWindow() {
        this.clearCache();
        return super.destroyWindow();
    }

    private void clearCache() {
        IDataDealCenter ddc = this.getAnalysisSysFacade().getDataDealCenter();
        if (ddc != null) {
            ddc.getFetchDataFactory().clearAllCache();
        }
        CACHE_ARY = null;
        if (CACHE_MAP != null) {
            CACHE_MAP.clear();
        }
        if (this.book != null) {
            this.book = null;
        }
    }

    protected void fillDataToTable(Sheet sheet, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params, int addRowIndex, Map amountUnitMap) throws EASBizException, BOSException {
        CostCenterOrgUnitInfo[] orgUnitAry = filter1Params.getCostCenterOrgUnitInfoAry();
        String rootOrgUnitId = orgUnitAry[0].getId().toString();
        List list = filter2Params.getAnalysisElement();
        Cell cell = null;
        BigDecimal amountUnit = null;
        for (int row = 0; row < sheet.getMaxRowIndex() + 1; ++row) {
            for (int col = 0; col < sheet.getMaxColIndex() + 1; ++col) {
                cell = sheet.getCell(row, col, true);
                if (cell == null || BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || cell.getValue() == null || cell.getValue().getValue() == null || !(cell.getValue().getValue() instanceof BigDecimal)) continue;
                MeasureUnitInfo measureUnitInfo = this.getDefaultMeasureUnitInfo(filter1Params);
                amountUnit = measureUnitInfo.getCoefficient();
                this.setCellValue(sheet, row, col, cell.getValue().getValue(), amountUnit);
            }
        }
        this.fillDataToTable(sheet, list, addRowIndex + 1, rootOrgUnitId, amountUnitMap);
    }

    protected final List getAnalysisColIndexList(Sheet sheet) {
        ArrayList<Integer> analysisColIndexList = new ArrayList<Integer>();
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            analysisColIndexList.add(new Integer(i));
        }
        return analysisColIndexList;
    }

    private BigDecimal reSetAmountUnit(String element, Map amountUnitMap) {
        if (amountUnitMap == null || amountUnitMap.size() == 0) {
            return ONE;
        }
        MeasureUnitInfo defaultMu = null;
        for (BgElementInfo elementInfo : amountUnitMap.keySet()) {
            if (elementInfo.getNumber().equals(element)) {
                MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)amountUnitMap.get(elementInfo);
                return measureUnitInfo.getCoefficient();
            }
            if (!"BOOK_DEF_MEASUREUNIT".equals(elementInfo.getNumber())) continue;
            defaultMu = (MeasureUnitInfo)amountUnitMap.get(elementInfo);
        }
        if (defaultMu == null) {
            return ONE;
        }
        return defaultMu.getCoefficient();
    }

    protected void fillDataToTable(Sheet sheet, List analysisColsList, int initRowIndex, String orgUnitId, Map amountUnitMap) throws EASBizException, BOSException {
        StyleAttributes cellSa = Styles.getEmptySA();
        cellSa.setLocked(true);
        cellSa.setNumberFormat(this.getNumberFormat(null));
        cellSa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        int rowCount = sheet.getMaxRowIndex() + 1;
        BigDecimal amountUnit = ONE;
        for (int rowIndex = initRowIndex; rowIndex < rowCount; ++rowIndex) {
            int colNum = analysisColIndexList.size();
            for (int k = 0; k < colNum; ++k) {
                int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
                Cell cell = sheet.getCell(rowIndex, analysisColIndex, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
                    amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
                    int num = analysisColsList.size();
                    for (int j = 0; j < num; ++j) {
                        int addedColIndex = analysisColIndex + j;
                        Column col = sheet.getColumn(addedColIndex, false);
                        Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                        if (!(colKey instanceof String)) continue;
                        Object val = null;
                        try {
                            val = this.getAnalysisSysFacade().getDataDealCenter().getDataFactory(bgItem, colKey.toString(), orgUnitId, ONE);
                        }
                        catch (SecurityException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        catch (IllegalArgumentException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        catch (NoSuchMethodException e) {
                        }
                        catch (IllegalAccessException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        catch (InvocationTargetException e) {
                            this.handleException(e);
                            SysUtil.abort();
                        }
                        this.setCellValue(sheet, rowIndex, addedColIndex, val, amountUnit);
                    }
                    continue;
                }
                if (bgFormula != null && !bgFormula.equals("")) {
                    String[] bgFormulaAry;
                    if (!BgNFSHelper.checkHasTextOfCell((Cell)cell) && BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
                        cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                    }
                    if (!BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                    String currentOrgNum = this.getOrgUnitNumber(orgUnitId);
                    if (currentOrgNum.equals((bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula))[0])) {
                        this.initBgFormulaDataFactory(bgFormulaAry, bgFormula);
                    } else {
                        BgNFSHelper.setExpression((Cell)cell, (String)BgFormulaHelper.rebulidBgFormula(bgFormulaAry));
                    }
                    amountUnit = this.reSetAmountUnit(bgFormulaAry[2], amountUnitMap);
                    int num = analysisColsList.size();
                    for (int j = 0; j < num; ++j) {
                        int addedColIndex = analysisColIndex + j;
                        Column col = sheet.getColumn(addedColIndex, false);
                        Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                        if (!(colKey instanceof String)) continue;
                        Object val = this.getFetchStandardDataForBgFormulaFactory().getDataFactory(bgFormula, colKey.toString(), orgUnitId, ONE);
                        this.setCellValue(sheet, rowIndex, addedColIndex, val, amountUnit);
                    }
                    continue;
                }
                if (BgNFSHelper.checkHasTextOfCell((Cell)cell) || !BgNFSHelper.checkIsNumericOfCell((Cell)cell)) continue;
                cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
            }
            this.fillDataToEntireTbl(sheet, rowIndex, orgUnitId, amountUnitMap, 0);
        }
    }

    private String getOrgUnitNumber(String orgUnitId) {
        FullOrgUnitInfo orgUnitInfo = null;
        try {
            orgUnitInfo = this.getFullOrgUnitInterface().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return orgUnitInfo != null ? orgUnitInfo.getNumber() : "";
    }

    private void initBgFormulaDataFactory(String[] bgFormulaAry, String bgFormula) throws EASBizException, BOSException {
        NewBgCompareAndAnalysisFilterParam filter1Params = this.getFilterUIParams();
        NewBgCompareAndAnalysisFilterParam filter2Params = this.getFilterUI2Params();
        this.getFetchStandardDataForBgFormulaFactory().initDataFactory(bgFormula, filter1Params, filter2Params);
    }

    protected void fillSubOrgDataToTable(Sheet sheet, List analysisColsList, int initRowIndex, String orgUnitId, Map amountUnitMap) throws EASBizException, BOSException {
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        BigDecimal amountUnit = ONE;
        int colNum = analysisColIndexList.size();
        for (int k = 0; k < colNum; ++k) {
            int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
            Cell cell = sheet.getCell(initRowIndex, analysisColIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
                amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
                int num = analysisColsList.size();
                for (int j = 0; j < num; ++j) {
                    int addedColIndex = analysisColIndex + j;
                    Column col = sheet.getColumn(addedColIndex, false);
                    Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                    if (!(colKey instanceof String)) continue;
                    Object val = null;
                    try {
                        val = this.getAnalysisSysFacade().getDataDealCenter().getDataFactory(bgItem, colKey.toString(), orgUnitId, ONE);
                    }
                    catch (SecurityException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (IllegalArgumentException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (NoSuchMethodException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (IllegalAccessException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    catch (InvocationTargetException e) {
                        this.handleException(e);
                        SysUtil.abort();
                    }
                    this.setCellValue(sheet, initRowIndex, addedColIndex, val, amountUnit);
                }
                continue;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
            String currentOrgNum = this.getOrgUnitNumber(orgUnitId);
            String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
            amountUnit = this.reSetAmountUnit(bgFormulaAry[2], amountUnitMap);
            int num = analysisColsList.size();
            for (int j = 0; j < num; ++j) {
                int addedColIndex = analysisColIndex + j;
                Column col = sheet.getColumn(addedColIndex, false);
                Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
                Object val = null;
                if (!"".equals(bgFormulaAry[0])) {
                    String newBgFormula = BgFormulaHelper.rebulidBgFormulaWithOrgUnitParam(bgFormulaAry, currentOrgNum);
                    this.initBgFormulaDataFactory(bgFormulaAry, newBgFormula);
                    if (colKey instanceof String) {
                        val = this.getFetchStandardDataForBgFormulaFactory().getDataFactory(newBgFormula, colKey.toString(), orgUnitId, ONE);
                    }
                } else {
                    val = new BigDecimal("0.00");
                }
                this.setCellValue(sheet, initRowIndex, addedColIndex, val, amountUnit);
            }
        }
    }

    private BgAnalyseFilterBaseUI getFilterUIByFilterUIKey(String filterUIKey) {
        if (NewBgCompareAndAnalysisFilterUI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filterUI == null) {
                    this.filterUI = new NewBgCompareAndAnalysisFilterUI();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            return this.filterUI;
        }
        if (NewBgCompareAndAnaylsisFilter2UI.FILTER_UI_KEY.equals(filterUIKey)) {
            try {
                if (this.filter2UI == null) {
                    this.filter2UI = new NewBgCompareAndAnaylsisFilter2UI();
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            return this.filter2UI;
        }
        return null;
    }

    protected Book addAndInitTable(NewBgCompareAndAnalysisFilterParam filter1Params) {
        UserInfo create;
        if (this.book != null) {
            return this.book;
        }
        if (this.sc != null) {
            this.TabPaneMain.remove((Component)this.sc);
        }
        String bgFormID = filter1Params.getBgFormID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("data");
        sic.add("currency");
        sic.add("currency.precision");
        sic.add("bgTemplate.id");
        sic.add("creator.id");
        Book book = null;
        BgFormInfo bgFormInfo = null;
        try {
            bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormID), sic);
            if (bgFormInfo == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"81_NewBgCompareAndAnalysisFacadeControllerBean"));
                SysUtil.abort();
            }
            this.setCurrency(bgFormInfo.getCurrency());
            BgIOHelper bih = new BgIOHelper();
            bih.setIDoForBook(new BgCompareAndAnalysisDoForBook());
            book = bih.getBook(bgFormInfo.getData());
            BgNFSHelper.disableCal((Book)book);
            BgNFSHelper.disableUndo((Book)book);
        }
        catch (Exception ex) {
            if (book != null) {
                book = null;
            }
            ExceptionHandler.handle((Throwable)ex);
            SysUtil.abort();
        }
        boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed();
        Map sheetPer = null;
        Sheet _sheet = null;
        boolean isShowSheet = false;
        String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (isSheetPer) {
            sheetPer = this.addBgSheetPermission(bgFormInfo.getBgTemplate().getId().toString());
        }
        if ((create = bgFormInfo.getCreator()) != null && book != null) {
            int n = book.getSheetCount();
            for (int i = 0; i < n; ++i) {
                if (book.getSheet(i).getUserObject("SHEET_CREATER_ID") != null) continue;
                book.getSheet(i).setUserObject("SHEET_CREATER_ID", (Object)create.getId().toString());
            }
        }
        if (book != null) {
            int sheetIndex = 0;
            int sheetSize = book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = book.getSheet(sheetIndex);
                if (isSheetPer) {
                    if (!isShowSheet) {
                        isShowSheet = this.hideSheet(_sheet, sheetPer, user);
                        continue;
                    }
                    this.hideSheet(_sheet, sheetPer, user);
                    continue;
                }
                _sheet.setHide(false);
            }
        }
        if (isSheetPer && !isShowSheet) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"292_BgOrgBasedListUI"));
            SysUtil.abort();
        }
        if (book != null && book.getSheet(0) != null) {
            this.sc = new SpreadContext();
            BudgetUserCellDisplayProvider dp = new BudgetUserCellDisplayProvider();
            dp.setDisplayValueProvider(new NumberDisplayProvider());
            this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)dp);
            this.sc.addBookChangeListener(new BookChangeListener(){

                public void changed(BookChangeEvent e) {
                    if (e.isSheetActive()) {
                        NewBgCompareAndAnalysisMainUI.this.onSheetActive(e.getSheet());
                    }
                }
            });
            if (this instanceof NewDirectedBgCompareAndAnalysisMainUI || this instanceof NewBgCompareAndAnalysisSavedFormMainUI) {
                ActionManager actionManager = this.sc.getActionManager();
                MyDelete_Col_Action myMerageAction = new MyDelete_Col_Action(this.sc);
                myMerageAction.setEnabled(true);
                myMerageAction.setAtomic(true);
                myMerageAction.setVisible(true);
                actionManager.putAction("Delete_Col", (SpreadAction)myMerageAction);
                MyDelete_Row_Action myMerageAction1 = new MyDelete_Row_Action(this.sc);
                myMerageAction1.setEnabled(true);
                myMerageAction1.setAtomic(true);
                myMerageAction1.setVisible(true);
                actionManager.putAction("Delete_Row", (SpreadAction)myMerageAction1);
            }
            this.TabPaneMain.add((Component)this.sc, (Object)"Center");
            this.TabPaneMain.setTitleAt(0, this.getTabPaneMainUITitle());
        }
        return book;
    }

    private Map addBgSheetPermission(String templateId) {
        if (templateId == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(templateId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission(null, hasPer);
            if (hasPer != null && hasPer.get(templateId) != null) {
                sheetPer = (Map)hasPer.get(templateId);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return sheetPer;
    }

    private boolean hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        boolean isShowSheet = false;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign((Sheet)_sheet))) {
            _sheet.setHide(false);
            isShowSheet = true;
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null) {
                if (!sheetCreater.equals(user)) {
                    _sheet.setHide(true);
                } else {
                    _sheet.setHide(false);
                    isShowSheet = true;
                }
            } else {
                _sheet.setHide(true);
            }
        }
        return isShowSheet;
    }

    protected void onSheetActive(Sheet sheet) {
        NewBgCompareAndAnalysisMainUI.setAllNumberRightA(sheet);
    }

    protected String getTabPaneMainUITitle() {
        return EASResource.getString((String)resourcePath, (String)"BgCompareAndAnalysisTitle");
    }

    protected int constructSheet(NewBgCompareAndAnalysisFilterParam filter1Param, List analysisElementList, Sheet sheet) {
        Map analysisColsMap = filter1Param.getAnalysisColsMap();
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String key = sheetID + "&" + sheetName;
        List analysisColsList = (List)analysisColsMap.get(key);
        if (analysisColsList == null) {
            return 0;
        }
        Map titleColsMap = filter1Param.getTitleColsMap();
        List titleColsList = null;
        if (titleColsMap != null) {
            titleColsList = (List)titleColsMap.get(key);
        }
        if (titleColsList != null && titleColsList.size() != 0) {
            this.removeUnRequiredCols(titleColsList, analysisColsList, sheet);
        } else {
            this.removeUnRequiredCols(analysisColsList, sheet);
        }
        int rowIndex = this.locateAddedNewRowIndex(sheet);
        Row addRow = BgNFSHelper.addRow((Sheet)sheet, (int)rowIndex, (boolean)false);
        addRow.setUserObject(ADD_ROW_FLAG, (Object)"addRow");
        this.addAnalysisCols(analysisElementList, rowIndex, sheet);
        this.removeOldColumns(sheet);
        this.accessorizeNewTable(analysisElementList.size(), rowIndex, sheet);
        this.addOrgUnitByCol(filter1Param, rowIndex + 1, sheet);
        return rowIndex;
    }

    private void removeUnRequiredCols(List titleList, List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (titleList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)TITLE_FLAG);
                continue;
            }
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)ANALYSIS_FLAG);
                continue;
            }
            try {
                BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
        }
    }

    private void removeUnRequiredCols(List analysisList, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            if (analysisList.contains(new Integer(i))) {
                BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)ANALYSIS_FLAG);
                continue;
            }
            BgNFSHelper.setColObject((Column)sheet.getColumn(i, false), (String)COL_KEY, (Object)TITLE_FLAG);
        }
    }

    @Override
    protected int getHeightOfDialog() {
        return 400;
    }

    protected void addTableListener() {
        this.getSc().getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(this.sc));
        this.getSc().getBook().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                try {
                    if (e.isSheetActive()) {
                        NewBgCompareAndAnalysisMainUI.this.sheetActive(e.getSheet());
                    }
                }
                catch (Exception ex) {
                    NewBgCompareAndAnalysisMainUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void sheetActive(Sheet sheet) throws Exception {
        if (sheet == null) {
            return;
        }
        Range range = sheet.getRange(0, 0);
        if (range != null) {
            range.select();
        }
        this.getSc().getSpread().scrollCellVisible(0, 0);
    }

    private IFullOrgUnit getFullOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    private void addOrgUnitByCol(NewBgCompareAndAnalysisFilterParam filter1Param, int beginRow, Sheet sheet) {
        CostCenterOrgUnitInfo[] orgInfoAry = filter1Param.getCostCenterOrgUnitInfoAry();
        int num = orgInfoAry.length;
        String[] companyIds = new String[num];
        for (int i = 0; i < num; ++i) {
            companyIds[i] = orgInfoAry[i].getId().toString();
        }
        if (companyIds != null && companyIds.length != 0) {
            FullOrgUnitInfo baseOrgUnit = null;
            try {
                baseOrgUnit = (FullOrgUnitInfo)this.getFullOrgUnitInterface().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyIds[0])));
            }
            catch (Exception e) {
                this.handleException(e);
            }
            Column column = BgNFSHelper.addColumn((Sheet)sheet, (int)0, (boolean)false);
            int colIndex = column.getCol();
            sheet.getColRange(colIndex, colIndex).setColumnWidth(200);
            ViewSplitInfo vsi = sheet.getSheetOption().getViewSplitInfo();
            if (vsi != null && vsi.isFreezed()) {
                boolean isChangeCol;
                boolean bl = isChangeCol = vsi.getFirstCol() > 0;
                if (isChangeCol) {
                    vsi.setFirstCol(vsi.getFirstCol() + 1);
                }
                if (vsi.getFirstCol2() > 0) {
                    vsi.setFirstCol2(vsi.getFirstCol2() + 1);
                }
                if (!isChangeCol) {
                    vsi.setColSplit(vsi.getColSplit() + 1);
                }
            }
            if (companyIds.length > 1) {
                this.render = new OrgUnitRender();
                BudgetUserCellDisplayProvider dp = new BudgetUserCellDisplayProvider();
                dp.addRenderProvider(this.render);
                this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)dp);
            }
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            MergeBlocks blocks = sheet.getMerger(false);
            CellBlock block = null;
            Cell firstCell = null;
            for (int rowIndex = beginRow; rowIndex < rowCount; ++rowIndex) {
                if (!this.checkHasBgItem(sheet, rowIndex)) continue;
                if (blocks != null && !blocks.isEmpty()) {
                    for (int i = 0; i < colCount; ++i) {
                        if (sheet.getCell(rowIndex, i, false) == null || (block = sheet.getCell(rowIndex, i, false).getMerge(false)) == null || (firstCell = sheet.getCell(block.getRow(), block.getCol(), false)) == null) continue;
                        int n = block.getRow2();
                        for (int ii = block.getRow(); ii <= n; ++ii) {
                            BgNFSHelper.setValue((Cell)sheet.getCell(ii, block.getCol(), true), (Object)BgNFSHelper.getValue((Cell)firstCell));
                        }
                    }
                }
                this.addExpandInfo(sheet.getCell(rowIndex, column.getCol(), true), baseOrgUnit, companyIds.length);
            }
        }
    }

    protected void addExpandInfo(Cell cell, FullOrgUnitInfo orgUnitInfo, int orgNum) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setLevel(0);
        expandInfo.setExpandStatus(false);
        if (orgNum == 1) {
            expandInfo.setLeaf(true);
        } else {
            expandInfo.setLeaf(false);
        }
        this.setCellStyle(cell);
        BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)expandInfo);
        if (orgNum == 1) {
            BgNFSHelper.setValue((Cell)cell, (Object)orgUnitInfo.getName());
        }
    }

    protected void setCellStyle(Cell cell) {
    }

    private boolean checkHasBgItem(Sheet sheet, int rowIndex) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int colIndex = colNum - 1; colIndex >= 0; --colIndex) {
            Column col = sheet.getColumn(colIndex, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
            return true;
        }
        return false;
    }

    private void accessorizeNewTable(int mergeColNum, int rowIndex, Sheet sheet) {
        int num = sheet.getMaxColIndex();
        for (int i = num - 1; i >= 0; --i) {
            String colKey;
            Column col = sheet.getColumn(i, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (!(obj instanceof String) || !ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            for (int j = rowIndex - 1; j >= 0; --j) {
                Cell cell = sheet.getCell(j, i, false);
                if (cell == null || !BgNFSHelper.checkHasCurrencyInfo((Cell)cell) && !BgNFSHelper.checkHasBgElementInfo((Cell)cell) && !BgNFSHelper.checkHasBgItemInfo((Cell)cell) && !BgNFSHelper.checkHasBgPeriodInfo((Cell)cell)) continue;
                sheet.getRange(j, i, j, mergeColNum + i - 1).merge();
            }
        }
    }

    private boolean isRealAnalysisCol(Column column, Sheet sheet) {
        int colIndex = column.getCol();
        int num = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < num; ++i) {
            String tempBgItem;
            Cell cell = sheet.getCell(i, colIndex, false);
            if (cell == null) continue;
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                return true;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula) || "".equals(tempBgItem = AnalysisColumnTool.changeBgFormulaToBgItem(bgFormula))) continue;
            return true;
        }
        return false;
    }

    private void addAnalysisCols(List analysisElementList, int rowIndex, Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)COL_KEY);
            if (!ANALYSIS_FLAG.equals(colKey)) continue;
            if (!this.isRealAnalysisCol(col, sheet)) {
                BgNFSHelper.setColObject((Column)col, (String)COL_KEY, null);
                continue;
            }
            int num = analysisElementList.size();
            for (int j = 0; j < num; ++j) {
                int colIndex = i + j + 1;
                Column column = BgNFSHelper.addColumn((Sheet)sheet, (int)colIndex, (boolean)true);
                String proName = analysisElementList.get(j).toString();
                BgNFSHelper.setColObject((Column)column, (String)COL_KEY, (Object)proName);
                try {
                    BgNFSHelper.setValue((Cell)sheet.getCell(rowIndex, colIndex, true), (Object)AnalysisColumnTool.getProValByProName(proName, this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().getAnalysisEleClass()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.handleException(e);
                    SysUtil.abort();
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.handleException(e);
                    SysUtil.abort();
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
            }
        }
    }

    private void removeOldColumns(Sheet sheet) {
        int colNum = sheet.getMaxColIndex() + 1;
        for (int i = colNum - 1; i >= 0; --i) {
            Column oldCol = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)oldCol, (String)COL_KEY);
            Row row = null;
            if (colKey == null || !ANALYSIS_FLAG.equals(colKey)) continue;
            int newAnalysisColIndex = i + 1;
            Column newAnalysisCol = sheet.getColumn(newAnalysisColIndex, false);
            BgNFSHelper.setColObject((Column)newAnalysisCol, (String)NEW_ANALYSIS_COL_KEY, (Object)ANALYSIS_FLAG);
            int num = sheet.getMaxRowIndex() + 1;
            for (int j = 0; j < num; ++j) {
                Cell newCell;
                Cell cell;
                row = sheet.getRow(j, false);
                if (row != null && row.getUserObjectValue(ADD_ROW_FLAG) != null && row.getUserObjectValue(ADD_ROW_FLAG).toString().equals("addRow") || (cell = sheet.getCell(j, i, false)) == null) continue;
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                String[] bgPeriod = BgNFSHelper.getBgPeriodInfo((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setFormulaOfCell((Cell)newCell, (String)bgItem, (boolean)true);
                } else if (BgNFSHelper.checkHasExpression((Cell)cell)) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setExpression((Cell)newCell, (String)bgFormula);
                } else if (bgPeriod != null) {
                    newCell = sheet.getCell(j, newAnalysisColIndex, true);
                    BgNFSHelper.setBgPeriodInfo((Cell)newCell, (String)bgPeriod[1]);
                }
                Object txtCellObj = BgNFSHelper.getValue((Cell)cell);
                if (txtCellObj == null) continue;
                Cell newCell2 = sheet.getCell(j, newAnalysisColIndex, true);
                BgNFSHelper.setValue((Cell)newCell2, (Object)txtCellObj);
            }
            boolean isDelete = BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
            if (isDelete) continue;
            BgNFSHelper.setSheetProtection((Sheet)sheet, (boolean)false);
            BgNFSHelper.removeColumn((Sheet)sheet, (int)i);
        }
    }

    protected void fillDataToEntireTbl(Sheet sheet, int rowIndex, String orgUnitId, Map amountUnitMap, int difRowNum) {
        int colCount = sheet.getMaxColIndex() + 1;
        BigDecimal amountUnit = ONE;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            String upBgItem;
            String colKey;
            Column col = sheet.getColumn(colIndex, false);
            Object obj = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (obj instanceof String && ANALYSIS_FLAG.equals(colKey = obj.toString())) continue;
            Cell cell = sheet.getCell(rowIndex, colIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
                amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
                Object val = null;
                try {
                    val = this.getAnalysisSysFacade().getDataDealCenter().getDataFactory(bgItem, "col4", orgUnitId, ONE);
                }
                catch (SecurityException e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
                catch (IllegalArgumentException e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
                catch (NoSuchMethodException e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
                catch (IllegalAccessException e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
                catch (InvocationTargetException e) {
                    this.handleException(e);
                    SysUtil.abort();
                }
                this.setCellValue(sheet, rowIndex, colIndex, val, amountUnit);
                continue;
            }
            if (bgItem != null || (upBgItem = this.findBgItem(sheet, rowIndex, colIndex, difRowNum)) == null || "".equals(upBgItem)) continue;
            BgNFSHelper.setFormulaOfCell((Cell)sheet.getCell(rowIndex, colIndex, true), (String)upBgItem, (boolean)true);
            String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(upBgItem);
            amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
            Object val = null;
            try {
                val = this.getAnalysisSysFacade().getDataDealCenter().getDataFactory(upBgItem, "col4", orgUnitId, ONE);
            }
            catch (SecurityException e) {
                this.handleException(e);
                SysUtil.abort();
            }
            catch (IllegalArgumentException e) {
                this.handleException(e);
                SysUtil.abort();
            }
            catch (NoSuchMethodException e) {
                this.handleException(e);
                SysUtil.abort();
            }
            catch (IllegalAccessException e) {
                this.handleException(e);
                SysUtil.abort();
            }
            catch (InvocationTargetException e) {
                this.handleException(e);
                SysUtil.abort();
            }
            this.setCellValue(sheet, rowIndex, colIndex, val, amountUnit);
        }
    }

    private String findBgItem(Sheet sheet, int rowIndex, int colIndex, int difRowNum) {
        if (difRowNum == 0) {
            return null;
        }
        Cell cell = sheet.getCell(rowIndex - difRowNum, colIndex, false);
        String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
        if (bgItem != null && !"".equals(bgItem)) {
            return bgItem;
        }
        return null;
    }

    private void removeBeginNullRows(Sheet sheet) {
        int rowCount;
        Row row = null;
        for (int rowIndex = rowCount = sheet.getMaxColIndex() + 1; rowIndex >= 0; --rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (BgNFSHelper.checkHasSign((Row)row)) continue;
            BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
        }
    }

    private int locateAddedNewRowIndex(Sheet sheet) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        boolean continueFlag = true;
        int rowIndex = 0;
        block0: for (int i = 0; i < rowCount && continueFlag; ++i) {
            for (int j = 0; j < colCount && continueFlag; ++j) {
                Cell cell = sheet.getCell(i, j, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    rowIndex = cell.getRow();
                    continueFlag = false;
                    continue block0;
                }
                if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                rowIndex = cell.getRow();
                continueFlag = false;
                continue block0;
            }
        }
        return rowIndex;
    }

    private void removeBeginNullCols(Sheet sheet) {
        int colCount;
        for (int colIndex = colCount = sheet.getMaxColIndex() + 1; colIndex >= 0; --colIndex) {
            Column col = sheet.getColumn(colIndex, false);
            if (BgNFSHelper.checkHasSign((Column)col)) continue;
            BgNFSHelper.removeColumn((Sheet)sheet, (int)colIndex);
        }
    }

    protected NewBgCompareAndAnalysisFilterParam getFilterUIParams() {
        if (this.getDirectFilterParam() != null) {
            return this.getDirectFilterParam();
        }
        NewBgCompareAndAnalysisFilterUI tempFilterUI = (NewBgCompareAndAnalysisFilterUI)this.getFilterUI();
        NewBgCompareAndAnalysisFilterParam filterParam = tempFilterUI.getOwnFilterParam();
        return filterParam;
    }

    protected NewBgCompareAndAnalysisFilterParam getFilterUI2Params() {
        if (this.getDirectFilterParam() != null) {
            return this.getDirectFilterParam();
        }
        KDPanel[] panels = this.getOtherFilterUI();
        this.filter2UI = (NewBgCompareAndAnaylsisFilter2UI)panels[0];
        return this.filter2UI.getOwnFilterParam();
    }

    protected void setTreeDisplayStyle(Cell cell, NumberExpandInfo expandInfo, Sheet sheet) {
        try {
            this.expandTable(cell, expandInfo, sheet);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
        NewBgCompareAndAnalysisMainUI.setAllNumberRightA(sheet);
        this.sc.getSpread().repaint();
    }

    private void expandTable(Cell cell, NumberExpandInfo parentExpandInfo, Sheet sheet) throws EASBizException, BOSException {
        Row childRow = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)parentExpandInfo);
            int beginRowIndex = cell.getRow() + 1;
            int rowCount = sheet.getMaxRowIndex() + 1;
            ArrayList<Integer> delList = new ArrayList<Integer>();
            for (int rowIndex = beginRowIndex; rowIndex < rowCount; ++rowIndex) {
                NumberExpandInfo childExpandInfo;
                Cell tempCell;
                childRow = sheet.getRow(rowIndex, false);
                if (childRow == null || (tempCell = childRow.getCell(0, false)) == null || (childExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)tempCell)) == null) continue;
                longnumber = childExpandInfo.getLongNumber();
                if (!longnumber.startsWith(plongnumber + "!")) break;
                delList.add(new Integer(childRow.getRow()));
            }
            this.deleteUnvisibleRows(sheet, delList, beginRowIndex);
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            BgNFCHelper.setNumberExpandInfo((Cell)cell, (NumberExpandInfo)parentExpandInfo);
            int rowCount = sheet.getMaxRowIndex() + 1;
            if (rowIndex >= rowCount - 1) {
                this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
            } else {
                for (rowIndex = cell.getRow(); rowIndex < rowCount - 1; ++rowIndex) {
                    childRow = sheet.getRow(rowIndex, false);
                    NumberExpandInfo childExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)childRow.getCell(0, false));
                    if (childExpandInfo != null) {
                        longnumber = childExpandInfo.getLongNumber();
                        if (rowIndex != cell.getRow()) break;
                        this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
                        break;
                    }
                    if (rowIndex != cell.getRow()) continue;
                    this.addChildRowByOrgUnitParentInfo(sheet, rowIndex, parentExpandInfo);
                }
            }
        }
    }

    private void deleteUnvisibleRows(Sheet sheet, List rowIndexList, int endRowIndex) {
        int rowIndex;
        BgNFSHelper.setSheetProtection((Sheet)sheet, (boolean)false);
        for (int i = rowIndexList.size() - 1; i > -1 && (rowIndex = Integer.valueOf(rowIndexList.get(i).toString()).intValue()) >= endRowIndex; --i) {
            BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
        }
    }

    private void addChildRowByOrgUnitParentInfo(Sheet sheet, int beginRow, NumberExpandInfo parentExpandInfo) throws EASBizException, BOSException {
        String parentLN;
        NewBgCompareAndAnalysisFilterParam filter1Params = this.getFilterUIParams();
        CostCenterOrgUnitInfo[] orgUnitInfoAry = filter1Params.getCostCenterOrgUnitInfoAry();
        Map amountUnitMap = filter1Params.getMeasureUnitInfoMap();
        Map map = this.dealWithOrgUnit(orgUnitInfoAry);
        Object obj = map.get(parentLN = parentExpandInfo.getLongNumber());
        if (obj == null) {
            return;
        }
        AnalysisColumnTool.SubNode subNode = (AnalysisColumnTool.SubNode)obj;
        List subNodeList = this.getSubNodeList(subNode.getSubNodeList(), orgUnitInfoAry);
        Object[] ary = new CostCenterOrgUnitInfo[subNodeList.size()];
        int num = subNodeList.size();
        for (int i = 0; i < num; ++i) {
            ary[i] = (CostCenterOrgUnitInfo)subNodeList.get(i);
        }
        this.rebuildFilter1Params(filter1Params, ary);
        NewBgCompareAndAnalysisFilterParam filter2Params = this.getFilterUI2Params();
        List analysisElementList = filter2Params.getAnalysisElement();
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        int num2 = subNodeList.size();
        for (int i = 0; i < num2; ++i) {
            CostCenterOrgUnitInfo info = (CostCenterOrgUnitInfo)subNodeList.get(i);
            String orgUnitId = info.getId().toString();
            NumberExpandInfo expandInfo = this.copyOrgUnitInfoToExpendInfo(info, map);
            int rowIndex = beginRow + i + 1;
            Row row = BgNFSHelper.addRow((Sheet)sheet, (int)rowIndex, (boolean)false);
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(0, true), (NumberExpandInfo)expandInfo);
            int _num = analysisColIndexList.size();
            String[] formulaAry = new String[_num];
            for (int j = 0; j < _num; ++j) {
                int analysisColIndex = Integer.valueOf(analysisColIndexList.get(j).toString());
                Cell cell = sheet.getCell(beginRow, analysisColIndex, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                String bgFormula = BgNFSHelper.getExpression((Cell)cell);
                if (bgItem != null && !"".equals(bgItem)) {
                    formulaAry[j] = bgItem;
                    BgNFSHelper.setFormulaOfCell((Cell)sheet.getCell(rowIndex, analysisColIndex, true), (String)bgItem, (boolean)true);
                    continue;
                }
                if (bgFormula == null || "".equals(bgFormula) || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
                BgNFSHelper.setExpression((Cell)sheet.getCell(rowIndex, analysisColIndex, true), (String)bgFormula);
            }
            try {
                this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().initSubOrgDataFactory(filter1Params, filter2Params, formulaAry);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
            this.fillSubOrgDataToTable(sheet, analysisElementList, rowIndex, orgUnitId, amountUnitMap);
            int difRowNum = i + 1;
            this.fillDataToEntireTbl(sheet, rowIndex, orgUnitId, amountUnitMap, difRowNum);
        }
        if (filter1Params.isShowColRow()) {
            NumberExpandInfo expandInfo = new NumberExpandInfo();
            expandInfo.setLongNumber(parentExpandInfo.getLongNumber() + "!");
            expandInfo.setName(EASResource.getString((String)resourcePath, (String)"collect"));
            expandInfo.setLeaf(true);
            int sumRowIndex = beginRow + 1;
            Row row = BgNFSHelper.addRow((Sheet)sheet, (int)sumRowIndex, (boolean)false);
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(0, true), (NumberExpandInfo)expandInfo);
            this.fillDataToEntireSumRow(sheet, sumRowIndex, subNodeList.size(), analysisElementList.size(), analysisColIndexList);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setBackground(BgSHelper.COLLECT_COLOR);
            sheet.getRowRange(row.getRow(), row.getRow()).setStyle(sa, Styles.getEmptySA());
        }
    }

    private void fillDataToSumRow(Sheet sheet, int sumRowIndex, int subNodeSize, int analysisElementNum, List analysisColIndexList, int analysisColIndex) {
        for (int j = 0; j < analysisElementNum; ++j) {
            int colIndex = j + analysisColIndex;
            Cell cell = sheet.getCell(sumRowIndex, colIndex, true);
            BgNFSHelper.setValue((Cell)cell, (Object)this.countSumVal(sheet, sumRowIndex, subNodeSize, colIndex));
        }
    }

    private void fillDataToEntireSumRow(Sheet sheet, int sumRowIndex, int subNodeSize, int analysisElementNum, List analysisColIndexList) {
        int colCount = sheet.getMaxColIndex() + 1;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            Object obj = BgNFSHelper.getColObject((Column)sheet.getColumn(colIndex, true), (String)NEW_ANALYSIS_COL_KEY);
            if (obj instanceof String) {
                String colKey = obj.toString();
                if (!ANALYSIS_FLAG.equals(colKey)) continue;
                this.fillDataToSumRow(sheet, sumRowIndex, subNodeSize, analysisElementNum, analysisColIndexList, colIndex);
                continue;
            }
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)sheet.getCell(sumRowIndex - 1, colIndex, true));
            if (bgItem == null || "".equals(bgItem)) continue;
            BgNFSHelper.setValue((Cell)sheet.getCell(sumRowIndex, colIndex, true), (Object)this.countSumVal(sheet, sumRowIndex, subNodeSize, colIndex));
        }
    }

    private Object countSumVal(Sheet sheet, int sumRowIndex, int subNodeSize, int colIndex) {
        Object obj = null;
        BigDecimal sumVal = new BigDecimal("0.00");
        BigDecimal fenmuVal = new BigDecimal("0.00");
        BigDecimal fenziVal = new BigDecimal("0.00");
        RatePopoInfo rateInfo = null;
        boolean isRateData = false;
        int scale = 2;
        for (int i = 1; i <= subNodeSize; ++i) {
            BigDecimal val;
            obj = BgNFSHelper.getValue((Cell)sheet.getCell(sumRowIndex + i, colIndex, false));
            if (obj instanceof String) {
                val = this.getNumberFromStrForm((String)obj);
                if (val == null) {
                    return "";
                }
                sumVal = sumVal.add(val);
                continue;
            }
            if (obj instanceof BigDecimal) {
                val = (BigDecimal)obj;
                sumVal = sumVal.add(val);
                continue;
            }
            if (!(obj instanceof RatePopoInfo)) continue;
            rateInfo = (RatePopoInfo)obj;
            fenmuVal = fenmuVal.add(rateInfo.getFenmu());
            fenziVal = fenziVal.add(rateInfo.getFenzi());
            isRateData = true;
            if (rateInfo.getScale() <= 2) continue;
            scale = rateInfo.getScale();
        }
        if (isRateData) {
            rateInfo = new RatePopoInfo(fenziVal, fenmuVal);
            rateInfo.setScale(scale);
            rateInfo.initReuslt();
            return rateInfo.toString();
        }
        return DataDealCenter.decFormat.format(sumVal);
    }

    private BigDecimal getNumberFromStrForm(String str) {
        BigDecimal bg = null;
        if (str.indexOf("%") != -1) {
            return null;
        }
        str = str.replaceAll(",", "");
        try {
            bg = new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            this.handleException(e);
            SysUtil.abort();
        }
        return bg;
    }

    private List getSubNodeList(List subNodeLNList, CostCenterOrgUnitInfo[] ary) {
        ArrayList<CostCenterOrgUnitInfo> subNodeList = new ArrayList<CostCenterOrgUnitInfo>();
        for (CostCenterOrgUnitInfo tempInfo : ary) {
            String tempLN = tempInfo.getLongNumber();
            if (!subNodeLNList.contains(tempLN)) continue;
            subNodeList.add(tempInfo);
        }
        return subNodeList;
    }

    private NumberExpandInfo copyOrgUnitInfoToExpendInfo(CostCenterOrgUnitInfo orgUnitInfo, Map map) {
        NumberExpandInfo expandInfo = new NumberExpandInfo();
        expandInfo.setId(orgUnitInfo.getId().toString());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setLevel(orgUnitInfo.getLevel());
        String longNumber = orgUnitInfo.getLongNumber();
        expandInfo.setLongNumber(longNumber);
        if (map.get(longNumber) != null) {
            expandInfo.setLeaf(false);
        } else {
            expandInfo.setLeaf(true);
        }
        return expandInfo;
    }

    protected Map dealWithOrgUnit(CostCenterOrgUnitInfo[] array) {
        Map map;
        if (!this.compareArray(array)) {
            return CACHE_MAP;
        }
        CACHE_MAP = map = AnalysisColumnTool.dealWithOrgUnit((OrgUnitInfo[])array);
        return map;
    }

    private boolean compareArray(CostCenterOrgUnitInfo[] newAry) {
        if (CACHE_ARY == null) {
            CACHE_ARY = newAry;
            return true;
        }
        if (newAry.length != CACHE_ARY.length) {
            return false;
        }
        List<CostCenterOrgUnitInfo> list = Arrays.asList(CACHE_ARY);
        for (CostCenterOrgUnitInfo tempInfo : newAry) {
            if (list.contains(tempInfo)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getQueryMainName() {
        return NewBgCompareAndAnalysisMainUI.class.getName();
    }

    @Override
    public void actionViewAdjustValue_actionPerformed(ActionEvent e) throws Exception {
        String[] conditionAry = this.getQueryConditions();
        NewBgCompareAndAnalysisFilterParam filterParams = this.getFilterUIParams();
        List list = BgCompareAndAnalysisFacadeFactory.getRemoteInstance().getBudgetViewValueList(filterParams, conditionAry[0], conditionAry[1]);
        if (list == null) {
            return;
        }
        this.createViewUI(list, "budget", conditionAry[1]);
    }

    protected IBgSelfDefineFacade getRptInterface() throws BOSException {
        return BgSelfDefineFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionViewActualValue_actionPerformed(ActionEvent e) throws Exception {
        String[] conditionAry = this.getQueryActualConditions();
        NewBgCompareAndAnalysisFilterParam filterParams = this.getFilterUIParams();
        if (conditionAry == null || StringUtils.isEmpty((String)conditionAry[0]) || StringUtils.isEmpty((String)conditionAry[1]) || StringUtils.isEmpty((String)conditionAry[2])) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"Unavailable_Formula"));
            return;
        }
        if (conditionAry == null || conditionAry.length < 3) {
            return;
        }
        String tmpStr = null;
        tmpStr = conditionAry[2].indexOf("&") > 0 ? conditionAry[2].substring(0, conditionAry[2].indexOf("&")) : conditionAry[2];
        String[] parameter = BgNFSHelper.parseFormulaPara((String)tmpStr);
        BgPeriodInfo bgPeriodInfo = BgPeriodFactory.getRemoteInstance().getBgPeriodInfo("select * where number ='" + parameter[1] + "'");
        Map resMap = this.getRptInterface().getExecuteInfo(conditionAry);
        if (resMap == null || !resMap.containsKey("ORGUNIT_INFO")) {
            return;
        }
        String bgFormId = filterParams.getBgFormID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.rootid");
        BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
        BgExecuteFilterParam filterParam = new BgExecuteFilterParam();
        filterParam.setOrgUnits((OrgUnitInfo[])resMap.get("ORGUNIT_INFO"));
        BgSchemeInfo schemeInfo = new BgSchemeInfo();
        schemeInfo.setId(bgFormInfo.getBgScheme().getId());
        schemeInfo.setName(bgFormInfo.getBgScheme().getName());
        schemeInfo.setNumber(bgFormInfo.getBgScheme().getNumber());
        schemeInfo.setRootId(bgFormInfo.getBgScheme().getRootId());
        filterParam.setBgScheme(schemeInfo);
        filterParam.setBgPeriodBegin(bgPeriodInfo);
        filterParam.setBgPeriodEnd(bgPeriodInfo);
        if (parameter != null) {
            filterParam.setBeginBgItem(new VisualItemInfo());
            filterParam.getBeginBgItem().setNumber(parameter[0]);
            filterParam.setEndBgItem(new VisualItemInfo());
            filterParam.getEndBgItem().setNumber(parameter[0]);
        }
        filterParam.setBgFormula(conditionAry[2]);
        UIContext uiContext = new UIContext(this.getUIContext().get("Owner"));
        uiContext.put((Object)"ANALYSEINFO", (Object)filterParam);
        NewBgCompareAndAnalysisMainUI.isNeedToDelOldWin(uiContext, BgExecuteAnalyseMainUI.class.getName());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(BgExecuteAnalyseMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String[] getQueryActualConditions() {
        NumberExpandInfo expandInfo;
        Sheet sheet = this.sc.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range == null || range.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PleaseSelect"));
            SysUtil.abort();
        }
        CellBlock block = (CellBlock)range.getAt(0);
        int beginRowIndex = block.getRow();
        String orgUnitID = null;
        String orgUnitNumber = null;
        String formula = this.searchFormulaBySelectedBlock(sheet, block, beginRowIndex);
        if (formula == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        if ((expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)sheet.getCell(beginRowIndex, 0, false))) != null) {
            orgUnitID = expandInfo.getId();
            orgUnitNumber = expandInfo.getNumber();
        }
        if (orgUnitID == null && formula == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        return new String[]{orgUnitID, orgUnitNumber, formula};
    }

    public void showDialogWindow(IUIObject ui, String orgId, String orgName, String formula, NewBgCompareAndAnalysisFilterParam param) throws Exception {
        BgTraceFilterParam traceParam = new BgTraceFilterParam();
        String[] ary = null;
        OrgUnitInfo info = new OrgUnitInfo();
        if (orgId == null) {
            ary = formula.split("&");
            if (ary.length < 2) {
                return;
            }
            info.setNumber(ary[1]);
            formula = ary[0];
        } else {
            info.setName(orgName);
            info.setId(BOSUuid.read((String)orgId));
        }
        traceParam.setOrgUnitInfoAry(new OrgUnitInfo[]{info});
        String bgSchemeID = param.getBgSchemeInfo().getId().toString();
        traceParam.setBgSchemeId(bgSchemeID);
        Sheet sheet = this.sc.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range == null || range.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PleaseSelect"));
            SysUtil.abort();
        }
        CellBlock block = (CellBlock)range.getAt(0);
        int col = block.getCol();
        Column column = sheet.getColumn(col, false);
        boolean isShowDict = false;
        if (column != null && BgNFSHelper.getColObject((Column)column, (String)COL_KEY) != null) {
            String colName = (String)BgNFSHelper.getColObject((Column)column, (String)COL_KEY);
            if (colName.equals("col0")) {
                isShowDict = true;
                traceParam.setBeginPeriod(param.getBeginPeriod());
                traceParam.setEndPeriod(param.getEndPeriod());
            } else {
                SysUtil.abort();
            }
        } else {
            SysUtil.abort();
        }
        List idList = BgRptFacadeFactory.getRemoteInstance().getBgDataIDByFormula(traceParam, formula);
        String uiName = BgTraceMainUI.class.getName();
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"filterParam", (Object)traceParam);
        uiContext.put((Object)"isDirectShow", (Object)new Boolean(true));
        uiContext.put((Object)"isDirectShowNotExecute", (Object)new Boolean(isShowDict));
        uiContext.put((Object)"bgDataIDList", (Object)idList);
        uiContext.put((Object)"formula", (Object)formula);
        NewBgCompareAndAnalysisMainUI.isNeedToDelOldWin(uiContext, uiName);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public static boolean isNeedToDelOldWin(UIContext uiContext, String uiName) throws UIException {
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        if (!(frame instanceof NewMainFrame)) {
            logger.error((Object)("frame is :" + frame.getClass().getName()));
            return false;
        }
        NewWinMainUI mainUI = ((NewMainFrame)frame).getMainUI();
        IUIObject uiObject = mainUI.getUiManager().findUIObject(uiName, (Map)uiContext, null, OprtState.VIEW);
        if (uiObject != null) {
            uiObject.getUIWindow().close();
            return true;
        }
        return false;
    }

    private void createViewUI(List recordList, String flag, String formula) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", (Object)this);
        ctx.put("records", recordList);
        ctx.put("formula", formula);
        String uiClassName = null;
        if (flag.equals("actual")) {
            uiClassName = BgViewActualCtrlUI.class.getName();
        } else if (flag.equals("budget")) {
            uiClassName = BgViewBudgetCtrlUI.class.getName();
        }
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(uiClassName, ctx);
            messageDialog.show();
        }
        catch (UIException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    protected String[] getQueryConditions() {
        int beginRowIndex;
        CellBlock block;
        String formula;
        Sheet sheet = this.sc.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range == null || range.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PleaseSelect"));
            SysUtil.abort();
        }
        if ((formula = this.searchFormulaBySelectedBlock(sheet, block = (CellBlock)range.getAt(0), beginRowIndex = block.getRow())) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        String orgUnitID = null;
        NumberExpandInfo expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)sheet.getCell(beginRowIndex, 0, false));
        if (expandInfo != null) {
            orgUnitID = expandInfo.getId();
        }
        if (orgUnitID == null && formula == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectedRowWithNoFormula"));
            SysUtil.abort();
        }
        return new String[]{orgUnitID, formula};
    }

    private String getFormulaFromSelectedBlock(Sheet sheet, CellBlock block, int rowIndex) {
        int beginColIndex = block.getCol();
        String rtnBgItem = null;
        Cell cell = sheet.getCell(rowIndex, beginColIndex, false);
        String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
        if (bgItem != null && !"".equals(bgItem)) {
            rtnBgItem = bgItem;
        }
        return rtnBgItem;
    }

    private String searchFormulaBySelectedBlock(Sheet sheet, CellBlock block, int rowIndex) {
        int beginColIndex;
        int i;
        String rtnBgItem = this.getFormulaFromSelectedBlock(sheet, block, rowIndex);
        if (rtnBgItem != null) {
            return rtnBgItem;
        }
        for (i = beginColIndex = block.getCol(); i >= 0; --i) {
            String transFormedBgItem;
            Column col = sheet.getColumn(i, false);
            Object colKey = BgNFSHelper.getColObject((Column)col, (String)NEW_ANALYSIS_COL_KEY);
            if (!ANALYSIS_FLAG.equals(colKey)) continue;
            Cell cell = sheet.getCell(rowIndex, i, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                rtnBgItem = bgItem;
                break;
            }
            if (bgFormula == null || "".equals(bgFormula) || "".equals(transFormedBgItem = AnalysisColumnTool.changeBgFormulaToBgItem(bgFormula))) continue;
            String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(transFormedBgItem);
            rtnBgItem = transFormedBgItem + "&" + bgFormulaAry[0];
            break;
        }
        if (rtnBgItem == null) {
            int num = sheet.getMaxColIndex() + 1;
            for (i = beginColIndex; i < num; ++i) {
                Cell cell = sheet.getCell(rowIndex, i, false);
                String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
                if (bgItem == null || "".equals(bgItem)) continue;
                rtnBgItem = bgItem;
                break;
            }
        }
        return rtnBgItem;
    }

    public void setUITitle(String title) {
        String currentClassName = this.getMetaDataPK().getFullName();
        if (currentClassName.equals(NewBgCompareAndAnalysisMainUI.class.getName()) || currentClassName.equals(NewDirectedBgCompareAndAnalysisMainUI.class.getName())) {
            title = EASResource.getString((String)resourcePath, (String)"BgCompareAndAnalysisTitle");
        }
        super.setUITitle(title);
    }

    @Override
    public void allFormView_actionPerformed(ActionEvent e) throws Exception {
        CellBlock block;
        int beginRowIndex;
        Cell cell;
        String uiname = BgAllFormCompareAndAnalysisMainUI.class.getName();
        UIContext uicontext = new UIContext((Object)this);
        uicontext.put("this.is.hidden.filter.ui", Boolean.TRUE);
        NewBgCompareAndAnalysisFilterUI fileter = new NewBgCompareAndAnalysisFilterUI();
        NewBgCompareAndAnalysisFilterParam filterParam = new NewBgCompareAndAnalysisFilterParam();
        NewBgCompareAndAnalysisFilterParam olderFilterParam = this.getFilterUIParams();
        ArrayList list = new ArrayList();
        if (olderFilterParam.getAnalysisColsList() == null) {
            filterParam.setAnalysisColsList(null);
        } else {
            list.addAll(olderFilterParam.getAnalysisColsList());
            filterParam.setAnalysisColsList(list);
        }
        BgPeriodInfo period = null;
        if (olderFilterParam.getBeginPeriod() != null) {
            period = (BgPeriodInfo)olderFilterParam.getBeginPeriod().clone();
            period.setId(olderFilterParam.getBeginPeriod().getId());
            filterParam.setBeginPeriod(period);
        }
        BgSchemeInfo scheme = (BgSchemeInfo)olderFilterParam.getBgSchemeInfo().clone();
        scheme.setId(olderFilterParam.getBgSchemeInfo().getId());
        filterParam.setBgSchemeInfo(scheme);
        if (olderFilterParam.getCurrencyInfo() != null) {
            CurrencyInfo currency = (CurrencyInfo)olderFilterParam.getCurrencyInfo().clone();
            currency.setId(olderFilterParam.getCurrencyInfo().getId());
            filterParam.setCurrencyInfo(currency);
        }
        if (olderFilterParam.getAnalysisColsMap() != null) {
            filterParam.setAnalysisColsMap(olderFilterParam.getAnalysisColsMap());
        }
        if (olderFilterParam.getEndPeriod() != null) {
            period = (BgPeriodInfo)olderFilterParam.getEndPeriod().clone();
            period.setId(olderFilterParam.getEndPeriod().getId());
            filterParam.setEndPeriod(olderFilterParam.getEndPeriod());
        }
        if (olderFilterParam.getMeasureUnitInfo() == null) {
            filterParam.setMeasureUnitInfo(null);
        } else {
            MeasureUnitInfo meaUnitInfo = (MeasureUnitInfo)olderFilterParam.getMeasureUnitInfo().clone();
            meaUnitInfo.setId(olderFilterParam.getMeasureUnitInfo().getId());
            filterParam.setMeasureUnitInfo(meaUnitInfo);
        }
        if (olderFilterParam.getMeasureUnitInfoMap() == null) {
            filterParam.setMeasureUnitInfoMap(null);
        } else {
            HashMap measureMap = new HashMap();
            measureMap.putAll(olderFilterParam.getMeasureUnitInfoMap());
            filterParam.setMeasureUnitInfoMap(measureMap);
        }
        filterParam.setShowColRow(false);
        list = new ArrayList();
        if (olderFilterParam.getTitleColsList() == null) {
            filterParam.setTitleColsList(null);
        } else {
            list.addAll(olderFilterParam.getTitleColsList());
            filterParam.setTitleColsList(olderFilterParam.getTitleColsList());
        }
        String formID = olderFilterParam.getBgFormID();
        if (formID == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"344_NewBgCompareAndAnalysisMainUI"));
            return;
        }
        Sheet sheet = this.sc.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        if (range != null && range.size() > 0 && (cell = sheet.getCell(beginRowIndex = (block = (CellBlock)range.getAt(0)).getRow(), 0, false)) != null) {
            NumberExpandInfo expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)cell);
            if (expandInfo != null) {
                int i;
                String id = expandInfo.getId();
                CostCenterOrgUnitInfo[] org = olderFilterParam.getCostCenterOrgUnitInfoAry();
                CostCenterOrgUnitInfo orgRoot = org[0];
                int length = org.length;
                for (i = 0; i < length; ++i) {
                    if (org[i].getLongNumber().split("!").length >= orgRoot.getLongNumber().split("!").length) continue;
                    orgRoot = org[i];
                }
                org = olderFilterParam.getLazyLoadDataCostCenterOrgUnitInfoAry();
                length = org.length;
                for (i = 0; i < length; ++i) {
                    if (org[i].getLongNumber().split("!").length >= orgRoot.getLongNumber().split("!").length) continue;
                    orgRoot = org[i];
                }
                if (!(orgRoot.getId().toString().equals(id) || (formID = BgFormCollectFacadeFactory.getRemoteInstance().getCollectionChildFormIdByColFormIDAndChildOrgID(formID, id)) != null && formID.trim().length() >= 1)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"345_NewBgCompareAndAnalysisMainUI"));
                    return;
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"346_NewBgCompareAndAnalysisMainUI"));
                return;
            }
        }
        filterParam.setBgFormID(formID);
        CostCenterOrgUnitInfo[] org1 = BgFormCollectFacadeFactory.getRemoteInstance().getsourceOrgArray(formID, true);
        filterParam.setCostCenterOrgUnitInfoAry(org1);
        filterParam.setLazyLoadDataCostCenterOrgUnitInfoAry(new CostCenterOrgUnitInfo[]{org1[0]});
        uicontext.put("this.is.hidden.filter.ui.filterParam", filterParam);
        uicontext.put("this.is.root.orgunit.id", org1[0].getId().toString());
        uicontext.put("system.time", org1[0].getId().toString());
        fileter.setFilterParam(filterParam);
        olderFilterParam = this.getFilterUI2Params();
        list = new ArrayList();
        list.addAll(olderFilterParam.getAnalysisElement());
        filterParam.setAnalysisElement(list);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiname, (Map)uicontext);
        uiWindow.show();
        this.btnAllFormView.getModel().setRollover(false);
    }

    @Override
    public void cellFormCollectionView_actionPerformed(ActionEvent e) throws Exception {
        NewBgCompareAndAnalysisFilterParam filter1Params = this.getFilterUIParams();
        int beginRowIndex = -1;
        Object[] orgLazyOld = (Object[])filter1Params.getLazyLoadDataCostCenterOrgUnitInfoAry().clone();
        Object[] orgOld = (Object[])filter1Params.getCostCenterOrgUnitInfoAry().clone();
        try {
            String colKey;
            Sheet sheet = this.sc.getBook().getActiveSheet();
            Range range = sheet.getSelectionRange();
            BigDecimal amountUnit = ONE;
            if (range == null || range.size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PleaseSelect"));
                SysUtil.abort();
            }
            Map amountUnitMap = filter1Params.getMeasureUnitInfoMap();
            CellBlock block = (CellBlock)range.getAt(0);
            beginRowIndex = block.getRow();
            int addedColIndex = block.getCol();
            if (beginRowIndex < 0) {
                return;
            }
            String orgUnitID = null;
            Cell cell = sheet.getCell(beginRowIndex, addedColIndex, false);
            if (BgNFSHelper.checkIsEmptyCell((Cell)cell)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkFormulaNoCollectView"));
                return;
            }
            String formID = filter1Params.getBgFormID();
            if (formID == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"344_NewBgCompareAndAnalysisMainUI"));
                return;
            }
            cell = sheet.getCell(beginRowIndex, 0, false);
            if (cell != null) {
                NumberExpandInfo expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)cell);
                if (expandInfo != null) {
                    int i;
                    String id = expandInfo.getId();
                    CostCenterOrgUnitInfo[] org = filter1Params.getCostCenterOrgUnitInfoAry();
                    CostCenterOrgUnitInfo orgRoot = org[0];
                    int length = org.length;
                    for (i = 0; i < length; ++i) {
                        if (org[i].getLongNumber().split("!").length >= orgRoot.getLongNumber().split("!").length) continue;
                        orgRoot = org[i];
                    }
                    org = filter1Params.getLazyLoadDataCostCenterOrgUnitInfoAry();
                    length = org.length;
                    for (i = 0; i < length; ++i) {
                        if (org[i].getLongNumber().split("!").length >= orgRoot.getLongNumber().split("!").length) continue;
                        orgRoot = org[i];
                    }
                    if (!(orgRoot.getId().toString().equals(id) || (formID = BgFormCollectFacadeFactory.getRemoteInstance().getCollectionChildFormIdByColFormIDAndChildOrgID(formID, id)) != null && formID.trim().length() >= 1)) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"347_NewBgCompareAndAnalysisMainUI"));
                        return;
                    }
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"346_NewBgCompareAndAnalysisMainUI"));
                    return;
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            CostCenterOrgUnitInfo[] org = BgFormCollectFacadeFactory.getRemoteInstance().getsourceOrgArray(formID, false);
            cell = null;
            for (int i = addedColIndex; i >= 0 && !BgNFSHelper.checkHasFormulaOfCell((Cell)(cell = sheet.getCell(beginRowIndex, i, false))); --i) {
                cell = null;
            }
            if (cell == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkFormulaNoCollectView"));
                return;
            }
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String[] formulaParamArray = BgFillHelper.parseStrFormulaToArray(bgItem);
            amountUnit = this.reSetAmountUnit(formulaParamArray[2], amountUnitMap);
            if (filter1Params.getBeginPeriod() != null) {
                bgItem = AnalysisColumnTool.rebuildFormulaWithPeriodParamNull(formulaParamArray);
            }
            if ((colKey = (String)BgNFSHelper.getColObject((Column)sheet.getColumn(addedColIndex, false), (String)COL_KEY)) == null) {
                return;
            }
            if (colKey.equals(TITLE_FLAG)) {
                colKey = "col4";
            }
            String dataType = AnalysisColumnTool.getProValByProName(colKey, this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().getAnalysisEleClass());
            NewBgCompareAndAnalysisFilterParam filter2Params = this.getFilterUI2Params();
            String[] formulaAry = new String[]{bgItem};
            CostCenterOrgUnitInfo[] orgArray = BgFormCollectFacadeFactory.getRemoteInstance().getsourceOrgArray(formID, true);
            filter1Params.setCostCenterOrgUnitInfoAry(orgArray);
            filter1Params.setLazyLoadDataCostCenterOrgUnitInfoAry(orgArray);
            this.getAnalysisSysFacade().getDataDealCenter().getFetchDataFactory().initSubOrgDataFactory(filter1Params, filter2Params, formulaAry);
            int length = org.length;
            for (int i = 0; i < length; ++i) {
                orgUnitID = org[i].getId().toString();
                Object val = this.getAnalysisSysFacade().getDataDealCenter().getDataFactory(bgItem, colKey, orgUnitID, ONE);
                map.put(orgUnitID, val);
            }
            if (map == null || map.isEmpty()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkFormulaNoCollectView"));
                return;
            }
            UIContext uicontext = new UIContext((Object)this);
            uicontext.put("com.kingdee.eas.ma.budget.client.newbg.datamap", map);
            uicontext.put("com.kingdee.eas.ma.budget.client.newbg.formula", bgItem);
            uicontext.put("data.type", dataType);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCollectViewCompareAndAUI.class.getName(), (Map)uicontext);
            uiWindow.show();
        }
        catch (Exception e1) {
            throw e1;
        }
        finally {
            filter1Params.setLazyLoadDataCostCenterOrgUnitInfoAry((CostCenterOrgUnitInfo[])orgLazyOld);
            filter1Params.setCostCenterOrgUnitInfoAry((CostCenterOrgUnitInfo[])orgOld);
        }
    }

    protected void setFilter2UI(NewBgCompareAndAnaylsisFilter2UI filter2UI) {
        this.filter2UI = filter2UI;
    }

    protected void setFilterUI(NewBgCompareAndAnalysisFilterUI filterUI) {
        this.filterUI = filterUI;
    }

    @Override
    protected boolean hasSpreadContext() {
        return true;
    }

    @Override
    protected SpreadContext getSpreadContext() {
        return this.getSc();
    }

    protected SpreadContext getSc() {
        return this.sc;
    }

    protected void setSc(SpreadContext sc) {
        this.sc = sc;
    }

    protected boolean isDelete() {
        return this.isDisplayZero;
    }

    protected void setDelete(NewBgCompareAndAnalysisFilterParam filter1Params) {
        this.isDisplayZero = filter1Params.isDisplayZero();
    }

    protected void delBgItemWithAllAnalysisDataEqualZero(boolean isDelete, Sheet sheet, int addRowIndex) {
        if (isDelete) {
            this.delRow(sheet, addRowIndex);
        }
    }

    private void delRow(Sheet sheet, int addRowIndex) {
        List analysisColIndexList = this.getAnalysisColIndexList(sheet);
        List analysisElementList = this.getFilterUI2Params().getAnalysisElement();
        for (int rowIndex = sheet.getMaxRowIndex() + 1; rowIndex > addRowIndex; --rowIndex) {
            if (!this.isDeleteRow(sheet, rowIndex, analysisColIndexList, analysisElementList)) continue;
            BgNFSHelper.removeRow((Sheet)sheet, (int)rowIndex);
        }
    }

    private boolean isDeleteRow(Sheet sheet, int rowIndex, List analysisColIndexList, List analysisElementList) {
        int colNum = analysisColIndexList.size();
        for (int k = 0; k < colNum; ++k) {
            int analysisColIndex = Integer.valueOf(analysisColIndexList.get(k).toString());
            int num = analysisElementList.size();
            for (int i = 0; i < num; ++i) {
                String variantStr;
                Variant variant;
                Cell cell = sheet.getCell(rowIndex, analysisColIndex + i, false);
                if (cell == null || (variant = cell.getValue()) == null || DataDealCenter.ZIROSTR_LIST.contains(variantStr = variant.toString().trim())) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isNeedToFetchTheLastData() {
        return this.isNeedToFetchTheLastData;
    }

    protected void setNeedToFetchTheLastData(boolean isNeedToFetchTheLastData) {
        this.isNeedToFetchTheLastData = isNeedToFetchTheLastData;
    }

    public MeasureUnitInfo getDefaultMeasureUnitInfo(NewBgCompareAndAnalysisFilterParam filter1Params) {
        if (this.defaultMeasureUnitInfo != null) {
            return this.defaultMeasureUnitInfo;
        }
        if (!StringUtils.isEmpty((String)filter1Params.getBgFormID())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("measureUnit.coefficient");
            selector.add("bgMeasureUnit.id");
            selector.add("bgMeasureUnit.bgElement.id");
            selector.add("bgMeasureUnit.bgElement.number");
            selector.add("bgMeasureUnit.measureUnit.id");
            selector.add("bgMeasureUnit.measureUnit.coefficient");
            BgFormInfo info = null;
            try {
                info = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(filter1Params.getBgFormID()), selector);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            if (info != null) {
                this.defaultMeasureUnitInfo = info.getMeasureUnit();
            }
        }
        return this.defaultMeasureUnitInfo;
    }

    protected Map getMeasureUnit(NewBgCompareAndAnalysisFilterParam filter1Params) {
        HashMap<BgElementInfo, MeasureUnitInfo> measureUnit = filter1Params.getMeasureUnitInfoMap();
        if (measureUnit != null) {
            return measureUnit;
        }
        measureUnit = new HashMap<BgElementInfo, MeasureUnitInfo>();
        if (!StringUtils.isEmpty((String)filter1Params.getBgFormID())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("measureUnit.coefficient");
            selector.add("bgMeasureUnit.id");
            selector.add("bgMeasureUnit.bgElement.id");
            selector.add("bgMeasureUnit.bgElement.number");
            selector.add("bgMeasureUnit.measureUnit.id");
            selector.add("bgMeasureUnit.measureUnit.coefficient");
            BgFormInfo info = null;
            try {
                info = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(filter1Params.getBgFormID()), selector);
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            if (info != null) {
                BgElementInfo element = null;
                if (info.getMeasureUnit() != null) {
                    element = new BgElementInfo();
                    element.setNumber("BOOK_DEF_MEASUREUNIT");
                    measureUnit.put(element, info.getMeasureUnit());
                }
                if (info.getBgMeasureUnit() != null && info.getBgMeasureUnit().size() != 0) {
                    BgMeasureUnitCollection col = info.getBgMeasureUnit();
                    BgMeasureUnitInfo unit = null;
                    for (int i = 0; i < col.size(); ++i) {
                        unit = col.get(i);
                        measureUnit.put(unit.getBgElement(), unit.getMeasureUnit());
                    }
                }
            }
        }
        return measureUnit;
    }

    private void inVisibleButton() {
        this.btnAllFormView.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnViewActualVal.setVisible(false);
        this.btnViewBgVal.setVisible(false);
        this.btnViewOrgInfo.setVisible(false);
        this.btnQuery.setVisible(false);
        this.menuItemSaveFile.setVisible(false);
        this.menuItemViewAll.setVisible(false);
        this.menuItemViewBgActualVal.setVisible(false);
        this.menuItemViewBgAdjustVal.setVisible(false);
        this.menuItemViewOrg.setVisible(false);
        this.menuItemQuery.setVisible(false);
    }

    protected void visibleButton() {
        this.btnAllFormView.setVisible(true);
        this.btnViewActualVal.setVisible(true);
        this.btnViewBgVal.setVisible(true);
        this.btnViewOrgInfo.setVisible(true);
        this.btnQuery.setVisible(true);
        this.menuItemQuery.setVisible(true);
        this.menuItemViewAll.setVisible(true);
        this.menuItemViewBgActualVal.setVisible(true);
        this.menuItemViewBgAdjustVal.setVisible(true);
        this.menuItemViewOrg.setVisible(true);
    }

    public static void setAllNumberRightA(Sheet sheet) {
        Row row = null;
        Cell cell = null;
        int ColCount = sheet.getMaxColIndex() + 1;
        int rowCount = sheet.getMaxRowIndex() + 1;
        String valueStr = null;
        for (int i = 0; i < rowCount; ++i) {
            row = sheet.getRow(i, false);
            if (row == null || row.getUserObject(THIS_ROW_HAS_DAIL_NUMBER_FORMAT) != null && row.getUserObjectValue(THIS_ROW_HAS_DAIL_NUMBER_FORMAT) != null && row.getUserObjectValue(THIS_ROW_HAS_DAIL_NUMBER_FORMAT) instanceof Boolean && ((Boolean)row.getUserObjectValue(THIS_ROW_HAS_DAIL_NUMBER_FORMAT)).booleanValue()) continue;
            for (int j = 0; j < ColCount; ++j) {
                cell = row.getCell(j, false);
                if (cell == null || cell.getValue() == null || BgNFSHelper.checkHasBgPeriodInfo((Cell)cell)) continue;
                valueStr = cell.getValue().toString();
                valueStr = valueStr.replaceAll(",", "");
                valueStr = valueStr.replaceAll("%", "");
                try {
                    new BigDecimal(valueStr);
                    StyleAttributes sa = Styles.getEmptySA();
                    StyleAttributes saInnerBorder = Styles.getEmptySA();
                    sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    sheet.getRange(cell).setStyle(sa, saInnerBorder);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            row.setUserObject(THIS_ROW_HAS_DAIL_NUMBER_FORMAT, (Object)Boolean.TRUE);
        }
    }

    static {
        notAllowOperation = Arrays.asList(Integer.valueOf("65536"));
    }

    protected class NumberDisplayProvider
    implements IDisplayValueProvider {
        protected NumberDisplayProvider() {
        }

        public Object getDisplayValue(Cell cell, int viewMode) {
            Object res = null;
            if (cell != null) {
                if (cell.getValue() != null && cell.getValue().getValue() instanceof GregorianCalendar) {
                    return cell.getText();
                }
                if (BgNFSHelper.checkHasBgPeriodInfo((Cell)cell)) {
                    return cell.getValue().getValue();
                }
                res = cell.getValue();
                if (cell.getValue().getValue() instanceof BigDecimal) {
                    if (BgNFSHelper.checkHasTextOfCell((Cell)cell)) {
                        return CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)((BigDecimal)cell.getValue().getValue()));
                    }
                    int precision = NewBgCompareAndAnalysisMainUI.this.getCurrency() == null ? 2 : NewBgCompareAndAnalysisMainUI.this.getCurrency().getPrecision();
                    BigDecimal number = (BigDecimal)cell.getValue().getValue();
                    if (cell.getUserObjectValue("Coefficient") instanceof BigDecimal) {
                        number = number.divide((BigDecimal)cell.getUserObjectValue("Coefficient"), precision, 4);
                    }
                    res = number;
                    StyleAttributes ssa = Styles.getEmptySA();
                    cell.getSheet().getRange(cell).getStyle(ssa);
                    String numberFormat = null;
                    try {
                        numberFormat = ssa.getNumberFormat();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (!StringUtils.isEmpty((String)numberFormat)) {
                        try {
                            res = new DecimalFormat(numberFormat, BgNationalFormatUIUtil.getDecimalFormatSymbols()).format(number);
                        }
                        catch (Exception e) {
                            res = new DecimalFormat(NewBgCompareAndAnalysisMainUI.this.getNumberFormat(null), BgNationalFormatUIUtil.getDecimalFormatSymbols()).format(number);
                        }
                    }
                }
            }
            return res;
        }
    }

    private class MyDelete_Col_Action
    extends SpreadAction {
        public MyDelete_Col_Action(SpreadContext context) {
            super(context);
        }

        protected void doAction(ActionEvent e) {
            try {
                int i;
                Sheet sheet = this._context.getBook().getActiveSheet();
                Range rangeSel = sheet.getSelectionRange();
                ArrayList<Integer> set = new ArrayList<Integer>();
                for (i = 0; i < rangeSel.size(); ++i) {
                    CellBlock block = rangeSel.getBlock(i);
                    for (int j = block.getCol(); j <= block.getCol2(); ++j) {
                        if (set.contains(Integer.valueOf(j + ""))) continue;
                        set.add(Integer.valueOf(j + ""));
                    }
                }
                Collections.sort(set, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return (Integer)o2 - (Integer)o1;
                    }
                });
                int size = set.size();
                for (i = 0; i < size; ++i) {
                    int col = sheet.getActiveCol();
                    Range range = sheet.getColRange(col, col);
                    range.setIgnoreProtected(true);
                    range.delete();
                }
            }
            catch (Exception ex) {
                NewBgCompareAndAnalysisMainUI.this.handleException(ex);
            }
        }
    }

    private class MyDelete_Row_Action
    extends SpreadAction {
        public MyDelete_Row_Action(SpreadContext context) {
            super(context);
        }

        protected void doAction(ActionEvent e) {
            try {
                int i;
                Sheet sheet = this._context.getBook().getActiveSheet();
                Range rangeSel = sheet.getSelectionRange();
                ArrayList<Integer> set = new ArrayList<Integer>();
                for (i = 0; i < rangeSel.size(); ++i) {
                    CellBlock block = rangeSel.getBlock(i);
                    for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                        if (set.contains(Integer.valueOf(j + ""))) continue;
                        set.add(Integer.valueOf(j + ""));
                    }
                }
                Collections.sort(set, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return (Integer)o2 - (Integer)o1;
                    }
                });
                int size = set.size();
                for (i = 0; i < size; ++i) {
                    int row = (Integer)set.get(i);
                    Range range = sheet.getRowRange(row, row);
                    range.setIgnoreProtected(true);
                    range.delete();
                }
            }
            catch (Exception ex) {
                NewBgCompareAndAnalysisMainUI.this.handleException(ex);
            }
        }
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseClicked(MouseEvent e) {
            Sheet activeSheet = NewBgCompareAndAnalysisMainUI.this.sc.getBook().getActiveSheet();
            Cell cell = activeSheet.getActiveCell();
            if (NewBgCompareAndAnalysisMainUI.this.render != null && cell != null) {
                OrgUnitRender.NumberExpendRender numRender = (OrgUnitRender.NumberExpendRender)NewBgCompareAndAnalysisMainUI.this.render.getRender(cell, -1);
                if (numRender == null) {
                    return;
                }
                NumberExpandInfo numberExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)cell);
                if (numberExpandInfo != null && numRender.inRect(numberExpandInfo, e.getX(), e.getY())) {
                    NewBgCompareAndAnalysisMainUI.this.setTreeDisplayStyle(cell, numberExpandInfo, activeSheet);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            NewBgCompareAndAnalysisMainUI.this.sc.getSpread().repaint();
        }
    }
}

