/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgAnlysisFormFactory;
import com.kingdee.eas.ma.budget.BgAnlysisFormInfo;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.SavedAnalysisFormTypeEnum;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.budget.client.BudgetUserCellDisplayProvider;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class NewBgCompareAndAnalysisSavedFormMainUI
extends NewBgCompareAndAnalysisMainUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisSavedFormMainUI");
    private static final long serialVersionUID = 4246531680312540116L;
    public static final String DIRECT_ANALYSIS_FORM_INFO = "BgFormInfo";
    public static final String DIRECT_ANALYSIS_ELEMENT = "DIRECT_ANALYSIS_ELEMENT";
    private NewBgCompareAndAnalysisFilterParam filterParam;
    private BgAnlysisFormInfo bgAnlysisFormInfo;

    @Override
    protected boolean hasSpreadContext() {
        return true;
    }

    @Override
    protected SpreadContext getSpreadContext() {
        return this.getSc();
    }

    @Override
    public void onLoad() throws Exception {
        this.bgAnlysisFormInfo = (BgAnlysisFormInfo)this.getUIContext().get(DIRECT_ANALYSIS_FORM_INFO);
        this.constructFilterParam(this.bgAnlysisFormInfo);
        this.setNeedToFetchTheLastData(false);
        super.onLoad();
    }

    @Override
    protected void visibleButton() {
        this.btnSave.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSaveFile.setVisible(true);
        SavedAnalysisFormTypeEnum analysisFormTypeEnum = (SavedAnalysisFormTypeEnum)((Object)this.getUIContext().get("AnalysisFormType"));
        if (SavedAnalysisFormTypeEnum.AdjustlAnalysisSavedForm.equals((Object)analysisFormTypeEnum)) {
            this.btnViewBgVal.setVisible(true);
            this.menuItemViewBgAdjustVal.setVisible(true);
        } else if (SavedAnalysisFormTypeEnum.BaseAnalysisSavedForm.equals((Object)analysisFormTypeEnum)) {
            this.btnViewActualVal.setVisible(true);
            this.menuItemViewBgActualVal.setVisible(true);
        } else if (SavedAnalysisFormTypeEnum.LYActualAnalysisSavedForm.equals((Object)analysisFormTypeEnum)) {
            this.btnViewActualVal.setVisible(true);
            this.menuItemViewBgActualVal.setVisible(true);
        }
    }

    @Override
    protected Book addAndInitTable(NewBgCompareAndAnalysisFilterParam filter1Params) {
        try {
            if (this.book != null) {
                return this.book;
            }
            if (this.sc != null) {
                this.TabPaneMain.remove((Component)this.sc);
            }
            this.book = IOHelper.unpackBook((byte[])this.bgAnlysisFormInfo.getData());
            if (this.getCurrency() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("currency"));
                sic.add(new SelectorItemInfo("currency.precision"));
                BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectUuidPK(this.bgAnlysisFormInfo.getBgFormID()), sic);
                this.setCurrency(bgFormInfo.getCurrency());
            }
            if (this.book != null && this.book.getSheet(0) != null) {
                this.sc = new SpreadContext();
                BudgetUserCellDisplayProvider dp = new BudgetUserCellDisplayProvider();
                dp.setDisplayValueProvider(new NewBgCompareAndAnalysisMainUI.NumberDisplayProvider());
                this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)dp);
                ActionManager actionManager = this.sc.getActionManager();
                MyDelete_Col_Action myMerageAction = new MyDelete_Col_Action(this.sc);
                myMerageAction.setEnabled(true);
                myMerageAction.setAtomic(true);
                myMerageAction.setVisible(true);
                actionManager.putAction("Delete_Col", (SpreadAction)myMerageAction);
                MyDelete_Row_Action myMerageAction1 = new MyDelete_Row_Action(this.sc);
                myMerageAction1.setEnabled(true);
                myMerageAction1.setAtomic(true);
                myMerageAction1.setVisible(true);
                actionManager.putAction("Delete_Row", (SpreadAction)myMerageAction1);
                this.sc.setBook(this.book);
                this.TabPaneMain.add((Component)this.sc, (Object)"Center");
                this.TabPaneMain.setTitleAt(0, this.getUITitle());
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return this.book;
    }

    @Override
    protected int constructSheet(NewBgCompareAndAnalysisFilterParam filter1Param, List analysisElementList, Sheet sheet) {
        try {
            int rowNum = sheet.getMaxRowIndex() + 1;
            for (int rowIndex = 0; rowIndex < rowNum; ++rowIndex) {
                Row row = sheet.getRow(rowIndex, false);
                if (row == null || !"addRow".equals(row.getUserObjectValue("add_row_flag"))) continue;
                return rowIndex;
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return 0;
    }

    @Override
    protected NewBgCompareAndAnalysisFilterParam getDirectFilterParam() {
        return this.filterParam;
    }

    private NewBgCompareAndAnalysisFilterParam constructFilterParam(BgAnlysisFormInfo info) {
        if (this.filterParam != null && this.filterParam.toString() != null) {
            return this.filterParam;
        }
        try {
            this.filterParam = BgAnlysisFormFactory.getRemoteInstance().getFilterParam(info.getBgFormID());
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        List analysisElementList = (List)this.getUIContext().get(DIRECT_ANALYSIS_ELEMENT);
        this.filterParam.setAnalysisElement(analysisElementList);
        return this.filterParam;
    }

    @Override
    public void actionSaveFile_actionPerformed(ActionEvent e) throws Exception {
        BgAnlysisFormInfo info = new BgAnlysisFormInfo();
        info.setData(IOHelper.packBook((Book)this.book));
        info.setBgFormID(this.filterParam.getBgFormID());
        SavedAnalysisFormTypeEnum analysisFormType = (SavedAnalysisFormTypeEnum)((Object)this.getUIContext().get("AnalysisFormType"));
        info.setAnalysisFormType(analysisFormType);
        BgAnlysisFormFactory.getRemoteInstance().addnew((CoreBaseInfo)info);
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"SaveSuccess"));
    }

    public String getUITitle() {
        SavedAnalysisFormTypeEnum analysisFormType = (SavedAnalysisFormTypeEnum)((Object)this.getUIContext().get("AnalysisFormType"));
        String title = "";
        if (SavedAnalysisFormTypeEnum.AdjustlAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"View_Adjust_Form");
        } else if (SavedAnalysisFormTypeEnum.BaseAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"View_Base_Form");
        } else if (SavedAnalysisFormTypeEnum.LYActualAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"View_LYActual_Form");
        } else if (SavedAnalysisFormTypeEnum.LYBudgetAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"View_LYBudget_Form");
        }
        return title;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.filterParam != null && this.filterParam.getAnalysisColsMap() == null) {
            this.initAnalysisColIndexMap();
        }
        super.actionRefresh_actionPerformed(e);
    }

    private void initAnalysisColIndexMap() {
        Map analysisColIndexMap = new HashMap();
        this.book = this.addAndInitTable(this.filterParam);
        if (this.book.getUserObjectValue("AnalysisColsMap") instanceof String) {
            analysisColIndexMap = (Map)BgAnalyseHelper.getObject(Base64.decode((String)((String)this.book.getUserObjectValue("AnalysisColsMap"))));
        } else {
            int num = this.book.getSheetCount();
            for (int i = 0; i < num; ++i) {
                Sheet currentSheet = this.book.getSheet(i);
                String id = this.specialID(currentSheet.getSheetName(), currentSheet.getID());
                ArrayList<Integer> list = new ArrayList<Integer>();
                int colNum = currentSheet.getMaxColIndex() + 1;
                for (int colIndex = 0; colIndex < colNum; ++colIndex) {
                    if (!this.isAnalysisCol(currentSheet, colIndex)) continue;
                    list.add(new Integer(colIndex - 1));
                }
                if (list.size() == 0) continue;
                analysisColIndexMap.put(id, list);
            }
        }
        this.filterParam.setAnalysisColsMap(analysisColIndexMap);
    }

    private String specialID(String sheetName, String sheetID) {
        return sheetID + "&" + sheetName;
    }

    private boolean isAnalysisCol(Sheet sheet, int columnIndex) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        boolean returnFlag = false;
        for (int i = 0; i < rowCount; ++i) {
            Cell cell = sheet.getCell(i, columnIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                returnFlag = true;
                break;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
            returnFlag = true;
            break;
        }
        return returnFlag;
    }

    private class MyDelete_Col_Action
    extends SpreadAction {
        public MyDelete_Col_Action(SpreadContext context) {
            super(context);
        }

        protected void doAction(ActionEvent e) {
            try {
                int i;
                Sheet sheet = this._context.getBook().getActiveSheet();
                Range rangeSel = sheet.getSelectionRange();
                ArrayList<Integer> set = new ArrayList<Integer>();
                for (i = 0; i < rangeSel.size(); ++i) {
                    CellBlock block = rangeSel.getBlock(i);
                    for (int j = block.getCol(); j <= block.getCol2(); ++j) {
                        if (set.contains(Integer.valueOf(j + ""))) continue;
                        set.add(Integer.valueOf(j + ""));
                    }
                }
                Collections.sort(set, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return (Integer)o2 - (Integer)o1;
                    }
                });
                int size = set.size();
                for (i = 0; i < size; ++i) {
                    int col = sheet.getActiveCol();
                    Range range = sheet.getColRange(col, col);
                    range.setIgnoreProtected(true);
                    range.delete();
                }
            }
            catch (Exception ex) {
                NewBgCompareAndAnalysisSavedFormMainUI.this.handleException(ex);
            }
        }
    }

    private class MyDelete_Row_Action
    extends SpreadAction {
        public MyDelete_Row_Action(SpreadContext context) {
            super(context);
        }

        protected void doAction(ActionEvent e) {
            try {
                int i;
                Sheet sheet = this._context.getBook().getActiveSheet();
                Range rangeSel = sheet.getSelectionRange();
                ArrayList<Integer> set = new ArrayList<Integer>();
                for (i = 0; i < rangeSel.size(); ++i) {
                    CellBlock block = rangeSel.getBlock(i);
                    for (int j = block.getRow(); j <= block.getRow2(); ++j) {
                        if (set.contains(Integer.valueOf(j + ""))) continue;
                        set.add(Integer.valueOf(j + ""));
                    }
                }
                Collections.sort(set, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return (Integer)o2 - (Integer)o1;
                    }
                });
                int size = set.size();
                for (i = 0; i < size; ++i) {
                    int row = (Integer)set.get(i);
                    Range range = sheet.getRowRange(row, row);
                    range.setIgnoreProtected(true);
                    range.delete();
                }
            }
            catch (Exception ex) {
                NewBgCompareAndAnalysisSavedFormMainUI.this.handleException(ex);
            }
        }
    }
}

