/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgAnlysisFormFactory;
import com.kingdee.eas.ma.budget.BgAnlysisFormInfo;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.SavedAnalysisFormTypeEnum;
import com.kingdee.eas.ma.budget.analysiscolumn.util.AnalysisColumnTool;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.budget.client.NewBgCompareAndAnalysisMainUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NewDirectedBgCompareAndAnalysisMainUI
extends NewBgCompareAndAnalysisMainUI {
    private static final long serialVersionUID = -4255306232697638793L;
    private NewBgCompareAndAnalysisFilterParam directFilterParam;
    public static final String Direct_Filter_Param = "DirectFilterParam";
    public static final String ANALYSIS_FORM_TYPE = "AnalysisFormType";

    @Override
    public void onLoad() throws Exception {
        this.initDirectFilterParam();
        super.onLoad();
    }

    @Override
    protected boolean hasSpreadContext() {
        return true;
    }

    @Override
    protected SpreadContext getSpreadContext() {
        return this.getSc();
    }

    @Override
    protected void visibleButton() {
        this.btnSave.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSaveFile.setVisible(true);
        SavedAnalysisFormTypeEnum analysisFormTypeEnum = (SavedAnalysisFormTypeEnum)((Object)this.getUIContext().get(ANALYSIS_FORM_TYPE));
        if (SavedAnalysisFormTypeEnum.AdjustlAnalysisSavedForm.equals((Object)analysisFormTypeEnum)) {
            this.btnViewBgVal.setVisible(true);
            this.menuItemViewBgAdjustVal.setVisible(true);
        } else if (SavedAnalysisFormTypeEnum.BaseAnalysisSavedForm.equals((Object)analysisFormTypeEnum)) {
            this.btnViewActualVal.setVisible(true);
            this.menuItemViewBgActualVal.setVisible(true);
        } else if (SavedAnalysisFormTypeEnum.LYActualAnalysisSavedForm.equals((Object)analysisFormTypeEnum)) {
            this.btnViewActualVal.setVisible(true);
            this.menuItemViewBgActualVal.setVisible(true);
        }
    }

    private void initDirectFilterParam() {
        if (this.directFilterParam == null) {
            Object filterParam = this.getUIContext().get(Direct_Filter_Param);
            if (filterParam == null) {
                return;
            }
            this.directFilterParam = (NewBgCompareAndAnalysisFilterParam)filterParam;
            this.initAnalysisColIndexMap();
        }
    }

    @Override
    protected NewBgCompareAndAnalysisFilterParam getDirectFilterParam() {
        return this.directFilterParam;
    }

    private void initAnalysisColIndexMap() {
        HashMap analysisColIndexMap = new HashMap();
        this.book = this.addAndInitTable(this.directFilterParam);
        int num = this.book.getSheetCount();
        for (int i = 0; i < num; ++i) {
            Sheet currentSheet = this.book.getSheet(i);
            String id = this.specialID(currentSheet.getSheetName(), currentSheet.getID());
            ArrayList<Integer> list = new ArrayList<Integer>();
            int colNum = currentSheet.getMaxColIndex() + 1;
            for (int colIndex = 0; colIndex < colNum; ++colIndex) {
                if (!this.isAnalysisCol(currentSheet, colIndex)) continue;
                list.add(new Integer(colIndex));
            }
            if (list.size() == 0) continue;
            analysisColIndexMap.put(id, list);
        }
        this.directFilterParam.setAnalysisColsMap(analysisColIndexMap);
    }

    private String specialID(String sheetName, String sheetID) {
        return sheetID + "&" + sheetName;
    }

    private boolean isAnalysisCol(Sheet sheet, int columnIndex) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        boolean returnFlag = false;
        for (int i = 0; i < rowCount; ++i) {
            Cell cell = sheet.getCell(i, columnIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                returnFlag = true;
                break;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
            returnFlag = true;
            break;
        }
        return returnFlag;
    }

    @Override
    public void actionSaveFile_actionPerformed(ActionEvent e) throws Exception {
        BgAnlysisFormInfo info = new BgAnlysisFormInfo();
        Map map = this.directFilterParam.getAnalysisColsMap();
        if (map != null && !map.isEmpty()) {
            this.book.setUserObject("AnalysisColsMap", (Object)Base64.encodeBytes((byte[])BgAnalyseHelper.getBytes(this.directFilterParam.getAnalysisColsMap())));
        }
        info.setData(IOHelper.packBook((Book)this.book));
        info.setBgFormID(this.directFilterParam.getBgFormID());
        SavedAnalysisFormTypeEnum analysisFormType = (SavedAnalysisFormTypeEnum)((Object)this.getUIContext().get(ANALYSIS_FORM_TYPE));
        info.setAnalysisFormType(analysisFormType);
        BgAnlysisFormFactory.getRemoteInstance().addnew((CoreBaseInfo)info);
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"SaveSuccess"));
    }

    @Override
    protected boolean isDelete() {
        return AnalysisColumnTool.isDelete(null);
    }

    @Override
    protected String getTabPaneMainUITitle() {
        return this.getUITitle();
    }

    public String getUITitle() {
        SavedAnalysisFormTypeEnum analysisFormType = (SavedAnalysisFormTypeEnum)((Object)this.getUIContext().get(ANALYSIS_FORM_TYPE));
        String title = "";
        if (SavedAnalysisFormTypeEnum.AdjustlAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"Adjust_Analysis");
        } else if (SavedAnalysisFormTypeEnum.BaseAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"Base_Analysis");
        } else if (SavedAnalysisFormTypeEnum.LYActualAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"LYActual_Analysis");
        } else if (SavedAnalysisFormTypeEnum.LYBudgetAnalysisSavedForm.equals((Object)analysisFormType)) {
            title = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"LYBudget_Analysis");
        }
        return title;
    }
}

