/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.client.AbstractProgressPatchUI;
import com.kingdee.eas.ma.nbudget.BgSchemeDispatchFacadeFactory;
import com.kingdee.eas.ma.nbudget.IBgSchemeDispatchFacade;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProgressPatchUI
extends AbstractProgressPatchUI {
    private static final long serialVersionUID = -926807580885262073L;
    private static final Logger logger = CoreUIObject.getLogger(ProgressPatchUI.class);
    private String bgSchemeId = null;
    private Map dispatchInfo = null;
    private int minValue = 0;
    private int maxValue = 0;
    private boolean canClose = false;
    private boolean hasCanel = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBgSchemeId((String)this.getUIContext().get("BGSCHEME_ID"));
        this.setDispatchInfo((Map)this.getUIContext().get("DISPATCH_INFO"));
        if (this.getDispatchInfo() != null) {
            Set _tmpSet2 = null;
            for (Set _tmpSet2 : this.getDispatchInfo().values()) {
                if (_tmpSet2 == null || _tmpSet2.isEmpty()) continue;
                ++this.maxValue;
            }
        }
    }

    public IBgSchemeDispatchFacade getDispatchInterface() throws Exception {
        return BgSchemeDispatchFacadeFactory.getRemoteInstance();
    }

    public void setBgSchemeId(String bgSchemeId) {
        this.bgSchemeId = bgSchemeId;
    }

    public String getBgSchemeId() {
        return this.bgSchemeId;
    }

    public void setDispatchInfo(Map dispatchInfo) {
        this.dispatchInfo = dispatchInfo;
    }

    public Map getDispatchInfo() {
        return this.dispatchInfo;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    public boolean isCanClose() {
        return this.canClose;
    }

    public void setHasCanel(boolean hasCanel) {
        this.hasCanel = hasCanel;
    }

    public boolean isHasCanel() {
        return this.hasCanel;
    }

    @Override
    protected void btnStart_actionPerformed(ActionEvent e) throws Exception {
        super.btnStart_actionPerformed(e);
        this.btnStart.setEnabled(false);
        DispatchThread thread = new DispatchThread((Component)((Object)this), this.progressBar);
        thread.start();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.setHasCanel(true);
        this.setCanClose(true);
        this.getUIWindow().close();
    }

    public boolean destroyWindow() {
        if (this.isCanClose()) {
            return super.destroyWindow();
        }
        return false;
    }

    class DispatchThread
    extends Thread {
        private int DELAY = 50;
        private Component component = null;
        private KDProgressBar progressBar = null;

        public DispatchThread(Component component, KDProgressBar progressBar) {
            this.component = component;
            this.progressBar = progressBar;
        }

        @Override
        public void run() {
            super.run();
            this.init();
            this.startup();
            this.close();
        }

        private void init() {
            this.progressBar.setValue(ProgressPatchUI.this.minValue);
            this.progressBar.setMaximum(ProgressPatchUI.this.maxValue);
            this.progressBar.setStringPainted(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startup() {
            Hashtable<String, Object> _tmpMap = new Hashtable<String, Object>();
            ArrayList _orgUnitIds = null;
            int i = 0;
            try {
                for (Map.Entry _entry : ProgressPatchUI.this.getDispatchInfo().entrySet()) {
                    _orgUnitIds = new ArrayList();
                    _orgUnitIds.addAll((Collection)_entry.getValue());
                    _tmpMap.put("BGSCHEME_ID", ProgressPatchUI.this.getBgSchemeId());
                    _tmpMap.put("BGTEMPLATE_ID", _entry.getKey());
                    _tmpMap.put("ORGUNIT_ID", _orgUnitIds);
                    try {
                        ProgressPatchUI.this.getDispatchInterface().dispatch(_tmpMap);
                    }
                    catch (Exception ex0) {
                        logger.error((Object)"error:", (Throwable)ex0);
                    }
                    finally {
                        _tmpMap.clear();
                    }
                    this.progressBar.setValue(i++);
                    try {
                        Thread.sleep(this.DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.progressBar.setValue(ProgressPatchUI.this.maxValue);
            }
            catch (Exception ex) {
                logger.error((Object)"error:", (Throwable)ex);
            }
        }

        private void close() {
            ((ProgressPatchUI)((Object)this.component)).btnCancel.setEnabled(false);
            ((ProgressPatchUI)((Object)this.component)).txtTitle.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"353_ProgressPatchUI"));
            ((ProgressPatchUI)((Object)this.component)).setCanClose(true);
        }
    }
}

