/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.RecalculateObjInfo;
import com.kingdee.eas.ma.budget.client.AbstractProgressUI;
import com.kingdee.eas.ma.budget.client.BgRecalculateReportUI;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormFacadeFactory;
import com.kingdee.eas.ma.nbudget.client.BgNCHelper;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProgressUI
extends AbstractProgressUI {
    private static final long serialVersionUID = 4517593707582280755L;
    private static boolean recalculateStopFlag = false;
    private Date beginTime;
    private List allBgFormInfoList;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopProgressBar();
        ProgressUI.setRecalculateStopFlag(false);
        this.allBgFormInfoList = (List)this.getUIContext().get("allBgFormInfoList");
        this.beginTime = new Date(System.currentTimeMillis());
        MultiRecalculateThread thread = new MultiRecalculateThread(this.allBgFormInfoList);
        thread.start();
    }

    private void initPopProgressBar() {
        this.kDProgressBar1.setStringPainted(false);
        this.kDProgressBar1.setString("");
        this.kDProgressBar1.setMinimum(0);
        this.kDProgressBar1.setMaximum(100);
        this.kDProgressBar1.setIndeterminate(true);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        ProgressUI.setRecalculateStopFlag(true);
        this.destroyWindow();
    }

    public static boolean isRecalculateStopFlag() {
        return recalculateStopFlag;
    }

    public static synchronized void setRecalculateStopFlag(boolean recalculateStopFlag) {
        ProgressUI.recalculateStopFlag = recalculateStopFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void MultiTableCalculate(List bgFormInfoList) throws Exception {
        int num = bgFormInfoList.size();
        if (num == 0) {
            return;
        }
        IReport iReport = ReportFactory.getRemoteInstance();
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        for (int i = 0; i < num && !ProgressUI.isRecalculateStopFlag(); ++i) {
            RecalculateObjInfo roi = (RecalculateObjInfo)bgFormInfoList.get(i);
            if (!roi.getRecalculateResult().equals("cancel")) continue;
            BgFormInfo info = roi.getBgForm();
            info.put("myBgPeriod", info.getBgPeriod());
            if (BgTemFormTypeEnum.VIEWFORM == info.getBgTemplate().getFormType()) continue;
            Book _book = info.getBook();
            byte[] newData = iReport.backCacl((IObjectValue)info, info.getZipData());
            info.setData(newData);
            _book = IOHelper.unpackBook((byte[])newData);
            if (BgNFSHelper.checkHasAdjust((IObjectValue)info)) {
                InputStream is = null;
                ObjectInputStream ois = null;
                HashMap adjustMap = null;
                if (info.getAdjustMapData() != null && info.getAdjustMapData().length > 0) {
                    try {
                        is = ZipUtil.unpack((byte[])info.getAdjustMapData());
                        ois = new ObjectInputStream(is);
                        adjustMap = (HashMap)ois.readObject();
                    }
                    catch (Throwable e) {
                        ProgressUI.setRecalculateStopFlag(true);
                        this.destroyWindow();
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (Exception e) {
                            ProgressUI.setRecalculateStopFlag(true);
                            this.destroyWindow();
                        }
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                        }
                        catch (Exception e) {
                            ProgressUI.setRecalculateStopFlag(true);
                            this.destroyWindow();
                        }
                    }
                }
                if (adjustMap == null) {
                    adjustMap = new HashMap();
                }
                adjustMap = BgNAdjHelper.getTmpDataOfFormula((BgFormInfo)info, adjustMap);
                Map initValueMap = BgNFormFacadeFactory.getRemoteInstance().getInitBudgetData(info.getAdjust().getId().toString());
                this.updateChangeValueInfo(_book, initValueMap, adjustMap);
                if (adjustMap != null && !adjustMap.isEmpty()) {
                    ByteArrayOutputStream baos = null;
                    ObjectOutputStream oos = null;
                    try {
                        baos = new ByteArrayOutputStream();
                        oos = new ObjectOutputStream(baos);
                        oos.writeObject(adjustMap);
                        info.setAdjustMapData(ZipUtil.pack((ByteArrayOutputStream)baos));
                    }
                    finally {
                        if (baos != null) {
                            baos.close();
                        }
                        if (oos != null) {
                            oos.close();
                        }
                    }
                }
            } else {
                this.recoverTables(_book);
            }
            info.setBook(_book);
            iBgForm.submit(info.getId(), (IObjectValue)info, true);
            roi.setRecalculateResult("success");
        }
        if (!ProgressUI.isRecalculateStopFlag()) {
            this.destroyWindow();
        }
    }

    public void updateChangeValueInfo(Book _book, Map initValueMap, Map adjustMap) {
        if (_book == null || initValueMap == null || adjustMap == null || initValueMap.isEmpty() || adjustMap.isEmpty()) {
            return;
        }
        Sheet _sheet = null;
        int size = _book.getSheetCount();
        for (int index = 0; index < size; ++index) {
            _sheet = _book.getSheet(index);
            this.updateSheetChangeValueInfo(initValueMap, adjustMap, _sheet);
        }
    }

    private void updateSheetChangeValueInfo(Map initValueMap, Map adjustMap, Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                _cell = sheet.getCell(rowIndex, colIndex, false);
                this.updateCellChangeValueInfo(initValueMap, adjustMap, _cell);
            }
        }
    }

    private void updateCellChangeValueInfo(Map initValueMap, Map adjustMap, Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
            Object _obj = null;
            BigDecimal _newValue = null;
            BigDecimal _oldValue = null;
            String _formulaStr = null;
            _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
            _obj = BgNFSHelper.getValue((Cell)cell);
            if (_obj instanceof BigDecimal) {
                _newValue = (BigDecimal)_obj;
            } else {
                try {
                    _newValue = new BigDecimal(_obj.toString());
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue((Cell)cell, (Object)BgNConstants.ZERO);
                    _newValue = BgNConstants.ZERO;
                }
            }
            if (initValueMap.containsKey(_formulaStr)) {
                _oldValue = (BigDecimal)initValueMap.get(_formulaStr);
                if (_newValue.compareTo(_oldValue) != 0) {
                    if (adjustMap.containsKey(_formulaStr)) {
                        this.updateDivInfo(cell, _formulaStr, _newValue, adjustMap);
                    } else {
                        this.createDivInfo(cell, _formulaStr, _newValue, _oldValue, adjustMap);
                    }
                } else {
                    this.removeDivInfo(cell, _formulaStr, adjustMap);
                }
            }
        }
    }

    private void removeDivInfo(Cell cell, String formulaStr, Map adjustMap) {
        adjustMap.remove(formulaStr);
        BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.BASE_COLOR);
    }

    private void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue, Map adjustMap) {
        BgFormDiversityData divData = new BgFormDiversityData();
        divData.setFormula(formulaStr);
        divData.setNewValue(newValue);
        divData.setOldValue(oldValue);
        divData.setAdjustor(this.getUserPk().toString());
        divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        adjustMap.put(formulaStr, divData);
        BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.EDIT_COLOR);
    }

    private void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, Map adjustMap) {
        BgFormDiversityData divData = (BgFormDiversityData)adjustMap.get(formulaStr);
        if (divData != null) {
            divData.setNewValue(newValue);
            divData.setAdjustor(this.getUserPk().toString());
            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        }
        BgNFSHelper.setBackGroup((Cell)cell, (Color)BgNConstants.EDIT_COLOR);
    }

    private void recoverTables(Book book) {
        int tableSize = book.getSheetCount();
        for (int tableIndex = 0; tableIndex < tableSize; ++tableIndex) {
            Sheet sheet = book.getSheet(tableIndex);
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            for (int r = 0; r <= rowCount; ++r) {
                for (int c = 0; c <= colCount; ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    if (cell == null || !cell.hasFormula() || !BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                    try {
                        Object obj = BgNFSHelper.getValue((Cell)cell);
                        BgNFSHelper.setBudgetValue((Cell)cell, (BigDecimal)new BigDecimal(obj.toString()));
                        continue;
                    }
                    catch (Exception ex) {
                        BgNFSHelper.setBudgetValue((Cell)cell, (BigDecimal)BgNConstants.ZERO);
                    }
                }
            }
        }
    }

    private void createReportUI(List bgFormList) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("bgFormList", bgFormList);
        ctx.put("beginTime", this.beginTime.toLocaleString());
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(BgRecalculateReportUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (UIException e) {
            ProgressUI.setRecalculateStopFlag(true);
            this.destroyWindow();
        }
    }

    public boolean destroyWindow() {
        BgNCHelper.refreshListUI((CoreUI)this);
        return super.destroyWindow();
    }

    public List getAllBgFormInfoList() {
        return this.allBgFormInfoList;
    }

    private class MultiRecalculateThread
    extends Thread {
        private List allBgFormInfoList;

        public MultiRecalculateThread(List allBgFormInfoList) {
            this.allBgFormInfoList = allBgFormInfoList;
        }

        @Override
        public void run() {
            try {
                ProgressUI.this.MultiTableCalculate(this.allBgFormInfoList);
            }
            catch (Exception e) {
                ProgressUI.setRecalculateStopFlag(true);
                ProgressUI.this.destroyWindow();
            }
        }
    }

    private class CreateReportUIThread
    extends Thread {
        private CreateReportUIThread() {
        }

        @Override
        public void run() {
            ProgressUI.this.createReportUI(ProgressUI.this.allBgFormInfoList);
        }
    }
}

