/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.DefaultTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.client.AbstractProjectFormulaUI;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgTemplateProcessUI;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class ProjectFormulaUI
extends AbstractProjectFormulaUI
implements FocusListener {
    private static final long serialVersionUID = -486983600504720062L;
    private static String formula = "";
    public static final String CURRENTBGPERIODNUMBER = "currentBgPeiodNumber";

    public void onLoad() throws Exception {
        super.onLoad();
        NewBgItemDialog boxProject = new NewBgItemDialog((IUIObject)this);
        this.budgetProject.setSelector((KDPromptSelector)boxProject);
        this.budgetProject.getEditor().addFocusListener(this);
        BgPeriodDialog boxPeriod = new BgPeriodDialog(this);
        this.budgetPeriod.setSelector((KDPromptSelector)boxPeriod);
        this.budgetPeriod.getEditor().addFocusListener(this);
        BgElementDialog boxElement = new BgElementDialog((IUIObject)this);
        this.budgetElement.setSelector((KDPromptSelector)boxElement);
        this.budgetElement.getEditor().addFocusListener(this);
        this.budgetCurrency.getEditor().addFocusListener(this);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        formula = "";
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        String bgProject = this.budgetProject.getText();
        String bgPeriod = this.budgetPeriod.getText();
        String bgElmt = this.budgetElement.getText();
        String bgCurrency = this.budgetCurrency.getText();
        if (this.getUIContext().get("Owner") != null && !(this.getUIContext().get("Owner") instanceof BgTemplateProcessUI) && this.getUIContext().get(CURRENTBGPERIODNUMBER) != null && this.getUIContext().get(CURRENTBGPERIODNUMBER) instanceof String) {
            String currentBgPeriodNumber = (String)this.getUIContext().get(CURRENTBGPERIODNUMBER);
            boolean isRelativeBgPeriod = false;
            int relativeValue = 0;
            try {
                relativeValue = Integer.parseInt(bgPeriod);
                isRelativeBgPeriod = true;
            }
            catch (NumberFormatException e1) {
                isRelativeBgPeriod = false;
            }
            if (isRelativeBgPeriod && Math.abs(relativeValue) > 100) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"257_BgFormProcessUI"));
                return;
            }
            if (isRelativeBgPeriod) {
                try {
                    bgPeriod = BgHelper.getRelativeBgPeriod(null, currentBgPeriodNumber, relativeValue);
                }
                catch (Exception e1) {
                    MsgBox.showWarning((Component)((Object)this), (String)e1.getMessage());
                    return;
                }
            }
        }
        String[] param = new String[]{bgProject, bgPeriod, bgElmt, bgCurrency};
        formula = this.constructFormula(param);
        this.getUIWindow().close();
    }

    private String constructFormula(String[] array) {
        String str = "BgData";
        String formula = "=BgItem(\"" + array[0] + "\",\"" + array[1] + "\",\"" + array[2] + "\",\"" + "BgData" + "\",true,\"" + array[3] + "\")";
        return formula;
    }

    public static String getFormula() {
        return formula;
    }

    public static void setFormula(String formula) {
        ProjectFormulaUI.formula = formula;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object comp = e.getSource();
        if (comp == null || !(comp instanceof DefaultTextField)) {
            return;
        }
        String parentCompName = ((DefaultTextField)comp).getParent().getName();
        if (parentCompName.equals("budgetProject")) {
            this.txtDescription.setText(this.kDLabelContainer1.getBoundLabelText());
        } else if (parentCompName.equals("budgetPeriod")) {
            this.txtDescription.setText(this.kDLabelContainer2.getBoundLabelText());
        } else if (parentCompName.equals("budgetElement")) {
            this.txtDescription.setText(this.kDLabelContainer3.getBoundLabelText());
        } else if (parentCompName.equals("budgetCurrency")) {
            this.txtDescription.setText(this.kDLabelContainer4.getBoundLabelText());
        } else {
            this.txtDescription.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

