/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgFDCConstants;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgItemImportFacadeFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItemImportFacade;
import com.kingdee.eas.ma.budget.client.AbstractQueryBizBillUI;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QueryBizBillUI
extends AbstractQueryBizBillUI {
    private static final Logger logger = CoreUIObject.getLogger(QueryBizBillUI.class);
    private Map subSystems = null;
    private Map subSystem2BizBill = null;
    BgFormInfo bgFormInfo = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Object bgFormId = this.getUIContext().get("bgFormId");
        BgFormInfo form = null;
        if (this.getUIContext().get("bgFormInfo") instanceof BgFormInfo) {
            form = (BgFormInfo)this.getUIContext().get("bgFormInfo");
        }
        if (form == null) {
            SysUtil.abort();
        }
        if (bgFormId == null || bgFormId.toString().length() == 0) {
            return;
        }
        this.cmbSubSys.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.cmbSubSys.addItem((Object)BgFDCConstants.FDC_PAYMENT_SYSTEM_ALIAS);
        this.cmbSubSys.setEnabled(false);
        this.cmbBizBill.addItem((Object)BgFDCConstants.FDC_YEAR_BILL_ALIAS);
        this.cmbBizBill.addItem((Object)BgFDCConstants.FDC_MONTH_BILL_ALIAS);
        this.cmbBizBill.addItem((Object)BgFDCConstants.FDC_EXE_BILL_ALIAS);
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("bgPeriod.id"));
        sic.add(new SelectorItemInfo("bgPeriod.name"));
        sic.add(new SelectorItemInfo("bgPeriod.number"));
        sic.add(new SelectorItemInfo("bgPeriod.periodType"));
        sic.add(new SelectorItemInfo("bgPeriod.year"));
        sic.add(new SelectorItemInfo("bgPeriod.month"));
        try {
            this.bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId.toString()), sic);
        }
        catch (ObjectNotFoundException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        if (this.bgFormInfo == null) {
            this.bgFormInfo = form;
        }
        FullOrgUnitInfo bgFormCostCenter = this.bgFormInfo.getOrgUnit();
        CostCenterOrgUnitInfo ccOrg = new CostCenterOrgUnitInfo();
        ccOrg.setId(bgFormCostCenter.getId());
        ccOrg.setNumber(bgFormCostCenter.getNumber());
        ccOrg.setName(bgFormCostCenter.getName());
        bgFormCostCenter.setLongNumber(bgFormCostCenter.getLongNumber());
        BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
        orgView.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"356_QueryBizBillUI"));
        orgView.setMultiSelect(false);
        this.orgPromptBox.setSelector((KDPromptSelector)orgView);
        this.orgPromptBox.setData((Object)ccOrg);
        this.orgPromptBox.setDisplayFormat("$name$");
        this.orgPromptBox.setEditFormat("$name$");
        this.orgPromptBox.setCommitFormat("$number$");
        BgPeriodInfo bgFormPeriod = this.bgFormInfo.getBgPeriod();
        BgPeriodDialog bgPeriodDialog = null;
        bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.periodPromptBox.setSelector((KDPromptSelector)bgPeriodDialog);
        this.periodPromptBox.setData((Object)bgFormPeriod);
        this.periodPromptBox.setDisplayFormat("$name$");
        this.periodPromptBox.setEditFormat("$name$");
        this.periodPromptBox.setCommitFormat("$number$");
    }

    @Override
    public void actionQueryBizBill_actionPerformed(ActionEvent e) throws Exception {
        if (this.cmbSubSys.getSelectedItem() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"357_QueryBizBillUI"));
            SysUtil.abort();
        }
        if (this.cmbBizBill.getSelectedItem() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"358_QueryBizBillUI"));
            SysUtil.abort();
        }
        if (this.orgPromptBox.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"198_BgCtrlSchemeAssignChildUI"));
            SysUtil.abort();
        }
        if (this.periodPromptBox.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"359_QueryBizBillUI"));
            SysUtil.abort();
        }
        CostCenterOrgUnitInfo costCenter = (CostCenterOrgUnitInfo)this.orgPromptBox.getData();
        BgPeriodInfo periodInfo = (BgPeriodInfo)this.periodPromptBox.getData();
        IBgItemImportFacade facade = BgItemImportFacadeFactory.getRemoteInstance();
        String billId = facade.queryFDCBill(this.cmbBizBill.getSelectedItem().toString(), costCenter.getId().toString(), periodInfo.getId().toString());
        UIContext uiContext = new UIContext((Object)this);
        String popUI = null;
        if (BgFDCConstants.FDC_YEAR_BILL_ALIAS.equals(this.cmbBizBill.getSelectedItem())) {
            popUI = "com.kingdee.eas.fdc.finance.client.FDCYearBudgetAcctEditUI";
            uiContext.put((Object)"ID", (Object)billId);
        } else if (BgFDCConstants.FDC_MONTH_BILL_ALIAS.equals(this.cmbBizBill.getSelectedItem())) {
            popUI = "com.kingdee.eas.fdc.finance.client.FDCMonthBudgetAcctEditUI";
            uiContext.put((Object)"ID", (Object)billId);
        } else if (BgFDCConstants.FDC_EXE_BILL_ALIAS.equals(this.cmbBizBill.getSelectedItem())) {
            popUI = "com.kingdee.eas.fdc.finance.client.FDCBudgetAcctExecUI";
            uiContext.put((Object)"costCenterId", (Object)costCenter.getId().toString());
            uiContext.put((Object)"year", (Object)new Integer(periodInfo.getYear()));
            uiContext.put((Object)"month", (Object)new Integer(periodInfo.getMonth()));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(popUI, (Map)uiContext, null, "VIEW");
        uiWindow.show();
    }

    private void initSubSystemsAndBizBills() {
        this.subSystems = new HashMap();
        this.subSystem2BizBill = new HashMap();
        DefaultKingdeeTreeNode root = SubSystemUtils.getKDTreeNode((IBriefViewTreeNode)SubSystemUtils.getRemoveEmptyPackageNode((IBriefViewTreeNode)SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_botp", (BOSObjectType)MetaDataTypeList.ENTITY)));
        this.traceLeafNode(root);
    }

    private void traceLeafNode(DefaultKingdeeTreeNode node) {
        MetaDataBriefInfo briefInfo = (MetaDataBriefInfo)node.getUserObject();
        BizBillMetaBriefInfo bizNodeBriefInfo = new BizBillMetaBriefInfo(briefInfo);
        if (bizNodeBriefInfo.getMetaDatatype().equals((Object)MetaDataTypeList.ENTITY)) {
            List<BizBillMetaBriefInfo> bizBillList;
            DefaultKingdeeTreeNode packageNode = (DefaultKingdeeTreeNode)node.getParent();
            MetaDataBriefInfo packageBriefInfo = (MetaDataBriefInfo)packageNode.getUserObject();
            BizBillMetaBriefInfo bizPackageBriefInfo = new BizBillMetaBriefInfo(packageBriefInfo);
            if (!this.subSystems.containsKey(bizPackageBriefInfo.getFullName())) {
                this.subSystems.put(bizPackageBriefInfo.getFullName(), bizPackageBriefInfo);
            }
            if (this.subSystem2BizBill.containsKey(bizPackageBriefInfo.getFullName())) {
                bizBillList = (List)this.subSystem2BizBill.get(bizPackageBriefInfo.getFullName());
            } else {
                bizBillList = new ArrayList();
                this.subSystem2BizBill.put(bizPackageBriefInfo.getFullName(), bizBillList);
            }
            bizBillList.add(bizNodeBriefInfo);
        } else {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.traceLeafNode(childNode);
            }
        }
    }

    protected void cmbSubSys_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            BizBillMetaBriefInfo bizBriefInfo;
            if (this.cmbSubSys.getSelectedIndex() >= 0 && this.subSystem2BizBill.containsKey((bizBriefInfo = (BizBillMetaBriefInfo)this.cmbSubSys.getSelectedItem()).getFullName())) {
                List bizBillList = (List)this.subSystem2BizBill.get(bizBriefInfo.getFullName());
                this.fillBizBillList(bizBillList);
            }
        } else {
            this.cmbBizBill.removeAllItems();
        }
    }

    private void fillBizBillList(Collection bizBillList) {
        Iterator iter = bizBillList.iterator();
        while (iter.hasNext()) {
            this.cmbBizBill.addItem(iter.next());
        }
    }

    private class BizBillMetaBriefInfo {
        private String packageName;
        private String name;
        private String fullName;
        private String alias;
        private String description;
        private boolean isPackage;
        private String bosType;
        BOSObjectType metaDatatype;
        private IObjectValue metaData;

        public BizBillMetaBriefInfo(MetaDataBriefInfo briefInfo) {
            this.setPackageName(briefInfo.getPackgeName());
            this.setPackage(briefInfo.isPackage());
            this.setName(briefInfo.getName());
            this.setAlias(briefInfo.getAlias());
            this.setDescription(briefInfo.getDescription());
            this.setMetaDatatype(briefInfo.getMetaDataType());
        }

        public boolean isPackage() {
            return this.isPackage;
        }

        public void setPackage(boolean isPackage) {
            this.isPackage = isPackage;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getBosType() {
            return this.bosType;
        }

        public void setBosType(String bosType) {
            this.bosType = bosType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public IObjectValue getMetaData() {
            if (this.metaData == null) {
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                this.metaData = loader.get(this.getMetaDatatype(), this.getMetaDataPK());
            }
            return this.metaData;
        }

        public void setMetaData(IObjectValue metaData) {
            this.metaData = metaData;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getFullName() {
            if (this.fullName == null) {
                this.fullName = this.isPackage() ? this.getPackageName() : this.getPackageName() + "." + this.getName();
            }
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public IMetaDataPK getMetaDataPK() {
            return new MetaDataPK(this.getPackageName(), this.getName());
        }

        public BOSObjectType getMetaDatatype() {
            return this.metaDatatype;
        }

        public void setMetaDatatype(BOSObjectType metaDatatype) {
            this.metaDatatype = metaDatatype;
        }

        public String toString() {
            return this.alias;
        }
    }
}

