/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.ReCalculateFacadeFactory;
import com.kingdee.eas.ma.budget.client.AbstractRecalculatePeriodF7UI;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;

public class RecalculatePeriodF7UI
extends AbstractRecalculatePeriodF7UI {
    private static final long serialVersionUID = -7814064098041528104L;
    private Object rtnVal;

    public void onLoad() throws Exception {
        super.onLoad();
        Date beginDate = (Date)this.getUIContext().get("beginDate");
        Date endDate = (Date)this.getUIContext().get("endDate");
        List periodList = ReCalculateFacadeFactory.getRemoteInstance().getPeriodsBySchemeDate(beginDate, endDate);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setEditable(false);
        int num = periodList.size();
        for (int i = 0; i < num; ++i) {
            BgPeriodInfo info = (BgPeriodInfo)periodList.get(i);
            IRow row = this.tblMain.addRow(i);
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("type").setValue((Object)info.getPeriodType().getAlias());
            row.getCell("dateFrom").setValue((Object)info.getBeginDate());
            row.getCell("dateTo").setValue((Object)info.getEndDate());
        }
    }

    public Object getSelectedPeriodInfo() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return null;
        }
        BgPeriodInfo info = new BgPeriodInfo();
        IRow row = this.tblMain.getRow(rowIndex);
        info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        info.setName(row.getCell("name").getValue().toString());
        return info;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.rtnVal = null;
        this.getUIWindow().close();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.rtnVal = this.getSelectedPeriodInfo();
        this.getUIWindow().close();
    }

    public Object getRtnVal() {
        return this.rtnVal;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount = e.getClickCount();
        if (clickCount == 2) {
            this.rtnVal = this.getSelectedPeriodInfo();
            this.getUIWindow().close();
        }
    }
}

