/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.util.SumItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.util.TokenMgrError;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemException;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemObject;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.AbstractSumBgItemFormulaPickerUI;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SumBgItemFormulaPickerUI
extends AbstractSumBgItemFormulaPickerUI {
    private static final Logger logger = CoreUIObject.getLogger(SumBgItemFormulaPickerUI.class);
    public String sumItemFormula = null;
    public BgItemCollection subItems = null;

    public SumBgItemFormulaPickerUI() throws Exception {
        this.lblSumFormula.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.btnPlus.setText(null);
        this.btnPlus.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setText(null);
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMultiply.setText(null);
        this.btnMultiply.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivide.setText(null);
        this.btnDivide.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnClear.setText(null);
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.txtExpression.setMaxLength(4000);
        this.mltBgItemF7.setEditable(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = super.getUIContext();
        this.sumItemFormula = uiCtx.get("SUMITEMFORMULA") != null ? uiCtx.get("SUMITEMFORMULA").toString() : "";
        NewBgItemDialog bgItem = new NewBgItemDialog((IUIObject)this);
        bgItem.setSelectCombinItem(false);
        this.mltBgItemF7.setSelector((KDPromptSelector)bgItem);
        this.txtExpression.setSelectAllOnFocus(false);
        this.txtExpression.setText(this.sumItemFormula);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (!this.checkFormula(this.txtExpression.getText().toString())) {
            return;
        }
        this.toSubItems();
        this.sumItemFormula = this.txtExpression.getText() != null ? this.txtExpression.getText().toString() : "";
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnClear_actionPerformed(e);
        this.txtExpression.setText("");
        this.txtExpression.requestFocus();
    }

    @Override
    public void insertOperatorAction_actionPerformed(ActionEvent e) throws Exception {
        super.insertOperatorAction_actionPerformed(e);
        int ch = 0;
        Object src = e.getSource();
        if (src == this.btnPlus) {
            ch = 43;
        } else if (src == this.btnMinus) {
            ch = 45;
        } else if (src == this.btnMultiply) {
            ch = 42;
        } else if (src == this.btnDivide) {
            ch = 47;
        } else if (src == this.btnInsert) {
            ch = 105;
        }
        this.insertOperator((char)ch);
        this.txtExpression.setCaretPosition(this.txtExpression.getText().length());
    }

    private void insertOperator(char ch) {
        String txtInsert = null;
        int pos = this.txtExpression.getCaretPosition();
        if (this.canInsert(ch)) {
            if (ch != '(') {
                if (ch == 'i') {
                    if (this.mltBgItemF7.getValue() != null) {
                        BgItemInfo item = null;
                        if (this.mltBgItemF7.getValue() instanceof BgItemInfo) {
                            item = (BgItemInfo)this.mltBgItemF7.getValue();
                        } else {
                            BgItemCollection itemCollection = ((BgItemObject)this.mltBgItemF7.getValue()).getResult();
                            item = itemCollection.get(0);
                        }
                        if (item != null) {
                            txtInsert = item.getNumber().toString().trim();
                        }
                    }
                } else {
                    txtInsert = Character.toString(ch);
                }
                this.txtExpression.insert(txtInsert, pos);
            } else {
                this.txtExpression.insert("()", pos);
                this.txtExpression.setCaretPosition(pos + 1);
            }
        }
    }

    private boolean canInsert(char ch) {
        boolean res = false;
        String line = this.txtExpression.getText();
        String regexp = null;
        if (ch == 'i') {
            regexp = "[\\+|\\-|\\*|\\/]{1}+";
        } else if (ch == '+' || ch == '-' || ch == '*' || ch == '/') {
            regexp = "[^\\+|^\\-|^\\*|^\\/|^\\s]{1,}";
        }
        Pattern pt = Pattern.compile(regexp);
        Matcher matcher = pt.matcher(line);
        int scanIndex = line.length() == 0 ? line.length() : line.length() - 1;
        res = matcher.find(scanIndex) | (ch == 'i' && line.length() == 0);
        return res;
    }

    private boolean checkFormula(String s) throws EASBizException {
        if (s == null || s.length() == 0) {
            return true;
        }
        SumItemFormula parser = new SumItemFormula(s);
        try {
            parser.formulaLine();
        }
        catch (Exception e) {
            return false;
        }
        catch (TokenMgrError e) {
            throw new BgItemException(BgItemException.INVALIDNUMBER);
        }
        return true;
    }

    private void toSubItems() throws EASBizException, BOSException {
        String str = this.txtExpression.getText().toString();
        if (str == null || str.length() == 0) {
            return;
        }
        IBgItem ie = BgItemFactory.getRemoteInstance();
        this.subItems = (BgItemCollection)ie.getItemListBySumItemFormula(str);
    }
}

