/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.InitImportBase;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.pca.IPcaFlag;
import com.kingdee.eas.ma.pca.InitPcAccountBalanceFactory;
import com.kingdee.eas.ma.pca.InitPcAccountBalanceInfo;
import com.kingdee.eas.ma.pca.PcaFlagFactory;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.app.PcaInitHelp;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitPcAccountBalanceImport
extends InitImportBase {
    private static final Logger logger = Logger.getLogger(InitPcAccountBalanceImport.class);
    private String accountid = null;
    private String companyid;
    private String actualAssistantHGInfoID = null;
    private String currecyID = null;
    private String profitCenterid = null;
    private String orgNumber = null;
    private Map companyMap = new HashMap();
    private int baseCurrencyPrecision = 4;
    private int reportCurrencyPrecision = 4;
    private int qtyScale = 0;
    private boolean isFirstLoaded = true;
    private Map currencyMap = new HashMap();
    private int rowNumber = 1;
    private ProfitCenterOrgUnitInfo profitCenterInfo = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private String currencyId = null;
    private String accountTableId = null;
    private CurrencyInfo currencyInfo = null;
    private boolean pca_055 = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InitPcAccountBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getType(), (Throwable)e);
        }
    }

    protected ProfitCenterOrgUnitInfo getProfitCenter(Context ctx, Hashtable hsData, String profitCenterIdstr) throws UuidException, SQLException, Exception {
        String orgUnitID = ((DataToken)hsData.get((Object)"FProfitCenterID")).data.toString();
        IProfitCenterOrgUnit profitCenterOrgUnit = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        ProfitCenterOrgUnitInfo profitCenterInfo = profitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterIdstr));
        ObjectUuidPK pk = new ObjectUuidPK(profitCenterInfo.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        profitCenterInfo = profitCenterOrgUnit.getProfitCenterOrgUnitInfo((IObjectPK)pk, sic);
        if (!profitCenterInfo.getNumber().equals(orgUnitID)) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1011_InitImportBase", (Locale)ctx.getLocale()));
        }
        return profitCenterInfo;
    }

    protected CompanyOrgUnitInfo getCompany(Context ctx, String CompanyIdStr) throws UuidException, SQLException, Exception {
        ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(CompanyIdStr));
        ObjectUuidPK pk = new ObjectUuidPK(unitInfo.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GlUtils.getCompanySic());
        unitInfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
        return unitInfo;
    }

    protected void isCloseInit(Context ctx, AccountViewInfo account, String ProfitCenterIdStr, boolean isCussent) throws Exception, BOSException {
        IPcaFlag flag = PcaFlagFactory.getLocalInstance(ctx);
        String[] closedAccount = null;
        closedAccount = isCussent ? flag.getAllCussentInitClosed(ProfitCenterIdStr) : flag.getAllAstInitClosed(ProfitCenterIdStr);
        if (closedAccount != null && Arrays.asList(closedAccount).contains(account.getId().toString())) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1012_InitImportBase", (Locale)ctx.getLocale()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AccountViewInfo getAccount(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitCenter, CurrencyInfo currency, Hashtable hsData, boolean isCussent) throws Exception, SQLException {
        AccountViewInfo account = null;
        String accountID = ((DataToken)hsData.get((Object)"FAccountID")).data.toString();
        BOSUuid cuID = company.getId();
        BOSUuid accountTableID = company.getAccountTable().getId();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("hasUserProperty"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("CAA.*"));
        sic.add(new SelectorItemInfo("accountTypeID.*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)cuID.toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableID.toString()));
        filterInfo.setMaskString("#0 and #1");
        view.setFilter(filterInfo);
        AccountViewCollection accountColl = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        for (int i = 0; i < accountColl.size(); ++i) {
            ObjectBaseInfo info = (ObjectBaseInfo)accountColl.getObject(i);
            if (info.getString("number") == null || !info.getString("number").equals(accountID)) continue;
            account = (AccountViewInfo)info;
        }
        if ("InitPcAccountBalance".equals(this.getType())) {
            if (account == null) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1014_InitImportBase", (Locale)ctx.getLocale()));
            if (!account.isIsLeaf() || account.getCAA() != null && this.pca_055) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PCAVoucherImpResource", (String)"accountError", (Locale)ctx.getLocale()));
            }
            if (account.getAccountingcurrency().getValue() != 0 || currency.getId().equals((Object)company.getBaseCurrency().getId())) return account;
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
        }
        if (account == null) throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1015_InitImportBase", (Locale)ctx.getLocale()));
        if (!account.isIsLeaf() || account.getCAA() == null) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.ma.pca.PCAVoucherImpResource", (String)"accountError", (Locale)ctx.getLocale()));
        }
        if (account.getAccountingcurrency().getValue() == 0 && !currency.getId().equals((Object)company.getBaseCurrency().getId())) {
            throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1013_InitImportBase", (Locale)ctx.getLocale()));
        }
        this.isCloseInit(ctx, account, isCussent);
        return account;
    }

    protected Object[] getExchangeRate(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitcenter, String orgCurId) throws EASBizException, BOSException {
        CurrencyInfo reportCur = company.getReportCurrency();
        CurrencyInfo localCur = company.getBaseCurrency();
        HashMap<String, Object> otherCtx = new HashMap<String, Object>();
        AccountTableInfo accouttable = company.getAccountTable();
        String cuid = company.getCU().getId().toString();
        otherCtx.put("COMPANY", company);
        otherCtx.put("CUID", cuid);
        otherCtx.put("ACCOUNTTABLEID", accouttable.getId().toString());
        LowTimer low = new LowTimer();
        low.reset();
        Map hmParamValue = PcaInitHelp.getInitParam((Context)ctx, (CompanyOrgUnitInfo)company, (String)profitcenter.getId().toString());
        boolean isUsingReport = (Boolean)hmParamValue.get("G001");
        PeriodInfo[] periods = this.getPeriods(ctx, company, profitcenter);
        PeriodInfo startPeriod = periods[0];
        Object[] info = new Object[8];
        if (company.getBaseExchangeTable() == null) {
            throw new GLException(GLException.NOLOCALEXTABLE);
        }
        info[0] = company.getBaseExchangeTable().getId().toString();
        info[2] = orgCurId;
        info[3] = localCur.getId().toString();
        if (isUsingReport) {
            info[4] = reportCur.getId().toString();
            info[1] = company.getReportExchangeTable().getId().toString();
        }
        info[5] = startPeriod.getBeginDate();
        info[7] = company.getId().toString();
        Object[] exes = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchExchangeRate(info);
        return exes;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        InitPcAccountBalanceInfo infos = null;
        Map pageParam = super.getContextMap();
        try {
            int precision;
            BigDecimal amt;
            BigDecimal qty;
            boolean isSettleByLocal;
            CompanyOrgUnitInfo[] relateCompanys;
            infos = new InitPcAccountBalanceInfo();
            ProfitCenterOrgUnitInfo profitCenter = this.getProfitCenter(ctx, hsData, pageParam.get("PROFITCENTERID").toString());
            ctx.remove((Object)"PROFITCENTER");
            ctx.put((Object)"PROFITCENTER", (Object)profitCenter);
            infos.setProfitCenter(profitCenter);
            infos.setFromExcel(true);
            this.profitCenterid = profitCenter.getId().toString();
            ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            Object companyStr = null;
            CompanyOrgUnitInfo company = null;
            String orgUnitNum = ((DataToken)hsData.get((Object)"FCompanyID")).data.toString();
            if (StringUtils.isEmpty((String)orgUnitNum)) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"companyIsNull", (Locale)ctx.getLocale()));
            }
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("isBizUnit"));
            sic.add(new SelectorItemInfo("accountPeriodType.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
            sic.add(new SelectorItemInfo("reportCurrency.number"));
            sic.add(new SelectorItemInfo("reportCurrency.name"));
            sic.add(new SelectorItemInfo("reportCurrency.precision"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("reportExchangeTable.id"));
            sic.add(new SelectorItemInfo("reportConvertMode"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.longNumber"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("number", (Object)orgUnitNum));
            CompanyOrgUnitCollection cs = companyOrgUnit.getCompanyOrgUnitCollection(view);
            if (cs.size() == 1) {
                company = cs.get(0);
            }
            CompanyOrgUnitInfo[] companyOrgUnitInfoArray = relateCompanys = this.companyMap != null ? (CompanyOrgUnitInfo[])this.companyMap.get(profitCenter.getNumber() + "RelatedCom") : null;
            if (relateCompanys == null) {
                relateCompanys = PcaUtils.getRelatedAndAccountingCompany(ctx, profitCenter.getId().toString());
            }
            boolean isRelatedCom = false;
            for (int j = 0; j < relateCompanys.length && company != null; ++j) {
                if (!relateCompanys[j].getId().toString().equals(company.getId().toString())) continue;
                isRelatedCom = true;
                break;
            }
            if (!isRelatedCom) {
                throw new Exception(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"companyIsNotRelatedCompany", (Locale)ctx.getLocale()));
            }
            ctx.remove((Object)"COMPANY");
            ctx.put((Object)"COMPANY", (Object)company);
            infos.setOrgUnit(company);
            CurrencyInfo currency = this.getCurrency(ctx, hsData);
            this.currecyID = currency.getId().toString();
            infos.setCurrency(currency);
            if (pageParam.get("PCA_055") != null) {
                this.pca_055 = Boolean.valueOf(pageParam.get("PCA_055").toString());
            }
            String relatedCompanyId = PcaUtils.getRelatedCompanyIds(ctx, profitCenter.getId().toString());
            CompanyOrgUnitInfo relatedCompanyInfo = PcaUtils.getCompanyById(ctx, relatedCompanyId);
            AccountViewInfo account = this.getAccount(ctx, relatedCompanyInfo, profitCenter, currency, hsData, true);
            this.accountid = account.getId().toString();
            infos.setAccount(account);
            Object[] exes = this.getExchangeRate(ctx, relatedCompanyInfo, profitCenter, this.currecyID);
            VoucherInfo.ExchangeRateWithValue lex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            VoucherInfo.ExchangeRateWithValue rex = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            if (exes != null) {
                if (exes[0] != null) {
                    lex = (VoucherInfo.ExchangeRateWithValue)exes[0];
                }
                if (exes[1] != null) {
                    rex = (VoucherInfo.ExchangeRateWithValue)exes[1];
                }
            }
            boolean isLocal = this.currecyID.equals(relatedCompanyInfo.getBaseCurrency().getId().toString());
            BigDecimal yearDebitFor = new BigDecimal("0");
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearDebitFor")).data)) {
                infos.setYearDebitFor(this.getValue(hsData.get("FYearDebitFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitLocal")).data)) {
                BigDecimal yearDebitLocal;
                if (currency.getId().toString().equals(relatedCompanyInfo.getBaseCurrency().getId().toString())) {
                    yearDebitLocal = yearDebitFor;
                } else {
                    yearDebitLocal = this.getValue(hsData.get("FYearDebitLocal"));
                    yearDebitLocal = yearDebitLocal.setScale(relatedCompanyInfo.getBaseCurrency().getPrecision(), 4);
                }
                infos.setYearDebitLocal(yearDebitLocal);
            } else if (infos.getYearDebitFor() != null) {
                infos.setYearDebitLocal(lex.getValue().multiply(infos.getYearDebitFor()));
            }
            boolean bl = isSettleByLocal = 3 == relatedCompanyInfo.getReportConvertMode().getValue();
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitRpt")).data)) {
                    infos.setYearDebitRpt(this.getValue(hsData.get("FYearDebitRpt")));
                } else if (infos.getYearDebitFor() != null) {
                    if (isSettleByLocal) {
                        infos.setYearDebitRpt(rex.getValue().multiply(infos.getYearDebitLocal()));
                    } else {
                        infos.setYearDebitRpt(rex.getValue().multiply(infos.getYearDebitFor()));
                    }
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearDebitQty")).data)) {
                qty = this.getValue(hsData.get("FYearDebitQty"));
                infos.setYearDebitQty(qty);
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditQty")).data)) {
                qty = this.getValue(hsData.get("FYearCreditQty"));
                infos.setYearCreditQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FYearCreditFor")).data)) {
                infos.setYearCreditFor(this.getValue(hsData.get("FYearCreditFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditLocal")).data)) {
                infos.setYearCreditLocal(this.getValue(hsData.get("FYearCreditLocal")));
            } else if (infos.getYearCreditFor() != null) {
                infos.setYearCreditLocal(lex.getValue().multiply(infos.getYearCreditFor()));
            }
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearCreditRpt")).data)) {
                    infos.setYearCreditRpt(this.getValue(hsData.get("FYearCreditRpt")));
                } else if (infos.getYearCreditFor() != null) {
                    if (isSettleByLocal) {
                        infos.setYearCreditRpt(rex.getValue().multiply(infos.getYearCreditLocal()));
                    } else {
                        infos.setYearCreditRpt(rex.getValue().multiply(infos.getYearCreditFor()));
                    }
                }
            }
            if (account.isIsQty() && this.CheckString(((DataToken)hsData.get((Object)"FBeginQty")).data)) {
                infos.setEndQty(this.getValue(hsData.get("FBeginQty")));
                qty = this.getValue(hsData.get("FBeginQty"));
                infos.setBeginQty(qty);
            }
            if (this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceFor")).data)) {
                infos.setBeginBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
                infos.setEndBalanceFor(this.getValue(hsData.get("FBeginBalanceFor")));
            }
            if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceLocal")).data)) {
                infos.setBeginBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
                infos.setEndBalanceLocal(this.getValue(hsData.get("FBeginBalanceLocal")));
            } else if (infos.getBeginBalanceFor() != null) {
                infos.setBeginBalanceLocal(lex.getValue().multiply(infos.getBeginBalanceFor()));
                infos.setEndBalanceLocal(lex.getValue().multiply(infos.getBeginBalanceFor()));
            }
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FBeginBalanceRpt")).data)) {
                    infos.setBeginBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
                    infos.setEndBalanceRpt(this.getValue(hsData.get("FBeginBalanceRpt")));
                } else if (infos.getBeginBalanceFor() != null) {
                    if (isSettleByLocal) {
                        infos.setBeginBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceLocal()));
                        infos.setEndBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceFor()));
                    } else {
                        infos.setBeginBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceLocal()));
                        infos.setEndBalanceRpt(rex.getValue().multiply(infos.getBeginBalanceFor()));
                    }
                }
            }
            if (account.getAccountTypeID() != null && account.getAccountTypeID().getProperty().equals((Object)AccountProperty.SUNYI) && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLFor")).data)) {
                infos.setYearPnLFor(this.getValue(hsData.get("FYearPnLFor")));
            }
            if (!isLocal && account.getAccountTypeID() != null && account.getAccountTypeID().getProperty().equals((Object)AccountProperty.SUNYI) && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLLocal")).data)) {
                infos.setYearPnLLocal(this.getValue(hsData.get("FYearPnLLocal")));
            } else if (infos.getYearPnLFor() != null) {
                infos.setYearPnLLocal(lex.getValue().multiply(infos.getYearPnLFor()));
            }
            if (pageParam == null || pageParam.get("G001") == null || Boolean.parseBoolean(pageParam.get("G001").toString())) {
                if (!isLocal && this.CheckString(((DataToken)hsData.get((Object)"FYearPnLRpt")).data)) {
                    infos.setYearPnLRpt(this.getValue(hsData.get("FYearPnLRpt")));
                } else if (infos.getYearPnLFor() != null) {
                    if (isSettleByLocal) {
                        infos.setYearPnLRpt(rex.getValue().multiply(infos.getYearPnLLocal()));
                    } else {
                        infos.setYearPnLRpt(rex.getValue().multiply(infos.getYearPnLFor()));
                    }
                }
            }
            if (infos.getYearDebitFor() != null) {
                amt = infos.getYearDebitFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearDebitFor(amt);
            }
            if (infos.getYearDebitLocal() != null) {
                amt = infos.getYearDebitLocal();
                amt = amt.setScale(relatedCompanyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setYearDebitLocal(amt);
            }
            if (infos.getYearDebitRpt() != null) {
                amt = infos.getYearDebitRpt();
                precision = relatedCompanyInfo.getBaseCurrency().getPrecision();
                if (relatedCompanyInfo.getReportCurrency() != null) {
                    precision = relatedCompanyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearDebitRpt(amt);
            }
            if (infos.getYearCreditFor() != null) {
                amt = infos.getYearCreditFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearCreditFor(amt);
            }
            if (infos.getYearCreditLocal() != null) {
                amt = infos.getYearCreditLocal();
                amt = amt.setScale(relatedCompanyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setYearCreditLocal(amt);
            }
            if (infos.getYearCreditRpt() != null) {
                amt = infos.getYearCreditRpt();
                precision = relatedCompanyInfo.getBaseCurrency().getPrecision();
                if (relatedCompanyInfo.getReportCurrency() != null) {
                    precision = relatedCompanyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearCreditRpt(amt);
            }
            if (infos.getBeginBalanceFor() != null) {
                amt = infos.getBeginBalanceFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setBeginBalanceFor(amt);
            }
            if (infos.getBeginBalanceLocal() != null) {
                amt = infos.getBeginBalanceLocal();
                amt = amt.setScale(relatedCompanyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setBeginBalanceLocal(amt);
            }
            if (infos.getBeginBalanceRpt() != null) {
                amt = infos.getBeginBalanceRpt();
                precision = relatedCompanyInfo.getBaseCurrency().getPrecision();
                if (relatedCompanyInfo.getReportCurrency() != null) {
                    precision = relatedCompanyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setBeginBalanceRpt(amt);
            }
            if (infos.getYearPnLFor() != null) {
                amt = infos.getYearPnLFor();
                amt = amt.setScale(currency.getPrecision(), 4);
                infos.setYearPnLFor(amt);
            }
            if (infos.getYearPnLLocal() != null) {
                amt = infos.getYearPnLLocal();
                amt = amt.setScale(relatedCompanyInfo.getBaseCurrency().getPrecision(), 4);
                infos.setYearPnLLocal(amt);
            }
            if (infos.getYearPnLRpt() != null) {
                amt = infos.getYearPnLRpt();
                precision = relatedCompanyInfo.getBaseCurrency().getPrecision();
                if (relatedCompanyInfo.getReportCurrency() != null) {
                    precision = relatedCompanyInfo.getReportCurrency().getPrecision();
                }
                amt = amt.setScale(precision, 4);
                infos.setYearPnLRpt(amt);
            }
            if (!this.isSltImportUpdate()) {
                StringBuffer sqls = new StringBuffer();
                sqls.append("select fBeginBalanceFor, fBeginBalanceLocal, fBeginBalanceRpt, fBeginQty, ");
                sqls.append("fCreditFor, fCreditLocal, fCreditQty, fCreditRpt, ");
                sqls.append("fDebitFor, fDebitLocal, fDebitQty, fDebitRpt, ");
                sqls.append("fEndBalanceFor, fEndBalanceLocal, fEndBalanceRpt, fEndQty, ");
                sqls.append("fMonthPnLFor, fMonthPnLLocal, fMonthPnLRpt, fYearCreditFor, ");
                sqls.append("fYearCreditLocal, fYearCreditQty, fYearCreditRpt, fYearDebitFor, ");
                sqls.append("fYearDebitLocal, fYearDebitQty, fYearDebitRpt, fYearPnLFor, ");
                sqls.append("fYearPnLLocal, fYearPnLRpt ");
                sqls.append(" from t_pca_initPcAccountbalance a where a.faccountid = ? and a.fcurrencyid = ? ");
                sqls.append(" and a.fprofitcenterid = ? and a.forgunitid = ? ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqls.toString(), (Object[])new Object[]{this.accountid, this.currecyID, this.profitCenterid, company.getId().toString()});
                if (rs != null && rs.size() > 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"1044_InitAccountBalanceImport", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return infos;
    }

    protected String getType() {
        return "InitPcAccountBalance";
    }

    protected PeriodInfo[] getPeriods(Context ctx, CompanyOrgUnitInfo company, ProfitCenterOrgUnitInfo profitcenter) throws BOSException, EASBizException {
        return PcaInitHelp.getPeriods((Context)ctx, (CompanyOrgUnitInfo)company, (ProfitCenterOrgUnitInfo)profitcenter);
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            this.getCurrencyPrecision(ctx);
            result.put("Fno", this.rowNumber);
            result.put("FProfitCenterID", this.profitCenterInfo.getNumber());
            result.put("FCompanyID", rs.getString("companyID.number"));
            result.put("FAccountID", rs.getString("number"));
            String currencyId = rs.getString("balance.currencyid");
            int currencyPre = 2;
            if (this.currencyInfo != null) {
                result.put("Fcurrency", this.currencyInfo.getNumber());
                currencyPre = this.currencyInfo.getPrecision();
            }
            result.put("FYearDebitQty", rs.getBigDecimal("balance.yearDebitQty").setScale(this.qtyScale, 4));
            if (rs.getBigDecimal("balance.yearDebitFor").scale() > currencyPre) {
                result.put("FYearDebitFor", rs.getBigDecimal("balance.yearDebitFor").setScale(rs.getBigDecimal("balance.yearDebitFor").scale(), 4));
            } else {
                result.put("FYearDebitFor", rs.getBigDecimal("balance.yearDebitFor").setScale(currencyPre, 4));
            }
            result.put("FYearDebitLocal", rs.getBigDecimal("balance.yearDebitLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearDebitRpt", rs.getBigDecimal("balance.yearDebitRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FYearCreditQty", rs.getBigDecimal("balance.yearCreditQty").setScale(this.qtyScale, 4));
            if (rs.getBigDecimal("balance.yearCreditFor").scale() > currencyPre) {
                result.put("FYearCreditFor", rs.getBigDecimal("balance.yearCreditFor").setScale(rs.getBigDecimal("balance.yearCreditFor").scale(), 4));
            } else {
                result.put("FYearCreditFor", rs.getBigDecimal("balance.yearCreditFor").setScale(currencyPre, 4));
            }
            result.put("FYearCreditLocal", rs.getBigDecimal("balance.yearCreditLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearCreditRpt", rs.getBigDecimal("balance.yearCreditRpt").setScale(this.reportCurrencyPrecision, 4));
            result.put("FBeginQty", rs.getBigDecimal("balance.beginQty").setScale(this.qtyScale, 4));
            if (rs.getBigDecimal("balance.beginBalanceFor").scale() > currencyPre) {
                result.put("FBeginBalanceFor", rs.getBigDecimal("balance.beginBalanceFor").setScale(rs.getBigDecimal("balance.beginBalanceFor").scale(), 4));
            } else {
                result.put("FBeginBalanceFor", rs.getBigDecimal("balance.beginBalanceFor").setScale(currencyPre, 4));
            }
            result.put("FBeginBalanceLocal", rs.getBigDecimal("balance.beginBalanceLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FBeginBalanceRpt", rs.getBigDecimal("balance.beginBalanceRpt").setScale(this.reportCurrencyPrecision, 4));
            if (rs.getBigDecimal("balance.yearPnLFor").scale() > currencyPre) {
                result.put("FYearPnLFor", rs.getBigDecimal("balance.yearPnLFor").setScale(rs.getBigDecimal("balance.yearPnLFor").scale(), 4));
            } else {
                result.put("FYearPnLFor", rs.getBigDecimal("balance.yearPnLFor").setScale(currencyPre, 4));
            }
            result.put("FYearPnLLocal", rs.getBigDecimal("balance.yearPnLLocal").setScale(this.baseCurrencyPrecision, 4));
            result.put("FYearPnLRpt", rs.getBigDecimal("balance.yearPnLRpt").setScale(this.reportCurrencyPrecision, 4));
            ++this.rowNumber;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    private void getCurrencyPrecision(Context ctx) throws EASBizException, BOSException {
        if (!this.isFirstLoaded) {
            return;
        }
        Map paramMap = this.getContextMap();
        String profitCenterId = (String)paramMap.get("profitCenter.id");
        if (StringUtils.isEmpty((String)profitCenterId)) {
            profitCenterId = ContextUtil.getCurrentProfitUnit((Context)ctx).getId().toString();
        }
        this.orgNumber = this.companyInfo.getNumber();
        this.baseCurrencyPrecision = this.companyInfo.getBaseCurrency() == null ? 4 : this.companyInfo.getBaseCurrency().getPrecision();
        this.reportCurrencyPrecision = this.companyInfo.getReportCurrency() == null ? 4 : this.companyInfo.getReportCurrency().getPrecision();
        ArrayList<String> paramKeys = new ArrayList<String>();
        paramKeys.add("GL_002");
        Map hmParam = PcaUtils.getParamsByKeys(ctx, this.companyInfo.getId().toString(), paramKeys);
        this.qtyScale = hmParam.get("GL_002") == null ? 0 : Integer.parseInt(hmParam.get("GL_002").toString());
        CurrencyCollection currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select id, precision,name,number where id ='" + this.currencyId + "'");
        if (currencyColl != null && currencyColl.size() > 0) {
            this.currencyInfo = currencyColl.get(0);
        }
        this.isFirstLoaded = false;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        String relatedCompanyId = null;
        CompanyOrgUnitInfo relatedCompanyInfo = null;
        try {
            this.dealParam(ctx, paramMap);
            relatedCompanyId = PcaUtils.getRelatedCompanyIds(ctx, this.profitCenterInfo.getId().toString());
            relatedCompanyInfo = PcaUtils.getCompanyById(ctx, relatedCompanyId);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        filter.getFilterItems().add(new FilterItemInfo("accounttable.id", (Object)this.accountTableId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)relatedCompanyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getAccountIdSql(relatedCompanyInfo), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", (Object)this.profitCenterInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("profitCenter.id", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("balance.currencyid", (Object)this.currencyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("balance.currencyid", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgCompany.id", (Object)this.companyInfo.getId().toString(), CompareType.EQUALS));
        String maskString = "#0 and #1 and #2 and (#3 or #4) and (#5 or #6 ) and #7";
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.currencyId) || "22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.currencyId)) {
            maskString = "#0 and #1 and (#3 or #4) and (#5 or #6 ) and #7";
        }
        filter.setMaskString(maskString);
        return filter;
    }

    private void dealParam(Context ctx, Map paramMap) throws EASBizException, BOSException {
        this.currencyId = (String)paramMap.get("currencyid");
        this.accountTableId = (String)paramMap.get("accountTable.id");
        String profitCenterId = (String)paramMap.get("profitCenter.id");
        String companyId = (String)paramMap.get("company.id");
        this.profitCenterInfo = profitCenterId == null ? ContextUtil.getCurrentProfitUnit((Context)ctx) : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
        try {
            this.companyInfo = this.getCompany(ctx, companyId);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getAccountIdSql(CompanyOrgUnitInfo companyInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select a.fid from t_bd_accountview a ").append("left join t_bd_accountcurrency b on  a.fid=b.faccountviewid ").append("where ((a.facctcurrency=1 and b.fcurrencyid='").append(this.currencyId);
        if (this.currencyId.equals(companyInfo.getBaseCurrency().getId().toString())) {
            sb.append("') or a.facctcurrency in (0,2)  ");
        } else {
            sb.append("') or a.facctcurrency=2 ");
        }
        sb.append(" ) and a.fcompanyid = '").append(companyInfo.getId().toString()).append("'  and  a.faccountTableid='").append(this.accountTableId).append("'");
        sb.append(" and a.fisLeaf = 1 ");
        return sb.toString();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.ma.pca.app.PcaAcBalanceInitQuery";
    }
}

