/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.eas.base.param.INewParamAfterDeal;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamAfterDeal;
import com.kingdee.eas.base.param.IParamCheck;
import com.kingdee.eas.base.param.IParamSetModify;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.pca.PcaException;
import com.kingdee.eas.ma.pca.PcaParamException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PCAParamCheck
implements INewParamCheck,
INewParamAfterDeal,
IParamCheck,
IParamAfterDeal,
IParamSetModify {
    private static final Log log = LogFactory.getLog(PCAParamCheck.class);
    private static Map validatorMap = new HashMap();

    public boolean setParamModify(Context ctx, ParamInfo paramInfo) throws BOSException, EASBizException {
        return false;
    }

    public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
        if (modelCol == null || modelCol.size() == 0) {
            return;
        }
        String number = modelCol.get(0).getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PCAParamCheck: Parameter:" + number + "; OrgCount:" + modelCol.size() + "; validator:" + validator));
        }
        if (validator != null) {
            try {
                if (validator instanceof MultiOrgValidator) {
                    ((MultiOrgValidator)validator).check(ctx, modelCol);
                } else if (validator instanceof SingleOrgValidator) {
                    for (int i = 0; i < modelCol.size(); ++i) {
                        ((SingleOrgValidator)validator).check(ctx, modelCol.get(i));
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        String number = model.getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PCAParamCheck: Parameter:" + number + "; validator:" + validator));
        }
        if (validator != null) {
            try {
                if (validator instanceof SingleOrgValidator) {
                    ((SingleOrgValidator)validator).check(ctx, model);
                } else if (validator instanceof MultiOrgValidator) {
                    ParamItemCollection modelCol = new ParamItemCollection();
                    modelCol.add(model);
                    ((MultiOrgValidator)validator).check(ctx, modelCol);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    public void afterDeal(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
    }

    public void afterDeal(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
    }

    private static void checkParamValue(Context ctx, ParamItemInfo model, String paramNumber, String expectedValue, NumericExceptionSubItem paramException) throws EASBizException, BOSException {
        ObjectUuidPK orgUnitId = new ObjectUuidPK(model.getOrgUnitID().getId());
        String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)orgUnitId, (String)paramNumber);
        if (value == null) {
            throw new PcaException(PcaException.NOPARAM, new Object[]{paramNumber});
        }
        if (!value.equals(expectedValue)) {
            throw new PcaParamException(paramException);
        }
    }

    static {
        validatorMap.put("PCA_075", new Validator_Pca075());
    }

    private static class Validator_Pca075
    implements SingleOrgValidator {
        private Validator_Pca075() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            PCAParamCheck.checkParamValue(ctx, model, "PCA_032", "false", PcaParamException.VCH_USE_WF);
            PCAParamCheck.checkParamValue(ctx, model, "PCA_029", "true", PcaParamException.BG_CTRL_DISABLE);
            String orgUnitId = model.getOrgUnitID().getId().toString();
            String sql = "select top 1 fid from t_pca_pcvoucher where fprofitCenterId=? and fbizstatus=1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitId});
            if (rs.next()) {
                throw new PcaParamException(PcaParamException.SUBMIT_VCH_EXISTS);
            }
        }
    }

    private static interface MultiOrgValidator {
        public void check(Context var1, ParamItemCollection var2) throws BOSException, EASBizException, SQLException;
    }

    private static interface SingleOrgValidator {
        public void check(Context var1, ParamItemInfo var2) throws BOSException, EASBizException, SQLException;
    }
}

