/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentInfo;
import com.kingdee.eas.fi.gl.BaseVoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.BaseVoucherEntryInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.validator.IVoucherAssistRecordValidator;
import com.kingdee.eas.ma.pca.PcVoucherAssistRecordInfo;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidatorOperatorSharer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PcVoucherAssistRecordSubmitValidator
extends PcVoucherValidatorOperatorSharer
implements IVoucherAssistRecordValidator {
    protected static final Logger logger = Logger.getLogger(PcVoucherAssistRecordSubmitValidator.class);
    protected Context ctx;
    protected GlParam sysParam;
    protected PcVoucherInfo voucherInfo;
    protected PcVoucherEntryInfo entryInfo;
    protected PcVoucherAssistRecordInfo recordInfo;

    public PcVoucherAssistRecordSubmitValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo, BaseVoucherEntryInfo baseEntryInfo, BaseVoucherAssistRecordInfo baseRecordInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        PcVoucherEntryInfo entryInfo = (PcVoucherEntryInfo)baseEntryInfo;
        PcVoucherAssistRecordInfo recordInfo = (PcVoucherAssistRecordInfo)baseRecordInfo;
        this.ctx = ctx;
        this.voucherInfo = voucherInfo;
        this.entryInfo = entryInfo;
        this.recordInfo = recordInfo;
        this.checkRecordDate(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordAssGrp(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordUserProperty(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordAmount(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordVerify(ctx, voucherInfo, entryInfo, recordInfo);
        this.checkRecordMeasureUnit(ctx, voucherInfo, entryInfo, recordInfo);
    }

    private void checkRecordDate(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo, PcVoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        Date bookDate;
        if (entryInfo.getAccount().isAC() && recordInfo.getEndDate() == null) {
            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_RECORD_NOT_ENDDATE : VoucherException.RECORD_NOT_ENDDATE, (Object[])this.getSeq());
        }
        Date bizDate = DateTimeUtils.truncateDate((Date)recordInfo.getBizDate());
        if (bizDate.after(bookDate = DateTimeUtils.truncateDate((Date)voucherInfo.getBookedDate()))) {
            if (voucherInfo.isWebVoucher()) {
                throw new VoucherException(VoucherException.WEB_NOTALLOWEDBIZAFTBOOK, (Object[])this.getSeq());
            }
            throw new VoucherException(VoucherException.NOTALLOWEDBIZAFTBOOK);
        }
    }

    private void checkRecordMeasureUnit(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo, PcVoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        boolean useQtyAsst = this.sysParam.getBoolean("G010");
        if (useQtyAsst && entryInfo.getAccount().isIsQty() && entryInfo.getAccount().getCAA() != null && entryInfo.getAccount().getCAA().isIsQty() && recordInfo.getQuantity() != null && GlUtils.zero.compareTo(recordInfo.getQuantity()) != 0 && recordInfo.getMeasureUnit() == null) {
            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.ENTRY_NEED_MU : VoucherException.ASST_NEED_MU, (Object[])this.getSeq());
        }
    }

    private void checkRecordVerify(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo, PcVoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        boolean isAdj;
        boolean isInTimeVerify = this.sysParam.getInt("GL_052") == 0;
        AcctCussentInfo aci = recordInfo.getVerifiedCussent();
        boolean noAc = aci == null;
        boolean bl = isAdj = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT);
        if (isInTimeVerify && !isAdj) {
            boolean isVer;
            boolean allowCussent = this.sysParam.getBoolean("GL_028");
            boolean bl2 = isVer = allowCussent && this.isVerify(entryInfo.getAccount(), entryInfo.getEntryDC());
            if (isVer == noAc) {
                if (isVer) {
                    throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_RECORD_VERIFY_NO_CUSSENT : VoucherException.RECORD_VERIFY_NO_CUSSENT, (Object[])this.getSeq());
                }
                throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_RECORD_NOT_VERIFY_BUT_HAS_CUSSENT : VoucherException.RECORD_NOT_VERIFY_BUT_HAS_CUSSENT, (Object[])this.getSeq());
            }
        }
    }

    private void checkRecordAmount(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo, PcVoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        boolean checkAmount = this.isCheckBalance(voucherInfo.getSourceType(), !voucherInfo.isPostedByUI());
        boolean canSaveZero = this.sysParam.getBoolean("GL_0301");
        if (!canSaveZero && checkAmount && GlUtils.isAllZeroOrNull((BigDecimal[])new BigDecimal[]{recordInfo.getLocalAmount(), recordInfo.getOriginalAmount(), recordInfo.getReportingAmount(), recordInfo.getQuantity()})) {
            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.ENTRY_ZERO_AMOUNT : VoucherException.RECORD_ZERO_AMOUNT, (Object[])this.getSeq());
        }
    }

    private void checkRecordUserProperty(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo, PcVoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        List list;
        boolean isAdj;
        boolean bl = isAdj = voucherInfo.getSourceType() != null && voucherInfo.getSourceType().equals((Object)SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT);
        if (!isAdj && entryInfo.getAccount().isHasUserProperty() && (list = (List)voucherInfo.getAccountUserProperty().get(entryInfo.getAccount().getId().toString())) != null && list.size() > 0) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object[] obj = (Object[])list.get(i);
                Object val = recordInfo.get((String)obj[2]);
                if ((!entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT) || !((Boolean)obj[1]).booleanValue()) && (!entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) || !((Boolean)obj[0]).booleanValue()) || !(val instanceof String ? val == null || ((String)val).length() == 0 : val == null)) continue;
                throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_USERPROPERTY_IS_NULL : VoucherException.USERPROPERTY_IS_NULL, (Object[])this.getSeq());
            }
        }
    }

    private void checkRecordAssGrp(Context ctx, PcVoucherInfo voucherInfo, PcVoucherEntryInfo entryInfo, PcVoucherAssistRecordInfo recordInfo) throws BOSException, EASBizException {
        if (entryInfo.getAccount().getCAA() != null && (recordInfo.getAssGrp() == null || recordInfo.getAssGrp().getId() == null)) {
            throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ASSGRP_CANNOT_NULL : VoucherException.ASSGRP_CANNOT_NULL, (Object[])this.getSeq());
        }
        if (entryInfo.getAccount().getCAA() != null && recordInfo.getAssGrp() != null) {
            String hgGroupName = recordInfo.getAssGrp().getLongNameGroup();
            if (hgGroupName != null) {
                if (hgGroupName.indexOf(":;") != -1 || hgGroupName.trim().split(";").length < recordInfo.getAssGrp().getCount()) {
                    throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ASSGRP_CANNOT_NULL : VoucherException.ASSGRP_CANNOT_NULL, (Object[])this.getSeq());
                }
            } else {
                StringBuffer sql = new StringBuffer();
                sql.append(" select c.fid fid,c.FLongNameGroup_").append(ctx.getLocale().toString()).append(" longNameGroup ");
                sql.append(" from t_bd_assistanthg c where c.fid = ? ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{recordInfo.getAssGrp().getId().toString()});
                try {
                    if (rs.next() && (hgGroupName = rs.getString("longNameGroup")) != null && (hgGroupName.indexOf(":;") != -1 || hgGroupName.trim().split(";").length < recordInfo.getAssGrp().getCount())) {
                        throw new VoucherException(voucherInfo.isWebVoucher() ? VoucherException.WEB_ASSGRP_CANNOT_NULL : VoucherException.ASSGRP_CANNOT_NULL, (Object[])this.getSeq());
                    }
                }
                catch (SQLException e) {
                    throw new BOSException("SQL ERROR!", (Throwable)e);
                }
            }
            if (recordInfo.getAssGrp().getAsstAccount() != null && !entryInfo.getAccount().getCAA().getId().equals((Object)recordInfo.getAssGrp().getAsstAccount().getId())) {
                StringBuffer sb = new StringBuffer(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"91_RepairlUI", (Locale)ctx.getLocale()));
                sb.append(voucherInfo.getNumber());
                StringBuffer sb1 = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.FIAutoGenerateResource", (String)"354_VoucherLeadControlControllerBean"));
                sb1.append(entryInfo.getSeq());
                sb.append(sb1.toString());
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"899_VoucherControllerBean", (Locale)ctx.getLocale()) + entryInfo.getAccount().getNumber());
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"900_VoucherControllerBean", (Locale)ctx.getLocale()) + entryInfo.getAccount().getCAA().getId() + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"901_VoucherControllerBean", (Locale)ctx.getLocale()) + recordInfo.getSeq());
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"902_VoucherControllerBean", (Locale)ctx.getLocale()) + recordInfo.getAssGrp().getId());
                logger.error((Object)sb.toString());
                throw new VoucherException(VoucherException.VCH_ACCT_ASST_TYPE_NOT_EQUAL, new Object[]{voucherInfo.getNumber(), new Integer(entryInfo.getSeq()), entryInfo.getAccount().getNumber(), entryInfo.getAccount().getCAA().getId(), new Integer(recordInfo.getSeq()), recordInfo.getAssGrp().getId()});
            }
        }
    }

    private boolean isCheckBalance(SourceType sourceType, boolean zeroRowRemoved) {
        boolean isPL;
        boolean checkAmount = !zeroRowRemoved;
        boolean adjEx = SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT == sourceType;
        boolean bl = isPL = SourceType.PROFIT_AND_LOSS == sourceType;
        if (adjEx || isPL) {
            checkAmount = false;
        }
        return checkAmount;
    }

    protected boolean isVerify(AccountViewInfo acc, EntryDC entryDC) {
        BalanceDirectionEnum accDC;
        return acc.isAC() && (BalanceDirectionEnum.DEBIT.equals((Object)(accDC = acc.getDC())) && EntryDC.CREDIT.equals((Object)entryDC) || BalanceDirectionEnum.CREDIT.equals((Object)accDC) && EntryDC.DEBIT.equals((Object)entryDC));
    }

    private Integer[] getSeq() {
        Integer[] assistSeq = new Integer[this.voucherInfo.isWebVoucher() ? 1 : 2];
        assistSeq[0] = new Integer(this.entryInfo.getSeq());
        if (!this.voucherInfo.isWebVoucher()) {
            assistSeq[1] = new Integer(this.recordInfo.getSeq());
        }
        return assistSeq;
    }
}

