/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.ma.pca.PcVoucherFactory;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.validator.AbstractPcVoucherBaseValidator;

public class PcVoucherBaseAntiCancelValidator
extends AbstractPcVoucherBaseValidator {
    private GlParam sysParam = null;

    public PcVoucherBaseAntiCancelValidator(GlParam sysParam) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        SynVoucherUtil.checkPcVoucherCannotOperateInPca(ctx, voucherInfo, VoucherOperateStatusEnum.ANTICANCLE);
        this.checkVoucherPeriod(ctx, voucherInfo);
        this.checkOriginalIsBalanced(ctx, voucherInfo);
    }

    private void checkOriginalIsBalanced(Context ctx, PcVoucherInfo voucherInfo) throws GLException, BOSException, EASBizException, VoucherException {
        boolean isValidatorOriginalCurrency = this.sysParam.getBoolean("GL_101");
        boolean isFz = this.sysParam.getBoolean("GL_008");
        if (!isFz && isValidatorOriginalCurrency) {
            PcVoucherInfo info = (PcVoucherInfo)PcVoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()));
            this.checkOriginalAmount(ctx, info);
        }
    }
}

