/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.PcaUtils;
import com.kingdee.eas.ma.pca.SynVoucherUtil;
import com.kingdee.eas.ma.pca.validator.AbstractPcVoucherBaseValidator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class PcVoucherBaseDeleteValidator
extends AbstractPcVoucherBaseValidator {
    private GlParam sysParam = null;
    private boolean isFromGL = true;

    public PcVoucherBaseDeleteValidator(GlParam sysParam, boolean isFromGL) throws BOSException {
        if (sysParam == null) {
            throw new BOSException("sysParam can't is null when instance a VoucherValidator!");
        }
        this.sysParam = sysParam;
        this.isFromGL = isFromGL;
    }

    @Override
    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        this.checkMutex(ctx, voucherInfo);
        SynVoucherUtil.checkPcVoucherCannotOperateInPca(ctx, voucherInfo, VoucherOperateStatusEnum.DELETE);
        if (voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            this.checkDeleteDapVchInGL(ctx, voucherInfo, this.sysParam, this.isFromGL);
            this.checkVchIsReversed(ctx, voucherInfo);
        }
    }

    protected void checkMutex(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (PcaUtils.isExisted(ctx, voucherInfo)) {
            this.checkMutex(ctx, (IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
        }
    }

    private void checkModifyVoucherFromMain(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws GLException, EASBizException, BOSException {
        boolean canModifyVoucherFromMain = sysParam.getBoolean("GL015");
        if (!canModifyVoucherFromMain && !BooksUtil.isMasterBook((Context)ctx) && voucherInfo.isIsAccountCopy()) {
            throw new VoucherException(VoucherException.MASTERVOUCHERNOTAUDIT);
        }
    }

    private void checkVchIsChecked(Context ctx, PcVoucherInfo voucherInfo) throws VoucherException {
        if (voucherInfo.getCashier() != null) {
            throw new VoucherException(VoucherException.VOUCHERCHECKED);
        }
    }

    private void checkAcNoticeIsChecked(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean useAC = sysParam.getBoolean("GLG01");
        if (useAC) {
            this.checkACNoticeCorrelation(ctx, voucherInfo.getId().toString());
        }
    }

    private void checkVerifiedStatus(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        this.checkVerifiedStatus(ctx, voucherInfo, sysParam, VoucherOperateStatusEnum.DELETE);
    }

    private void checkDeleteDapVchInGL(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam, boolean isFromGL) throws EASBizException, NumberFormatException, BOSException {
        int deleteCtrl = sysParam.getInt("PCA_019");
        boolean vchIsGL = SystemEnum.PROFIT_CENTER_ACCOUNTING.equals((Object)voucherInfo.getSourceSys());
        if (!vchIsGL) {
            if (deleteCtrl == 0 && isFromGL) {
                throw new VoucherException(VoucherException.DELETE_CTRL_BYOTHER, new Object[]{voucherInfo.getVoucherType().getName(), voucherInfo.getNumber()});
            }
            if (deleteCtrl == 1 && !isFromGL) {
                throw new VoucherException(VoucherException.DELETE_CTRL_BYGL, new Object[]{voucherInfo.getVoucherType().getName(), voucherInfo.getNumber()});
            }
        }
    }

    private void checkVchIsReversed(Context ctx, PcVoucherInfo voucherInfo) throws BOSException, EASBizException {
        StringBuffer sqlReverse = new StringBuffer();
        sqlReverse.append("select fid from t_pca_pcvoucher where fsourcebillid=? and FIsReverseVoucher=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlReverse.toString(), (Object[])new Object[]{voucherInfo.getId().toString(), new Integer(1)});
        try {
            if (rs.next()) {
                throw new VoucherException(VoucherException.REVERSED_VCH_NOT_DEL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkPiaoJu(Context ctx, PcVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        this.checkPiaoJu(ctx, voucherInfo.getId().toString(), sysParam, false);
    }
}

