/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.validator.IValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherAssistRecordValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator;
import com.kingdee.eas.fi.gl.validator.ValidatorCollection;
import com.kingdee.eas.fi.gl.validator.ValidatorFactory;
import com.kingdee.eas.fi.gl.validator.ValidatorInfo;
import com.kingdee.eas.ma.pca.validator.PcVoucherValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class PcVoucherValidatorFactory {
    protected static final Logger logger = Logger.getLogger(PcVoucherValidatorFactory.class);
    private static HashMap validatorMap = new HashMap();

    public static void getVoucherValidator(Context ctx, String callClassName, PcVoucherValidator voucherValidator) throws BOSException, EASBizException {
        if (validatorMap.get(callClassName) != null) {
            HashMap classNameMap = (HashMap)validatorMap.get(callClassName);
            List baseList = PcVoucherValidatorFactory.getValidatorList("base", classNameMap);
            List entryList = PcVoucherValidatorFactory.getValidatorList("entry", classNameMap);
            List recordList = PcVoucherValidatorFactory.getValidatorList("record", classNameMap);
            PcVoucherValidatorFactory.initVoucherValidatorBase(voucherValidator, baseList);
            PcVoucherValidatorFactory.initVoucherValidatorEntry(voucherValidator, entryList);
            PcVoucherValidatorFactory.initVoucherValidatorRecord(voucherValidator, recordList);
        } else {
            ValidatorCollection vc = PcVoucherValidatorFactory.queyValidatorCollection(ctx, callClassName);
            ArrayList baseList = new ArrayList();
            ArrayList entryList = new ArrayList();
            ArrayList recordList = new ArrayList();
            PcVoucherValidatorFactory.populateValidatorCollection(vc, baseList, entryList, recordList);
            PcVoucherValidatorFactory.cacheValidator(callClassName, baseList, entryList, recordList);
            PcVoucherValidatorFactory.initVoucherValidatorBase(voucherValidator, baseList);
            PcVoucherValidatorFactory.initVoucherValidatorEntry(voucherValidator, entryList);
            PcVoucherValidatorFactory.initVoucherValidatorRecord(voucherValidator, recordList);
        }
    }

    private static void cacheValidator(String callClassName, List baseList, List entryList, List recordList) {
        LinkedHashMap<String, List> calssNameMap = new LinkedHashMap<String, List>();
        calssNameMap.put("base", baseList);
        calssNameMap.put("entry", entryList);
        calssNameMap.put("record", recordList);
        validatorMap.put(callClassName, calssNameMap);
    }

    private static void populateValidatorCollection(ValidatorCollection vc, List baseList, List entryList, List recordList) {
        int size = vc.size();
        for (int i = 0; i < size; ++i) {
            ValidatorInfo validatorInfo = vc.get(i);
            if ("com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator".toLowerCase().indexOf(validatorInfo.getValidatorInterface().toLowerCase()) > 0) {
                baseList.add(validatorInfo.getValidatorClassName());
                continue;
            }
            if ("com.kingdee.eas.fi.gl.validator.IVoucherEntryValidator".toLowerCase().indexOf(validatorInfo.getValidatorInterface().toLowerCase()) > 0) {
                entryList.add(validatorInfo.getValidatorClassName());
                continue;
            }
            if ("com.kingdee.eas.fi.gl.validator.IVoucherAssistRecordValidator".toLowerCase().indexOf(validatorInfo.getValidatorInterface().toLowerCase()) <= 0) continue;
            recordList.add(validatorInfo.getValidatorClassName());
        }
    }

    private static ValidatorCollection queyValidatorCollection(Context ctx, String callClassName) throws BOSException {
        IValidator iValidator = ValidatorFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("callClassName"));
        coll.add(new SelectorItemInfo("validatorInterface"));
        coll.add(new SelectorItemInfo("validatorClassName"));
        evi.setSelector(coll);
        if (callClassName != null && callClassName.length() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("callClassName", (Object)callClassName, CompareType.EQUALS));
            evi.setFilter(filter);
        }
        ValidatorCollection vc = iValidator.getValidatorCollection(evi);
        return vc;
    }

    private static List getValidatorList(String key, HashMap calssNameMap) {
        return calssNameMap.get(key) != null ? (List)calssNameMap.get(key) : new ArrayList();
    }

    private static void initVoucherValidatorRecord(PcVoucherValidator voucherValidator, List recordList) throws BOSException {
        int size = recordList.size();
        for (int i = 0; i < size; ++i) {
            IVoucherAssistRecordValidator recordValidator;
            String validatorClassName = (String)recordList.get(i);
            try {
                Class<?> claze = Class.forName(validatorClassName);
                recordValidator = (IVoucherAssistRecordValidator)claze.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)(validatorClassName + e.getMessage()));
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            voucherValidator.addVoucherAssistRecordValidator(recordValidator);
        }
    }

    private static void initVoucherValidatorEntry(PcVoucherValidator voucherValidator, List entryList) throws BOSException {
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            IVoucherEntryValidator entryValidator;
            String validatorClassName = (String)entryList.get(i);
            try {
                Class<?> claze = Class.forName(validatorClassName);
                entryValidator = (IVoucherEntryValidator)claze.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)(validatorClassName + e.getMessage()));
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            voucherValidator.addVoucherEntryValidator(entryValidator);
        }
    }

    private static void initVoucherValidatorBase(PcVoucherValidator voucherValidator, List baseList) throws BOSException {
        String validatorClassName = null;
        int size = baseList.size();
        for (int i = 0; i < size; ++i) {
            IVoucherBaseValidator baseValidator;
            validatorClassName = (String)baseList.get(i);
            try {
                Class<?> claze = Class.forName(validatorClassName);
                baseValidator = (IVoucherBaseValidator)claze.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)(validatorClassName + e.getMessage()));
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            voucherValidator.addVoucherBaseValidator(baseValidator);
        }
    }
}

