/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.pca.validator;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.validator.IVoucherBaseValidator;
import com.kingdee.eas.ma.pca.PcVoucherEntryCollection;
import com.kingdee.eas.ma.pca.PcVoucherEntryInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.ma.pca.validator.ReversePcVoucherValidatorUtils;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.Locale;

public class ReversePcVoucherBaseSubmitValidator
implements IVoucherBaseValidator {
    protected static final String resource = "com.kingdee.eas.fi.gl.GLResource";

    public void validate(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        PcVoucherInfo voucherInfo = (PcVoucherInfo)baseVoucherInfo;
        ObjectUuidPK srcVchPK = new ObjectUuidPK(voucherInfo.getSourceBillId());
        PcVoucherInfo srcVch = (PcVoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)srcVchPK, PcVoucherInfo.getReverseSelector());
        voucherInfo.setSrcVoucherInfo((BaseVoucherInfo)srcVch);
        this.checkSrcVch(ctx, srcVch);
        StringBuffer msgCollector = new StringBuffer();
        msgCollector.append(this.getResource(ctx, resource, "BEYOND_SRC_AMOUNT", new Object[]{srcVch.getVoucherType().getName(ctx.getLocale()), srcVch.getNumber(), srcVch.getPeriod().getPeriodYear() + "." + srcVch.getPeriod().getPeriodNumber()}));
        msgCollector.append("\r\n");
        int result = ReversePcVoucherValidatorUtils.checkReverse(ctx, voucherInfo, srcVch, msgCollector);
        if (result == -1) {
            throw new VoucherException(VoucherException.NO_MSG, (Object[])new String[]{msgCollector.toString()});
        }
        if (result == 0) {
            srcVch.put("ReverseComplete", (Object)true);
        }
    }

    private void checkSrcVch(Context ctx, PcVoucherInfo srcVch) throws BOSException, EASBizException {
        if (!VoucherStatusEnum.POSTED.equals((Object)srcVch.getBizStatus())) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_POSTED);
        }
        if (srcVch.isIsReverseVoucher()) {
            throw new VoucherException(VoucherException.VOUCHER_IS_REVERSE);
        }
        PcVoucherEntryCollection entries = srcVch.getEntries();
        PcVoucherEntryInfo entry = null;
        boolean hasPLAccount = false;
        String currentAcctTable = srcVch.getCompany().getAccountTable().getId().toString();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (!currentAcctTable.equals(entry.getAccount().getAccountTableID().getId().toString())) {
                throw new VoucherException(VoucherException.REV_FAILUE_FOR_ACCOUNT_CHANGED);
            }
            if (!AccountProperty.SUNYI.equals((Object)entry.getAccount().getAccountTypeID().getProperty())) continue;
            hasPLAccount = true;
        }
        if (hasPLAccount) {
            PeriodInfo currentPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(1006, srcVch.getProfitCenter().getId().toString());
            if (srcVch.getPeriod().getPeriodYear() != currentPeriod.getPeriodYear()) {
                throw new VoucherException(VoucherException.REV_FAILURE_FOR_PL);
            }
        }
    }

    protected String getResource(Context ctx, String resName, String key, Object[] params) {
        String message = ResourceBase.getString((String)resName, (String)key, (Locale)ctx.getLocale());
        if (params == null) {
            return message;
        }
        return MessageFormat.format(message, params);
    }
}

