/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.lot.BatchFileEntryInfo;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.LotSourceEnum;
import com.kingdee.eas.mm.lot.client.AbstractBatchFileEditUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BatchFileEditUI
extends AbstractBatchFileEditUI {
    private static final long serialVersionUID = -4815762585872159457L;
    private DataChangeListener materialChanged = null;
    private KDBizPromptBox prmpEntryMaterial = null;
    private String TB_MATERIAL = "material";
    private String TB_MATERIALNAME = "materialName";
    private String TB_MATERIALMODEL = "materialModel";
    private String TB_LOT = "batch";
    private String TB_TIMES = "times";
    private String TB_LOTSOURCE = "lotSource";
    private String RESOURCE_PATH = "com.kingdee.eas.mm.lot.BatchFileResource";
    private MaterialInfo oldInfo;
    private boolean isRemoveFailed = false;
    private static final Logger logger = CoreUIObject.getLogger(BatchFileEditUI.class);

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuTool.remove((JMenuItem)this.menuItemMsgFormat);
    }

    public void onLoad() throws Exception {
        this.dtCreateTime.setDatePattern(CtrlFormatUtilities.getDateFormatString());
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                if (colIndex == BatchFileEditUI.this.kdtEntrys.getColumn(BatchFileEditUI.this.TB_MATERIAL).getColumnIndex()) {
                    BatchFileEditUI.this.oldInfo = (MaterialInfo)e.getValue();
                }
            }
        });
        this.prmpEntryMaterial = (KDBizPromptBox)this.kdtEntrys.getColumn(this.TB_MATERIAL).getEditor().getComponent();
        String materialQueryInfo = "com.kingdee.eas.basedata.master.material.app.F7MaterialLotTraceQuery";
        this.prmpEntryMaterial.setQueryInfo(materialQueryInfo);
        this.prmpEntryMaterial.setDisplayFormat("$number$");
        this.prmpEntryMaterial.setEditFormat("$number$");
        this.prmpEntryMaterial.setCommitFormat("$number$");
        this.prmpEntryMaterial.setEnabledMultiSelection(false);
        this.prmpEntryMaterial.setEditable(true);
        this.kdtEntrys.getColumn(this.TB_MATERIAL).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmpEntryMaterial));
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn(this.TB_MATERIAL).setRenderer((IBasicRender)ovr);
        this.prmpEntryMaterial.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                block11: {
                    MaterialInfo materialInfo;
                    int row = BatchFileEditUI.this.kdtEntrys.getSelectManager().getActiveRowIndex();
                    if (row < 0) {
                        if (BatchFileEditUI.this.kdtEntrys.getRowCount() > 0) {
                            row = 0;
                        } else {
                            return;
                        }
                    }
                    if ((materialInfo = (MaterialInfo)BatchFileEditUI.this.prmpEntryMaterial.getValue()) != null && !materialInfo.equals((Object)BatchFileEditUI.this.oldInfo)) {
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_MATERIAL).setValue((Object)materialInfo);
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_MATERIALNAME).setValue((Object)materialInfo.getName());
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_MATERIALMODEL).setValue((Object)materialInfo.getModel());
                        try {
                            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)BatchFileEditUI.this.getMainOrgUnit().getValue();
                            LotFrame lotFrame = LotRuleFactory.getRemoteInstance().getLotFrame(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
                            if (lotFrame != null) {
                                if (LotSourceEnum.manual.equals((Object)((LotSourceEnum)((Object)BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOTSOURCE).getValue())))) {
                                    BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOT).getStyleAttributes().setLocked(false);
                                } else {
                                    BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOT).getStyleAttributes().setLocked(true);
                                }
                                long currentSerial = BatchFileFactory.getRemoteInstance().updateLotRuleAssign(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
                                lotFrame.setCurrentSerial(currentSerial);
                                lotFrame.setMainBizOrg(storageOrgUnitInfo.getNumber());
                                lotFrame.setMaterial(materialInfo.getNumber());
                                lotFrame.setBizDate(new Date());
                                lotFrame.setSeq(1);
                                lotFrame.setBillNumber(BatchFileEditUI.this.txtNumber.getText());
                                BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOT).setValue((Object)lotFrame.getLotNumber());
                                break block11;
                            }
                            BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOT).getStyleAttributes().setLocked(false);
                            BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOT).setValue(null);
                        }
                        catch (Exception e) {
                            BatchFileEditUI.this.handUIException(e);
                        }
                    } else if (materialInfo == null) {
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_MATERIAL).setValue(null);
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_MATERIALNAME).setValue(null);
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_MATERIALMODEL).setValue(null);
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOT).setValue(null);
                        BatchFileEditUI.this.kdtEntrys.getCell(row, BatchFileEditUI.this.TB_LOT).getStyleAttributes().setLocked(false);
                    }
                }
            }
        });
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntrys, (boolean)false, null);
        this.menuItemSave.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        this.setEnabled(true);
        this.kdtEntrys.getActionMap().remove("Cut");
        this.getDetailTable().getColumn(this.TB_TIMES).getStyleAttributes().setHided(true);
        this.addLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.insertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.removeLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.addLine.setText(null);
        this.insertLine.setText(null);
        this.removeLine.setText(null);
        super.setReservationVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.removeListener();
        try {
            this.initCustomF7(null);
            this.addListener();
            if (this.editData != null && this.editData.getId() != null) {
                this.initEntryMaterialF7(this.editData.getStorageOrgUnit());
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.setEnableByStatus();
        this.setEntryLotNo();
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntrys, (boolean)false, null);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setEnableByStatus();
    }

    protected void initListener() {
        super.initListener();
        this.materialChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchFileEditUI.this.materialChanged(eventObj);
            }
        };
        this.prmpMaterial.addDataChangeListener(this.materialChanged);
    }

    private void addListener() {
        this.prmpMaterial.addDataChangeListener(this.materialChanged);
    }

    protected void setEnableByStatus() {
        String status = this.getOprtState();
        if (status.equals("ADDNEW")) {
            this.prmtStorageOrgUnit.setAccessAuthority(0);
            this.prmpMaterial.setAccessAuthority(0);
            this.txtLotNo.setAccessAuthority(0);
        } else if (status.equals("EDIT")) {
            this.prmtStorageOrgUnit.setAccessAuthority(1);
            this.prmpMaterial.setAccessAuthority(1);
            this.txtLotNo.setAccessAuthority(1);
        } else if (status.equals("VIEW")) {
            this.prmtStorageOrgUnit.setAccessAuthority(1);
            this.prmpMaterial.setAccessAuthority(1);
            this.txtLotNo.setAccessAuthority(1);
        }
    }

    public void materialChanged(DataChangeEvent eventObj) {
        block10: {
            if (OprtState.VIEW.equals(this.getOprtState()) || this.isInSubmiting) {
                return;
            }
            MaterialInfo newVal = (MaterialInfo)eventObj.getNewValue();
            MaterialInfo oldVal = (MaterialInfo)eventObj.getOldValue();
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
            if (newVal != null && null != storageOrgUnitInfo && !newVal.equals((Object)oldVal)) {
                this.txtLotNo.setText(null);
                this.initEntryMaterialF7(null);
                this.clearTable(this.kdtEntrys);
                this.txtMaterialName.setText(newVal.getName());
                this.txtMaterialModel.setText(newVal.getModel());
                try {
                    LotFrame lotFrame = LotRuleFactory.getRemoteInstance().getLotFrame(newVal.getId().toString(), storageOrgUnitInfo.getId().toString());
                    if (lotFrame != null) {
                        if (lotFrame.getLotRule().isIsModifiable()) {
                            this.txtLotNo.setAccessAuthority(0);
                        } else {
                            this.txtLotNo.setAccessAuthority(1);
                        }
                        long currentSerial = BatchFileFactory.getRemoteInstance().updateLotRuleAssign(newVal.getId().toString(), storageOrgUnitInfo.getId().toString());
                        lotFrame.setCurrentSerial(currentSerial);
                        lotFrame.setMainBizOrg(storageOrgUnitInfo.getNumber());
                        lotFrame.setMaterial(newVal.getNumber());
                        lotFrame.setBizDate(new Date());
                        lotFrame.setSeq(1);
                        lotFrame.setBillNumber(this.txtNumber.getText());
                        this.txtLotNo.setText(lotFrame.getLotNumber());
                        break block10;
                    }
                    this.txtLotNo.setAccessAuthority(0);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else if (newVal == null) {
                this.initEntryMaterialF7(null);
                this.txtMaterialName.setText(null);
                this.txtMaterialModel.setText(null);
                this.txtLotNo.setText(null);
                this.txtLotNo.setAccessAuthority(0);
                this.clearTable(this.kdtEntrys);
            }
        }
    }

    public void initEntryMaterialF7(StorageOrgUnitInfo orgUnitInfo) {
        if (null == orgUnitInfo) {
            orgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        }
        if (orgUnitInfo == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo entityView = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)orgUnitInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)orgUnitInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10030)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10050)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10040)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE));
        filterInfo.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND (#5 OR #6 OR #7) AND #8");
        entityView.setFilter(filterInfo);
        this.prmpEntryMaterial.setEntityViewInfo(entityView);
    }

    public void initCustomF7(String storageOrgId) {
        StorageOrgUnitInfo info = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (MMUtils.isEmptyString((String)storageOrgId)) {
            if (info == null) {
                return;
            }
            storageOrgId = info.getId().toString();
        }
        if (MMUtils.isEmptyString((String)storageOrgId)) {
            return;
        }
        if (info != null) {
            this.prmpMaterial.setCurrentCtrlUnit(info.getCU());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)storageOrgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)storageOrgId));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1)));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(MaterialAttributeEnum.FABRICATEDPART.getValue())));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(MaterialAttributeEnum.EXTERNALPROCESSINPART.getValue())));
        filterInfo.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5  AND (#6 OR #7)");
        viewInfo.setFilter(filterInfo);
        this.prmpMaterial.setEntityViewInfo(viewInfo);
        if (null != this.prmpEntryMaterial) {
            viewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)storageOrgId));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)storageOrgId));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10030)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10050)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)new Integer(10040)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE));
            filterInfo.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND (#5 OR #6 OR #7) AND #8");
            viewInfo.setFilter(filterInfo);
            if (info != null) {
                this.prmpEntryMaterial.setCurrentCtrlUnit(info.getCU());
            }
            this.prmpEntryMaterial.setEntityViewInfo(viewInfo);
        }
    }

    protected void afterMainOrgChanged(String arg0, String arg1) {
        if (arg1 == null) {
            this.getMainBizOrg().setValue((Object)this.getMainOrgInfo());
            return;
        }
        super.afterMainOrgChanged(arg0, arg1);
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)arg0, (Object)arg1);
        if (isDiffrent) {
            this.initCustomF7(arg1);
            this.prmpMaterial.setValue(null);
            this.clearTable(this.kdtEntrys);
        }
    }

    private void removeListener() {
        if (this.materialChanged != null) {
            this.prmpMaterial.removeDataChangeListener(this.materialChanged);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BatchFileEntryInfo info = new BatchFileEntryInfo();
        info.setLotSource(LotSourceEnum.manual);
        info.setTimes(1);
        return info;
    }

    @Override
    protected IObjectValue createNewData() {
        StorageOrgUnitInfo _ = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        if (_ == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.mm.lot.LOTAutoGenerateResource", (String)"46_BatchFileEditUI"));
            SysUtil.abort();
        }
        BatchFileInfo objectValue = new BatchFileInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)com.kingdee.eas.mm.common.client.MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)"mm_batchfile_addnew"));
        BatchFileEntryInfo entryInfo = new BatchFileEntryInfo();
        entryInfo.setTimes(1);
        objectValue.getEntries().add(entryInfo);
        this.storeFields();
        return objectValue;
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtStorageOrgUnit;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected String getOnloadPermItemName() {
        String permItem = null;
        if ("ADDNEW".equalsIgnoreCase(this.getOprtState())) {
            permItem = "mm_batchfile_addnew";
        }
        return permItem;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.mm.lot.app.BatchFileQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/MM/lot/lotFile/batchFile";
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.invokePrintFunction(false);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.invokePrintFunction(true);
    }

    private void clearTable(KDTable table) {
        table.removeRows();
        this.addLine(table);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntrys, (boolean)false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        boolean isRemoveSucceed = false;
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        try {
            super.actionRemove_actionPerformed(e);
            isRemoveSucceed = true;
        }
        finally {
            if (isRemoveSucceed) {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(pk.toString());
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                }
            } else if ("VIEW".equals(this.getOprtState())) {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(pk.toString());
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                }
            } else {
                this.isRemoveFailed = true;
            }
        }
        if (this.idList.size() <= 0) {
            this.initOldData((IObjectValue)this.editData);
        }
    }

    public boolean destroyWindow() {
        if (this.isRemoveFailed) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(pk.toString());
            }
            catch (Throwable ex) {
                this.handUIException(ex);
            }
        }
        return super.destroyWindow();
    }

    protected boolean isModifySave() {
        return false;
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        KDTable table = this.getDetailTable();
        KDTSelectManager selectManager = table.getSelectManager();
        int size = selectManager.size();
        KDTSelectBlock selectBlock = null;
        String error = "";
        if (size == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
            selectBlock = selectManager.get(blockIndex);
            int top = selectBlock.getBeginRow();
            int bottom = selectBlock.getEndRow();
            if (table.getRow(top) == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                return;
            }
            for (int i = top; i <= bottom; ++i) {
                Integer times = (Integer)table.getCell(i, this.TB_TIMES).getValue();
                LotSourceEnum lotSource = (LotSourceEnum)((Object)table.getCell(i, this.TB_LOTSOURCE).getValue());
                if (times != null && times <= 1 && !LotSourceEnum.system.equals((Object)lotSource)) continue;
                error = error + (i + 1) + ",";
            }
        }
        if (!error.equals("")) {
            String msg = EASResource.getString((String)this.RESOURCE_PATH, (String)"ENTRY_CAN_NOT_REMOVE");
            error = error.substring(0, error.length() - 1);
            MsgBox.showInfo((Component)((Object)this), (String)MMUtils.getResourceWithParam((String)msg, (Object[])new String[]{error}));
            SysUtil.abort();
        }
        super.actionRemoveLine_actionPerformed(e);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            int i;
            if (this.isTableColumnSelected(table)) {
                table.removeRows();
                return;
            }
            int size = table.getSelectManager().size();
            KDTSelectBlock selectBlock = null;
            KDTSelectBlock tempBlock = null;
            IRow iRow = null;
            Vector<KDTSelectBlock> vtemp = new Vector<KDTSelectBlock>(0);
            for (i = 0; i < size; ++i) {
                selectBlock = table.getSelectManager().get(i);
                boolean find = false;
                for (int j = 0; j < vtemp.size(); ++j) {
                    tempBlock = (KDTSelectBlock)vtemp.get(j);
                    if (selectBlock.getTop() > tempBlock.getTop()) continue;
                    vtemp.add(j, selectBlock);
                    find = true;
                    break;
                }
                if (find) continue;
                vtemp.add(selectBlock);
            }
            for (i = size - 1; i >= 0; --i) {
                selectBlock = (KDTSelectBlock)vtemp.get(i);
                for (int j = selectBlock.getBottom(); j >= selectBlock.getTop(); --j) {
                    int index;
                    iRow = table.getRow(j);
                    if (iRow == null) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                        return;
                    }
                    IObjectValue detailData = (IObjectValue)iRow.getUserObject();
                    this.beforeRemoveLine(table, detailData);
                    table.removeRow(j);
                    IObjectCollection collection = (IObjectCollection)table.getUserObject();
                    if (collection == null) {
                        logger.error((Object)"collection not be binded to table");
                    } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) != -1) {
                        collection.removeObject(index);
                    }
                    this.afterRemoveLine(table, detailData);
                }
            }
        }
    }

    public void checkModified() throws Exception {
        if (this.isModify()) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                if (!this.isModifySave()) {
                    ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                    this.actionSubmit.actionPerformed(event);
                    if (this.actionSubmit.isInvokeFailed()) {
                        SysUtil.abort();
                    }
                } else {
                    this.actionSave.setDaemonRun(false);
                    ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                    this.actionSave.actionPerformed(event);
                    if (this.actionSave.isInvokeFailed()) {
                        SysUtil.abort();
                    }
                }
            } else if (result == 2) {
                SysUtil.abort();
            }
        }
    }

    protected void initUserConfig() {
        super.initUserConfig();
        String path = "com.kingdee.eas.mm.lot.client.BatchFileEditUI.kdtEntrys";
        UserCustomConfigItemData user = this.tHelper.getUserDataFromUI().getTableCurrentSetting(path);
        if (user == null) {
            return;
        }
        Map map = user.getColumnData();
        if (map.containsKey(this.TB_TIMES)) {
            this.getDetailTable().getColumn(this.TB_TIMES).getStyleAttributes().setHided(true);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.clearBotpViewInContext();
        try {
            this.isInSubmiting = true;
            if ((this.getOprtState().equals("ADDNEW") || this.getOprtState().equals("EDIT")) && !this.verifyManager.verify()) {
                SysUtil.abort();
            }
            this.editData.setBotpCallSave(false);
            super.actionSubmit_actionPerformed(e);
            if (BillBaseStatusEnum.AUDITED.equals((Object)this.editData.getBaseStatus())) {
                this.setOprtState("VIEW");
                this.lockUIForViewStatus();
            }
        }
        catch (Exception exc) {
            this.submitException(e, exc);
        }
        finally {
            this.isInSubmiting = false;
        }
    }

    private void clearBotpViewInContext() {
        this.getUIContext().remove("BOTPViewStatus");
    }

    private void submitException(ActionEvent e, Exception exc) {
        String result = exc.getMessage();
        String actionValue = "";
        if (e.getSource() instanceof KDWorkButton) {
            actionValue = (String)((KDWorkButton)e.getSource()).getAction().getValue("ShortDescription");
        } else if (e.getSource() instanceof KDMenuItem) {
            actionValue = (String)((KDMenuItem)e.getSource()).getAction().getValue("ShortDescription");
        }
        MsgBox.showDetailAndOK(null, (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.common.ActionResource", (String)"ERROR_HEAD_MSG", (String[])new String[]{String.valueOf(1), String.valueOf(1), actionValue}), (String)result.toString(), (int)8188);
        SysUtil.abort();
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        BatchFileInfo info = (BatchFileInfo)newData;
        for (int i = 0; i < info.getEntries().size(); ++i) {
            info.getEntries().get(i).setTimes(1);
            info.getEntries().get(i).setLotSource(LotSourceEnum.manual);
        }
    }

    private void setEntryLotNo() {
        if (this.kdtEntrys.getRowCount() <= 0) {
            return;
        }
        try {
            boolean isIsModifiable = false;
            for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
                Integer times = (Integer)this.kdtEntrys.getCell(i, this.TB_TIMES).getValue();
                LotSourceEnum lotSource = (LotSourceEnum)((Object)this.kdtEntrys.getCell(i, this.TB_LOTSOURCE).getValue());
                isIsModifiable = times != null && times <= 1 && !LotSourceEnum.system.equals((Object)lotSource);
                this.kdtEntrys.getRow(i).getStyleAttributes().setLocked(!isIsModifiable);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_batchfile_addnew";
        }
        if ("EDIT".equals(status)) {
            return "mm_batchfile_update";
        }
        if ("VIEW".equals(status)) {
            return "mm_batchfile_view";
        }
        return null;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        long currentSerial;
        super.actionCopy_actionPerformed(e);
        MaterialInfo materialInfo = (MaterialInfo)this.prmpMaterial.getValue();
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        LotFrame lotFrame = LotRuleFactory.getRemoteInstance().getLotFrame(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
        if (lotFrame != null) {
            if (lotFrame.getLotRule().isIsModifiable()) {
                this.txtLotNo.setAccessAuthority(0);
            } else {
                this.txtLotNo.setAccessAuthority(1);
            }
            currentSerial = BatchFileFactory.getRemoteInstance().updateLotRuleAssign(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
            lotFrame.setCurrentSerial(currentSerial);
            lotFrame.setMainBizOrg(storageOrgUnitInfo.getNumber());
            lotFrame.setMaterial(materialInfo.getNumber());
            lotFrame.setBizDate(new Date());
            lotFrame.setSeq(1);
            lotFrame.setBillNumber(this.txtNumber.getText());
            this.txtLotNo.setText(lotFrame.getLotNumber());
        } else {
            this.txtLotNo.setAccessAuthority(0);
        }
        int rowCount = this.kdtEntrys.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            materialInfo = (MaterialInfo)this.kdtEntrys.getCell(i, this.TB_MATERIAL).getValue();
            lotFrame = LotRuleFactory.getRemoteInstance().getLotFrame(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
            if (lotFrame != null) {
                if (lotFrame.getLotRule().isIsModifiable()) {
                    this.kdtEntrys.getCell(i, this.TB_LOT).getStyleAttributes().setLocked(false);
                } else {
                    this.kdtEntrys.getCell(i, this.TB_LOT).getStyleAttributes().setLocked(true);
                }
                currentSerial = BatchFileFactory.getRemoteInstance().updateLotRuleAssign(materialInfo.getId().toString(), storageOrgUnitInfo.getId().toString());
                lotFrame.setCurrentSerial(currentSerial);
                lotFrame.setMainBizOrg(storageOrgUnitInfo.getNumber());
                lotFrame.setMaterial(materialInfo.getNumber());
                lotFrame.setBizDate(new Date());
                lotFrame.setSeq(1);
                lotFrame.setBillNumber(this.txtNumber.getText());
                this.kdtEntrys.getCell(i, this.TB_LOT).setValue((Object)lotFrame.getLotNumber());
                continue;
            }
            this.kdtEntrys.getCell(i, this.TB_LOT).getStyleAttributes().setLocked(false);
            this.kdtEntrys.getCell(i, this.TB_LOT).setValue(null);
        }
    }
}

