/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.lot.client.AbstractBatchFileFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class BatchFileFilterUI
extends AbstractBatchFileFilterUI {
    private static final long serialVersionUID = 1L;
    private DataChangeListener storageOrgUnitChanged = null;
    private DataChangeListener materialFromChanged = null;
    private KDBizPromptBox[] prmtMaterials = new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo};
    private StorageOrgUnitInfo currPermOrg = null;

    protected StorageOrgUnitInfo getCurrPermOrg() {
        if (null == this.currPermOrg) {
            this.currPermOrg = (StorageOrgUnitInfo)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_batchfile_view");
        }
        return this.currPermOrg;
    }

    public BatchFileFilterUI() throws Exception {
        MMUtils.handleManualInputForF7((KDBizPromptBox[])this.prmtMaterials);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)this.getDefaultPermissionItem());
        Timestamp[] dates = SCMUtils.getDefaultDateRange((Date)SCMClientUtils.getServerDate2());
        this.prmtStorageOrgUnit.setValue((Object)this.getCurrPermOrg());
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement storage = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        elements.add((FilterElement)storage);
        MMRangeFilterElement materialElement = new MMRangeFilterElement("material.number", (Component)this.prmtMaterialFrom, (Component)this.prmtMaterialTo);
        elements.add((FilterElement)materialElement);
        elements.add((FilterElement)new SingleFilterElement("lotNo", (Component)this.prmtLotNoFrom));
        RangeFilterElement createTimeElement = new RangeFilterElement("createTime", (Component)this.dtCreateTimeFrom, (Component)this.dtCreateTimeTo);
        createTimeElement.setDefaultValue((Object)dates);
        elements.add((FilterElement)createTimeElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)storage, this.getPropertyOfMainBizOrg());
        this.setMaterialFilter();
        this.prmtLotNoFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                HashSet<String> storageID = new HashSet<String>();
                if (BatchFileFilterUI.this.prmtStorageOrgUnit.getValue() instanceof OrgUnitInfo) {
                    storageID.add(((OrgUnitInfo)BatchFileFilterUI.this.prmtStorageOrgUnit.getValue()).getId().toString());
                } else if (BatchFileFilterUI.this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
                    Object[] obj = (Object[])BatchFileFilterUI.this.prmtStorageOrgUnit.getValue();
                    for (int i = 0; i < obj.length; ++i) {
                        Object temp = obj[i];
                        storageID.add(((OrgUnitInfo)temp).getId().toString());
                    }
                }
                BatchFileFilterUI.this.initLotNoFromF7(storageID, BatchFileFilterUI.this.prmtMaterialFrom.getText(), BatchFileFilterUI.this.prmtMaterialTo.getText());
            }
        });
        this.prmtLotNoFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                HashSet<String> storageID = new HashSet<String>();
                if (BatchFileFilterUI.this.prmtStorageOrgUnit.getValue() instanceof OrgUnitInfo) {
                    storageID.add(((OrgUnitInfo)BatchFileFilterUI.this.prmtStorageOrgUnit.getValue()).getId().toString());
                } else if (BatchFileFilterUI.this.prmtStorageOrgUnit.getValue() instanceof Object[]) {
                    Object[] obj = (Object[])BatchFileFilterUI.this.prmtStorageOrgUnit.getValue();
                    for (int i = 0; i < obj.length; ++i) {
                        Object temp = obj[i];
                        storageID.add(((OrgUnitInfo)temp).getId().toString());
                    }
                }
                BatchFileFilterUI.this.initLotNoFromF7(storageID, BatchFileFilterUI.this.prmtMaterialFrom.getText(), BatchFileFilterUI.this.prmtMaterialTo.getText());
            }
        });
    }

    public void initLotNoFromF7(Set storageOrgID, String materialFrom, String materialTo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgID.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgID, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)" ", CompareType.EQUALS));
        }
        if (materialFrom != null && !materialFrom.equals("")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialFrom, CompareType.GREATER_EQUALS));
        }
        if (materialTo != null && !materialTo.equals("")) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialTo, CompareType.LESS_EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtLotNoFrom.setQueryInfo("com.kingdee.eas.mm.lot.app.F7LotNoBatchFileQuery");
        this.prmtLotNoFrom.setEntityViewInfo(viewInfo);
        this.prmtLotNoFrom.getQueryAgent().resetRuntimeEntityView();
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQuery((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtMaterialFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtMaterialTo, false, queryInfo);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtMaterialFrom, this.prmtMaterialTo});
    }

    protected String getDefaultPermissionItem() {
        return "mm_batchfile_view";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.lot.BatchFileResource", (String)strKey);
    }

    protected void initListener() {
        this.removeListener();
        super.initListener();
        this.storageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchFileFilterUI.this.storageOrgUnitChanged(eventObj);
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.materialFromChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchFileFilterUI.this.materialFromChanged(eventObj);
            }
        };
        this.prmtMaterialFrom.addDataChangeListener(this.materialFromChanged);
    }

    private void materialFromChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() instanceof MaterialInfo) {
            MaterialInfo materialFrom = (MaterialInfo)eventObj.getNewValue();
            if (this.prmtMaterialTo.getText() == null) {
                this.prmtMaterialTo.setValue((Object)materialFrom);
            }
        } else if (eventObj.getNewValue() instanceof String) {
            String materialFromText = (String)eventObj.getNewValue();
            if (this.prmtMaterialTo.getText() == null) {
                this.prmtMaterialTo.setText(materialFromText);
            }
        }
    }

    private void storageOrgUnitChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null || eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        this.prmtLotNoFrom.setValue(null);
        OrgUnitInfo storageInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String materialAttributeStr = "10030,10050";
        if (this.prmtStorageOrgUnit.getValue() instanceof OrgUnitInfo) {
            storageInfo = (OrgUnitInfo)eventObj.getNewValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)storageInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)storageInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)materialAttributeStr, CompareType.INCLUDE));
        } else if (eventObj.getNewValue() instanceof Object[]) {
            Object[] storageOrgUnits = (Object[])eventObj.getNewValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)materialAttributeStr, CompareType.INCLUDE));
            String maskString = "#0 AND #1 AND #2 AND #3 AND #4 AND (";
            int count = 4;
            for (int i = 0; i < storageOrgUnits.length; ++i) {
                storageInfo = (OrgUnitInfo)storageOrgUnits[i];
                if (i > 0) {
                    maskString = maskString + " OR ";
                }
                maskString = maskString + "(#" + ++count;
                maskString = maskString + " AND #" + ++count + ")";
                filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)storageInfo.getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)storageInfo.getId().toString()));
            }
            maskString = maskString + ")";
            filterInfo.setMaskString(maskString);
        }
        viewInfo.setFilter(filterInfo);
        this.prmtMaterialFrom.setEntityViewInfo(viewInfo);
        this.prmtMaterialTo.setEntityViewInfo(viewInfo);
    }

    private void removeListener() {
        if (this.storageOrgUnitChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        }
        if (this.materialFromChanged != null) {
            this.prmtMaterialFrom.removeDataChangeListener(this.materialFromChanged);
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public boolean verify() {
        if (!super.verify()) {
            return false;
        }
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)BatchFileFilterUI.getResource("storageOrgUnitIsNull"));
            this.prmtMaterialFrom.requestFocus();
            return false;
        }
        if (com.kingdee.eas.mm.common.util.MMUtils.isEmptyString((String)this.prmtMaterialFrom.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)BatchFileFilterUI.getResource("MaterialIsNotNull"));
            this.prmtMaterialFrom.requestFocus();
            return false;
        }
        if (com.kingdee.eas.mm.common.util.MMUtils.isEmptyString((String)this.prmtMaterialTo.getText())) {
            MsgBox.showInfo((Component)((Object)this), (String)BatchFileFilterUI.getResource("MaterialIsNotNull"));
            this.prmtMaterialFrom.requestFocus();
            return false;
        }
        if (this.dtCreateTimeFrom.getTimestamp() != null && this.dtCreateTimeTo.getTimestamp() != null && this.dtCreateTimeFrom.getTimestamp().compareTo(this.dtCreateTimeTo.getTimestamp()) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)BatchFileFilterUI.getResource("lessTime"));
            this.prmtMaterialFrom.requestFocus();
            return false;
        }
        return true;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        try {
            FilterInfo filterInfo;
            if (entityViewInfo != null && (filterInfo = entityViewInfo.getFilter()).getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                String materialAttributeStr = "10030,10050";
                for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                    int k;
                    FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
                    if (!"storageOrgUnit.number".equals(filterItemInfo.getPropertyName())) continue;
                    String orgIds = filterItemInfo.getCompareValue().toString();
                    if (orgIds.charAt(0) == '[' && orgIds.charAt(orgIds.length() - 1) == ']') {
                        orgIds = orgIds.substring(1, orgIds.length() - 1);
                    }
                    String[] numbers = orgIds.split(",");
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    int count = 0;
                    String maskString = "";
                    for (int j = 0; j < numbers.length; ++j) {
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numbers[j].trim(), CompareType.EQUALS));
                        if (j > 0) {
                            maskString = maskString + " or ";
                        }
                        maskString = maskString + "#" + count;
                        ++count;
                    }
                    filter.setMaskString(maskString);
                    viewInfo.setFilter(filter);
                    StorageOrgUnitCollection collection = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(viewInfo);
                    Object[] obj = new Object[collection.size()];
                    for (k = 0; k < obj.length; ++k) {
                        obj[k] = collection.get(k);
                    }
                    this.prmtStorageOrgUnit.setValue((Object)obj);
                    filterInfo = new FilterInfo();
                    viewInfo = new EntityViewInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1)));
                    filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1)));
                    filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
                    filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE));
                    filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", (Object)materialAttributeStr, CompareType.INCLUDE));
                    maskString = "#0 AND #1 AND #2 AND #3 AND #4 AND (";
                    count = 4;
                    for (k = 0; k < collection.size(); ++k) {
                        StorageOrgUnitInfo storageInfo = collection.get(k);
                        if (k > 0) {
                            maskString = maskString + " or ";
                        }
                        maskString = maskString + "(#" + ++count;
                        maskString = maskString + " and #" + ++count + ")";
                        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)storageInfo.getId().toString()));
                        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)storageInfo.getId().toString()));
                    }
                    maskString = maskString + ")";
                    filterInfo.setMaskString(maskString);
                    viewInfo.setFilter(filterInfo);
                    this.prmtMaterialFrom.setEntityViewInfo(viewInfo);
                    this.prmtMaterialTo.setEntityViewInfo(viewInfo);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected String getViewPermission() {
        return "mm_batchfile_view";
    }
}

