/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.lot.BatchFileFactory;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.LotTraceFacadeException;
import com.kingdee.eas.mm.lot.client.AbstractBatchFileListUI;
import com.kingdee.eas.mm.lot.client.BatchFileFilterUI;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class BatchFileListUI
extends AbstractBatchFileListUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchFileListUI.class);
    private static final String[] KDT_DATES = new String[]{"createTime"};
    private BatchFileFilterUI conditionPanel = null;
    private String RESOURCE_PATH = "com.kingdee.eas.mm.lot.BatchFileResource";
    private static final String CR = "\n";

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDMenuPercisionConfig.setText(this.kDMenuPercisionConfig.getText() + "(C)");
        this.kDMenuPercisionConfig.setIcon(EASResource.getIcon((String)"imgTbtn_showsetting"));
        this.kDMenuPercisionConfig.setMnemonic(67);
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new BatchFileFilterUI();
        }
        return this.conditionPanel;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        String title = this.getBatchFileResource("BatchFileTitle");
        dialog.setTitle(title + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BatchFileFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        BatchFileInfo objectValue = new BatchFileInfo();
        return objectValue;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"id", "storageOrgUnit.name", "material.number", "material.name", "material.model", "baseStatus", "lotNo", "createTime"};
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        SorterItemInfo newSort = new SorterItemInfo();
        newSort.setPropertyName("id");
        newSort.setSortType(SortType.ASCEND);
        SorterItemInfo oldSort = new SorterItemInfo();
        oldSort.setPropertyName("id");
        oldSort.setSortType(SortType.ASCEND);
        this.setSortForQuery(oldSort, newSort);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.btnSubmit.setVisible(false);
        this.btnUnAudit.setVisible(false);
        String uiTitle = EASResource.getString((String)this.RESOURCE_PATH, (String)"batchFileListTitle");
        this.setUITitle(uiTitle);
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
        super.setReservationVisible(false);
    }

    private void mergeColumns() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "BatchFileImport";
        param.alias = this.getBatchFileResource("BatchFileInOutTitle");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "BatchFileImport";
        param.alias = this.getBatchFileResource("BatchFileInOutTitle");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    protected String getEditUIName() {
        return "com.kingdee.eas.mm.lot.client.BatchFileEditUI";
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Storage)) {
            return "storageOrgUnit.id";
        }
        return null;
    }

    protected void logPrint() {
        BatchFileInfo plInfo = new BatchFileInfo();
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)plInfo.getBOSType(), null, (String)this.getBatchFileResource("MSG_BATCHFILE_PRINT"), (String)"mm_batchFile_print");
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    private String getBatchFileResource(String sKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.lot.BatchFileResource", (String)sKey);
    }

    public boolean isSupportedBatchActions() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            ArrayList ids = super.getSelectedIdValues();
            int errorCount = 0;
            int idnum = ids.size();
            if (ids != null) {
                boolean hasException = false;
                ICoreBase scmBillBase = this.getBizInterface();
                for (int i = 0; i < idnum; ++i) {
                    try {
                        this.setOprtState("REMOVE");
                        this.pubFireVOChangeListener(ids.get(i).toString());
                    }
                    catch (Throwable ex) {
                        if (idnum == 1) {
                            this.handUIException(ex);
                            this.abort();
                        }
                        hasException = true;
                        continue;
                    }
                    try {
                        scmBillBase.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString())));
                        continue;
                    }
                    catch (Exception onfe) {
                        if (idnum == 1) {
                            this.refreshList();
                            throw onfe;
                        }
                        if (onfe instanceof LotTraceFacadeException) {
                            String code = ((LotTraceFacadeException)((Object)onfe)).getSubCode();
                            if (LotTraceFacadeException.CAN_BE_REMOVE2.getCode().equals(code)) {
                                ++errorCount;
                            }
                        }
                        hasException = true;
                        continue;
                    }
                    finally {
                        try {
                            this.setOprtState("RELEASEALL");
                            this.pubFireVOChangeListener(ids.get(i).toString());
                        }
                        catch (Throwable t) {
                            this.handUIException(t);
                        }
                    }
                }
                if (hasException) {
                    this.showException(e, errorCount, idnum);
                }
            }
            this.refresh(e);
        }
    }

    private void showException(ActionEvent e, int errorCount, int idnum) throws Exception, SCMBillException {
        String actionValue;
        StringBuffer result;
        this.refreshList();
        if (errorCount > 0) {
            result = new StringBuffer();
            result.append(ResourceUtils.getMessage((String)this.RESOURCE_PATH, (String)"makeBySys2", (String[])new String[]{String.valueOf(idnum), String.valueOf(errorCount)}));
            actionValue = "";
            if (e.getSource() instanceof KDWorkButton) {
                actionValue = (String)((KDWorkButton)e.getSource()).getAction().getValue("ShortDescription");
            } else if (e.getSource() instanceof KDMenuItem) {
                actionValue = (String)((KDMenuItem)e.getSource()).getAction().getValue("ShortDescription");
            }
        } else {
            throw new SCMBillException(SCMBillException.PARTOFDELETEDBILL_CANNOT_BE_DELETE);
        }
        MsgBox.showDetailAndOK(null, (String)ResourceUtils.getMessageInOrder((String)"com.kingdee.eas.scm.common.ActionResource", (String)"ERROR_HEAD_MSG", (String[])new String[]{String.valueOf(idnum), String.valueOf(errorCount), actionValue}), (String)result.toString(), (int)8188);
        SysUtil.abort();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        viewInfo.setSorter(null);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("storageOrgUnit.name");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("material.number");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("material.name");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("material.model");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("lotNo");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("baseStatus");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        return super.getQueryExecutor(queryPK, viewInfo);
    }
}

