/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.lot.QueryTypeEnum;
import com.kingdee.eas.mm.lot.client.AbstractMaterialLotTraceFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MaterialLotTraceFilterUI
extends AbstractMaterialLotTraceFilterUI {
    private static final long serialVersionUID = -2042247311810302662L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialLotTraceFilterUI.class);
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType(), 1);
    private OrgUnitInfo currPermOrg = null;
    private DataChangeListener materialChanged = null;
    private DataChangeListener lotNoStartChanged = null;
    private CustomerParams cp = null;
    private DataChangeListener storageOrgUnitChanged = null;

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_materialLotTrace_query");
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"StorageOrgUnitIsNotNull")));
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement materialElement = new SingleFilterElement("materialNumber", (Component)this.prmtMaterial);
        materialElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"MaterialIsNotNull")));
        elements.add((FilterElement)materialElement);
        elements.add((FilterElement)new SingleFilterElement("lotNo", (Component)this.prmtLotNoFrom));
        this.cmbQueryType.removeItem((Object)QueryTypeEnum.sumTier);
        SingleFilterElement queryMode = new SingleFilterElement("queryType", (Component)this.cmbQueryType);
        queryMode.setDefaultValue((Object)new Integer(10));
        elements.add((FilterElement)queryMode);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.prmtMaterial.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                MaterialLotTraceFilterUI.this.initMaterialF7((OrgUnitInfo)MaterialLotTraceFilterUI.this.prmtStorageOrgUnit.getValue());
            }
        });
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MaterialLotTraceFilterUI.this.initMaterialF7((OrgUnitInfo)MaterialLotTraceFilterUI.this.prmtStorageOrgUnit.getValue());
            }
        });
        this.prmtLotNoFrom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                MaterialLotTraceFilterUI.this.initLotNoFromF7((OrgUnitInfo)MaterialLotTraceFilterUI.this.prmtStorageOrgUnit.getValue(), (MaterialInfo)MaterialLotTraceFilterUI.this.prmtMaterial.getValue());
            }
        });
        this.prmtLotNoFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                MaterialLotTraceFilterUI.this.initLotNoFromF7((OrgUnitInfo)MaterialLotTraceFilterUI.this.prmtStorageOrgUnit.getValue(), (MaterialInfo)MaterialLotTraceFilterUI.this.prmtMaterial.getValue());
            }
        });
        this.prmtLotNoFrom.setCommitParser(null);
        this.prmtLotNoFrom.setEnabledMultiSelection(true);
        this.addListener();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public boolean verify() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"StorageOrgUnitIsNotNull"));
            return false;
        }
        if (this.prmtMaterial.getValue() == null) {
            MsgBox.showInfo((String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"MaterialIsNotNull"));
            return false;
        }
        if (MMUtils.isEmptyString((String)this.prmtLotNoFrom.getText())) {
            MsgBox.showInfo((String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"LotNoIsNotNull"));
            this.prmtLotNoFrom.requestFocus();
            return false;
        }
        return true;
    }

    public void initMaterialF7(OrgUnitInfo storageOrg) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String storageOrgID = null;
        if (storageOrg != null) {
            storageOrgID = storageOrg.getId().toString();
        } else if (this.currPermOrg != null) {
            storageOrgID = this.currPermOrg.getId().toString();
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(10030));
        set.add(new Integer(10050));
        set.add(new Integer(10060));
        set.add(new Integer(10040));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)storageOrgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)storageOrgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE, CompareType.EQUALS));
        if (storageOrg != null) {
            this.prmtMaterial.setCurrentCtrlUnit(storageOrg.getCU());
        }
        viewInfo.setFilter(filterInfo);
        this.prmtMaterial.setEntityViewInfo(viewInfo);
        this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
    }

    public void initLotNoFromF7(OrgUnitInfo storageOrg, MaterialInfo material) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrg != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrg.getId().toString(), CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)" ", CompareType.EQUALS));
        }
        if (material != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtLotNoFrom.setQueryInfo("com.kingdee.eas.mm.lot.app.F7LotNoTraceQuery");
        this.prmtLotNoFrom.setEntityViewInfo(viewInfo);
        this.prmtLotNoFrom.getQueryAgent().resetRuntimeEntityView();
    }

    protected void addListener() {
        this.storageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MaterialLotTraceFilterUI.this.storageOrgUnitChanged(eventObj);
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.materialChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MaterialLotTraceFilterUI.this.materialChanged(eventObj);
            }
        };
        this.prmtMaterial.addDataChangeListener(this.materialChanged);
    }

    public void storageOrgUnitChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        Object storageOrg = null;
        storageOrg = eventObj.getNewValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)eventObj.getNewValue(), (Object)eventObj.getOldValue());
        if (storageOrg == null) {
            storageOrg = (OrgUnitInfo)eventObj.getOldValue();
        }
        if (isDiffrent) {
            this.currPermOrg = storageOrg;
            this.prmtMaterial.setValue(null);
            this.prmtLotNoFrom.setValue(null);
            this.prmtLotNoFrom.setText(null);
            if (storageOrg != null) {
                this.prmtMaterial.setCurrentCtrlUnit(storageOrg.getCU());
            }
        }
    }

    private void materialChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)eventObj.getNewValue(), (Object)eventObj.getOldValue());
        if (isDiffrent) {
            this.prmtLotNoFrom.setValue(null);
            this.prmtLotNoFrom.setText(null);
        }
    }

    private void removeListener() {
        if (this.storageOrgUnitChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        }
        if (this.materialChanged != null) {
            this.prmtMaterial.removeDataChangeListener(this.materialChanged);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        FilterItemCollection itemCollection = filter.getFilterItems();
        Object stotageInfo = null;
        stotageInfo = this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (stotageInfo != null) {
            itemCollection.add(new FilterItemInfo("storageOrgUnit.id", (Object)stotageInfo.getId().toString(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("storageOrgUnit.number", (Object)stotageInfo.getNumber(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("storageOrgUnit.name", (Object)stotageInfo.getName(), CompareType.EQUALS));
        }
        if (this.prmtMaterial.getValue() != null && this.prmtMaterial.getText() != null && this.prmtMaterial.getText().length() > 0) {
            itemCollection.add(new FilterItemInfo("material.id", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("material.number", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getNumber(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("material.name", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getName(), CompareType.EQUALS));
        }
        return filter;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        Object stotageInfo = null;
        stotageInfo = this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (stotageInfo != null) {
            pp.addCustomerParam("storageOrgUnit.id", stotageInfo.getId().toString());
            pp.addCustomerParam("storageOrgUnit.name", stotageInfo.getName().toString());
            pp.addCustomerParam("storageOrgUnit.number", stotageInfo.getNumber().toString());
            pp.addCustomerParam("storageOrgUnit.cu", stotageInfo.getCU().getId().toString());
        }
        MaterialInfo mInfo = (MaterialInfo)this.prmtMaterial.getValue();
        pp.addCustomerParam("material.id", mInfo.getId().toString());
        pp.addCustomerParam("material.name", mInfo.getName().toString());
        pp.addCustomerParam("material.number", mInfo.getNumber().toString());
        return pp;
    }

    public RptParams getCustomCondition() {
        RptParams pp = super.getCustomCondition();
        Object stotageInfo = null;
        stotageInfo = this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (stotageInfo != null) {
            pp.setString("storageOrgUnit.id", stotageInfo.getId().toString());
            pp.setString("storageOrgUnit.name", stotageInfo.getName().toString());
            pp.setString("storageOrgUnit.number", stotageInfo.getNumber());
            pp.setString("storageOrgUnit.cu", stotageInfo.getCU().getId().toString());
        }
        MaterialInfo mInfo = (MaterialInfo)this.prmtMaterial.getValue();
        pp.setString("material.name", mInfo.getName().toString());
        pp.setString("material.id", mInfo.getId().toString());
        pp.setString("material.number", mInfo.getNumber());
        this.cp = null;
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        super.loadData(entityViewInfo);
        CtrlUnitInfo cu = new CtrlUnitInfo();
        if (this.cp.getCustomerParam("storageOrgUnit.cu") != null) {
            cu.setId(BOSUuid.read((String)this.cp.getCustomerParam("storageOrgUnit.cu")));
        }
        MaterialInfo mInfo = new MaterialInfo();
        mInfo.setName(this.cp.getCustomerParam("material.name"));
        mInfo.setNumber(this.cp.getCustomerParam("material.number"));
        mInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("material.id")));
        this.prmtMaterial.setValue((Object)mInfo);
        this.prmtMaterial.setCurrentCtrlUnit(cu);
        StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
        storageInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("storageOrgUnit.id")));
        storageInfo.setName(this.cp.getCustomerParam("storageOrgUnit.name"));
        storageInfo.setNumber(this.cp.getCustomerParam("storageOrgUnit.number"));
        storageInfo.setCU(cu);
        this.prmtStorageOrgUnit.setValue((Object)storageInfo);
        this.addListener();
    }

    protected String getViewPermission() {
        return "mm_materialLotTrace_query";
    }
}

