/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.control.client.MaterialLotTracePrintDataProvider;
import com.kingdee.eas.mm.control.client.ProductToSaleIssueBillTraceUI;
import com.kingdee.eas.mm.control.client.TableCellComparator;
import com.kingdee.eas.mm.lot.BatchFileInfo;
import com.kingdee.eas.mm.lot.ILotTraceFacade;
import com.kingdee.eas.mm.lot.LotTraceFacadeFactory;
import com.kingdee.eas.mm.lot.QueryTypeEnum;
import com.kingdee.eas.mm.lot.client.AbstractMaterialLotTraceListUI;
import com.kingdee.eas.mm.lot.client.MaterialLotTraceFilterUI;
import com.kingdee.eas.scm.common.action.ISupportObjContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class MaterialLotTraceListUI
extends AbstractMaterialLotTraceListUI
implements ISupportObjContext {
    private static final long serialVersionUID = -8200712514397445259L;
    private static final Logger logger = CoreUIObject.getLogger(MaterialLotTraceListUI.class);
    private static final String TB_P_STRUCTCODE = "tier";
    private static final String TB_P_OFMATERIAL = "OfMaterial";
    private static final String TB_P_OFMATERIALLOT = "OfMaterialLot";
    private static final String[] KDT_DATES = new String[]{"lotDate"};
    protected MaterialLotTraceFilterUI filterUI;
    ILotTraceFacade iLotTraceFacade;
    private CommonQueryDialog queryDialog;
    private List productList;
    private List srcMaterialList;
    private String curSrcMaterialId;
    private String curProductMaterialId;
    private String curProductLotNo;
    private KDTSelectListener srcMaterialKDTSelectListener;
    private KDTSelectListener productKDTSelectListener;
    private boolean mustShowQueryDialog = false;
    private Map productionMap = null;
    private QueryTypeEnum queryType = QueryTypeEnum.lastTier;
    private String storageOrgUnitId;
    private Set lotNo;
    private StorageOrgUnitInfo storageOrgUnit;
    public final String UICONTEXT_KEY_BE_JOINQUERY = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_BE_JOINQUERY";
    public final String UICONTEXT_KEY_JOINQUERY_PARAMS = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_PARAMS";
    public final String UICONTEXT_KEY_JOINQUERY_DATA = "com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_DATA";
    private String[] MATERIAL_HEAD = null;
    private int sort = 0;

    public Map getProductionMap() {
        if (null == this.productionMap) {
            this.productionMap = new HashMap();
        }
        return this.productionMap;
    }

    public MaterialLotTraceListUI() throws Exception {
        this.iLotTraceFacade = LotTraceFacadeFactory.getRemoteInstance();
        this.kdtMaterial.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                MaterialLotTraceListUI.this.sortForTable(e, MaterialLotTraceListUI.this.kdtMaterial);
            }
        });
        this.kdtProduct.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                MaterialLotTraceListUI.this.sortForTable(e, MaterialLotTraceListUI.this.kdtProduct);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.showQueryDialog()) {
            SysUtil.abort();
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setColumnVisible();
        this.kdtMaterial.getSelectManager().setSelectMode(10);
        this.kdtProduct.getSelectManager().setSelectMode(2);
        this.kdtMaterial.getStyleAttributes().setLocked(true);
        this.kdtProduct.getStyleAttributes().setLocked(true);
        this.addListener();
        EditTableUtil.formatColDate((KDTable)this.kdtMaterial, (String[])KDT_DATES);
        EditTableUtil.formatColDate((KDTable)this.kdtProduct, (String[])KDT_DATES);
    }

    private void addListener() {
        this.removeListener();
        this.kdtMaterial.getSelectManager().addKDTSelectListener(this.srcMaterialKDTSelectListener);
        this.kdtProduct.getSelectManager().addKDTSelectListener(this.productKDTSelectListener);
    }

    private void removeListener() {
        if (null != this.srcMaterialKDTSelectListener) {
            this.kdtMaterial.getSelectManager().removeKDTSelectListener(this.srcMaterialKDTSelectListener);
        }
        if (null != this.productKDTSelectListener) {
            this.kdtProduct.getSelectManager().removeKDTSelectListener(this.productKDTSelectListener);
        }
    }

    protected void initListener() {
        super.initListener();
        this.srcMaterialKDTSelectListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int selectedIndex = MaterialLotTraceListUI.this.kdtMaterial.getSelectManager().getActiveRowIndex();
                if (selectedIndex < 0) {
                    return;
                }
                String selectedRowId = (String)MaterialLotTraceListUI.this.kdtMaterial.getCell(selectedIndex, "id").getValue();
                if (null != MaterialLotTraceListUI.this.curSrcMaterialId && null != selectedRowId && !MaterialLotTraceListUI.this.curSrcMaterialId.equals(selectedRowId)) {
                    MaterialLotTraceListUI.this.curSrcMaterialId = selectedRowId;
                    MaterialLotTraceListUI.this.productList = MaterialLotTraceListUI.this.productTrace(MaterialLotTraceListUI.this.curSrcMaterialId);
                    MaterialLotTraceListUI.this.fillKdtProduct(MaterialLotTraceListUI.this.productList);
                }
            }
        };
        this.productKDTSelectListener = new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                MaterialLotTraceListUI.this.curProductMaterialId = null;
                MaterialLotTraceListUI.this.curProductLotNo = null;
                int selectedIndex = MaterialLotTraceListUI.this.kdtProduct.getSelectManager().getActiveRowIndex();
                if (selectedIndex < 0) {
                    return;
                }
                MaterialLotTraceListUI.this.curProductMaterialId = (String)MaterialLotTraceListUI.this.kdtProduct.getCell(selectedIndex, "materialId").getValue();
                MaterialLotTraceListUI.this.curProductLotNo = (String)MaterialLotTraceListUI.this.kdtProduct.getCell(selectedIndex, "lotNo").getValue();
            }
        };
    }

    private void setColumnVisible() {
        boolean isHide = 20 != this.queryType.getValue();
        this.kdtProduct.getColumn(TB_P_STRUCTCODE).getStyleAttributes().setHided(isHide);
        this.kdtProduct.getColumn(TB_P_OFMATERIAL).getStyleAttributes().setHided(isHide);
        this.kdtProduct.getColumn(TB_P_OFMATERIALLOT).getStyleAttributes().setHided(isHide);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected boolean showQueryDialog() {
        try {
            boolean actionType;
            FilterInfo filterInfo = null;
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            this.initCommonQueryDialog();
            this.filterUI.getUIContext().clear();
            this.filterUI.getUIContext().putAll(this.getUIContext());
            boolean isNeedShowQueryDialog = true;
            if (!this.mustShowQueryDialog) {
                this.queryDialog.init();
                this.queryDialog.getCommonQueryParam().setDirty(false);
                QuerySolutionInfo currSolution = this.queryDialog.getCurrentSolutionInfo();
                if (currSolution.isIsUserDefaultSolu()) {
                    this.filterUI = (MaterialLotTraceFilterUI)this.queryDialog.getUserPanel(MaterialLotTraceFilterUI.class.getName());
                    if (null != currSolution.getEntityViewInfo()) {
                        filterInfo = this.filterUI.getFilterInfo();
                        entityViewInfo.setFilter(filterInfo);
                        entityViewInfo.setSorter(this.queryDialog.getCommonSorters());
                        try {
                            this.execQuery(entityViewInfo);
                            isNeedShowQueryDialog = false;
                            return true;
                        }
                        catch (Exception e1) {
                            this.handleException(e1);
                        }
                    }
                }
            }
            if ((this.mustShowQueryDialog || isNeedShowQueryDialog) && (actionType = this.queryDialog.show())) {
                this.filterUI = (MaterialLotTraceFilterUI)this.queryDialog.getUserPanel(MaterialLotTraceFilterUI.class.getName());
                filterInfo = this.filterUI.getFilterInfo();
                if (null != filterInfo) {
                    entityViewInfo.setFilter(filterInfo);
                    entityViewInfo.setSorter(this.queryDialog.getCommonSorters());
                    this.execQuery(entityViewInfo);
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"@showQueryDialog", (Throwable)e);
            this.handleException(e);
        }
        return false;
    }

    private void execQuery(EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        String materialId = null;
        HashSet lotNo = new HashSet();
        SorterItemCollection sorterIC = entityViewInfo.getSorter();
        FilterItemCollection filterItems = entityViewInfo.getFilter().getFilterItems();
        if (null != filterItems && filterItems.size() > 0) {
            this.storageOrgUnit = new StorageOrgUnitInfo();
            for (FilterItemInfo filterItem : filterItems) {
                if (filterItem.getPropertyName().equals("storageOrgUnit.id")) {
                    this.storageOrgUnit.setId(BOSUuid.read((String)((String)filterItem.getCompareValue())));
                    this.storageOrgUnitId = this.storageOrgUnit.getId().toString();
                    continue;
                }
                if (filterItem.getPropertyName().equals("storageOrgUnit.number")) {
                    this.storageOrgUnit.setNumber((String)filterItem.getCompareValue());
                    continue;
                }
                if (filterItem.getPropertyName().equals("storageOrgUnit.name")) {
                    this.storageOrgUnit.setName((String)filterItem.getCompareValue());
                    continue;
                }
                if (filterItem.getPropertyName().equals("material.id")) {
                    materialId = filterItem.getCompareValue().toString();
                    continue;
                }
                if (filterItem.getPropertyName().equals("lotNo")) {
                    if (filterItem.getCompareValue() instanceof String) {
                        lotNo.add((String)filterItem.getCompareValue());
                        continue;
                    }
                    lotNo = (HashSet)filterItem.getCompareValue();
                    continue;
                }
                if (!filterItem.getPropertyName().equals("queryType")) continue;
                this.queryType = QueryTypeEnum.getEnum(new Integer((String)filterItem.getCompareValue()));
            }
            this.prmtStorageOrgUnit.setValue((Object)this.storageOrgUnit);
        }
        if (null == this.storageOrgUnitId || null == materialId || null == lotNo) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"QueryMustAllInput"));
            return;
        }
        FilterInfo commonFilterInfo = this.queryDialog.getCommonFilter();
        List list = this.iLotTraceFacade.querySrcMaterial(this.storageOrgUnitId, materialId, lotNo, this.queryType, sorterIC, commonFilterInfo);
        if (null != list && list.size() > 0) {
            this.srcMaterialList = (List)list.get(0);
            this.kdtProduct.removeRows();
            this.fillKdtMaterial(this.srcMaterialList);
            if (list.size() > 1) {
                this.productList = (List)list.get(1);
                this.fillKdtProduct(this.productList);
                this.curSrcMaterialId = ((String[])this.srcMaterialList.get(0))[0];
                String key = new StringBuffer().append(this.curSrcMaterialId).append("-").append(this.storageOrgUnitId.trim()).append("-").append(this.queryType.getValue()).toString();
                this.getProductionMap().put(key, this.productList);
            }
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDialog == null) {
            this.queryDialog = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                this.queryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.queryDialog.setOwner((Component)((Object)this));
            }
            this.queryDialog.setUiObject((IUIObject)this);
            this.queryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.queryDialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.mm.lot.app.MaterialLotNoTraceQuery"));
            MessageFormat format = BOSLocaleUtil.getMessageFormat((String)"{0}-{1}");
            String title = format.format(new Object[]{this.getUITitle(), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter")});
            this.queryDialog.setTitle(title);
            this.queryDialog.setShowFilter(false);
            try {
                this.filterUI = new MaterialLotTraceFilterUI();
                Dimension a = this.filterUI.getSize();
                this.queryDialog.setWidth(a.width);
                this.queryDialog.setHeight(a.height);
                this.queryDialog.addUserPanel((KDPanel)this.filterUI);
                this.queryDialog.setShowSorter(true);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.queryDialog;
    }

    private List productTrace(String srcMaterialId) {
        String key = new StringBuffer().append(srcMaterialId).append("-").append(this.storageOrgUnitId.trim()).append("-").append(this.queryType.getValue()).toString();
        List products = (List)this.getProductionMap().get(key);
        if (null == products) {
            try {
                products = this.iLotTraceFacade.materialTrace(srcMaterialId, this.storageOrgUnitId, this.queryType);
                this.getProductionMap().put(key, products);
            }
            catch (Exception e1) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"TraceProductError"), (String)e1.getMessage(), (int)1);
                this.kdtProduct.removeRows();
                SysUtil.abort();
            }
        }
        return products;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.mustShowQueryDialog = true;
        this.showQueryDialog();
        this.setColumnVisible();
    }

    private Map getPrintProductInfo() {
        HashMap<String, List> srcMaterialToProduct = new HashMap<String, List>();
        for (String[] element : this.srcMaterialList) {
            List products = this.productTrace(element[0]);
            srcMaterialToProduct.put(element[0], products);
        }
        return srcMaterialToProduct;
    }

    public String getTemplatePath(QueryTypeEnum queryType) {
        String templatePath = null;
        if (10 == queryType.getValue() || 30 == queryType.getValue()) {
            templatePath = "MM/lot/lotApp/MaterialLotTrace/MaterialLotTrace_NoMulti.r1-print";
        } else if (20 == queryType.getValue()) {
            templatePath = "MM/lot/lotApp/MaterialLotTrace/MaterialLotTrace_Multi.r1-print";
        }
        return templatePath;
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.srcMaterialList || this.srcMaterialList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrintPreview"));
            return;
        }
        Map printProduct = this.getPrintProductInfo();
        MaterialLotTracePrintDataProvider data = new MaterialLotTracePrintDataProvider(this.storageOrgUnit.getName(), this.srcMaterialList, printProduct, this.queryType);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, true, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.srcMaterialList || this.srcMaterialList.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotPrint"));
            return;
        }
        Map printProduct = this.getPrintProductInfo();
        MaterialLotTracePrintDataProvider data = new MaterialLotTracePrintDataProvider(this.storageOrgUnit.getName(), this.srcMaterialList, printProduct, this.queryType);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.directPrint(this.getTemplatePath(this.queryType), (Object)data, false, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionAssociatedQuery_actionPerformed(ActionEvent e) throws Exception {
        int row = this.kdtProduct.getSelectManager().getActiveRowIndex();
        if (row < 0) {
            MsgBox.showInfo((String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"select_One_product"));
            return;
        }
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        String permItemName = "saleissue_view";
        permission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(this.storageOrgUnitId), permItemName);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"curProductMaterialId", (Object)this.curProductMaterialId);
        uiContext.put((Object)"curProductLotNo", (Object)this.curProductLotNo);
        uiContext.put((Object)"storageOrgUnitId", (Object)this.storageOrgUnitId);
        UIHelper.openUIWindow((UIContext)uiContext, (String)ProductToSaleIssueBillTraceUI.class.getName());
    }

    private void fillKdtMaterial(List list) {
        this.kdtMaterial.checkParsed();
        this.kdtMaterial.removeRows();
        if (null != list && list.size() > 0) {
            for (String[] element : list) {
                IRow row = this.kdtMaterial.addRow();
                row.getCell("id").setValue((Object)element[0]);
                row.getCell("material.number").setValue((Object)element[1]);
                row.getCell("material.name").setValue((Object)element[2]);
                row.getCell("material.model").setValue((Object)element[3]);
                row.getCell("lotNo").setValue((Object)element[4]);
                row.getCell("lotDate").setValue((Object)element[5]);
            }
        }
    }

    private void fillKdtProduct(List list) {
        this.kdtProduct.checkParsed();
        this.kdtProduct.removeRows();
        if (null != list && list.size() > 0) {
            for (BatchFileInfo element : list) {
                IRow row = this.kdtProduct.addRow();
                row.getCell("id").setValue((Object)element.getId().toString());
                row.getCell(TB_P_STRUCTCODE).setValue(element.get("ep_structCode_20080923"));
                if (null != element.getMaterial()) {
                    row.getCell("materialId").setValue((Object)element.getMaterial().getId().toString());
                    row.getCell("materialNumber").setValue((Object)element.getMaterial().getNumber());
                    row.getCell("materialName").setValue((Object)element.getMaterial().getName());
                    row.getCell("materialModel").setValue((Object)element.getMaterial().getModel());
                }
                row.getCell("lotNo").setValue((Object)element.getLotNo());
                if (null != element.getCreateTime()) {
                    row.getCell("lotDate").setValue((Object)CtrlFormatUtilities.getDateFormat().format(element.getCreateTime()));
                }
                row.getCell(TB_P_OFMATERIAL).setValue(element.get("ep_OfMaterial_20080923"));
                row.getCell(TB_P_OFMATERIALLOT).setValue(element.get("ep_OfMaterialLot_20080923"));
            }
        }
    }

    private String[] toStringArray(List list) {
        String[] arrays = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arrays[i] = list.get(i).toString();
        }
        return arrays;
    }

    private List getExportTableName(KDTable table) {
        ArrayList<Object> headList = new ArrayList<Object>();
        KDTRow headRow = table.getHead().getRow(0);
        headList.add(ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"seq"));
        for (int i = 0; i < table.getColumnCount(); ++i) {
            KDTCell cell = headRow.getCell(i);
            if (table.getColumn(i).getStyleAttributes().isHided()) continue;
            headList.add(cell.getValue());
        }
        return headList;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.srcMaterialList || this.srcMaterialList.size() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"NoData_CanNotExport"));
            return;
        }
        List head = this.getExportTableName(this.kdtMaterial);
        this.MATERIAL_HEAD = this.toStringArray(head);
        head = this.getExportTableName(this.kdtProduct);
        String[] productHead = this.toStringArray(head);
        ArrayList<String[]> exportList = new ArrayList<String[]>();
        List selectIds = KDTableUtils.getSelectedRows((KDTable)this.kdtMaterial, (String)"id");
        if (0 == selectIds.size()) {
            MsgBox.showInfo((Component)((Object)this), (String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"SelectMaterialInfo"));
            return;
        }
        if (null != selectIds && selectIds.size() > 0) {
            for (String id : selectIds) {
                for (String[] element : this.srcMaterialList) {
                    if (!element[0].equals(id)) continue;
                    exportList.add(element);
                }
            }
        }
        File tempFile = File.createTempFile("tmp", ".xls");
        int curRowIndex = 0;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Sheet1");
        String storageLabel = ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"StorageLabel");
        String prodectLabel = ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"ProdectLabel");
        String materialLabel = ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"MaterialLabel");
        HSSFRow row = sheet.createRow(curRowIndex);
        row.createCell(0).setCellValue((RichTextString)new HSSFRichTextString(storageLabel));
        String storageOrgUnitName = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getName();
        row.createCell(1).setCellValue((RichTextString)new HSSFRichTextString(storageOrgUnitName));
        curRowIndex = (short)(curRowIndex + 1);
        row = sheet.createRow(curRowIndex);
        row.createCell(0).setCellValue((RichTextString)new HSSFRichTextString(materialLabel));
        curRowIndex = (short)(curRowIndex + 1);
        int index = 0;
        int seq = 0;
        for (String[] element : exportList) {
            int i;
            curRowIndex = (short)(curRowIndex + 1);
            row = sheet.createRow(curRowIndex);
            for (i = 0; i < this.MATERIAL_HEAD.length; ++i) {
                row.createCell((int)((short)i)).setCellValue((RichTextString)new HSSFRichTextString(this.MATERIAL_HEAD[i]));
            }
            curRowIndex = (short)(curRowIndex + 1);
            row = sheet.createRow(curRowIndex);
            row.createCell(0).setCellValue((double)(++index));
            for (i = 1; i < element.length; ++i) {
                row.createCell((int)((short)i)).setCellValue((RichTextString)new HSSFRichTextString(element[i]));
            }
            seq = 0;
            List products = null;
            products = this.productTrace(element[0]);
            if (null != products && products.size() > 0) {
                curRowIndex = (short)(curRowIndex + 1);
                row = sheet.createRow(curRowIndex);
                row.createCell(0).setCellValue((RichTextString)new HSSFRichTextString(prodectLabel));
                curRowIndex = (short)(curRowIndex + 1);
                row = sheet.createRow(curRowIndex);
                for (int i2 = 0; i2 < productHead.length; ++i2) {
                    row.createCell((int)((short)i2)).setCellValue((RichTextString)new HSSFRichTextString(productHead[i2]));
                }
                for (BatchFileInfo batchFileInfo : products) {
                    Object[] producValue = this.getProductItem(batchFileInfo);
                    curRowIndex = (short)(curRowIndex + 1);
                    row = sheet.createRow(curRowIndex);
                    row.createCell(0).setCellValue((double)(++seq));
                    for (int i3 = 0; i3 < producValue.length; ++i3) {
                        row.createCell((int)((short)(i3 + 1))).setCellValue((RichTextString)new HSSFRichTextString((String)producValue[i3]));
                    }
                }
            }
            curRowIndex = (short)(curRowIndex + 1);
        }
        FileOutputStream fileOut = new FileOutputStream(tempFile);
        wb.write((OutputStream)fileOut);
        fileOut.close();
        try {
            KDTMenuManager.openFileInExcel((String)tempFile.getPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tempFile.deleteOnExit();
    }

    private Object[] getProductItem(BatchFileInfo batchFileInfo) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (20 == this.queryType.getValue()) {
            items.add(batchFileInfo.get("ep_structCode_20080923"));
        }
        items.add(batchFileInfo.getMaterial().getNumber() == null ? "" : batchFileInfo.getMaterial().getNumber());
        items.add(batchFileInfo.getMaterial().getName() == null ? "" : batchFileInfo.getMaterial().getName());
        items.add(batchFileInfo.getMaterial().getModel() == null ? "" : batchFileInfo.getMaterial().getModel());
        items.add(batchFileInfo.getLotNo() == null ? "" : batchFileInfo.getLotNo());
        items.add(batchFileInfo.getCreateTime() == null ? "" : CtrlFormatUtilities.getDateFormat().format(batchFileInfo.getCreateTime()));
        String tmpValue = "";
        if (20 == this.queryType.getValue()) {
            items.add(batchFileInfo.get("ep_OfMaterial_20080923") == null ? "" : batchFileInfo.get("ep_OfMaterial_20080923"));
            items.add(batchFileInfo.get("ep_OfMaterialLot_20080923") == null ? "" : batchFileInfo.get("ep_OfMaterialLot_20080923"));
        }
        return items.toArray();
    }

    private void sortForTable(KDTMouseEvent e, KDTable kdtable) {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            if (null == kdtable.getBody().getRows() || kdtable.getBody().getRows().size() < 2) {
                return;
            }
            KDTSortManager sm = new KDTSortManager(kdtable);
            this.sort = this.sort == 0 ? 1 : 0;
            sm.sort(e.getColIndex(), this.sort);
            List rows = kdtable.getBody().getRows();
            Collections.sort(rows, new TableCellComparator(e.getColIndex(), this.sort));
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnLotUsing.setIcon(EASResource.getIcon((String)"imgTbtn_showsubflow"));
        this.menuItemLotUsing.setIcon(EASResource.getIcon((String)"imgTbtn_showsubflow"));
    }

    @Override
    public void actionLotUsing_actionPerformed(ActionEvent e) throws Exception {
        RptParams filter = new RptParams();
        HashMap<String, String> mapData = new HashMap<String, String>();
        String materialid = null;
        String lotNo = null;
        Object batchfileid = null;
        String materialNumber = null;
        int row = this.kdtProduct.getSelectManager().getActiveRowIndex();
        if (row < 0) {
            MsgBox.showInfo((String)ResourceManage.getResource((String)"com.kingdee.eas.mm.lot.LotTraceResource", (String)"select_One_product"));
            return;
        }
        IRow row_t = this.kdtProduct.getRow(row);
        if (row_t != null) {
            lotNo = (String)row_t.getCell("lotNo").getValue();
            materialid = (String)row_t.getCell("materialId").getValue();
            materialNumber = (String)row_t.getCell("materialNumber").getValue();
        }
        mapData.put("Flot", lotNo);
        mapData.put("FStorageOrgUnitId", this.storageOrgUnitId);
        mapData.put("FMaterialId", materialid);
        mapData.put("materialNumber", materialNumber);
        filter.setString("Flot", lotNo);
        filter.setString("FStorageOrgUnitId", this.storageOrgUnitId);
        filter.setString("FMaterialId", materialid);
        filter.setString("materialNumber", materialNumber);
        this.setCursorOfWair();
        int winStyle = 2;
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"UIClassParam", (Object)"leuOplSpQwTgQAB/AQAmws5PzmM=");
        ctx.put((Object)"com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_BE_JOINQUERY", (Object)true);
        ctx.put((Object)"com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_PARAMS", (Object)filter);
        ctx.put((Object)"com.kingdee.eas.base.report.client.ReportViewerUI#UICONTEXT_KEY_JOINQUERY_DATA", mapData);
        ctx.put((Object)"ID", (Object)("ss" + mapData.hashCode()));
        IUIWindow win = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.base.report.client.ReportViewerUI", (Map)ctx, null, OprtState.VIEW, winStyle);
        win.show();
        this.setCursorOfDefault();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public Context getMainContext() {
        return this.getMainOrgContext();
    }
}

