/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.kds.KDSRow;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTHead;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.eas.mm.control.client.ProductLotNoTraceDataProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.OrientationRequested;

public class ProductLotNoTraceExportUtil {
    private static final int MAX_VALUE = 65536;
    private static final int PRD_INTERVAL_ROW = 1;
    private static final int MAT_INTERVAL_ROW = 1;
    private static final int TITLE_ROW = 4;
    private static final float PRD_INTERVAL_HEIGHT = 10.0f;
    private static final float MAT_INTERVAL_Height = 5.0f;
    private static ProductLotNoTraceExportUtil instance = new ProductLotNoTraceExportUtil();

    private ProductLotNoTraceExportUtil() {
    }

    public static ProductLotNoTraceExportUtil getInstance() {
        if (instance == null) {
            instance = new ProductLotNoTraceExportUtil();
        }
        return instance;
    }

    public KDSBook exportToKDSBook(KDTable prdTable, KDTable matTable, ProductLotNoTraceDataProvider dataProvider, String orgUnitName) throws Exception {
        return this.exportToKDSBook(prdTable, matTable, dataProvider, orgUnitName, true, true, true, false, false);
    }

    public KDSBook exportToKDSBook(KDTable prdTable, KDTable matTable, ProductLotNoTraceDataProvider dataProvider, String orgUnitName, boolean isWithOrgUnitHead, boolean isWithPrmtHead, boolean isWithHead, boolean isWithHiddenCol, boolean isWithIndexColumn) throws Exception {
        if (dataProvider == null || dataProvider.getSelRowIndexLst() == null || dataProvider.getSelRowIndexLst().length < 1) {
            return null;
        }
        return this.exportKDT2KDS(prdTable, matTable, dataProvider, orgUnitName, isWithOrgUnitHead, isWithPrmtHead, isWithHead, isWithHiddenCol, isWithIndexColumn);
    }

    private KDSBook exportKDT2KDS(KDTable prdTable, KDTable matTable, ProductLotNoTraceDataProvider dataProvider, String orgUnitName, boolean isWithOrgUnitHead, boolean isWithPrmtHead, boolean isWithHead, boolean isWithHiddenCol, boolean isWithIndexColumn) throws Exception {
        String exportName;
        String sSheetName = exportName = EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.ExportMsg2");
        Map matCatch = dataProvider.getMaterialOfProductData();
        KDSBook book = new KDSBook(sSheetName);
        int i = 0;
        int k = 0;
        int iLen = dataProvider.getSelRowIndexLst().length;
        int iBeginRow = 0;
        int iEndRow = 0;
        int iTableCount = 0;
        int iSheetIndex = 0;
        int iMergeRowCount = 0;
        int mergeSheetCount = this.calcMergeSheet(dataProvider.getSelRowIndexLst(), prdTable, matCatch);
        KDSSheet[] mergeSheet = new KDSSheet[mergeSheetCount];
        IRowSet matRowSet = null;
        for (i = 0; i < iLen; ++i) {
            String prdId = prdTable.getCellDisplayText(prdTable.getCell(dataProvider.getSelRowIndexLst()[i], "fid"));
            matRowSet = (IRowSet)matCatch.get(prdId);
            iTableCount = this.getRowCount(matRowSet);
            iBeginRow = 0;
            iEndRow = 0;
            while (iEndRow != iTableCount) {
                if (mergeSheet[iSheetIndex] == null) {
                    mergeSheet[iSheetIndex] = new KDSSheet(book, sSheetName);
                }
                iMergeRowCount = mergeSheet[iSheetIndex].getRowCount();
                KDSSheet sheet = null;
                iBeginRow = iEndRow;
                if ((iEndRow = iBeginRow + 65536 - iMergeRowCount - 1) > iTableCount) {
                    iEndRow = iTableCount;
                }
                sSheetName = exportName + new Integer(i).toString() + new Integer(iSheetIndex).toString();
                sheet = this.exportToKDSheet(prdTable, matTable, book, i, dataProvider.getSelRowIndexLst()[i], orgUnitName, matRowSet, isWithOrgUnitHead, isWithPrmtHead, isWithHead, isWithHiddenCol, isWithIndexColumn, sSheetName);
                iMergeRowCount = mergeSheet[iSheetIndex].getRowCount();
                this.mergeKDSheet(mergeSheet[iSheetIndex], sheet);
                this.mergeBlock(mergeSheet[iSheetIndex], sheet, iMergeRowCount);
                iMergeRowCount = mergeSheet[iSheetIndex].getRowCount();
                if (iMergeRowCount < 65536) continue;
                ++iSheetIndex;
            }
        }
        for (k = 0; k < iSheetIndex + 1; ++k) {
            book.addSheet(null, mergeSheet[k]);
        }
        return book;
    }

    private boolean mergeKDSheet(KDSSheet mergeSheet, KDSSheet sheet) {
        int iSheetRowCount;
        if (mergeSheet == null || sheet == null) {
            return false;
        }
        boolean bReturnValue = true;
        int iMergeRowCount = mergeSheet.getRowCount() == 0 ? 0 : mergeSheet.getRowCount() + 1;
        if (iMergeRowCount + (iSheetRowCount = sheet.getRowCount()) > 65536) {
            iSheetRowCount = 65536 - iMergeRowCount;
            bReturnValue = false;
        }
        int iSheetColCount = sheet.getColumnCount();
        if (mergeSheet.getRowCount() != 0) {
            for (int m = 0; m < 1; ++m) {
                mergeSheet.getRows().setRowHeight(mergeSheet.getRowCount() + m, 10.0f);
            }
        } else {
            mergeSheet.setPrintSetup(sheet.getPrintSetup());
        }
        for (int i = 0; i < iSheetRowCount; ++i) {
            KDSRow row = sheet.getRow(i, false);
            if (row == null) continue;
            mergeSheet.getRows().setRowHeight(i + iMergeRowCount, row.getHeight());
            for (int j = 0; j < iSheetColCount; ++j) {
                KDSCell cell = sheet.getCell(i, j, false);
                if (cell == null) continue;
                ShareStyleAttributes ssa = null;
                ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA()});
                mergeSheet.setCell(i + iMergeRowCount, j, cell.getValue(), null, ssa, null);
            }
        }
        mergeSheet.getRowCount();
        return bReturnValue;
    }

    private KDSSheet exportToKDSheet(KDTable prdTable, KDTable matTable, KDSBook book, int curRecordIndex, int prdSelectRowIndex, String orgUnitName, IRowSet matRowSet, boolean isWithOrgUnitHead, boolean isWithPrmtHead, boolean isWithHead, boolean isWithHiddenCol, boolean isWithIndexColumn, String sheetName) throws Exception {
        KDSSheet sheet = new KDSSheet(book, sheetName);
        int prdRowIndex = this.exportProductToKDSheet(sheet, prdTable, curRecordIndex, prdSelectRowIndex, orgUnitName, isWithOrgUnitHead, isWithPrmtHead, isWithHead, isWithHiddenCol, isWithIndexColumn);
        int matRowIndex = this.exportMatrialToKDSheet(sheet, matTable, prdRowIndex, matRowSet, isWithPrmtHead, isWithHead, isWithHiddenCol, isWithIndexColumn);
        return sheet;
    }

    private boolean isColumnHidden(KDTable table, int colIndex) {
        IColumn col = table.getColumn(colIndex);
        if (col != null) {
            return col.getStyleAttributes().isHided();
        }
        return true;
    }

    private KDSSheet mergeBlock(KDSSheet mergeSheet, KDSSheet sheet, int beginRow) {
        for (KDSMergeBlock kdsBlock : sheet.getMerges()) {
            if (kdsBlock == null) continue;
            mergeSheet.getMerges().addMerge(kdsBlock.getRow2() - kdsBlock.getWidth() + beginRow, kdsBlock.getCol2() - kdsBlock.getHeight(), kdsBlock.getRow2(), kdsBlock.getCol2());
        }
        return null;
    }

    private int getRowCount(IRowSet matRowSet) {
        int rowCount = 0;
        rowCount += 6;
        if (matRowSet != null) {
            rowCount += matRowSet.size();
        }
        return rowCount;
    }

    private int exportProductToKDSheet(KDSSheet sheet, KDTable prdTable, int curRecordIndex, int prdSelectRowIndex, String orgUnitName, boolean isWithOrgUnitHead, boolean isWithPrmtHead, boolean isWithHead, boolean isWithHiddenCol, boolean isWithIndexColumn) {
        int i;
        ShareStyleAttributes ssa;
        KDTRow row;
        KDSSheetPrintSetup printSetup = this.generatePrintSetup(prdTable);
        int prmtHeadStartRow = 0;
        int headStartRow = 0;
        int rowBeginIndex = 0;
        if (curRecordIndex == 0 && isWithOrgUnitHead) {
            row = prdTable.getHead().getRow(0);
            sheet.getRows().setRowHeight(0, (float)UnitConverter.px2mm((int)row.getHeight()));
            ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getSSA(), prdTable.getHeadSSA()});
            sheet.setCell(0, 0, (Object)EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.ExportMsg1"), null, ssa, null);
            sheet.setCell(0, 1, (Object)orgUnitName, null, ssa, null);
            ++prmtHeadStartRow;
            ++headStartRow;
            ++rowBeginIndex;
        }
        if (isWithPrmtHead) {
            row = prdTable.getHead().getRow(0);
            sheet.getRows().setRowHeight(prmtHeadStartRow, (float)UnitConverter.px2mm((int)row.getHeight()));
            ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getSSA(), prdTable.getHeadSSA()});
            sheet.setCell(prmtHeadStartRow, 0, (Object)EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.ExportMsg3"), null, ssa, null);
            ++headStartRow;
            ++rowBeginIndex;
        }
        boolean isSelectAllTable = true;
        int headRowCount = prdTable.getHeadRowCount();
        int colIndex = 0;
        int colCount = prdTable.getColumnCount();
        boolean[] colOutputMark = new boolean[colCount];
        for (int i2 = 0; i2 < colCount; ++i2) {
            colOutputMark[i2] = isWithHiddenCol ? true : !this.isColumnHidden(prdTable, i2);
        }
        int colBeginIndex = isWithIndexColumn ? 1 : 0;
        rowBeginIndex += isWithHead ? headRowCount : 0;
        if (isWithHead) {
            KDTHead head = prdTable.getHead();
            for (i = 0; i < headRowCount; ++i) {
                KDTRow row2 = head.getRow(i);
                sheet.getRows().setRowHeight(i + headStartRow, (float)UnitConverter.px2mm((int)row2.getHeight()));
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    boolean tempB;
                    KDTCell cell;
                    if (!colOutputMark[j] || (cell = row2.getCell(j)) == null) continue;
                    KDTMergeBlock block = cell.getMergeBlock();
                    boolean bl = tempB = block != null && (i != block.getTop() || j != block.getLeft());
                    if (tempB) {
                        cell = head.getRow(block.getTop()).getCell(block.getLeft());
                    }
                    if (cell != null) {
                        ShareStyleAttributes ssa2 = null;
                        ssa2 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row2.getSSA(), prdTable.getHeadSSA()});
                        sheet.setCell(i + headStartRow, colIndex, tempB ? null : cell.getValue(), null, ssa2);
                    }
                    boolean firstVisibleCell = true;
                    if (cell != null) {
                        boolean mergeCell;
                        KDTMergeBlock mergeBlock = cell.getMergeBlock();
                        boolean bl2 = mergeCell = mergeBlock != null && (i != mergeBlock.getTop() || j != mergeBlock.getLeft());
                        if (mergeCell) {
                            cell = head.getRow(mergeBlock.getTop()).getCell(mergeBlock.getLeft());
                            firstVisibleCell = this.isFirstVisibleCell(!mergeCell, mergeBlock, colOutputMark, i, j, isSelectAllTable);
                        }
                    }
                    ShareStyleAttributes ssa3 = null;
                    Object value = null;
                    if (cell != null) {
                        ssa3 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row2.getSSA(), prdTable.getHeadSSA()});
                        value = cell.getValue();
                    } else {
                        ssa3 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{Styles.getEmptySSA(), row2.getSSA(), prdTable.getHeadSSA()});
                    }
                    if (!firstVisibleCell) {
                        sheet.setCell(i + headStartRow, colIndex, null, null, ssa3, null);
                    } else {
                        sheet.setCell(i + headStartRow, colIndex, value, null, ssa3, null);
                    }
                    ++colIndex;
                }
            }
        }
        KDTColumns cols = prdTable.getColumns();
        if (isWithIndexColumn) {
            sheet.getColumns().setColumnWidth(0, (float)UnitConverter.px2mm((int)prdTable.getIndexColumn().getWidth()));
        }
        colIndex = colBeginIndex;
        for (i = 0; i < colCount; ++i) {
            if (!colOutputMark[i]) continue;
            sheet.getColumns().setColumnWidth(colIndex, (float)UnitConverter.px2mm((int)cols.getColumnWidth(i)));
            ++colIndex;
        }
        int rowIndex = rowBeginIndex;
        block4: while (rowIndex == rowBeginIndex) {
            for (int i3 = prdSelectRowIndex; i3 <= prdSelectRowIndex; ++i3) {
                IRow row3;
                if (isWithIndexColumn) {
                    ShareStyleAttributes ssa4 = prdTable.getIndexColumn().getSsa();
                    sheet.setCell(rowIndex, 0, (Object)String.valueOf(curRecordIndex), null, ssa4);
                }
                if ((row3 = prdTable.getRow(i3)) == null) continue block4;
                sheet.setRowHeight(rowIndex, (float)UnitConverter.px2mm((int)row3.getHeight()));
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    if (!colOutputMark[j]) continue;
                    ICell cell = row3.getCell(j);
                    boolean firstVisibleCell = true;
                    if (cell != null) {
                        boolean mergeCell;
                        KDTMergeBlock mergeBlock = cell.getMergeBlock();
                        boolean bl = mergeCell = mergeBlock != null && (i3 != mergeBlock.getTop() || j != mergeBlock.getLeft());
                        if (mergeCell) {
                            cell = prdTable.getRow(mergeBlock.getTop()).getCell(mergeBlock.getLeft());
                            firstVisibleCell = this.isFirstVisibleCell(!mergeCell, mergeBlock, colOutputMark, i3, j, isSelectAllTable);
                        }
                    }
                    ShareStyleAttributes ssa5 = null;
                    Object value = null;
                    String formula = null;
                    Object text = null;
                    if (cell != null) {
                        ssa5 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getKDTCell().getSSA(), row3.getKDTRow().getSSA(), cols.getColumn(j).getSSA(), prdTable.getSSA()});
                        if (firstVisibleCell) {
                            value = this.getCellValue(prdTable, cell, cell.getValue(), ssa5, cell.getRowIndex(), cell.getColumnIndex());
                            formula = cell.getExpressions();
                            text = prdTable.getCellDisplayText(cell);
                        }
                    } else {
                        ssa5 = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{prdTable.getBlankCellSSA(), row3.getKDTRow().getSSA(), prdTable.getColumns().getColumn(j).getSSA(), prdTable.getSSA()});
                    }
                    if (formula != null && !(formula = formula.trim()).equals("") && formula.charAt(0) == '=') {
                        formula = formula.substring(1);
                    }
                    if (!firstVisibleCell) {
                        sheet.setCell(rowIndex, colIndex, null, null, ssa5, null);
                    } else {
                        if (cell.getStyleAttributes().getNumberFormat().equals("yyyy-MM-dd")) {
                            value = text;
                        }
                        sheet.setCell(rowIndex, colIndex, value, formula, ssa5, (String)text);
                    }
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
        if (isWithHead) {
            Iterator it = prdTable.getHeadMergeManager().getMergeBlockList().iterator();
            while (it.hasNext()) {
                KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)it.next(), colOutputMark, 0, isWithIndexColumn);
                if (kdtBlock == null) continue;
                sheet.getMerges().addMerge(kdtBlock.getTop(), kdtBlock.getLeft(), kdtBlock.getBottom(), kdtBlock.getRight());
            }
        }
        Iterator iter = prdTable.getMergeManager().getMergeBlockList().iterator();
        while (iter.hasNext()) {
            KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)iter.next(), colOutputMark, headRowCount, isWithIndexColumn);
            if (kdtBlock == null) continue;
            if (isWithHead) {
                sheet.getMerges().addMerge(kdtBlock.getTop(), kdtBlock.getLeft(), kdtBlock.getBottom(), kdtBlock.getRight());
                continue;
            }
            sheet.getMerges().addMerge(kdtBlock.getTop() - headRowCount, kdtBlock.getLeft(), kdtBlock.getBottom() - headRowCount, kdtBlock.getRight());
        }
        sheet.setPrintSetup(printSetup);
        return rowIndex;
    }

    private int exportMatrialToKDSheet(KDSSheet sheet, KDTable matTable, int prdRowIndex, IRowSet matRowSet, boolean isWithPrmtHead, boolean isWithHead, boolean isWithHiddenCol, boolean isWithIndexColumn) throws Exception {
        int colIndex;
        int i;
        int prmtHeadStartRow;
        int headStartRow = prmtHeadStartRow = prdRowIndex + 1;
        int rowBeginIndex = prmtHeadStartRow;
        for (int i2 = 0; i2 < 1; ++i2) {
            sheet.getRows().setRowHeight(prdRowIndex + i2, 5.0f);
            sheet.setCell(prdRowIndex + i2, 0, null, null, null, null);
        }
        if (isWithPrmtHead) {
            KDTRow row = matTable.getHead().getRow(0);
            sheet.getRows().setRowHeight(prmtHeadStartRow, (float)UnitConverter.px2mm((int)row.getHeight()));
            ShareStyleAttributes ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{row.getSSA(), matTable.getHeadSSA()});
            sheet.setCell(prmtHeadStartRow, 0, (Object)EASResource.getString((String)"com.kingdee.eas.mm.control.ProductionOrderResource.ExportMsg4"), null, ssa, null);
            ++headStartRow;
            ++rowBeginIndex;
        }
        boolean isSelectAllTable = true;
        int headRowCount = matTable.getHeadRowCount();
        int colCount = matTable.getColumnCount();
        boolean[] colOutputMark = new boolean[colCount];
        for (int i3 = 0; i3 < colCount; ++i3) {
            colOutputMark[i3] = isWithHiddenCol ? true : !this.isColumnHidden(matTable, i3);
        }
        int colBeginIndex = isWithIndexColumn ? 1 : 0;
        rowBeginIndex += isWithHead ? headRowCount : 0;
        if (isWithHead) {
            KDTHead head = matTable.getHead();
            for (i = 0; i < headRowCount; ++i) {
                KDTRow row = head.getRow(i);
                sheet.getRows().setRowHeight(i + headStartRow, (float)UnitConverter.px2mm((int)row.getHeight()));
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    boolean tempB;
                    KDTCell cell;
                    if (!colOutputMark[j] || (cell = row.getCell(j)) == null) continue;
                    KDTMergeBlock block = cell.getMergeBlock();
                    boolean bl = tempB = block != null && (i != block.getTop() || j != block.getLeft());
                    if (tempB) {
                        cell = head.getRow(block.getTop()).getCell(block.getLeft());
                    }
                    if (cell != null) {
                        ShareStyleAttributes ssa = null;
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), matTable.getHeadSSA()});
                        sheet.setCell(i + headStartRow, colIndex, tempB ? null : cell.getValue(), null, ssa);
                    }
                    boolean firstVisibleCell = true;
                    if (cell != null) {
                        boolean mergeCell;
                        KDTMergeBlock mergeBlock = cell.getMergeBlock();
                        boolean bl2 = mergeCell = mergeBlock != null && (i != mergeBlock.getTop() || j != mergeBlock.getLeft());
                        if (mergeCell) {
                            cell = head.getRow(mergeBlock.getTop()).getCell(mergeBlock.getLeft());
                            firstVisibleCell = this.isFirstVisibleCell(!mergeCell, mergeBlock, colOutputMark, i, j, isSelectAllTable);
                        }
                    }
                    ShareStyleAttributes ssa = null;
                    Object value = null;
                    if (cell != null) {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), row.getSSA(), matTable.getHeadSSA()});
                        value = cell.getValue();
                    } else {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{Styles.getEmptySSA(), row.getSSA(), matTable.getHeadSSA()});
                    }
                    if (!firstVisibleCell) {
                        sheet.setCell(i + headStartRow, colIndex, null, null, ssa, null);
                    } else {
                        sheet.setCell(i + headStartRow, colIndex, value, null, ssa, "sss");
                    }
                    ++colIndex;
                }
            }
        }
        KDTColumns cols = matTable.getColumns();
        if (isWithIndexColumn) {
            sheet.getColumns().setColumnWidth(0, (float)UnitConverter.px2mm((int)matTable.getIndexColumn().getWidth()));
        }
        colIndex = colBeginIndex;
        for (i = 0; i < colCount; ++i) {
            if (!colOutputMark[i]) continue;
            sheet.getColumns().setColumnWidth(colIndex, (float)UnitConverter.px2mm((int)cols.getColumnWidth(i)));
            ++colIndex;
        }
        int rowIndex = rowBeginIndex;
        boolean flag = false;
        if (matRowSet != null) {
            matRowSet.beforeFirst();
            while (matRowSet.next()) {
                IRow matRow;
                if (isWithIndexColumn) {
                    ShareStyleAttributes ssa = matTable.getIndexColumn().getSsa();
                    sheet.setCell(rowIndex, 0, (Object)String.valueOf(rowIndex - rowBeginIndex + 1), null, ssa);
                }
                sheet.setRowHeight(rowIndex, (float)UnitConverter.px2mm((int)((matRow = matTable.getRow(0)) == null ? matTable.getHead().getRowHeight(0) : matRow.getHeight())));
                flag = true;
                colIndex = colBeginIndex;
                for (int j = 0; j < colCount; ++j) {
                    if (!colOutputMark[j]) continue;
                    ICell matCell = matRow == null ? null : matRow.getCell(j);
                    boolean firstVisibleCell = true;
                    ShareStyleAttributes ssa = null;
                    Object value = matRowSet.getObject(matTable.getColumn(j).getKey());
                    String formula = null;
                    String text = null;
                    if (matCell != null) {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{matCell.getKDTCell().getSSA(), matRow.getKDTRow().getSSA(), cols.getColumn(j).getSSA(), matTable.getSSA()});
                        if (firstVisibleCell) {
                            value = this.getCellValue(matTable, matCell, value, ssa, 0, j);
                            formula = matCell == null ? null : matCell.getExpressions();
                            text = value == null ? "" : value.toString();
                        }
                    } else {
                        ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{matTable.getBlankCellSSA(), matRow == null ? matTable.getBlankCellSSA() : matRow.getKDTRow().getSSA(), matTable.getColumns().getColumn(j).getSSA(), matTable.getSSA()});
                    }
                    if (formula != null && !(formula = formula.trim()).equals("") && formula.charAt(0) == '=') {
                        formula = formula.substring(1);
                    }
                    if (!firstVisibleCell) {
                        sheet.setCell(rowIndex, colIndex, null, null, ssa, null);
                    } else {
                        sheet.setCell(rowIndex, colIndex, (Object)(value == null ? null : value.toString()), formula, ssa, text);
                    }
                    ++colIndex;
                }
                ++rowIndex;
            }
        }
        if (!flag) {
            sheet.setRowHeight(rowBeginIndex, 5.0f);
        }
        if (isWithHead) {
            Iterator it = matTable.getHeadMergeManager().getMergeBlockList().iterator();
            while (it.hasNext()) {
                KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)it.next(), colOutputMark, 0, isWithIndexColumn);
                if (kdtBlock == null) continue;
                sheet.getMerges().addMerge(kdtBlock.getTop(), kdtBlock.getLeft(), kdtBlock.getBottom(), kdtBlock.getRight());
            }
        }
        Iterator iter = matTable.getMergeManager().getMergeBlockList().iterator();
        while (iter.hasNext()) {
            KDTMergeBlock kdtBlock = this.transBlock((KDTMergeBlock)iter.next(), colOutputMark, headRowCount, isWithIndexColumn);
            if (kdtBlock == null) continue;
            if (isWithHead) {
                sheet.getMerges().addMerge(kdtBlock.getTop(), kdtBlock.getLeft(), kdtBlock.getBottom(), kdtBlock.getRight());
                continue;
            }
            sheet.getMerges().addMerge(kdtBlock.getTop() - headRowCount, kdtBlock.getLeft(), kdtBlock.getBottom() - headRowCount, kdtBlock.getRight());
        }
        return rowIndex;
    }

    private KDSSheetPrintSetup generatePrintSetup(KDTable table) {
        HeadFootModel footModel;
        if (!table.isExportPrintSetup2Xls()) {
            return null;
        }
        KDTPrintManager printManager = table.getPrintManager();
        TablePageSetupModel printJobModel = printManager.getNewPrintManager().getPrintJobConfig();
        KDSSheetPrintSetup printInfo = new KDSSheetPrintSetup();
        if (printJobModel != null) {
            printInfo.setNoColor(printJobModel.isSingleColor());
            printInfo.setRowToCol(!printJobModel.getOrder());
            printInfo.setHasNotes(printJobModel.getPostilType() != 0);
        }
        printInfo.setScale((short)printManager.getScale());
        printInfo.setPageSize(this.transformPaperSizefromISOtoPOI(printManager.getPaperSize()));
        PageSetupModel printModel = printManager.getPageSetupModel();
        Attribute att = printModel.getPrintRequestAttributeSet().get(OrientationRequested.class);
        printInfo.setLandScape(att == OrientationRequested.LANDSCAPE);
        HeadFootModel headModel = printManager.getHeaderModel();
        if (headModel != null) {
            this.configHeaderFooter(true, headModel, printInfo);
        }
        if ((footModel = printManager.getFooterModel()) != null) {
            this.configHeaderFooter(false, footModel, printInfo);
        }
        return printInfo;
    }

    private short transformPaperSizefromISOtoPOI(int paperSizeValue) {
        short paperSize = 9;
        switch (paperSizeValue) {
            case 4: {
                paperSize = 9;
                break;
            }
            case 5: {
                paperSize = 11;
                break;
            }
            case 40: {
                paperSize = 1;
                break;
            }
            case 60: {
                paperSize = 20;
                break;
            }
            case 57: {
                paperSize = 37;
                break;
            }
            default: {
                paperSize = 9;
            }
        }
        return paperSize;
    }

    private void configHeaderFooter(boolean isHead, HeadFootModel model, KDSSheetPrintSetup printInfo) {
        ListIterator rowList = model.getRows();
        StringBuffer LeftBuffer = new StringBuffer("");
        StringBuffer CenterBuffer = new StringBuffer("");
        StringBuffer RightBuffer = new StringBuffer("");
        while (rowList.hasNext()) {
            String originRowText = ((HeadFootRow)rowList.next()).toString();
            String[] Text = StringUtil.splitString((String)originRowText, (String)"&|");
            String[] Result = this.spliceHeaderOrFooter(Text, rowList.previousIndex());
            LeftBuffer.append(Result[0]);
            CenterBuffer.append(Result[1]);
            RightBuffer.append(Result[2]);
        }
        if (isHead) {
            if (!StringUtil.isEmptyString((String)LeftBuffer.toString())) {
                printInfo.setHeaderLeft(LeftBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)CenterBuffer.toString())) {
                printInfo.setHeaderCenter(CenterBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)RightBuffer.toString())) {
                printInfo.setHeaderRight(RightBuffer.toString());
            }
        } else {
            if (!StringUtil.isEmptyString((String)LeftBuffer.toString())) {
                printInfo.setFooterLeft(LeftBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)CenterBuffer.toString())) {
                printInfo.setFooterCenter(CenterBuffer.toString());
            }
            if (!StringUtil.isEmptyString((String)RightBuffer.toString())) {
                printInfo.setFooterRight(RightBuffer.toString());
            }
        }
    }

    private String[] spliceHeaderOrFooter(String[] rowText, int rowIndex) {
        String newLine = rowIndex > 0 ? "\n" : "";
        StringBuffer left = new StringBuffer(newLine + "");
        StringBuffer center = new StringBuffer(newLine + "");
        StringBuffer right = new StringBuffer(newLine + "");
        int col = rowText.length;
        if (col != 0) {
            if (col == 1) {
                center.append(rowText[0]);
            } else if (col == 2) {
                left.append(rowText[0]);
                right.append(rowText[1]);
            } else if (col == 3) {
                left.append(rowText[0]);
                center.append(rowText[1]);
                right.append(rowText[2]);
            } else {
                left.append(rowText[0]);
                right.append(rowText[col - 1]);
                for (int i = 1; i <= col - 2; ++i) {
                    center.append(rowText[i]);
                }
            }
        }
        return new String[]{left.toString(), center.toString(), right.toString()};
    }

    private boolean isFirstVisibleCell(boolean firstmerge, KDTMergeBlock mergeBlock, boolean[] colOutputMark, int rowIndex, int colIndex, boolean isSelectAllTable) {
        int left;
        if (mergeBlock == null || firstmerge) {
            return true;
        }
        if (isSelectAllTable && mergeBlock.getTop() != rowIndex) {
            return false;
        }
        for (int i = left = mergeBlock.getLeft(); i < colIndex; ++i) {
            if (!colOutputMark[i]) continue;
            return false;
        }
        return true;
    }

    private Object getCellValue(KDTable table, ICell cell, Object value, ShareStyleAttributes ssa, int rowIndex, int cellIndex) {
        String nf = ssa.getNumberFormat();
        if (nf != null && nf.startsWith("@") && nf.length() > 1) {
            return value;
        }
        return this.getCellDisplayValue2(table, cell, value, rowIndex, cellIndex);
    }

    private Object getCellDisplayValue2(KDTable table, ICell cell, Object value, int rIndex, int cIndex) {
        IBasicRender render;
        if (cell != null && (render = table.getCellRenderer(rIndex, cIndex)) instanceof ObjectValueRender) {
            value = ((ObjectValueRender)render).getText(value);
        }
        return value;
    }

    private KDTMergeBlock transBlock(KDTMergeBlock block, boolean[] colOutputMark, int headRowCount, boolean isWithIndexColumn) {
        KDTMergeBlock newBlock = new KDTMergeBlock();
        newBlock.setBottom(block.getBottom() + headRowCount);
        newBlock.setTop(block.getTop() + headRowCount);
        newBlock.setLeft(block.getLeft());
        newBlock.setRight(block.getRight());
        newBlock = this.transBlockWithHiddenColumn(newBlock, colOutputMark);
        if (newBlock == null) {
            return null;
        }
        if (isWithIndexColumn) {
            newBlock.setLeft(newBlock.getLeft() + 1);
            newBlock.setRight(newBlock.getRight() + 1);
        }
        return newBlock;
    }

    private KDTMergeBlock transBlockWithHiddenColumn(KDTMergeBlock block, boolean[] colOutputMark) {
        int i;
        int left;
        int length = colOutputMark.length;
        int right = block.getRight();
        if (right > length - 1 || left > length - 1) {
            return null;
        }
        for (left = block.getLeft(); left <= right && !colOutputMark[left]; ++left) {
        }
        while (right >= left && !colOutputMark[right]) {
            --right;
        }
        int left2 = left;
        int right2 = right;
        for (i = 0; i < left; ++i) {
            if (colOutputMark[i]) continue;
            --left2;
            --right2;
        }
        for (i = left; i < right; ++i) {
            if (colOutputMark[i]) continue;
            --right2;
        }
        if (left2 > right2) {
            return null;
        }
        if (left2 == right2 && block.getTop() == block.getBottom()) {
            return null;
        }
        block.setLeft(left2);
        block.setRight(right2);
        return block;
    }

    private int calcMergeSheet(int[] rowIndex, KDTable prdTable, Map matCatch) {
        int mergeSheetCount = 0;
        int mergeRowCount = 0;
        for (int i = 0; i < rowIndex.length; ++i) {
            String prdId = prdTable.getCellDisplayText(prdTable.getCell(rowIndex[i], "fid"));
            mergeRowCount += this.getRowCount((IRowSet)matCatch.get(prdId));
            ++mergeRowCount;
        }
        mergeSheetCount = (mergeRowCount + 1) / 65536;
        if (mergeRowCount % 65536 != 0) {
            ++mergeSheetCount;
        }
        if (mergeSheetCount == 0) {
            ++mergeSheetCount;
        }
        return mergeSheetCount;
    }
}

