/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.lot.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.lot.QueryTypeEnum;
import com.kingdee.eas.mm.lot.client.AbstractProductLotNoTraceQueryUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ProductLotNoTraceQueryUI
extends AbstractProductLotNoTraceQueryUI {
    private static final long serialVersionUID = -1216158761359073260L;
    private static final Logger logger = CoreUIObject.getLogger(ProductLotNoTraceQueryUI.class);
    private static final String permItem_query = "mm_productLotNo_query";
    private static final String resourceName = "com.kingdee.eas.mm.control.ProductLotNoResource";
    private OrgUnitInfo currPermOrg = null;
    private DataChangeListener storageOrgUnitChanged = null;
    private DataChangeListener materialChanged = null;
    private CustomerParams cp = null;

    public void onLoad() throws Exception {
        this.removeListener();
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)permItem_query);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resourceName, (String)"PLC_Msg_StorageOrg_Not_Null")));
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        elements.add((FilterElement)mainOrgElement);
        SingleFilterElement materialElement = new SingleFilterElement("materialNumber", (Component)this.prmtMaterial);
        materialElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, EASResource.getString((String)resourceName, (String)"MM_CONTROL_PRODUCTLOTNO_MATERIAL_NOT_NULL")));
        elements.add((FilterElement)materialElement);
        elements.add((FilterElement)new SingleFilterElement("lotNoStart", (Component)this.prmtLotNoStart));
        SingleFilterElement queryMode = new SingleFilterElement("queryType1", (Component)this.queryType);
        queryMode.setDefaultValue((Object)new Integer(10));
        elements.add((FilterElement)queryMode);
        Timestamp[] dates = ProductLotNoTraceQueryUI.getDefaultDateRange(SCMClientUtils.getServerDate2());
        RangeFilterElement elementBizDate = new RangeFilterElement("batchTime", (Component)this.pkBizDateStart, (Component)this.pkBizDateEnd);
        elementBizDate.setDefaultValue((Object)dates);
        elementBizDate.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)elementBizDate);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        this.prmtMaterial.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ProductLotNoTraceQueryUI.this.initMaterialF7();
            }
        });
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ProductLotNoTraceQueryUI.this.initMaterialF7();
            }
        });
        this.prmtLotNoStart.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                ProductLotNoTraceQueryUI.this.initLotNoStartF7((OrgUnitInfo)ProductLotNoTraceQueryUI.this.prmtStorageOrgUnit.getValue(), (MaterialInfo)ProductLotNoTraceQueryUI.this.prmtMaterial.getValue());
            }
        });
        this.prmtLotNoStart.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                ProductLotNoTraceQueryUI.this.initLotNoStartF7((OrgUnitInfo)ProductLotNoTraceQueryUI.this.prmtStorageOrgUnit.getValue(), (MaterialInfo)ProductLotNoTraceQueryUI.this.prmtMaterial.getValue());
            }
        });
        this.prmtLotNoStart.setCommitParser(null);
        this.prmtLotNoStart.setEnabledMultiSelection(true);
        this.addListener();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public void initMaterialF7() {
        OrgUnitInfo storageOrg = (OrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String storageOrgID = null;
        if (storageOrg != null) {
            storageOrgID = storageOrg.getId().toString();
        } else if (this.currPermOrg != null) {
            storageOrgID = this.currPermOrg.getId().toString();
        }
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(10030));
        set.add(new Integer(10050));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.orgUnit.id", (Object)storageOrgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.orgUnit.id", (Object)storageOrgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.status", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("Plan.materialAttr", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.isLotNumber", (Object)Boolean.TRUE, CompareType.EQUALS));
        if (storageOrg != null) {
            this.prmtMaterial.setCurrentCtrlUnit(storageOrg.getCU());
        }
        viewInfo.setFilter(filterInfo);
        this.prmtMaterial.setEntityViewInfo(viewInfo);
        this.prmtMaterial.getQueryAgent().resetRuntimeEntityView();
    }

    public void initLotNoStartF7(OrgUnitInfo storageOrg, MaterialInfo material) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String storageOrgID = null;
        if (storageOrg != null) {
            storageOrgID = storageOrg.getId().toString();
        } else if (this.currPermOrg != null) {
            storageOrgID = this.currPermOrg.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgID, CompareType.EQUALS));
        if (material != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtLotNoStart.setQueryInfo("com.kingdee.eas.mm.lot.app.F7LotNoTraceQuery");
        this.prmtLotNoStart.setEntityViewInfo(viewInfo);
        this.prmtLotNoStart.getQueryAgent().resetRuntimeEntityView();
    }

    protected void addListener() {
        this.storageOrgUnitChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ProductLotNoTraceQueryUI.this.storageOrgUnitChanged(eventObj);
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitChanged);
        this.materialChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ProductLotNoTraceQueryUI.this.materialChanged(eventObj);
            }
        };
        this.prmtMaterial.addDataChangeListener(this.materialChanged);
    }

    private void storageOrgUnitChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        Object storageOrg = null;
        storageOrg = eventObj.getNewValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)eventObj.getNewValue(), (Object)eventObj.getOldValue());
        if (storageOrg == null) {
            storageOrg = (OrgUnitInfo)eventObj.getOldValue();
        }
        if (isDiffrent) {
            this.currPermOrg = storageOrg;
            this.prmtMaterial.setValue(null);
            this.prmtLotNoStart.setValue(null);
            this.prmtLotNoStart.setText(null);
            if (storageOrg != null) {
                this.prmtMaterial.setCurrentCtrlUnit(storageOrg.getCU());
            }
        }
    }

    private void materialChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null && eventObj.getNewValue().equals(eventObj.getOldValue())) {
            return;
        }
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)eventObj.getNewValue(), (Object)eventObj.getOldValue());
        if (isDiffrent) {
            this.prmtLotNoStart.setValue(null);
            this.prmtLotNoStart.setText(null);
        }
    }

    private void removeListener() {
        if (this.storageOrgUnitChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitChanged);
        }
        if (this.materialChanged != null) {
            this.prmtMaterial.removeDataChangeListener(this.materialChanged);
        }
    }

    public boolean verify() {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resourceName, (String)"PLC_Msg_StorageOrg_Not_Null"));
            return false;
        }
        if (this.prmtMaterial.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resourceName, (String)"MM_CONTROL_PRODUCTLOTNO_MATERIAL_NOT_NULL"));
            return false;
        }
        if (MMUtils.isEmptyString((String)this.prmtLotNoStart.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)resourceName, (String)"MM_CONTROL_PRODUCTLOTNO_LOTTXT_NOT_NULL"));
            return false;
        }
        if (this.pkBizDateStart.getTimestamp() != null && this.pkBizDateEnd.getTimestamp() != null && this.pkBizDateStart.getTimestamp().getTime() > this.pkBizDateEnd.getTimestamp().getTime()) {
            MsgBox.showInfo((String)EASResource.getString((String)resourceName, (String)"MM_CONTROL_PRODUCTLOTNO_STARTMUSTLESSEND"));
            return false;
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        Calendar cal;
        FilterInfo filter = super.getFilterInfo();
        if (filter == null) {
            filter = new FilterInfo();
        }
        FilterItemCollection itemCollection = filter.getFilterItems();
        Object stotageInfo = null;
        stotageInfo = this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (stotageInfo != null) {
            itemCollection.add(new FilterItemInfo("storageOrgUnitID", (Object)stotageInfo.getId().toString(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("storageOrgUnit.number", (Object)stotageInfo.getNumber(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("storageOrgUnit.name", (Object)stotageInfo.getName(), CompareType.EQUALS));
        }
        if (this.prmtMaterial.getValue() != null) {
            itemCollection.add(new FilterItemInfo("materialid", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getId().toString(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("materialNumber", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getNumber(), CompareType.EQUALS));
            itemCollection.add(new FilterItemInfo("materialname", (Object)((MaterialInfo)this.prmtMaterial.getValue()).getName(), CompareType.EQUALS));
        }
        if (this.queryType.getSelectedItem() != null) {
            QueryTypeEnum queryType = (QueryTypeEnum)((Object)this.queryType.getSelectedItem());
            itemCollection.add(new FilterItemInfo("queryType", (Object)queryType));
            itemCollection.add(new FilterItemInfo("selectItem", (Object)new Integer(queryType.getValue())));
        }
        if (this.pkBizDateStart.getValue() != null) {
            cal = Calendar.getInstance();
            cal.setTime((Date)this.pkBizDateStart.getValue());
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            itemCollection.add(new FilterItemInfo("startQueryDate", (Object)new Timestamp(cal.getTimeInMillis()), CompareType.GREATER_EQUALS));
        }
        if (this.pkBizDateEnd.getValue() != null) {
            cal = Calendar.getInstance();
            cal.setTime((Date)this.pkBizDateEnd.getValue());
            cal.set(10, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            itemCollection.add(new FilterItemInfo("endQueryDate", (Object)new Timestamp(cal.getTimeInMillis()), CompareType.LESS_EQUALS));
        }
        return filter;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        Object stotageInfo = null;
        stotageInfo = this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (stotageInfo != null) {
            pp.addCustomerParam("storageOrgUnitID", stotageInfo.getId().toString());
            pp.addCustomerParam("storageOrgUnit.name", stotageInfo.getName().toString());
            pp.addCustomerParam("storageOrgUnit.number", stotageInfo.getNumber().toString());
            pp.addCustomerParam("storageOrgUnit.cu", stotageInfo.getCU().getId().toString());
        }
        MaterialInfo mInfo = (MaterialInfo)this.prmtMaterial.getValue();
        pp.addCustomerParam("materialid", mInfo.getId().toString());
        pp.addCustomerParam("materialname", mInfo.getName().toString());
        pp.addCustomerParam("materialNumber", mInfo.getNumber().toString());
        return pp;
    }

    public RptParams getCustomCondition() {
        RptParams pp = super.getCustomCondition();
        Object stotageInfo = null;
        stotageInfo = this.prmtStorageOrgUnit.getValue() instanceof FullOrgUnitInfo ? (OrgUnitInfo)this.prmtStorageOrgUnit.getValue() : (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (stotageInfo != null) {
            pp.setString("storageOrgUnitID", stotageInfo.getId().toString());
            pp.setString("storageOrgUnit.name", stotageInfo.getName().toString());
            pp.setString("storageOrgUnit.number", stotageInfo.getNumber());
            pp.setString("storageOrgUnit.cu", stotageInfo.getCU().getId().toString());
        }
        MaterialInfo mInfo = (MaterialInfo)this.prmtMaterial.getValue();
        pp.setString("materialname", mInfo.getName().toString());
        pp.setString("materialid", mInfo.getId().toString());
        pp.setString("materialNumber", mInfo.getNumber());
        this.cp = null;
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        super.loadData(entityViewInfo);
        CtrlUnitInfo cu = new CtrlUnitInfo();
        if (this.cp.getCustomerParam("storageOrgUnit.cu") != null) {
            cu.setId(BOSUuid.read((String)this.cp.getCustomerParam("storageOrgUnit.cu")));
        }
        MaterialInfo mInfo = new MaterialInfo();
        mInfo.setName(this.cp.getCustomerParam("materialname"));
        mInfo.setNumber(this.cp.getCustomerParam("materialNumber"));
        mInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("materialid")));
        this.prmtMaterial.setValue((Object)mInfo);
        this.prmtMaterial.setCurrentCtrlUnit(cu);
        StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
        storageInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("storageOrgUnitID")));
        storageInfo.setName(this.cp.getCustomerParam("storageOrgUnit.name"));
        storageInfo.setNumber(this.cp.getCustomerParam("storageOrgUnit.number"));
        storageInfo.setCU(cu);
        this.prmtStorageOrgUnit.setValue((Object)storageInfo);
        this.addListener();
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorCol = new SorterItemCollection();
        SorterItemInfo materialItem = new SorterItemInfo();
        materialItem.setPropertyName("materialid");
        materialItem.setUserDefined(true);
        sorCol.add(materialItem);
        return sorCol;
    }

    protected String getViewPermission() {
        return permItem_query;
    }
}

